/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import driftwood.moldb2.AtomState;
import driftwood.r3.Builder;
import driftwood.r3.SpatialBin;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.util.ProcessTank;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class KingFoo {
    static final double MAX_ATOM_RADIUS = 2.0;
    static final Triple[] FCC_OFFSETS = new Triple[]{new Triple(0.0, 1.0, 0.0), new Triple(1.0, 0.0, 0.0), new Triple(1.0, -1.0, 0.0), new Triple(0.0, -1.0, 0.0), new Triple(-1.0, 0.0, 0.0), new Triple(-1.0, 1.0, 0.0), new Triple(0.0, 0.0, 1.0), new Triple(0.0, -1.0, 1.0), new Triple(-1.0, 0.0, 1.0), new Triple(0.0, 1.0, -1.0), new Triple(1.0, 0.0, -1.0), new Triple(0.0, 0.0, -1.0)};
    Collection atomStates;
    double fooRadius;
    double touchDist;
    SpatialBin atomBin;
    SpatialBin fooBin;
    Collection liveFoos = new LinkedList();

    static Transform makeFCCtoCartesian() {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Math.cos(Math.toRadians(60.0));
        double d5 = Math.sin(Math.toRadians(60.0));
        double d6 = 0.0;
        double d7 = Math.cos(Math.toRadians(60.0));
        double d8 = Math.tan(Math.toRadians(30.0)) / 2.0;
        double d9 = Math.sqrt(1.0 - d7 * d7 - d8 * d8);
        return new Transform().likeMatrix(d, d4, d7, d2, d5, d8, d3, d6, d9);
    }

    public KingFoo(Collection collection, double d, double d2) {
        this.atomStates = new ArrayList(collection);
        this.fooRadius = d;
        this.touchDist = d2;
        this.atomBin = new SpatialBin(1.5 * (2.0 + d + d2));
        this.fooBin = new SpatialBin(1.5 * d);
        this.atomBin.addAll(this.atomStates);
    }

    public int placeFoos(int n, Triple triple, Triple triple2) {
        double d = 2.0 * (triple2.getX() - this.fooRadius);
        double d2 = 2.0 * (triple2.getX() - this.fooRadius);
        double d3 = 2.0 * (triple2.getX() - this.fooRadius);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Triple triple3 = new Triple(triple.getX() + d * (Math.random() - 0.5), triple.getY() + d2 * (Math.random() - 0.5), triple.getZ() + d3 * (Math.random() - 0.5));
            arrayList.clear();
            this.atomBin.findSphere(triple3, 2.0 + this.fooRadius + this.touchDist, arrayList);
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < arrayList.size(); ++j) {
                AtomState atomState = (AtomState)arrayList.get(j);
                double d4 = triple3.sqDistance(atomState);
                double d5 = this.getVdwRadius(atomState) + this.fooRadius;
                double d6 = d5 + this.touchDist;
                d5 *= d5;
                d6 *= d6;
                if (d4 < d5) {
                    bl = true;
                    break;
                }
                if (!(d4 <= d6)) continue;
                bl2 = true;
            }
            if (bl || !bl2) continue;
            this.fooBin.add(triple3);
            this.liveFoos.add(triple3);
        }
        return this.liveFoos.size();
    }

    public int placeFoosWithProbe(File file) throws IOException {
        String string;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        String string2 = "probe -drop -add" + decimalFormat.format(this.fooRadius) + " -r0.0 -density2.0 -u -out 'not water' '" + file + "'";
        Process process = Runtime.getRuntime().exec(Strings.tokenizeCommandLine(string2));
        ProcessTank processTank = new ProcessTank();
        processTank.fillTank(process);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(processTank.getStdout()));
        while ((string = lineNumberReader.readLine()) != null) {
            String[] stringArray = Strings.explode(string, ':');
            try {
                Triple triple = new Triple(Double.parseDouble(stringArray[14]), Double.parseDouble(stringArray[15]), Double.parseDouble(stringArray[16]));
                this.fooBin.add(triple);
                this.liveFoos.add(triple);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        lineNumberReader.close();
        return this.liveFoos.size();
    }

    public int placeFoosFCC(Triple triple, double d, int n, int n2) {
        Transform transform = KingFoo.makeFCCtoCartesian();
        transform.append(new Transform().likeScale(d));
        transform.append(new Transform().likeTranslation(triple));
        Object object = new HashSet<Triple>();
        object.add(new Triple(0.0, 0.0, 0.0));
        HashSet<Triple> hashSet = new HashSet<Triple>();
        ArrayList arrayList = new ArrayList();
        while (true) {
            int n3;
            Triple triple2;
            Triple triple3 = new Triple();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                triple2 = (Triple)object2.next();
                hashSet.add(triple2);
                transform.transform(triple2, triple3);
                arrayList.clear();
                this.atomBin.findSphere(triple3, 2.0 + this.fooRadius + this.touchDist, arrayList);
                boolean bl = false;
                boolean bl2 = false;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    AtomState atomState = (AtomState)arrayList.get(n3);
                    double d2 = triple3.sqDistance(atomState);
                    double d3 = this.getVdwRadius(atomState) + this.fooRadius;
                    double d4 = d3 + this.touchDist;
                    d3 *= d3;
                    d4 *= d4;
                    if (d2 < d3) {
                        bl = true;
                        break;
                    }
                    if (!(d2 <= d4)) continue;
                    bl2 = true;
                }
                if (n2 <= 0 && bl) {
                    object2.remove();
                    continue;
                }
                if (bl || !bl2) continue;
                this.fooBin.add(triple3);
                this.liveFoos.add(triple3);
                triple3 = new Triple();
            }
            if (--n < 0) break;
            --n2;
            object2 = new HashSet();
            triple2 = new Triple();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Triple triple4 = (Triple)iterator.next();
                for (n3 = 0; n3 < FCC_OFFSETS.length; ++n3) {
                    triple2.like(triple4).add(FCC_OFFSETS[n3]);
                    if (hashSet.contains(triple2)) continue;
                    object2.add(triple2);
                    triple2 = new Triple();
                }
            }
            object = object2;
        }
        return this.liveFoos.size();
    }

    public int removeWetFoos() {
        return this.removeWetFoos(1.4);
    }

    public int removeWetFoos(double d) {
        double d2 = this.fooRadius + d;
        double d3 = 16.0 * (this.fooRadius / d2) * (this.fooRadius / d2);
        new Builder();
        Collection collection = Builder.makeDotSphere(d2, d3);
        Triple triple = new Triple();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.liveFoos.iterator();
        block0: while (iterator.hasNext()) {
            Triple triple2 = (Triple)iterator.next();
            for (Triple triple3 : collection) {
                triple.likeSum(triple2, triple3);
                arrayList.clear();
                this.atomBin.findSphere(triple, 2.0 + d, arrayList);
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    AtomState atomState = (AtomState)arrayList.get(i);
                    String string = atomState.getResidue().getName();
                    if (string.equals("HOH") || string.equals("H2O") || string.equals("WAT")) continue;
                    double d4 = triple.sqDistance(atomState);
                    double d5 = this.getVdwRadius(atomState) + d;
                    if (!(d4 < (d5 *= d5))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                iterator.remove();
                continue block0;
            }
        }
        return this.liveFoos.size();
    }

    public Collection surfaceFoos(double d) {
        new Builder();
        Collection collection = Builder.makeDotSphere(this.fooRadius, d);
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        Triple triple = new Triple();
        ArrayList arrayList2 = new ArrayList();
        for (Triple triple2 : this.liveFoos) {
            for (Triple triple3 : collection) {
                triple.likeSum(triple2, triple3);
                arrayList2.clear();
                this.fooBin.findSphere(triple, 0.99 * this.fooRadius, arrayList2);
                if (arrayList2.size() > 1 || arrayList2.size() == 1 && arrayList2.get(0) == triple2) continue;
                arrayList2.clear();
                this.atomBin.findSphere(triple, 2.0 + this.touchDist, arrayList2);
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    AtomState atomState = (AtomState)arrayList2.get(i);
                    double d2 = triple.sqDistance(atomState);
                    double d3 = this.getVdwRadius(atomState);
                    double d4 = d3 + this.touchDist;
                    d3 *= d3;
                    d4 *= d4;
                    if (d2 < d3) {
                        bl = true;
                        break;
                    }
                    if (!(d2 <= d4)) continue;
                    bl2 = true;
                }
                if (!bl2 || bl) continue;
                arrayList.add(triple);
                triple = new Triple();
            }
        }
        return arrayList;
    }

    double getVdwRadius(AtomState atomState) {
        String string = atomState.getName();
        if (Character.isLetter(string.charAt(0))) {
            return 0.0;
        }
        if (string.charAt(1) == 'H') {
            return 1.17;
        }
        if (string.charAt(1) == 'C') {
            return 1.75;
        }
        if (string.charAt(1) == 'O') {
            return 1.4;
        }
        if (string.charAt(1) == 'N') {
            return 1.55;
        }
        if (string.charAt(1) == 'P') {
            return 1.8;
        }
        if (string.charAt(1) == 'S') {
            return 1.8;
        }
        return 0.0;
    }

    public Collection getFoos() {
        return Collections.unmodifiableCollection(this.liveFoos);
    }
}

