/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import chiropraxis.dangle.XyzSpec;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AtomSpec
extends XyzSpec {
    int resOffset;
    Matcher regexName;
    String starName;
    String primeName;

    public AtomSpec(int n, String string) {
        this.resOffset = n;
        string = string.replace('_', ' ');
        this.primeName = string.replace('*', '\'');
        this.starName = this.primeName.replace('\'', '*');
        if (string.startsWith("/") && string.endsWith("/")) {
            this.regexName = Pattern.compile(string.substring(1, string.length() - 1)).matcher("");
            this.primeName = string;
            this.starName = string;
        } else {
            this.regexName = null;
            this.primeName = string.replace('*', '\'');
            this.starName = this.primeName.replace('\'', '*');
        }
    }

    public AtomState get(Model model, ModelState modelState, Residue residue) {
        Residue residue2 = this.getRes(model, modelState, residue);
        if (residue2 == null) {
            return null;
        }
        Atom atom = null;
        if (this.regexName == null) {
            atom = residue2.getAtom(this.starName);
            if (atom == null) {
                atom = residue2.getAtom(this.primeName);
            }
        } else {
            Iterator iterator = residue2.getAtoms().iterator();
            while (iterator.hasNext() && atom == null) {
                Atom atom2 = (Atom)iterator.next();
                if (!this.regexName.reset(atom2.getName()).matches()) continue;
                atom = atom2;
            }
        }
        if (atom == null) {
            return null;
        }
        try {
            return modelState.get(atom);
        }
        catch (AtomException atomException) {
            return null;
        }
    }

    public Collection getAll(Model model, ModelState modelState, Residue residue) {
        Residue residue2 = this.getRes(model, modelState, residue);
        if (residue2 == null) {
            return Collections.emptySet();
        }
        if (this.regexName == null) {
            Atom atom = residue2.getAtom(this.starName);
            if (atom == null) {
                atom = residue2.getAtom(this.primeName);
            }
            if (atom == null) {
                return Collections.emptySet();
            }
            try {
                return Collections.singleton(modelState.get(atom));
            }
            catch (AtomException atomException) {
                return Collections.emptySet();
            }
        }
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Atom atom : residue2.getAtoms()) {
            if (!this.regexName.reset(atom.getName()).matches()) continue;
            try {
                arrayList.add(modelState.get(atom));
            }
            catch (AtomException atomException) {}
        }
        return arrayList;
    }

    protected Residue getRes(Model model, ModelState modelState, Residue residue) {
        Residue residue2 = residue;
        int n = Math.abs(this.resOffset);
        for (int i = 0; i < n; ++i) {
            Residue residue3 = residue2;
            residue2 = this.resOffset > 0 ? residue.getNext(model) : residue.getPrev(model);
            if (residue2 == null) {
                return null;
            }
            if (!(this.resOffset > 0 ? !this.checkConnection(model, modelState, residue3, residue2) : !this.checkConnection(model, modelState, residue2, residue3))) continue;
            return null;
        }
        return residue2;
    }

    private boolean checkConnection(Model model, ModelState modelState, Residue residue, Residue residue2) {
        Atom atom = null;
        Atom atom2 = null;
        Atom atom3 = null;
        Atom atom4 = null;
        atom = residue.getAtom(" C  ");
        atom2 = residue2.getAtom(" N  ");
        if (atom != null && atom2 != null) {
            try {
                AtomState atomState = modelState.get(atom);
                AtomState atomState2 = modelState.get(atom2);
                return atomState.sqDistance(atomState2) <= 4.0;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        atom3 = residue.getAtom(" O3*");
        if (atom3 == null) {
            atom3 = residue.getAtom(" O3'");
        }
        atom4 = residue2.getAtom(" P  ");
        if (atom3 != null && atom4 != null) {
            try {
                AtomState atomState = modelState.get(atom3);
                AtomState atomState3 = modelState.get(atom4);
                return atomState.sqDistance(atomState3) <= 4.84;
            }
            catch (AtomException atomException) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        String string = "i";
        if (this.resOffset > 0) {
            string = string + "+" + this.resOffset;
        } else if (this.resOffset < 0) {
            string = string + this.resOffset;
        }
        return string + " " + this.starName.replace(' ', '_');
    }

    protected int getResOffset() {
        return this.resOffset;
    }
}

