/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Disulfide;
import driftwood.moldb2.Disulfides;
import java.util.Collection;
import java.util.Iterator;

class PdbDisulfides
extends Disulfides {
    public PdbDisulfides(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                if (!string.startsWith("SSBOND ")) continue;
                this.add(this.forDisulfide(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Non-numeric sequence numbers: " + string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.err.println("PDB record too short: " + string);
            }
        }
    }

    Disulfide forDisulfide(String string) throws NumberFormatException {
        Disulfide disulfide = new Disulfide();
        disulfide.initChainId = string.substring(15, 16);
        disulfide.endChainId = string.substring(29, 30);
        disulfide.type = !disulfide.initChainId.equals(disulfide.endChainId) ? Disulfide.INTER_CHAIN : Disulfide.INTRA_CHAIN;
        disulfide.initSeqNum = Integer.parseInt(string.substring(17, 21).trim());
        disulfide.endSeqNum = Integer.parseInt(string.substring(31, 35).trim());
        disulfide.initICode = string.substring(21, 22);
        disulfide.endICode = string.length() >= 36 ? string.substring(35, 36) : " ";
        return disulfide;
    }
}

