/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;

public class Bond
implements Comparable {
    public final AtomState lower;
    public final AtomState higher;
    final int iLow;
    final int iHigh;
    public final Bond mirror;

    public Bond(AtomState atomState, int n, AtomState atomState2, int n2) {
        if (n > n2) {
            this.lower = atomState2;
            this.iLow = n2;
            this.higher = atomState;
            this.iHigh = n;
        } else {
            this.lower = atomState;
            this.iLow = n;
            this.higher = atomState2;
            this.iHigh = n2;
        }
        this.mirror = new Bond(this);
    }

    private Bond(Bond bond) {
        this.lower = bond.higher;
        this.higher = bond.lower;
        this.iLow = bond.iLow;
        this.iHigh = bond.iHigh;
        this.mirror = bond;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.iLow << 16 | this.iHigh;
    }

    public int compareTo(Object object) {
        Bond bond = (Bond)object;
        int n = this.iLow - bond.iLow;
        if (n == 0) {
            n = this.iHigh - bond.iHigh;
        }
        return n;
    }

    public static void optimizeBondSequence(Bond[] bondArray) {
        int n = 0;
        while (n < bondArray.length) {
            int n2;
            Residue residue = bondArray[n].lower.getResidue();
            for (n2 = n; n2 < bondArray.length && (residue.equals(bondArray[n2].lower.getResidue()) || residue.equals(bondArray[n2].higher.getResidue())); ++n2) {
            }
            while (n < n2) {
                Bond.extendLeft(bondArray, n, n2);
                n = Bond.extendRight(bondArray, n, n2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void extendLeft(Bond[] bondArray, int n, int n2) {
        while (n < n2) {
            block4: {
                int n3;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    if (bondArray[n].lower != bondArray[n3].higher) continue;
                    Bond.rotateRight(bondArray, n, n3);
                    break block4;
                }
                n3 = n + 1;
                while (n3 < n2) {
                    if (bondArray[n].lower == bondArray[n3].lower) {
                        bondArray[n3] = bondArray[n3].mirror;
                        Bond.rotateRight(bondArray, n, n3);
                        break block4;
                    }
                    ++n3;
                }
                break block0;
                return;
            }
            ++n;
        }
    }

    private static int extendRight(Bond[] bondArray, int n, int n2) {
        while (n < n2) {
            block3: {
                int n3;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    if (bondArray[n].higher != bondArray[n3].lower) continue;
                    Bond.rotateRight(bondArray, n + 1, n3);
                    break block3;
                }
                for (n3 = n + 1; n3 < n2; ++n3) {
                    if (bondArray[n].higher != bondArray[n3].higher) continue;
                    bondArray[n3] = bondArray[n3].mirror;
                    Bond.rotateRight(bondArray, n + 1, n3);
                    break block3;
                }
                ++n;
                break;
            }
            ++n;
        }
        return n;
    }

    private static void rotateRight(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        Object object = objectArray[n2];
        for (int i = n2; i > n; --i) {
            objectArray[i] = objectArray[i - 1];
        }
        objectArray[n] = object;
    }
}

