/*
 * Decompiled with CFR 0.152.
 */
package king.painters;

import com.sun.opengl.util.GLUT;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import king.core.AGE;
import king.core.Engine;
import king.core.KIterator;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.KView;

public class JoglEngine3D
extends Engine {
    public Triple screenCenterPos = new Triple(0.0, 0.0, 0.0);
    public Triple screenNormalVec = new Triple(0.0, 0.0, 1.0);
    public Triple screenUpVec = new Triple(0.0, 1.0, 0.0);
    public boolean caveClipping = false;
    protected GL gl;
    protected GLU glu;
    protected GLUT glut;
    protected float[] clearColor;
    protected int currFont = 7;
    protected Triple[] icosVerts = new Triple[]{new Triple(-0.5257311121191336, 0.0, 0.8506508083520399), new Triple(0.5257311121191336, 0.0, 0.8506508083520399), new Triple(-0.5257311121191336, 0.0, -0.8506508083520399), new Triple(0.5257311121191336, 0.0, -0.8506508083520399), new Triple(0.0, 0.8506508083520399, 0.5257311121191336), new Triple(0.0, 0.8506508083520399, -0.5257311121191336), new Triple(0.0, -0.8506508083520399, 0.5257311121191336), new Triple(0.0, -0.8506508083520399, -0.5257311121191336), new Triple(0.8506508083520399, 0.5257311121191336, 0.0), new Triple(-0.8506508083520399, 0.5257311121191336, 0.0), new Triple(0.8506508083520399, -0.5257311121191336, 0.0), new Triple(-0.8506508083520399, -0.5257311121191336, 0.0)};
    protected int[][] icosFaces = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}};
    protected int ballDL = 0;

    public void cleanup(GL gL) {
        if (this.ballDL != 0) {
            gL.glDeleteLists(this.ballDL, 1);
            this.ballDL = 0;
        }
    }

    public void render(AGE aGE, KView kView, Rectangle rectangle, GL gL) {
        this.render(aGE, kView, rectangle, gL, new Triple(0.0, 0.0, this.perspDist));
    }

    public void render(AGE aGE, KView kView, Rectangle rectangle, GL gL, Tuple3 tuple3) {
        this.gl = gL;
        this.glu = new GLU();
        this.glut = new GLUT();
        this.clearColor = this.whiteBackground ? new float[]{1.0f, 1.0f, 1.0f, 1.0f} : new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        gL.glEnable(3042);
        gL.glBlendFunc(770, 771);
        gL.glEnable(2832);
        gL.glEnable(2848);
        Transform transform = this.setupTransforms(kView, rectangle, tuple3);
        this.setupLighting(transform);
        gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
        gL.glEnable(2929);
        gL.glClear(16640);
        for (KList kList : KIterator.visibleLists(aGE)) {
            String string = kList.getType();
            if ("vector".equals(string)) {
                this.doVectorList(kList);
                continue;
            }
            if ("dot".equals(string)) {
                this.doDotList(kList);
                continue;
            }
            if ("ribbon".equals(string)) {
                this.doTriangleList(kList, true);
                continue;
            }
            if ("ball".equals(string)) {
                this.doBallList(kList);
                continue;
            }
            if ("sphere".equals(string)) {
                this.doBallList(kList);
                continue;
            }
            if ("triangle".equals(string)) {
                this.doTriangleList(kList, false);
                continue;
            }
            if ("mark".equals(string)) {
                this.doDotList(kList);
                continue;
            }
            if ("label".equals(string)) {
                this.doLabelList(kList);
                continue;
            }
            if ("ring".equals(string)) {
                this.doDotList(kList);
                continue;
            }
            if ("arrow".equals(string)) {
                this.doDotList(kList);
                continue;
            }
            this.doDotList(kList);
        }
    }

    protected void setupLighting(Transform transform) {
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMultMatrixd(new double[]{transform.get(1, 1), transform.get(2, 1), transform.get(3, 1), transform.get(4, 1), transform.get(1, 2), transform.get(2, 2), transform.get(3, 2), transform.get(4, 2), transform.get(1, 3), transform.get(2, 3), transform.get(3, 3), transform.get(4, 3), transform.get(1, 4), transform.get(2, 4), transform.get(3, 4), transform.get(4, 4)}, 0);
        this.gl.glEnable(2977);
        this.gl.glEnable(16384);
        float f = 1.0f;
        float f2 = 0.3f * f;
        float f3 = 0.8f * f;
        float f4 = 0.0f * f;
        this.gl.glLightfv(16384, 4608, new float[]{f2, f2, f2, 1.0f}, 0);
        this.gl.glLightfv(16384, 4609, new float[]{f3, f3, f3, 1.0f}, 0);
        this.gl.glLightfv(16384, 4610, new float[]{f4, f4, f4, 1.0f}, 0);
        Triple triple = this.lightingVector;
        this.gl.glLightfv(16384, 4611, new float[]{-((float)triple.getX()), -((float)triple.getY()), -((float)triple.getZ()), 0.0f}, 0);
        this.gl.glLightModelfv(2899, new float[]{0.0f, 0.0f, 0.0f, 1.0f}, 0);
        this.gl.glLightModeli(2897, 0);
        this.gl.glLightModeli(2898, 1);
        this.gl.glEnable(2903);
        this.gl.glColorMaterial(1032, 5634);
        this.gl.glMaterialfv(1032, 4610, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0);
        this.gl.glMaterialf(1032, 5633, 80.0f);
        this.gl.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transform setupTransforms(KView kView, Rectangle rectangle, Tuple3 tuple3) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = rectangle.getWidth();
        double d15 = rectangle.getHeight();
        double d16 = Math.min(d14, d15);
        double d17 = rectangle.getX() + d14 / 2.0;
        double d18 = rectangle.getY() + d15 / 2.0;
        this.viewClipScaling = d16 / 2.0;
        Serializable serializable = kView;
        synchronized (serializable) {
            kView.compile();
            this.zoom3D = d16 / (double)kView.getSpan();
            d13 = kView.cx;
            d12 = kView.cy;
            d11 = kView.cz;
            d10 = kView.R11;
            d9 = kView.R12;
            d8 = kView.R13;
            d7 = kView.R21;
            d6 = kView.R22;
            d5 = kView.R23;
            d4 = kView.R31;
            d3 = kView.R32;
            d2 = kView.R33;
            this.viewClipFront = kView.getClip();
            this.viewClipBack = -this.viewClipFront;
        }
        this.gl.glViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        serializable = new Triple(this.screenNormalVec).unit();
        Triple triple = new Triple().likeVector(this.screenCenterPos, tuple3);
        if (triple.dot((Tuple3)((Object)serializable)) < 0.0) {
            ((Triple)serializable).neg();
        }
        Triple triple2 = new Triple(this.screenUpVec).cross((Tuple3)((Object)serializable)).unit();
        Triple triple3 = new Triple((Tuple3)((Object)serializable)).cross(triple2);
        Transform transform = new Transform().likeMatrix(triple2.getX(), triple2.getY(), triple2.getZ(), triple3.getX(), triple3.getY(), triple3.getZ(), ((Triple)serializable).getX(), ((Triple)serializable).getY(), ((Triple)serializable).getZ());
        Triple triple4 = new Triple(tuple3).neg();
        transform.prepend(new Transform().likeTranslation(triple4));
        Triple triple5 = (Triple)transform.transform(this.screenCenterPos, new Triple());
        double d19 = d16 / 20.0;
        double d20 = -triple5.getZ();
        double d21 = Math.max(d20 - this.viewClipScaling * this.viewClipFront, d19);
        double d22 = Math.max(d20 - this.viewClipScaling * this.viewClipBack, 2.0 * d19);
        double d23 = (triple5.getX() + d14 / 2.0) * (d21 / d20);
        double d24 = (triple5.getX() - d14 / 2.0) * (d21 / d20);
        double d25 = (triple5.getY() + d15 / 2.0) * (d21 / d20);
        double d26 = (triple5.getY() - d15 / 2.0) * (d21 / d20);
        if (this.caveClipping) {
            d = d21 - d19;
            d21 -= d;
            d22 -= d;
        }
        if (this.usePerspective) {
            this.gl.glFrustum(d24, d23, d26, d25, d21, d22);
        } else {
            this.gl.glOrtho(d24, d23, d26, d25, d21, d22);
        }
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glMultMatrixd(new double[]{transform.get(1, 1), transform.get(2, 1), transform.get(3, 1), transform.get(4, 1), transform.get(1, 2), transform.get(2, 2), transform.get(3, 2), transform.get(4, 2), transform.get(1, 3), transform.get(2, 3), transform.get(3, 3), transform.get(4, 3), transform.get(1, 4), transform.get(2, 4), transform.get(3, 4), transform.get(4, 4)}, 0);
        this.gl.glMultMatrixd(new double[]{d10, d7, d4, 0.0, d9, d6, d3, 0.0, d8, d5, d2, 0.0, 0.0, 0.0, 0.0, 1.0}, 0);
        this.gl.glScaled(this.zoom3D, this.zoom3D, this.zoom3D);
        this.gl.glTranslated(-d13, -d12, -d11);
        this.gl.glEnable(2912);
        this.gl.glFogi(2917, 9729);
        this.gl.glFogf(2915, (float)d21);
        d = (d22 - 0.36 * d21) / 0.64;
        this.gl.glFogf(2916, (float)d);
        this.gl.glFogfv(2918, this.clearColor, 0);
        return transform;
    }

    private void printMatrix(String string, double[] dArray) {
        System.err.println(string);
        System.err.printf("%10g %10g %10g %10g \n", dArray[0], dArray[4], dArray[8], dArray[12]);
        System.err.printf("%10g %10g %10g %10g \n", dArray[1], dArray[5], dArray[9], dArray[13]);
        System.err.printf("%10g %10g %10g %10g \n", dArray[2], dArray[6], dArray[10], dArray[14]);
        System.err.printf("%10g %10g %10g %10g \n", dArray[3], dArray[7], dArray[11], dArray[15]);
    }

    protected double[] ar_frustumMatrix(Triple triple, Triple triple2, Triple triple3, Triple triple4, double d, double d2, double d3, double d4) {
        if (triple2.mag() <= 0.0) {
            return null;
        }
        Triple triple5 = new Triple(triple2).unit();
        Triple triple6 = new Triple(triple5).cross(triple3).unit();
        Triple triple7 = new Triple(triple6).cross(triple5);
        Triple triple8 = new Triple(triple).addMult(d, triple6);
        Triple triple9 = new Triple(triple).addMult(-d, triple6);
        Triple triple10 = new Triple(triple).addMult(d2, triple7);
        Triple triple11 = new Triple(triple).addMult(-d2, triple7);
        double d5 = new Triple(triple).sub(triple4).dot(triple5);
        if (d5 == 0.0) {
            return null;
        }
        double d6 = d3;
        double d7 = d6 / d5;
        double d8 = d7 * new Triple(triple8).sub(triple4).dot(triple6);
        double d9 = d7 * new Triple(triple9).sub(triple4).dot(triple6);
        double d10 = d7 * new Triple(triple10).sub(triple4).dot(triple7);
        double d11 = d7 * new Triple(triple11).sub(triple4).dot(triple7);
        double d12 = d5 + d4;
        if (d8 == d9 || d10 == d11 || d6 == d12) {
            return null;
        }
        double[] dArray = new double[]{2.0 * d6 / (d8 - d9), 0.0, 0.0, 0.0, 0.0, 2.0 * d6 / (d10 - d11), 0.0, 0.0, (d8 + d9) / (d8 - d9), (d10 + d11) / (d10 - d11), (d6 + d12) / (d6 - d12), -1.0, 0.0, 0.0, 2.0 * d6 * d12 / (d6 - d12), 0.0};
        return dArray;
    }

    protected void doVectorList(KList kList) {
        KPaint kPaint = kList.getColor();
        if (kPaint.isInvisible()) {
            return;
        }
        this.setPaint(kPaint);
        int n = kList.getWidth();
        this.gl.glLineWidth((float)n + 0.5f);
        this.gl.glBegin(3);
        for (KPoint kPoint : kList.getChildren()) {
            int n2;
            KPaint kPaint2;
            if (kPoint.isBreak()) {
                this.gl.glEnd();
                this.gl.glBegin(3);
            }
            if ((kPaint2 = kPoint.getDrawingColor(this)).isInvisible()) continue;
            if (kPaint2 != kPaint) {
                this.setPaint(kPaint2);
                kPaint = kPaint2;
            }
            if ((n2 = this.calcLineWidth(kPoint, kList)) != n) {
                this.gl.glLineWidth((float)n2 + 0.5f);
                n = n2;
            }
            this.gl.glVertex3d(kPoint.getX(), kPoint.getY(), kPoint.getZ());
        }
        this.gl.glEnd();
    }

    protected void doDotList(KList kList) {
        KPaint kPaint = kList.getColor();
        if (kPaint.isInvisible()) {
            return;
        }
        this.setPaint(kPaint);
        int n = kList.getWidth();
        this.gl.glPointSize((float)n + 0.5f);
        this.gl.glBegin(0);
        for (KPoint kPoint : kList.getChildren()) {
            int n2;
            KPaint kPaint2 = kPoint.getDrawingColor(this);
            if (kPaint2.isInvisible()) continue;
            if (kPaint2 != kPaint) {
                this.setPaint(kPaint2);
                kPaint = kPaint2;
            }
            if ((n2 = this.calcLineWidth(kPoint, kList)) != n) {
                this.gl.glLineWidth((float)n2 + 0.5f);
                n = n2;
            }
            this.gl.glVertex3d(kPoint.getX(), kPoint.getY(), kPoint.getZ());
        }
        this.gl.glEnd();
    }

    protected void doBallList(KList kList) {
        double d = 4.0 / this.zoom3D;
        double d2 = 12.0 / this.zoom3D;
        double d3 = 128.0 / this.zoom3D;
        KPaint kPaint = kList.getColor();
        if (kPaint.isInvisible()) {
            return;
        }
        this.setPaint(kPaint);
        double d4 = kList.getRadius();
        for (KPoint kPoint : kList.getChildren()) {
            double d5;
            KPaint kPaint2 = kPoint.getDrawingColor(this);
            if (kPaint2.isInvisible()) continue;
            if (kPaint2 != kPaint) {
                this.setPaint(kPaint2);
                kPaint = kPaint2;
            }
            if ((d5 = (double)kPoint.getRadius()) == 0.0) {
                d5 = d4;
            }
            this.gl.glPushMatrix();
            this.gl.glTranslated(kPoint.getX(), kPoint.getY(), kPoint.getZ());
            this.gl.glScaled(d5, d5, d5);
            if (d5 <= d) {
                this.drawSphere(0);
            } else if (d5 <= d2) {
                this.drawSphere(1);
            } else if (d5 <= d3) {
                this.drawSphere(2);
            } else {
                this.drawSphere(3);
            }
            this.gl.glPopMatrix();
        }
    }

    protected void drawSphere(int n) {
        if (this.ballDL == 0) {
            this.ballDL = this.gl.glGenLists(4);
            if (this.ballDL != 0) {
                for (int i = 0; i <= 3; ++i) {
                    this.gl.glNewList(this.ballDL + i, 4864);
                    this.gl.glEnable(2896);
                    this.gl.glBegin(4);
                    int[][] nArray = this.icosFaces;
                    int n2 = nArray.length;
                    for (int j = 0; j < n2; ++j) {
                        int[] nArray2 = nArray[j];
                        this.drawSphereFace(this.icosVerts[nArray2[0]], this.icosVerts[nArray2[1]], this.icosVerts[nArray2[2]], i);
                    }
                    this.gl.glEnd();
                    this.gl.glDisable(2896);
                    this.gl.glEndList();
                }
            }
        }
        if (this.ballDL != 0 && n <= 3) {
            this.gl.glCallList(this.ballDL + n);
        } else {
            this.gl.glEnable(2896);
            this.gl.glBegin(4);
            for (int[] nArray : this.icosFaces) {
                this.drawSphereFace(this.icosVerts[nArray[0]], this.icosVerts[nArray[1]], this.icosVerts[nArray[2]], n);
            }
            this.gl.glEnd();
            this.gl.glDisable(2896);
        }
    }

    protected void drawSphereFace(Triple triple, Triple triple2, Triple triple3, int n) {
        if (n == 0) {
            this.gl.glNormal3d(triple.getX(), triple.getY(), triple.getZ());
            this.gl.glVertex3d(triple.getX(), triple.getY(), triple.getZ());
            this.gl.glNormal3d(triple2.getX(), triple2.getY(), triple2.getZ());
            this.gl.glVertex3d(triple2.getX(), triple2.getY(), triple2.getZ());
            this.gl.glNormal3d(triple3.getX(), triple3.getY(), triple3.getZ());
            this.gl.glVertex3d(triple3.getX(), triple3.getY(), triple3.getZ());
        } else {
            Triple triple4 = new Triple().likeMidpoint(triple, triple2).unit();
            Triple triple5 = new Triple().likeMidpoint(triple2, triple3).unit();
            Triple triple6 = new Triple().likeMidpoint(triple3, triple).unit();
            this.drawSphereFace(triple, triple4, triple6, --n);
            this.drawSphereFace(triple2, triple5, triple4, n);
            this.drawSphereFace(triple3, triple6, triple5, n);
            this.drawSphereFace(triple4, triple5, triple6, n);
        }
    }

    protected void doLabelList(KList kList) {
        KPaint kPaint = kList.getColor();
        if (kPaint.isInvisible()) {
            return;
        }
        this.setPaint(kPaint);
        for (KPoint kPoint : kList.getChildren()) {
            KPaint kPaint2 = kPoint.getDrawingColor(this);
            if (kPaint2.isInvisible()) continue;
            if (kPaint2 != kPaint) {
                this.setPaint(kPaint2);
                kPaint = kPaint2;
            }
            this.gl.glRasterPos3d(kPoint.getX(), kPoint.getY(), kPoint.getZ());
            this.glut.glutBitmapString(this.currFont, kPoint.getName());
        }
    }

    protected void doTriangleList(KList kList, boolean bl) {
        KPaint kPaint = kList.getColor();
        if (kPaint.isInvisible()) {
            return;
        }
        this.setPaint(kPaint);
        this.gl.glEnable(2896);
        this.gl.glBegin(5);
        KPoint kPoint = null;
        KPoint kPoint2 = null;
        boolean bl2 = false;
        for (KPoint kPoint3 : kList.getChildren()) {
            KPaint kPaint2;
            if (kPoint3.isBreak()) {
                this.gl.glEnd();
                kPoint2 = null;
                kPoint = null;
                bl2 = false;
                this.gl.glBegin(5);
            }
            if ((kPaint2 = kPoint3.getDrawingColor(this)).isInvisible()) continue;
            if (kPaint2 != kPaint) {
                this.setPaint(kPaint2);
                kPaint = kPaint2;
            }
            if (kPoint != null && kPoint2 != null) {
                this.work2.likeVector(kPoint2, kPoint);
                this.work1.likeVector(kPoint, kPoint3);
                this.work1.cross(this.work2);
                if (bl2) {
                    if (!bl) {
                        this.gl.glNormal3d(-this.work1.getX(), -this.work1.getY(), -this.work1.getZ());
                    }
                } else {
                    this.gl.glNormal3d(this.work1.getX(), this.work1.getY(), this.work1.getZ());
                }
            }
            this.gl.glVertex3d(kPoint3.getX(), kPoint3.getY(), kPoint3.getZ());
            kPoint2 = kPoint;
            kPoint = kPoint3;
            bl2 = !bl2;
        }
        this.gl.glEnd();
        this.gl.glDisable(2896);
    }

    protected void setPaint(KPaint kPaint) {
        try {
            Color color = this.whiteBackground ? kPaint.getWhiteExemplar() : kPaint.getBlackExemplar();
            this.gl.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            System.err.println("JoglPainter: tried painting with non-Color type of Paint");
        }
    }

    protected int calcLineWidth(KPoint kPoint, KList kList) {
        int n = kPoint.getWidth();
        if (this.thinLines) {
            return 1;
        }
        if (n > 0) {
            return n;
        }
        if (kList != null) {
            return kList.getWidth();
        }
        return 2;
    }

    public void setFont(Font font) {
        this.setFont(font.getSize());
    }

    public void setFont(int n) {
        this.currFont = n <= 10 ? 6 : (n <= 14 ? 7 : 8);
    }

    protected int getLabelWidth(String string) {
        return this.glut.glutBitmapLength(this.currFont, string);
    }

    protected int getLabelAscent(String string) {
        if (this.currFont == 6) {
            return 10;
        }
        if (this.currFont == 7) {
            return 12;
        }
        if (this.currFont == 8) {
            return 18;
        }
        return 1;
    }

    protected int getLabelDescent(String string) {
        return this.getLabelAscent(string) / 4;
    }
}

