/*
 * Decompiled with CFR 0.152.
 */
package king.painters;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import king.core.KPaint;
import king.core.KPalette;
import king.painters.StandardPainter;

public class HighQualityPainter
extends StandardPainter {
    Line2D.Double line1 = new Line2D.Double();
    Ellipse2D.Double ellipse1 = new Ellipse2D.Double();
    GeneralPath path1 = new GeneralPath();

    public HighQualityPainter(boolean bl) {
        super(bl);
    }

    public void paintBall(Paint paint, double d, double d2, double d3, double d4, boolean bl) {
        if (d4 < 0.5) {
            d4 = 0.5;
        }
        double d5 = 2.0 * d4;
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pen0);
        this.ellipse1.setFrame(d - d4, d2 - d4, d5, d5);
        this.g.fill(this.ellipse1);
        try {
            Color color = (Color)paint;
            if (d5 >= 10.0 && color.getAlpha() == 255) {
                this.g.setPaint(KPaint.black);
                this.g.setStroke(KPalette.pen1);
                this.g.draw(this.ellipse1);
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            System.err.println("HighQualityPainter: tried painting with non-Color type of Paint");
        }
        if (bl) {
            double d6 = 0.5 * d4;
            d5 = 0.3 * d4;
            this.g.setPaint(Color.white);
            this.g.setStroke(KPalette.pen0);
            this.ellipse1.setFrame(d - d6, d2 - d6, d5, d5);
            this.g.fill(this.ellipse1);
        }
    }

    public void paintDot(Paint paint, double d, double d2, double d3, int n) {
        int n2 = n / 2;
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pen0);
        this.ellipse1.setFrame(d - (double)n2, d2 - (double)n2, n, n);
        this.g.fill(this.ellipse1);
    }

    public void paintSphereDisk(Paint paint, double d, double d2, double d3, double d4) {
        if (d4 < 0.5) {
            d4 = 0.5;
        }
        double d5 = 2.0 * d4;
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pen0);
        this.ellipse1.setFrame(d - d4, d2 - d4, d5, d5);
        this.g.fill(this.ellipse1);
    }

    public void paintTriangle(Paint paint, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pen1);
        this.path1.reset();
        this.path1.moveTo((float)d, (float)d2);
        this.path1.lineTo((float)d4, (float)d5);
        this.path1.lineTo((float)d7, (float)d8);
        this.path1.closePath();
        this.g.fill(this.path1);
        this.g.draw(this.path1);
    }

    public void paintVector(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pens[n - 1][n2]);
        this.line1.setLine(d, d2, d4, d5);
        this.g.draw(this.line1);
    }

    public void drawOval(Paint paint, double d, double d2, double d3, double d4, double d5) {
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pen1);
        this.ellipse1.setFrame(d - d4 / 2.0, d2 - d5 / 2.0, d4, d5);
        this.g.draw(this.ellipse1);
    }

    public void drawOval(Paint paint, int n, int n2, double d, double d2, double d3, double d4, double d5) {
        this.g.setPaint(paint);
        this.g.setStroke(KPalette.pens[n - 1][n2]);
        this.ellipse1.setFrame(d - d4 / 2.0, d2 - d5 / 2.0, d4, d5);
        this.g.draw(this.ellipse1);
    }
}

