/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.r3.Transform;
import king.ParaParams;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.Kinemage;
import king.points.VectorPoint;

public class ParaPoint
extends VectorPoint {
    KPoint proxyFor;
    int dimIdx;
    ParaParams params;
    double width;

    public ParaPoint(KPoint kPoint, int n, ParaPoint paraPoint, ParaParams paraParams, double d) {
        super(kPoint.getName(), paraPoint);
        this.setParent((KList)kPoint.getParent());
        this.proxyFor = kPoint;
        this.dimIdx = n;
        this.params = paraParams;
        this.width = d;
        if (d < 900.0) {
            this.width = 900.0;
        }
        this.syncCoords();
    }

    protected void syncCoords() {
        float[] fArray = this.proxyFor.getAllCoords();
        if (fArray == null || fArray.length <= this.dimIdx) {
            throw new IllegalArgumentException("Not enough coordinates in proxy to support parallel coords");
        }
        this.x0 = (float)(1.0 * (double)this.dimIdx / (double)(this.params.getNumDim() - 1) + (double)(((float)this.dimIdx - (float)this.params.getNumDim() / 2.0f) / (float)(this.params.getNumDim() - 1)) * (this.width - 900.0) / 900.0);
        this.y0 = (float)(((double)fArray[this.dimIdx] - this.params.getMin(this.dimIdx)) / this.params.getRange(this.dimIdx));
        this.z0 = 0.0f;
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public void setZ(double d) {
    }

    public void setXYZ(double d, double d2, double d3) {
    }

    public void useCoordsXYZ(int n, int n2, int n3) {
        this.proxyFor.useCoordsXYZ(n, n2, n3);
    }

    public boolean isOn() {
        return this.proxyFor.isOn();
    }

    public void setOn(boolean bl) {
        this.proxyFor.setOn(bl);
    }

    public boolean isUnpickable() {
        return this.proxyFor.isUnpickable();
    }

    public void setUnpickable(boolean bl) {
        this.proxyFor.setUnpickable(bl);
    }

    public boolean isGhost() {
        return this.proxyFor.isGhost();
    }

    public void setGhost(boolean bl) {
        this.proxyFor.setGhost(bl);
    }

    public KPaint getColor() {
        return this.proxyFor.getColor();
    }

    public void setColor(KPaint kPaint) {
        this.proxyFor.setColor(kPaint);
    }

    public String getAspects() {
        return this.proxyFor.getAspects();
    }

    public void setAspects(String string) {
        this.proxyFor.setAspects(string);
    }

    public float getRadius() {
        return this.proxyFor.getRadius();
    }

    public void setRadius(float f) {
        this.proxyFor.setRadius(f);
    }

    public void setComment(String string) {
        this.proxyFor.setComment(string);
    }

    public String getComment() {
        return this.proxyFor.getComment();
    }

    public KPaint getDrawingColor() {
        return this.proxyFor.getDrawingColor();
    }

    public KPaint getDrawingColor(Engine engine) {
        return this.proxyFor.getDrawingColor(engine);
    }

    public void pmHit(int n, int n2, boolean bl) {
        this.proxyFor.pmHit(n, n2, bl);
    }

    public boolean pmWouldHit(int n) {
        return this.proxyFor.pmWouldHit(n);
    }

    public int getPmMask() {
        return this.proxyFor.getPmMask();
    }

    public void setPmMask(int n) {
        this.proxyFor.setPmMask(n);
    }

    public void calcBoundingBox(float[] fArray) {
        this.syncCoords();
        super.calcBoundingBox(fArray);
    }

    public float calcRadiusSq(float[] fArray) {
        this.syncCoords();
        return super.calcRadiusSq(fArray);
    }

    public void doTransform(Engine engine, Transform transform) {
        this.syncCoords();
        super.doTransform(engine, transform);
    }

    public void doTransform(Engine engine, Transform transform, double d) {
        this.syncCoords();
        super.doTransform(engine, transform, d);
    }

    public void paint2D(Engine2D engine2D) {
        super.paint2D(engine2D);
    }

    public KPoint isPickedBy(float f, float f2, float f3, boolean bl) {
        return super.isPickedBy(f, f2, f3, bl);
    }

    public String getName() {
        return this.proxyFor.getName();
    }

    public void setName(String string) {
        if (this.proxyFor == null) {
            super.setName(string);
        } else {
            this.proxyFor.setName(string);
        }
    }

    public KList getParent() {
        if (this.proxyFor == null) {
            return super.getParent();
        }
        return (KList)this.proxyFor.getParent();
    }

    public void setParent(KList kList) {
        if (this.proxyFor == null) {
            super.setParent(kList);
        } else {
            this.proxyFor.setParent(kList);
        }
    }

    public String toString() {
        return this.proxyFor.toString();
    }

    public Kinemage getKinemage() {
        return this.proxyFor.getKinemage();
    }

    public boolean isVisible() {
        return this.proxyFor.isVisible();
    }
}

