/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import driftwood.r3.MutableTuple3;
import driftwood.r3.Transform;

public class Quaternion
implements MutableTuple3 {
    protected double x;
    protected double y;
    protected double z;
    protected double w;

    public Quaternion() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public void setW(double d) {
        this.w = d;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void setXYZW(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Quaternion likeRotation(Transform transform) {
        double d = transform.m11 + transform.m22 + transform.m33;
        if (d > 0.0) {
            double d2 = Math.sqrt(d + 1.0);
            this.w = d2 * 0.5;
            d2 = 0.5 / d2;
            this.x = (transform.m23 - transform.m32) * d2;
            this.y = (transform.m31 - transform.m13) * d2;
            this.z = (transform.m12 - transform.m21) * d2;
        } else {
            int n = 1;
            int n2 = 2;
            int n3 = 3;
            if (transform.m22 > transform.m11) {
                n = 2;
                n2 = 3;
                n3 = 1;
            }
            if (transform.m33 > transform.get(n, n)) {
                n = 3;
                n2 = 1;
                n3 = 2;
            }
            double d3 = Math.sqrt(transform.get(n, n) - (transform.get(n2, n2) + transform.get(n3, n3)) + 1.0);
            double[] dArray = new double[4];
            dArray[n] = d3 * 0.5;
            d3 = 0.5 / d3;
            dArray[n2] = (transform.get(n, n2) + transform.get(n2, n)) * d3;
            dArray[n3] = (transform.get(n, n3) + transform.get(n3, n)) * d3;
            this.x = dArray[1];
            this.y = dArray[2];
            this.z = dArray[3];
            this.w = (transform.get(n2, n3) - transform.get(n3, n2)) * d3;
        }
        return this;
    }

    public Quaternion likeSlerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        double d2 = quaternion.getX() * quaternion2.getX() + quaternion.getY() * quaternion2.getY() + quaternion.getZ() * quaternion2.getZ() + quaternion.getW() * quaternion2.getW();
        if (d2 < 0.0) {
            d2 = -d2;
            quaternion = new Quaternion(-quaternion.getX(), -quaternion.getY(), -quaternion.getZ(), -quaternion.getW());
        }
        if (1.0 + d2 > 1.0E-10) {
            double d3;
            double d4;
            if (1.0 - d2 > 1.0E-10) {
                double d5 = Math.acos(d2);
                double d6 = Math.sin(d5);
                d4 = Math.sin((1.0 - d) * d5) / d6;
                d3 = Math.sin(d * d5) / d6;
            } else {
                d4 = 1.0 - d;
                d3 = d;
            }
            this.setXYZW(d4 * quaternion.getX() + d3 * quaternion2.getX(), d4 * quaternion.getY() + d3 * quaternion2.getY(), d4 * quaternion.getZ() + d3 * quaternion2.getZ(), d4 * quaternion.getW() + d3 * quaternion2.getW());
        } else {
            double d7 = Math.sin((0.5 - d) * Math.PI);
            double d8 = Math.sin(d * Math.PI);
            this.setXYZW(d7 * quaternion.getX() - d8 * quaternion.getY(), d7 * quaternion.getY() + d8 * quaternion.getX(), d7 * quaternion.getZ() - d8 * quaternion.getW(), quaternion.getZ());
        }
        return this;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z) || Double.isNaN(this.w);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        return this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z && this.w == quaternion.w;
    }

    public int hashCode() {
        int n = Float.floatToIntBits((float)this.x * 6.6360896E8f);
        int n2 = Float.floatToIntBits((float)this.y * 6.6360896E8f);
        int n3 = Float.floatToIntBits((float)this.z * 6.6360896E8f);
        int n4 = Float.floatToIntBits((float)this.w * 6.6360896E8f);
        return n ^ (n2 << 11 | n2 >>> 21) ^ (n3 << 22 | n3 >>> 10) ^ n4;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

