/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.EdgePlotter;
import driftwood.util.Strings;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class KinfileEdgePlotter
implements EdgePlotter {
    static DecimalFormat df4 = Strings.usDecimalFormat("0.####");
    static DecimalFormat dfe4 = Strings.usDecimalFormat("0.####E0");
    PrintStream out;
    String color = "cyan";
    int width = 1;

    public KinfileEdgePlotter(OutputStream outputStream) {
        this.out = new PrintStream(outputStream);
    }

    public void startIsosurface(double d) {
        this.out.println("@group {mesh @ " + this.format(d) + "} dominant");
        this.out.println("@vectorlist {x} color= " + this.color + " width= " + this.width);
    }

    public void startCell(int n, int n2, int n3) {
    }

    public void plotEdge(double d, double d2, double d3, boolean bl) {
        if (bl) {
            this.out.println("{x} " + this.format(d) + " " + this.format(d2) + " " + this.format(d3));
        } else {
            this.out.println("{x}P " + this.format(d) + " " + this.format(d2) + " " + this.format(d3));
        }
    }

    public void endCell(int n, int n2, int n3) {
    }

    public void endIsosurface(double d) {
        this.out.flush();
    }

    String format(double d) {
        return df4.format(d);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 7) {
            n = 7;
        }
        this.width = n;
    }
}

