/*
 * Decompiled with CFR 0.152.
 */
package absigner;

import java.util.ArrayList;

public class Parameters {
    ArrayList<Parameter> alphaParams = new ArrayList();
    ArrayList<Parameter> alphaSD = new ArrayList();
    ArrayList<Parameter> betaParams;
    ArrayList<Parameter> betaSD;

    public Parameters() {
        Parameter parameter = new Parameter(3.788, 91.2, 92.2, -74.0, 51.0, 125.0);
        Parameter parameter2 = new Parameter(0.1, 1.0, 1.0, 1.0, 1.0, 1.0);
        Parameter parameter3 = new Parameter(5.4, 66.0, 62.0, -37.0, 113.0, 160.5);
        Parameter parameter4 = new Parameter(0.1, 1.0, 1.0, 1.0, 1.0, 1.0);
        this.alphaParams.add(parameter);
        this.alphaParams.add(parameter3);
        this.alphaSD.add(parameter2);
        this.alphaSD.add(parameter4);
        this.betaParams = new ArrayList();
        this.betaSD = new ArrayList();
        Parameter parameter5 = new Parameter(3.8, 122.8, 117.2, -60.0, -169.0, -85.0);
        Parameter parameter6 = new Parameter(0.1, 1.0, 1.0, 5.0, 1.0, 5.0);
        Parameter parameter7 = new Parameter(6.357, 161.6, 167.0, -124.6, 12.8, -31.9);
        Parameter parameter8 = new Parameter(0.1, 1.0, 1.0, 5.0, 5.0, 5.0);
        this.betaParams.add(parameter5);
        this.betaSD.add(parameter6);
        this.betaParams.add(parameter7);
        this.betaSD.add(parameter8);
    }

    public double[] getAlphaSize(int n) {
        if (n <= this.alphaParams.size()) {
            Parameter parameter = this.alphaParams.get(n - 1);
            return parameter.get();
        }
        System.err.println("No data on alpha fragments of that size available!");
        return null;
    }

    public double[] getAlphaSD(int n) {
        if (n <= this.alphaSD.size()) {
            Parameter parameter = this.alphaSD.get(n - 1);
            return parameter.get();
        }
        System.err.println("No data on alpha standard dev of that size available!");
        return null;
    }

    public double[] getBetaSize(int n) {
        if (n <= this.betaParams.size()) {
            Parameter parameter = this.betaParams.get(n - 1);
            return parameter.get();
        }
        System.err.println("No data on beta fragments of that size available!");
        return null;
    }

    public double[] getBetaSD(int n) {
        if (n <= this.betaSD.size()) {
            Parameter parameter = this.betaSD.get(n - 1);
            return parameter.get();
        }
        System.err.println("No data on beta standard dev of that size available!");
        return null;
    }

    public static boolean inRange(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        for (n = 0; n < 3; ++n) {
            if (!(dArray[n] > dArray2[n] + dArray3[n]) && !(dArray[n] < dArray2[n] - dArray3[n])) continue;
            return false;
        }
        for (n = 3; n < dArray2.length; ++n) {
            if (Parameters.angleInRange(dArray[n], dArray2[n], dArray3[n])) continue;
            return false;
        }
        return true;
    }

    public static boolean angleInRange(double d, double d2, double d3) {
        return !(d2 >= 180.0 - d3 ? !(d >= d2 - d3) && !(d <= -360.0 + d2 + d3) : (d2 <= -180.0 + d3 ? !(d <= d2 + d3) && !(d >= 360.0 + d2 - d3) : d > d2 + d3 || d < d2 - d3));
    }

    class Parameter {
        double[] param;

        public Parameter(double d, double d2, double d3, double d4, double d5, double d6) {
            this.param = new double[]{d, d2, d3, d4, d5, d6};
        }

        public double[] get() {
            return this.param;
        }
    }
}

