package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/appinsights/mgmt/2021-11-01-preview/insights"

// Annotation annotation associated with an application insights resource.
type Annotation struct {
	// AnnotationName - Name of annotation
	AnnotationName *string `json:"AnnotationName,omitempty"`
	// Category - Category of annotation, free form
	Category *string `json:"Category,omitempty"`
	// EventTime - Time when event occurred
	EventTime *date.Time `json:"EventTime,omitempty"`
	// ID - Unique Id for annotation
	ID *string `json:"Id,omitempty"`
	// Properties - Serialized JSON object for detailed properties
	Properties *string `json:"Properties,omitempty"`
	// RelatedAnnotation - Related parent annotation if any
	RelatedAnnotation *string `json:"RelatedAnnotation,omitempty"`
}

// AnnotationError error associated with trying to create annotation with Id that already exist
type AnnotationError struct {
	// Code - Error detail code and explanation
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message    *string     `json:"message,omitempty"`
	Innererror *InnerError `json:"innererror,omitempty"`
}

// AnnotationsListResult annotations list result.
type AnnotationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; An array of annotations.
	Value *[]Annotation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AnnotationsListResult.
func (alr AnnotationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// APIKeyRequest an Application Insights component API Key creation request definition.
type APIKeyRequest struct {
	// Name - The name of the API Key.
	Name *string `json:"name,omitempty"`
	// LinkedReadProperties - The read access rights of this API Key.
	LinkedReadProperties *[]string `json:"linkedReadProperties,omitempty"`
	// LinkedWriteProperties - The write access rights of this API Key.
	LinkedWriteProperties *[]string `json:"linkedWriteProperties,omitempty"`
}

// ApplicationInsightsComponent an Application Insights component definition.
type ApplicationInsightsComponent struct {
	autorest.Response `json:"-"`
	// Kind - The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
	Kind *string `json:"kind,omitempty"`
	// ApplicationInsightsComponentProperties - Properties that define an Application Insights component resource.
	*ApplicationInsightsComponentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponent.
func (aic ApplicationInsightsComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aic.Kind != nil {
		objectMap["kind"] = aic.Kind
	}
	if aic.ApplicationInsightsComponentProperties != nil {
		objectMap["properties"] = aic.ApplicationInsightsComponentProperties
	}
	if aic.Location != nil {
		objectMap["location"] = aic.Location
	}
	if aic.Tags != nil {
		objectMap["tags"] = aic.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationInsightsComponent struct.
func (aic *ApplicationInsightsComponent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aic.Kind = &kind
			}
		case "properties":
			if v != nil {
				var applicationInsightsComponentProperties ApplicationInsightsComponentProperties
				err = json.Unmarshal(*v, &applicationInsightsComponentProperties)
				if err != nil {
					return err
				}
				aic.ApplicationInsightsComponentProperties = &applicationInsightsComponentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aic.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aic.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aic.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aic.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationInsightsComponentAnalyticsItem properties that define an Analytics item that is associated to
// an Application Insights component.
type ApplicationInsightsComponentAnalyticsItem struct {
	autorest.Response `json:"-"`
	// ID - Internally assigned unique id of the item definition.
	ID *string `json:"Id,omitempty"`
	// Name - The user-defined name of the item.
	Name *string `json:"Name,omitempty"`
	// Content - The content of this item
	Content *string `json:"Content,omitempty"`
	// Version - READ-ONLY; This instance's version of the data model. This can change as new features are added.
	Version *string `json:"Version,omitempty"`
	// Scope - Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component. Possible values include: 'ItemScopeShared', 'ItemScopeUser'
	Scope ItemScope `json:"Scope,omitempty"`
	// Type - Enum indicating the type of the Analytics item. Possible values include: 'ItemTypeQuery', 'ItemTypeFunction', 'ItemTypeFolder', 'ItemTypeRecent'
	Type ItemType `json:"Type,omitempty"`
	// TimeCreated - READ-ONLY; Date and time in UTC when this item was created.
	TimeCreated *string `json:"TimeCreated,omitempty"`
	// TimeModified - READ-ONLY; Date and time in UTC of the last modification that was made to this item.
	TimeModified *string                                              `json:"TimeModified,omitempty"`
	Properties   *ApplicationInsightsComponentAnalyticsItemProperties `json:"Properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentAnalyticsItem.
func (aicai ApplicationInsightsComponentAnalyticsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicai.ID != nil {
		objectMap["Id"] = aicai.ID
	}
	if aicai.Name != nil {
		objectMap["Name"] = aicai.Name
	}
	if aicai.Content != nil {
		objectMap["Content"] = aicai.Content
	}
	if aicai.Scope != "" {
		objectMap["Scope"] = aicai.Scope
	}
	if aicai.Type != "" {
		objectMap["Type"] = aicai.Type
	}
	if aicai.Properties != nil {
		objectMap["Properties"] = aicai.Properties
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentAnalyticsItemProperties a set of properties that can be defined in the
// context of a specific item type. Each type may have its own properties.
type ApplicationInsightsComponentAnalyticsItemProperties struct {
	// FunctionAlias - A function alias, used when the type of the item is Function
	FunctionAlias *string `json:"functionAlias,omitempty"`
}

// ApplicationInsightsComponentAPIKey properties that define an API key of an Application Insights
// Component.
type ApplicationInsightsComponentAPIKey struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The unique ID of the API key inside an Application Insights component. It is auto generated when the API key is created.
	ID *string `json:"id,omitempty"`
	// APIKey - READ-ONLY; The API key value. It will be only return once when the API Key was created.
	APIKey *string `json:"apiKey,omitempty"`
	// CreatedDate - The create date of this API key.
	CreatedDate *string `json:"createdDate,omitempty"`
	// Name - The name of the API key.
	Name *string `json:"name,omitempty"`
	// LinkedReadProperties - The read access rights of this API Key.
	LinkedReadProperties *[]string `json:"linkedReadProperties,omitempty"`
	// LinkedWriteProperties - The write access rights of this API Key.
	LinkedWriteProperties *[]string `json:"linkedWriteProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentAPIKey.
func (aicak ApplicationInsightsComponentAPIKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicak.CreatedDate != nil {
		objectMap["createdDate"] = aicak.CreatedDate
	}
	if aicak.Name != nil {
		objectMap["name"] = aicak.Name
	}
	if aicak.LinkedReadProperties != nil {
		objectMap["linkedReadProperties"] = aicak.LinkedReadProperties
	}
	if aicak.LinkedWriteProperties != nil {
		objectMap["linkedWriteProperties"] = aicak.LinkedWriteProperties
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentAPIKeyListResult describes the list of API Keys of an Application Insights
// Component.
type ApplicationInsightsComponentAPIKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - List of API Key definitions.
	Value *[]ApplicationInsightsComponentAPIKey `json:"value,omitempty"`
}

// ApplicationInsightsComponentAvailableFeatures an Application Insights component available features.
type ApplicationInsightsComponentAvailableFeatures struct {
	autorest.Response `json:"-"`
	// Result - READ-ONLY; A list of Application Insights component feature.
	Result *[]ApplicationInsightsComponentFeature `json:"Result,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentAvailableFeatures.
func (aicaf ApplicationInsightsComponentAvailableFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentBillingFeatures an Application Insights component billing features
type ApplicationInsightsComponentBillingFeatures struct {
	autorest.Response `json:"-"`
	// DataVolumeCap - An Application Insights component daily data volume cap
	DataVolumeCap *ApplicationInsightsComponentDataVolumeCap `json:"DataVolumeCap,omitempty"`
	// CurrentBillingFeatures - Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
	CurrentBillingFeatures *[]string `json:"CurrentBillingFeatures,omitempty"`
}

// ApplicationInsightsComponentDataVolumeCap an Application Insights component daily data volume cap
type ApplicationInsightsComponentDataVolumeCap struct {
	// Cap - Daily data volume cap in GB.
	Cap *float64 `json:"Cap,omitempty"`
	// ResetTime - READ-ONLY; Daily data volume cap UTC reset hour.
	ResetTime *int32 `json:"ResetTime,omitempty"`
	// WarningThreshold - Reserved, not used for now.
	WarningThreshold *int32 `json:"WarningThreshold,omitempty"`
	// StopSendNotificationWhenHitThreshold - Reserved, not used for now.
	StopSendNotificationWhenHitThreshold *bool `json:"StopSendNotificationWhenHitThreshold,omitempty"`
	// StopSendNotificationWhenHitCap - Do not send a notification email when the daily data volume cap is met.
	StopSendNotificationWhenHitCap *bool `json:"StopSendNotificationWhenHitCap,omitempty"`
	// MaxHistoryCap - READ-ONLY; Maximum daily data volume cap that the user can set for this component.
	MaxHistoryCap *float64 `json:"MaxHistoryCap,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentDataVolumeCap.
func (aicdvc ApplicationInsightsComponentDataVolumeCap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicdvc.Cap != nil {
		objectMap["Cap"] = aicdvc.Cap
	}
	if aicdvc.WarningThreshold != nil {
		objectMap["WarningThreshold"] = aicdvc.WarningThreshold
	}
	if aicdvc.StopSendNotificationWhenHitThreshold != nil {
		objectMap["StopSendNotificationWhenHitThreshold"] = aicdvc.StopSendNotificationWhenHitThreshold
	}
	if aicdvc.StopSendNotificationWhenHitCap != nil {
		objectMap["StopSendNotificationWhenHitCap"] = aicdvc.StopSendNotificationWhenHitCap
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentExportConfiguration properties that define a Continuous Export
// configuration.
type ApplicationInsightsComponentExportConfiguration struct {
	autorest.Response `json:"-"`
	// ExportID - READ-ONLY; The unique ID of the export configuration inside an Application Insights component. It is auto generated when the Continuous Export configuration is created.
	ExportID *string `json:"ExportId,omitempty"`
	// InstrumentationKey - READ-ONLY; The instrumentation key of the Application Insights component.
	InstrumentationKey *string `json:"InstrumentationKey,omitempty"`
	// RecordTypes - This comma separated list of document types that will be exported. The possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
	RecordTypes *string `json:"RecordTypes,omitempty"`
	// ApplicationName - READ-ONLY; The name of the Application Insights component.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// SubscriptionID - READ-ONLY; The subscription of the Application Insights component.
	SubscriptionID *string `json:"SubscriptionId,omitempty"`
	// ResourceGroup - READ-ONLY; The resource group of the Application Insights component.
	ResourceGroup *string `json:"ResourceGroup,omitempty"`
	// DestinationStorageSubscriptionID - READ-ONLY; The destination storage account subscription ID.
	DestinationStorageSubscriptionID *string `json:"DestinationStorageSubscriptionId,omitempty"`
	// DestinationStorageLocationID - READ-ONLY; The destination account location ID.
	DestinationStorageLocationID *string `json:"DestinationStorageLocationId,omitempty"`
	// DestinationAccountID - READ-ONLY; The name of destination account.
	DestinationAccountID *string `json:"DestinationAccountId,omitempty"`
	// DestinationType - READ-ONLY; The destination type.
	DestinationType *string `json:"DestinationType,omitempty"`
	// IsUserEnabled - READ-ONLY; This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
	IsUserEnabled *string `json:"IsUserEnabled,omitempty"`
	// LastUserUpdate - READ-ONLY; Last time the Continuous Export configuration was updated.
	LastUserUpdate *string `json:"LastUserUpdate,omitempty"`
	// NotificationQueueEnabled - Deprecated
	NotificationQueueEnabled *string `json:"NotificationQueueEnabled,omitempty"`
	// ExportStatus - READ-ONLY; This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success', 'Failure'.
	ExportStatus *string `json:"ExportStatus,omitempty"`
	// LastSuccessTime - READ-ONLY; The last time data was successfully delivered to the destination storage container for this Continuous Export configuration.
	LastSuccessTime *string `json:"LastSuccessTime,omitempty"`
	// LastGapTime - READ-ONLY; The last time the Continuous Export configuration started failing.
	LastGapTime *string `json:"LastGapTime,omitempty"`
	// PermanentErrorReason - READ-ONLY; This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
	PermanentErrorReason *string `json:"PermanentErrorReason,omitempty"`
	// StorageName - READ-ONLY; The name of the destination storage account.
	StorageName *string `json:"StorageName,omitempty"`
	// ContainerName - READ-ONLY; The name of the destination storage container.
	ContainerName *string `json:"ContainerName,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentExportConfiguration.
func (aicec ApplicationInsightsComponentExportConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicec.RecordTypes != nil {
		objectMap["RecordTypes"] = aicec.RecordTypes
	}
	if aicec.NotificationQueueEnabled != nil {
		objectMap["NotificationQueueEnabled"] = aicec.NotificationQueueEnabled
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentExportRequest an Application Insights component Continuous Export
// configuration request definition.
type ApplicationInsightsComponentExportRequest struct {
	// RecordTypes - The document types to be exported, as comma separated values. Allowed values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
	RecordTypes *string `json:"RecordTypes,omitempty"`
	// DestinationType - The Continuous Export destination type. This has to be 'Blob'.
	DestinationType *string `json:"DestinationType,omitempty"`
	// DestinationAddress - The SAS URL for the destination storage container. It must grant write permission.
	DestinationAddress *string `json:"DestinationAddress,omitempty"`
	// IsEnabled - Set to 'true' to create a Continuous Export configuration as enabled, otherwise set it to 'false'.
	IsEnabled *string `json:"IsEnabled,omitempty"`
	// NotificationQueueEnabled - Deprecated
	NotificationQueueEnabled *string `json:"NotificationQueueEnabled,omitempty"`
	// NotificationQueueURI - Deprecated
	NotificationQueueURI *string `json:"NotificationQueueUri,omitempty"`
	// DestinationStorageSubscriptionID - The subscription ID of the destination storage container.
	DestinationStorageSubscriptionID *string `json:"DestinationStorageSubscriptionId,omitempty"`
	// DestinationStorageLocationID - The location ID of the destination storage container.
	DestinationStorageLocationID *string `json:"DestinationStorageLocationId,omitempty"`
	// DestinationAccountID - The name of destination storage account.
	DestinationAccountID *string `json:"DestinationAccountId,omitempty"`
}

// ApplicationInsightsComponentFavorite properties that define a favorite that is associated to an
// Application Insights component.
type ApplicationInsightsComponentFavorite struct {
	autorest.Response `json:"-"`
	// Name - The user-defined name of the favorite.
	Name *string `json:"Name,omitempty"`
	// Config - Configuration of this particular favorite, which are driven by the Azure portal UX. Configuration data is a string containing valid JSON
	Config *string `json:"Config,omitempty"`
	// Version - This instance's version of the data model. This can change as new features are added that can be marked favorite. Current examples include MetricsExplorer (ME) and Search.
	Version *string `json:"Version,omitempty"`
	// FavoriteID - READ-ONLY; Internally assigned unique id of the favorite definition.
	FavoriteID *string `json:"FavoriteId,omitempty"`
	// FavoriteType - Enum indicating if this favorite definition is owned by a specific user or is shared between all users with access to the Application Insights component. Possible values include: 'FavoriteTypeShared', 'FavoriteTypeUser'
	FavoriteType FavoriteType `json:"FavoriteType,omitempty"`
	// SourceType - The source of the favorite definition.
	SourceType *string `json:"SourceType,omitempty"`
	// TimeModified - READ-ONLY; Date and time in UTC of the last modification that was made to this favorite definition.
	TimeModified *string `json:"TimeModified,omitempty"`
	// Tags - A list of 0 or more tags that are associated with this favorite definition
	Tags *[]string `json:"Tags,omitempty"`
	// Category - Favorite category, as defined by the user at creation time.
	Category *string `json:"Category,omitempty"`
	// IsGeneratedFromTemplate - Flag denoting wether or not this favorite was generated from a template.
	IsGeneratedFromTemplate *bool `json:"IsGeneratedFromTemplate,omitempty"`
	// UserID - READ-ONLY; Unique user id of the specific user that owns this favorite.
	UserID *string `json:"UserId,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentFavorite.
func (aicf ApplicationInsightsComponentFavorite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicf.Name != nil {
		objectMap["Name"] = aicf.Name
	}
	if aicf.Config != nil {
		objectMap["Config"] = aicf.Config
	}
	if aicf.Version != nil {
		objectMap["Version"] = aicf.Version
	}
	if aicf.FavoriteType != "" {
		objectMap["FavoriteType"] = aicf.FavoriteType
	}
	if aicf.SourceType != nil {
		objectMap["SourceType"] = aicf.SourceType
	}
	if aicf.Tags != nil {
		objectMap["Tags"] = aicf.Tags
	}
	if aicf.Category != nil {
		objectMap["Category"] = aicf.Category
	}
	if aicf.IsGeneratedFromTemplate != nil {
		objectMap["IsGeneratedFromTemplate"] = aicf.IsGeneratedFromTemplate
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentFeature an Application Insights component daily data volume cap status
type ApplicationInsightsComponentFeature struct {
	// FeatureName - READ-ONLY; The pricing feature name.
	FeatureName *string `json:"FeatureName,omitempty"`
	// MeterID - READ-ONLY; The meter id used for the feature.
	MeterID *string `json:"MeterId,omitempty"`
	// MeterRateFrequency - READ-ONLY; The meter rate for the feature's meter.
	MeterRateFrequency *string `json:"MeterRateFrequency,omitempty"`
	// ResouceID - READ-ONLY; Reserved, not used now.
	ResouceID *string `json:"ResouceId,omitempty"`
	// IsHidden - READ-ONLY; Reserved, not used now.
	IsHidden *bool `json:"IsHidden,omitempty"`
	// Capabilities - READ-ONLY; A list of Application Insights component feature capability.
	Capabilities *[]ApplicationInsightsComponentFeatureCapability `json:"Capabilities,omitempty"`
	// Title - READ-ONLY; Display name of the feature.
	Title *string `json:"Title,omitempty"`
	// IsMainFeature - READ-ONLY; Whether can apply addon feature on to it.
	IsMainFeature *bool `json:"IsMainFeature,omitempty"`
	// SupportedAddonFeatures - READ-ONLY; The add on features on main feature.
	SupportedAddonFeatures *string `json:"SupportedAddonFeatures,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentFeature.
func (aicf ApplicationInsightsComponentFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentFeatureCapabilities an Application Insights component feature capabilities
type ApplicationInsightsComponentFeatureCapabilities struct {
	autorest.Response `json:"-"`
	// SupportExportData - READ-ONLY; Whether allow to use continuous export feature.
	SupportExportData *bool `json:"SupportExportData,omitempty"`
	// BurstThrottlePolicy - READ-ONLY; Reserved, not used now.
	BurstThrottlePolicy *string `json:"BurstThrottlePolicy,omitempty"`
	// MetadataClass - READ-ONLY; Reserved, not used now.
	MetadataClass *string `json:"MetadataClass,omitempty"`
	// LiveStreamMetrics - READ-ONLY; Reserved, not used now.
	LiveStreamMetrics *bool `json:"LiveStreamMetrics,omitempty"`
	// ApplicationMap - READ-ONLY; Reserved, not used now.
	ApplicationMap *bool `json:"ApplicationMap,omitempty"`
	// WorkItemIntegration - READ-ONLY; Whether allow to use work item integration feature.
	WorkItemIntegration *bool `json:"WorkItemIntegration,omitempty"`
	// PowerBIIntegration - READ-ONLY; Reserved, not used now.
	PowerBIIntegration *bool `json:"PowerBIIntegration,omitempty"`
	// OpenSchema - READ-ONLY; Reserved, not used now.
	OpenSchema *bool `json:"OpenSchema,omitempty"`
	// ProactiveDetection - READ-ONLY; Reserved, not used now.
	ProactiveDetection *bool `json:"ProactiveDetection,omitempty"`
	// AnalyticsIntegration - READ-ONLY; Reserved, not used now.
	AnalyticsIntegration *bool `json:"AnalyticsIntegration,omitempty"`
	// MultipleStepWebTest - READ-ONLY; Whether allow to use multiple steps web test feature.
	MultipleStepWebTest *bool `json:"MultipleStepWebTest,omitempty"`
	// APIAccessLevel - READ-ONLY; Reserved, not used now.
	APIAccessLevel *string `json:"ApiAccessLevel,omitempty"`
	// TrackingType - READ-ONLY; The application insights component used tracking type.
	TrackingType *string `json:"TrackingType,omitempty"`
	// DailyCap - READ-ONLY; Daily data volume cap in GB.
	DailyCap *float64 `json:"DailyCap,omitempty"`
	// DailyCapResetTime - READ-ONLY; Daily data volume cap UTC reset hour.
	DailyCapResetTime *float64 `json:"DailyCapResetTime,omitempty"`
	// ThrottleRate - READ-ONLY; Reserved, not used now.
	ThrottleRate *float64 `json:"ThrottleRate,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentFeatureCapabilities.
func (aicfc ApplicationInsightsComponentFeatureCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentFeatureCapability an Application Insights component feature capability
type ApplicationInsightsComponentFeatureCapability struct {
	// Name - READ-ONLY; The name of the capability.
	Name *string `json:"Name,omitempty"`
	// Description - READ-ONLY; The description of the capability.
	Description *string `json:"Description,omitempty"`
	// Value - READ-ONLY; The value of the capability.
	Value *string `json:"Value,omitempty"`
	// Unit - READ-ONLY; The unit of the capability.
	Unit *string `json:"Unit,omitempty"`
	// MeterID - READ-ONLY; The meter used for the capability.
	MeterID *string `json:"MeterId,omitempty"`
	// MeterRateFrequency - READ-ONLY; The meter rate of the meter.
	MeterRateFrequency *string `json:"MeterRateFrequency,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentFeatureCapability.
func (aicfc ApplicationInsightsComponentFeatureCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentListResult describes the list of Application Insights Resources.
type ApplicationInsightsComponentListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Application Insights component definitions.
	Value *[]ApplicationInsightsComponent `json:"value,omitempty"`
	// NextLink - The URI to get the next set of Application Insights component definitions if too many components where returned in the result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationInsightsComponentListResultIterator provides access to a complete listing of
// ApplicationInsightsComponent values.
type ApplicationInsightsComponentListResultIterator struct {
	i    int
	page ApplicationInsightsComponentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationInsightsComponentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationInsightsComponentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationInsightsComponentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationInsightsComponentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationInsightsComponentListResultIterator) Response() ApplicationInsightsComponentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationInsightsComponentListResultIterator) Value() ApplicationInsightsComponent {
	if !iter.page.NotDone() {
		return ApplicationInsightsComponent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationInsightsComponentListResultIterator type.
func NewApplicationInsightsComponentListResultIterator(page ApplicationInsightsComponentListResultPage) ApplicationInsightsComponentListResultIterator {
	return ApplicationInsightsComponentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aiclr ApplicationInsightsComponentListResult) IsEmpty() bool {
	return aiclr.Value == nil || len(*aiclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aiclr ApplicationInsightsComponentListResult) hasNextLink() bool {
	return aiclr.NextLink != nil && len(*aiclr.NextLink) != 0
}

// applicationInsightsComponentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aiclr ApplicationInsightsComponentListResult) applicationInsightsComponentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aiclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aiclr.NextLink)))
}

// ApplicationInsightsComponentListResultPage contains a page of ApplicationInsightsComponent values.
type ApplicationInsightsComponentListResultPage struct {
	fn    func(context.Context, ApplicationInsightsComponentListResult) (ApplicationInsightsComponentListResult, error)
	aiclr ApplicationInsightsComponentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationInsightsComponentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationInsightsComponentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aiclr)
		if err != nil {
			return err
		}
		page.aiclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationInsightsComponentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationInsightsComponentListResultPage) NotDone() bool {
	return !page.aiclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationInsightsComponentListResultPage) Response() ApplicationInsightsComponentListResult {
	return page.aiclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationInsightsComponentListResultPage) Values() []ApplicationInsightsComponent {
	if page.aiclr.IsEmpty() {
		return nil
	}
	return *page.aiclr.Value
}

// Creates a new instance of the ApplicationInsightsComponentListResultPage type.
func NewApplicationInsightsComponentListResultPage(cur ApplicationInsightsComponentListResult, getNextPage func(context.Context, ApplicationInsightsComponentListResult) (ApplicationInsightsComponentListResult, error)) ApplicationInsightsComponentListResultPage {
	return ApplicationInsightsComponentListResultPage{
		fn:    getNextPage,
		aiclr: cur,
	}
}

// ApplicationInsightsComponentProactiveDetectionConfiguration properties that define a ProactiveDetection
// configuration.
type ApplicationInsightsComponentProactiveDetectionConfiguration struct {
	autorest.Response `json:"-"`
	// Name - The rule name
	Name *string `json:"Name,omitempty"`
	// Enabled - A flag that indicates whether this rule is enabled by the user
	Enabled *bool `json:"Enabled,omitempty"`
	// SendEmailsToSubscriptionOwners - A flag that indicated whether notifications on this rule should be sent to subscription owners
	SendEmailsToSubscriptionOwners *bool `json:"SendEmailsToSubscriptionOwners,omitempty"`
	// CustomEmails - Custom email addresses for this rule notifications
	CustomEmails *[]string `json:"CustomEmails,omitempty"`
	// LastUpdatedTime - The last time this rule was updated
	LastUpdatedTime *string `json:"LastUpdatedTime,omitempty"`
	// RuleDefinitions - Static definitions of the ProactiveDetection configuration rule (same values for all components).
	RuleDefinitions *ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions `json:"RuleDefinitions,omitempty"`
}

// ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions static definitions of the
// ProactiveDetection configuration rule (same values for all components).
type ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions struct {
	// Name - The rule name
	Name *string `json:"Name,omitempty"`
	// DisplayName - The rule name as it is displayed in UI
	DisplayName *string `json:"DisplayName,omitempty"`
	// Description - The rule description
	Description *string `json:"Description,omitempty"`
	// HelpURL - URL which displays additional info about the proactive detection rule
	HelpURL *string `json:"HelpUrl,omitempty"`
	// IsHidden - A flag indicating whether the rule is hidden (from the UI)
	IsHidden *bool `json:"IsHidden,omitempty"`
	// IsEnabledByDefault - A flag indicating whether the rule is enabled by default
	IsEnabledByDefault *bool `json:"IsEnabledByDefault,omitempty"`
	// IsInPreview - A flag indicating whether the rule is in preview
	IsInPreview *bool `json:"IsInPreview,omitempty"`
	// SupportsEmailNotifications - A flag indicating whether email notifications are supported for detections for this rule
	SupportsEmailNotifications *bool `json:"SupportsEmailNotifications,omitempty"`
}

// ApplicationInsightsComponentProperties properties that define an Application Insights component
// resource.
type ApplicationInsightsComponentProperties struct {
	// ApplicationID - READ-ONLY; The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// AppID - READ-ONLY; Application Insights Unique ID for your Application.
	AppID *string `json:"AppId,omitempty"`
	// ApplicationType - Type of application being monitored. Possible values include: 'ApplicationTypeWeb', 'ApplicationTypeOther'
	ApplicationType ApplicationType `json:"Application_Type,omitempty"`
	// FlowType - Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API. Possible values include: 'FlowTypeBluefield'
	FlowType FlowType `json:"Flow_Type,omitempty"`
	// RequestSource - Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'. Possible values include: 'RequestSourceRest'
	RequestSource RequestSource `json:"Request_Source,omitempty"`
	// InstrumentationKey - READ-ONLY; Application Insights Instrumentation key. A read-only value that applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction of each new Application Insights component.
	InstrumentationKey *string `json:"InstrumentationKey,omitempty"`
	// CreationDate - READ-ONLY; Creation Date for the Application Insights component, in ISO 8601 format.
	CreationDate *date.Time `json:"CreationDate,omitempty"`
	// TenantID - READ-ONLY; Azure Tenant Id.
	TenantID *string `json:"TenantId,omitempty"`
	// HockeyAppID - The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
	HockeyAppID *string `json:"HockeyAppId,omitempty"`
	// HockeyAppToken - READ-ONLY; Token used to authenticate communications with between Application Insights and HockeyApp.
	HockeyAppToken *string `json:"HockeyAppToken,omitempty"`
	// ProvisioningState - READ-ONLY; Current state of this component: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SamplingPercentage - Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
	SamplingPercentage *float64 `json:"SamplingPercentage,omitempty"`
	// ConnectionString - READ-ONLY; Application Insights component connection string.
	ConnectionString *string `json:"ConnectionString,omitempty"`
	// RetentionInDays - Retention period in days.
	RetentionInDays *int32 `json:"RetentionInDays,omitempty"`
	// DisableIPMasking - Disable IP masking.
	DisableIPMasking *bool `json:"DisableIpMasking,omitempty"`
	// ImmediatePurgeDataOn30Days - Purge data immediately after 30 days.
	ImmediatePurgeDataOn30Days *bool `json:"ImmediatePurgeDataOn30Days,omitempty"`
	// PrivateLinkScopedResources - READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources *[]PrivateLinkScopedResource `json:"PrivateLinkScopedResources,omitempty"`
	// PublicNetworkAccessForIngestion - The network access type for accessing Application Insights ingestion. Possible values include: 'PublicNetworkAccessTypeEnabled', 'PublicNetworkAccessTypeDisabled'
	PublicNetworkAccessForIngestion PublicNetworkAccessType `json:"publicNetworkAccessForIngestion,omitempty"`
	// PublicNetworkAccessForQuery - The network access type for accessing Application Insights query. Possible values include: 'PublicNetworkAccessTypeEnabled', 'PublicNetworkAccessTypeDisabled'
	PublicNetworkAccessForQuery PublicNetworkAccessType `json:"publicNetworkAccessForQuery,omitempty"`
	// IngestionMode - Indicates the flow of the ingestion. Possible values include: 'IngestionModeApplicationInsights', 'IngestionModeApplicationInsightsWithDiagnosticSettings', 'IngestionModeLogAnalytics'
	IngestionMode IngestionMode `json:"IngestionMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentProperties.
func (aicp ApplicationInsightsComponentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aicp.ApplicationType != "" {
		objectMap["Application_Type"] = aicp.ApplicationType
	}
	if aicp.FlowType != "" {
		objectMap["Flow_Type"] = aicp.FlowType
	}
	if aicp.RequestSource != "" {
		objectMap["Request_Source"] = aicp.RequestSource
	}
	if aicp.HockeyAppID != nil {
		objectMap["HockeyAppId"] = aicp.HockeyAppID
	}
	if aicp.SamplingPercentage != nil {
		objectMap["SamplingPercentage"] = aicp.SamplingPercentage
	}
	if aicp.RetentionInDays != nil {
		objectMap["RetentionInDays"] = aicp.RetentionInDays
	}
	if aicp.DisableIPMasking != nil {
		objectMap["DisableIpMasking"] = aicp.DisableIPMasking
	}
	if aicp.ImmediatePurgeDataOn30Days != nil {
		objectMap["ImmediatePurgeDataOn30Days"] = aicp.ImmediatePurgeDataOn30Days
	}
	if aicp.PublicNetworkAccessForIngestion != "" {
		objectMap["publicNetworkAccessForIngestion"] = aicp.PublicNetworkAccessForIngestion
	}
	if aicp.PublicNetworkAccessForQuery != "" {
		objectMap["publicNetworkAccessForQuery"] = aicp.PublicNetworkAccessForQuery
	}
	if aicp.IngestionMode != "" {
		objectMap["IngestionMode"] = aicp.IngestionMode
	}
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentQuotaStatus an Application Insights component daily data volume cap status
type ApplicationInsightsComponentQuotaStatus struct {
	autorest.Response `json:"-"`
	// AppID - READ-ONLY; The Application ID for the Application Insights component.
	AppID *string `json:"AppId,omitempty"`
	// ShouldBeThrottled - READ-ONLY; The daily data volume cap is met, and data ingestion will be stopped.
	ShouldBeThrottled *bool `json:"ShouldBeThrottled,omitempty"`
	// ExpirationTime - READ-ONLY; Date and time when the daily data volume cap will be reset, and data ingestion will resume.
	ExpirationTime *string `json:"ExpirationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentQuotaStatus.
func (aicqs ApplicationInsightsComponentQuotaStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsComponentWebTestLocation properties that define a web test location available to an
// Application Insights Component.
type ApplicationInsightsComponentWebTestLocation struct {
	// DisplayName - READ-ONLY; The display name of the web test location.
	DisplayName *string `json:"DisplayName,omitempty"`
	// Tag - READ-ONLY; Internally defined geographic location tag.
	Tag *string `json:"Tag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationInsightsComponentWebTestLocation.
func (aicwtl ApplicationInsightsComponentWebTestLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationInsightsWebTestLocationsListResult describes the list of web test locations available to an
// Application Insights Component.
type ApplicationInsightsWebTestLocationsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of web test locations.
	Value *[]ApplicationInsightsComponentWebTestLocation `json:"value,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComponentLinkedStorageAccounts an Application Insights component linked storage accounts
type ComponentLinkedStorageAccounts struct {
	autorest.Response `json:"-"`
	// LinkedStorageAccountsProperties - The properties of the linked storage accounts.
	*LinkedStorageAccountsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComponentLinkedStorageAccounts.
func (clsa ComponentLinkedStorageAccounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clsa.LinkedStorageAccountsProperties != nil {
		objectMap["properties"] = clsa.LinkedStorageAccountsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComponentLinkedStorageAccounts struct.
func (clsa *ComponentLinkedStorageAccounts) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedStorageAccountsProperties LinkedStorageAccountsProperties
				err = json.Unmarshal(*v, &linkedStorageAccountsProperties)
				if err != nil {
					return err
				}
				clsa.LinkedStorageAccountsProperties = &linkedStorageAccountsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				clsa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				clsa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				clsa.Type = &typeVar
			}
		}
	}

	return nil
}

// ComponentLinkedStorageAccountsPatch an Application Insights component linked storage accounts patch
type ComponentLinkedStorageAccountsPatch struct {
	// LinkedStorageAccountsProperties - The properties of the linked storage accounts.
	*LinkedStorageAccountsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ComponentLinkedStorageAccountsPatch.
func (clsap ComponentLinkedStorageAccountsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clsap.LinkedStorageAccountsProperties != nil {
		objectMap["properties"] = clsap.LinkedStorageAccountsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComponentLinkedStorageAccountsPatch struct.
func (clsap *ComponentLinkedStorageAccountsPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedStorageAccountsProperties LinkedStorageAccountsProperties
				err = json.Unmarshal(*v, &linkedStorageAccountsProperties)
				if err != nil {
					return err
				}
				clsap.LinkedStorageAccountsProperties = &linkedStorageAccountsProperties
			}
		}
	}

	return nil
}

// ComponentPurgeBody describes the body of a purge request for an App Insights component
type ComponentPurgeBody struct {
	// Table - Table from which to purge data.
	Table *string `json:"table,omitempty"`
	// Filters - The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters *[]ComponentPurgeBodyFilters `json:"filters,omitempty"`
}

// ComponentPurgeBodyFilters user-defined filters to return data which will be purged from the table.
type ComponentPurgeBodyFilters struct {
	// Column - The column of the table over which the given query should run
	Column *string `json:"column,omitempty"`
	// Operator - A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would in a KQL query.
	Operator *string `json:"operator,omitempty"`
	// Value - the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or array of values.
	Value interface{} `json:"value,omitempty"`
	// Key - When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string `json:"key,omitempty"`
}

// ComponentPurgeResponse response containing operationId for a specific purge action.
type ComponentPurgeResponse struct {
	autorest.Response `json:"-"`
	// OperationID - Id to use when querying for status for a particular purge operation.
	OperationID *string `json:"operationId,omitempty"`
}

// ComponentPurgeStatusResponse response containing status for a specific purge operation.
type ComponentPurgeStatusResponse struct {
	autorest.Response `json:"-"`
	// Status - Status of the operation represented by the requested Id. Possible values include: 'PurgeStatePending', 'PurgeStateCompleted'
	Status PurgeState `json:"status,omitempty"`
}

// ComponentsResource an azure resource object
type ComponentsResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ComponentsResource.
func (cr ComponentsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	return json.Marshal(objectMap)
}

// ErrorDefinition error definition.
type ErrorDefinition struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty"`
	// Innererror - READ-ONLY; Internal error details.
	Innererror interface{} `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDefinition.
func (ed ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates Insights service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseLinkedStorage ...
type ErrorResponseLinkedStorage struct {
	// Error - Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error message.
	Error *ErrorResponseLinkedStorageError `json:"error,omitempty"`
}

// ErrorResponseLinkedStorageError error response indicates Insights service is not able to process the
// incoming request. The reason is provided in the error message.
type ErrorResponseLinkedStorageError struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseLinkedStorageError.
func (erls ErrorResponseLinkedStorageError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InnerError inner error
type InnerError struct {
	// Diagnosticcontext - Provides correlation for request
	Diagnosticcontext *string `json:"diagnosticcontext,omitempty"`
	// Time - Request time
	Time *date.Time `json:"time,omitempty"`
}

// InnerErrorTrace error details
type InnerErrorTrace struct {
	// Trace - READ-ONLY; detailed error trace
	Trace *[]string `json:"trace,omitempty"`
}

// MarshalJSON is the custom marshaler for InnerErrorTrace.
func (iet InnerErrorTrace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LinkedStorageAccountsProperties an Application Insights component linked storage account
type LinkedStorageAccountsProperties struct {
	// LinkedStorageAccount - Linked storage account resource ID
	LinkedStorageAccount *string `json:"linkedStorageAccount,omitempty"`
}

// ListAnnotation ...
type ListAnnotation struct {
	autorest.Response `json:"-"`
	Value             *[]Annotation `json:"value,omitempty"`
}

// ListApplicationInsightsComponentAnalyticsItem ...
type ListApplicationInsightsComponentAnalyticsItem struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationInsightsComponentAnalyticsItem `json:"value,omitempty"`
}

// ListApplicationInsightsComponentExportConfiguration ...
type ListApplicationInsightsComponentExportConfiguration struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationInsightsComponentExportConfiguration `json:"value,omitempty"`
}

// ListApplicationInsightsComponentFavorite ...
type ListApplicationInsightsComponentFavorite struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationInsightsComponentFavorite `json:"value,omitempty"`
}

// ListApplicationInsightsComponentProactiveDetectionConfiguration ...
type ListApplicationInsightsComponentProactiveDetectionConfiguration struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationInsightsComponentProactiveDetectionConfiguration `json:"value,omitempty"`
}

// LiveTokenResponse the response to a live token query.
type LiveTokenResponse struct {
	autorest.Response `json:"-"`
	// LiveToken - READ-ONLY; JWT token for accessing live metrics stream data.
	LiveToken *string `json:"liveToken,omitempty"`
}

// MarshalJSON is the custom marshaler for LiveTokenResponse.
func (ltr LiveTokenResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedServiceIdentity managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// PrincipalID - READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Type - Possible values include: 'ManagedServiceIdentityTypeNone', 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeUserAssigned', 'ManagedServiceIdentityTypeSystemAssignedUserAssigned'
	Type                   ManagedServiceIdentityType       `json:"type,omitempty"`
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// MyWorkbook an Application Insights private workbook definition.
type MyWorkbook struct {
	autorest.Response `json:"-"`
	// Kind - The kind of workbook. Choices are user and shared. Possible values include: 'KindUser', 'KindShared'
	Kind Kind `json:"kind,omitempty"`
	// MyWorkbookProperties - Metadata describing a workbook for an Azure resource.
	*MyWorkbookProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Identity - Identity used for BYOS
	Identity *MyWorkbookManagedIdentity `json:"identity,omitempty"`
	// ID - Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Etag - Resource etag
	Etag map[string]*string `json:"etag"`
}

// MarshalJSON is the custom marshaler for MyWorkbook.
func (mw MyWorkbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mw.Kind != "" {
		objectMap["kind"] = mw.Kind
	}
	if mw.MyWorkbookProperties != nil {
		objectMap["properties"] = mw.MyWorkbookProperties
	}
	if mw.Identity != nil {
		objectMap["identity"] = mw.Identity
	}
	if mw.ID != nil {
		objectMap["id"] = mw.ID
	}
	if mw.Name != nil {
		objectMap["name"] = mw.Name
	}
	if mw.Type != nil {
		objectMap["type"] = mw.Type
	}
	if mw.Location != nil {
		objectMap["location"] = mw.Location
	}
	if mw.Tags != nil {
		objectMap["tags"] = mw.Tags
	}
	if mw.Etag != nil {
		objectMap["etag"] = mw.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MyWorkbook struct.
func (mw *MyWorkbook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mw.Kind = kind
			}
		case "properties":
			if v != nil {
				var myWorkbookProperties MyWorkbookProperties
				err = json.Unmarshal(*v, &myWorkbookProperties)
				if err != nil {
					return err
				}
				mw.MyWorkbookProperties = &myWorkbookProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mw.SystemData = &systemData
			}
		case "identity":
			if v != nil {
				var identity MyWorkbookManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mw.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mw.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mw.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mw.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mw.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mw.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag map[string]*string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mw.Etag = etag
			}
		}
	}

	return nil
}

// MyWorkbookError error response.
type MyWorkbookError struct {
	// Error - The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// MyWorkbookManagedIdentity customer Managed Identity
type MyWorkbookManagedIdentity struct {
	UserAssignedIdentities *MyWorkbookUserAssignedIdentities `json:"userAssignedIdentities,omitempty"`
	// Type - The identity type. Possible values include: 'TypeUserAssigned', 'TypeNone'
	Type Type `json:"type,omitempty"`
}

// MyWorkbookProperties properties that contain a private workbook.
type MyWorkbookProperties struct {
	// DisplayName - The user-defined name of the private workbook.
	DisplayName *string `json:"displayName,omitempty"`
	// SerializedData - Configuration of this particular private workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`
	// Version - This instance's version of the data model. This can change as new features are added that can be marked private workbook.
	Version *string `json:"version,omitempty"`
	// TimeModified - READ-ONLY; Date and time in UTC of the last modification that was made to this private workbook definition.
	TimeModified *string `json:"timeModified,omitempty"`
	// Category - Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`
	// Tags - A list of 0 or more tags that are associated with this private workbook definition
	Tags *[]string `json:"tags,omitempty"`
	// UserID - READ-ONLY; Unique user id of the specific user that owns this private workbook.
	UserID *string `json:"userId,omitempty"`
	// SourceID - Optional resourceId for a source resource.
	SourceID *string `json:"sourceId,omitempty"`
	// StorageURI - BYOS Storage Account URI
	StorageURI *string `json:"storageUri,omitempty"`
}

// MarshalJSON is the custom marshaler for MyWorkbookProperties.
func (mwp MyWorkbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mwp.DisplayName != nil {
		objectMap["displayName"] = mwp.DisplayName
	}
	if mwp.SerializedData != nil {
		objectMap["serializedData"] = mwp.SerializedData
	}
	if mwp.Version != nil {
		objectMap["version"] = mwp.Version
	}
	if mwp.Category != nil {
		objectMap["category"] = mwp.Category
	}
	if mwp.Tags != nil {
		objectMap["tags"] = mwp.Tags
	}
	if mwp.SourceID != nil {
		objectMap["sourceId"] = mwp.SourceID
	}
	if mwp.StorageURI != nil {
		objectMap["storageUri"] = mwp.StorageURI
	}
	return json.Marshal(objectMap)
}

// MyWorkbookResource an azure resource object
type MyWorkbookResource struct {
	// Identity - Identity used for BYOS
	Identity *MyWorkbookManagedIdentity `json:"identity,omitempty"`
	// ID - Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Etag - Resource etag
	Etag map[string]*string `json:"etag"`
}

// MarshalJSON is the custom marshaler for MyWorkbookResource.
func (mwr MyWorkbookResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mwr.Identity != nil {
		objectMap["identity"] = mwr.Identity
	}
	if mwr.ID != nil {
		objectMap["id"] = mwr.ID
	}
	if mwr.Name != nil {
		objectMap["name"] = mwr.Name
	}
	if mwr.Type != nil {
		objectMap["type"] = mwr.Type
	}
	if mwr.Location != nil {
		objectMap["location"] = mwr.Location
	}
	if mwr.Tags != nil {
		objectMap["tags"] = mwr.Tags
	}
	if mwr.Etag != nil {
		objectMap["etag"] = mwr.Etag
	}
	return json.Marshal(objectMap)
}

// MyWorkbooksListResult workbook list result.
type MyWorkbooksListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; An array of private workbooks.
	Value    *[]MyWorkbook `json:"value,omitempty"`
	NextLink *string       `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for MyWorkbooksListResult.
func (mwlr MyWorkbooksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mwlr.NextLink != nil {
		objectMap["nextLink"] = mwlr.NextLink
	}
	return json.Marshal(objectMap)
}

// MyWorkbooksListResultIterator provides access to a complete listing of MyWorkbook values.
type MyWorkbooksListResultIterator struct {
	i    int
	page MyWorkbooksListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MyWorkbooksListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MyWorkbooksListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MyWorkbooksListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MyWorkbooksListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MyWorkbooksListResultIterator) Response() MyWorkbooksListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MyWorkbooksListResultIterator) Value() MyWorkbook {
	if !iter.page.NotDone() {
		return MyWorkbook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MyWorkbooksListResultIterator type.
func NewMyWorkbooksListResultIterator(page MyWorkbooksListResultPage) MyWorkbooksListResultIterator {
	return MyWorkbooksListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mwlr MyWorkbooksListResult) IsEmpty() bool {
	return mwlr.Value == nil || len(*mwlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mwlr MyWorkbooksListResult) hasNextLink() bool {
	return mwlr.NextLink != nil && len(*mwlr.NextLink) != 0
}

// myWorkbooksListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mwlr MyWorkbooksListResult) myWorkbooksListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mwlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mwlr.NextLink)))
}

// MyWorkbooksListResultPage contains a page of MyWorkbook values.
type MyWorkbooksListResultPage struct {
	fn   func(context.Context, MyWorkbooksListResult) (MyWorkbooksListResult, error)
	mwlr MyWorkbooksListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MyWorkbooksListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MyWorkbooksListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mwlr)
		if err != nil {
			return err
		}
		page.mwlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MyWorkbooksListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MyWorkbooksListResultPage) NotDone() bool {
	return !page.mwlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MyWorkbooksListResultPage) Response() MyWorkbooksListResult {
	return page.mwlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MyWorkbooksListResultPage) Values() []MyWorkbook {
	if page.mwlr.IsEmpty() {
		return nil
	}
	return *page.mwlr.Value
}

// Creates a new instance of the MyWorkbooksListResultPage type.
func NewMyWorkbooksListResultPage(cur MyWorkbooksListResult, getNextPage func(context.Context, MyWorkbooksListResult) (MyWorkbooksListResult, error)) MyWorkbooksListResultPage {
	return MyWorkbooksListResultPage{
		fn:   getNextPage,
		mwlr: cur,
	}
}

// MyWorkbookUserAssignedIdentities customer Managed Identity
type MyWorkbookUserAssignedIdentities struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for MyWorkbookUserAssignedIdentities.
func (mwuai MyWorkbookUserAssignedIdentities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Operation CDN REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationInfo information about an operation
type OperationInfo struct {
	// Provider - Name of the provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list CDN operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationLive represents an operation returned by the GetOperations request
type OperationLive struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Display - Display name of the operation
	Display *OperationInfo `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsListResult result of the List Operations operation
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of operations
	Value *[]OperationLive `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListResultIterator provides access to a complete listing of OperationLive values.
type OperationsListResultIterator struct {
	i    int
	page OperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListResultIterator) Response() OperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListResultIterator) Value() OperationLive {
	if !iter.page.NotDone() {
		return OperationLive{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListResultIterator type.
func NewOperationsListResultIterator(page OperationsListResultPage) OperationsListResultIterator {
	return OperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationsListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationsListResult) operationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationsListResultPage contains a page of OperationLive values.
type OperationsListResultPage struct {
	fn  func(context.Context, OperationsListResult) (OperationsListResult, error)
	olr OperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListResultPage) Response() OperationsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListResultPage) Values() []OperationLive {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationsListResultPage type.
func NewOperationsListResultPage(cur OperationsListResult, getNextPage func(context.Context, OperationsListResult) (OperationsListResult, error)) OperationsListResultPage {
	return OperationsListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateLinkScopedResource the private link scope resource reference.
type PrivateLinkScopedResource struct {
	// ResourceID - The full resource Id of the private link scope resource.
	ResourceID *string `json:"ResourceId,omitempty"`
	// ScopeID - The private link scope unique Identifier.
	ScopeID *string `json:"ScopeId,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// WebTest instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserAssignedIdentity user assigned identity properties
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client ID of the assigned identity.
	ClientID *uuid.UUID `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WebTest an Application Insights web test definition.
type WebTest struct {
	autorest.Response `json:"-"`
	// Kind - The kind of web test that this web test watches. Choices are ping and multistep. Possible values include: 'WebTestKindPing', 'WebTestKindMultistep'
	Kind WebTestKind `json:"kind,omitempty"`
	// WebTestProperties - Metadata describing a web test for an Azure resource.
	*WebTestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebTest.
func (wt WebTest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wt.Kind != "" {
		objectMap["kind"] = wt.Kind
	}
	if wt.WebTestProperties != nil {
		objectMap["properties"] = wt.WebTestProperties
	}
	if wt.Location != nil {
		objectMap["location"] = wt.Location
	}
	if wt.Tags != nil {
		objectMap["tags"] = wt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebTest struct.
func (wt *WebTest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind WebTestKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				wt.Kind = kind
			}
		case "properties":
			if v != nil {
				var webTestProperties WebTestProperties
				err = json.Unmarshal(*v, &webTestProperties)
				if err != nil {
					return err
				}
				wt.WebTestProperties = &webTestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wt.Tags = tags
			}
		}
	}

	return nil
}

// WebTestGeolocation geo-physical location to run a web test from. You must specify one or more locations
// for the test to run from.
type WebTestGeolocation struct {
	// Location - Location ID for the webtest to run from.
	Location *string `json:"Id,omitempty"`
}

// WebTestListResult a list of 0 or more Application Insights web test definitions.
type WebTestListResult struct {
	autorest.Response `json:"-"`
	// Value - Set of Application Insights web test definitions.
	Value *[]WebTest `json:"value,omitempty"`
	// NextLink - The link to get the next part of the returned list of web tests, should the return set be too large for a single request. May be null.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebTestListResultIterator provides access to a complete listing of WebTest values.
type WebTestListResultIterator struct {
	i    int
	page WebTestListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebTestListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebTestListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebTestListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebTestListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebTestListResultIterator) Response() WebTestListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebTestListResultIterator) Value() WebTest {
	if !iter.page.NotDone() {
		return WebTest{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebTestListResultIterator type.
func NewWebTestListResultIterator(page WebTestListResultPage) WebTestListResultIterator {
	return WebTestListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wtlr WebTestListResult) IsEmpty() bool {
	return wtlr.Value == nil || len(*wtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wtlr WebTestListResult) hasNextLink() bool {
	return wtlr.NextLink != nil && len(*wtlr.NextLink) != 0
}

// webTestListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wtlr WebTestListResult) webTestListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wtlr.NextLink)))
}

// WebTestListResultPage contains a page of WebTest values.
type WebTestListResultPage struct {
	fn   func(context.Context, WebTestListResult) (WebTestListResult, error)
	wtlr WebTestListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebTestListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebTestListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wtlr)
		if err != nil {
			return err
		}
		page.wtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebTestListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebTestListResultPage) NotDone() bool {
	return !page.wtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebTestListResultPage) Response() WebTestListResult {
	return page.wtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebTestListResultPage) Values() []WebTest {
	if page.wtlr.IsEmpty() {
		return nil
	}
	return *page.wtlr.Value
}

// Creates a new instance of the WebTestListResultPage type.
func NewWebTestListResultPage(cur WebTestListResult, getNextPage func(context.Context, WebTestListResult) (WebTestListResult, error)) WebTestListResultPage {
	return WebTestListResultPage{
		fn:   getNextPage,
		wtlr: cur,
	}
}

// WebTestProperties metadata describing a web test for an Azure resource.
type WebTestProperties struct {
	// SyntheticMonitorID - Unique ID of this WebTest. This is typically the same value as the Name field.
	SyntheticMonitorID *string `json:"SyntheticMonitorId,omitempty"`
	// WebTestName - User defined name if this WebTest.
	WebTestName *string `json:"Name,omitempty"`
	// Description - Purpose/user defined descriptive test for this WebTest.
	Description *string `json:"Description,omitempty"`
	// Enabled - Is the test actively being monitored.
	Enabled *bool `json:"Enabled,omitempty"`
	// Frequency - Interval in seconds between test runs for this WebTest. Default value is 300.
	Frequency *int32 `json:"Frequency,omitempty"`
	// Timeout - Seconds until this WebTest will timeout and fail. Default value is 30.
	Timeout *int32 `json:"Timeout,omitempty"`
	// WebTestKind - The kind of web test this is, valid choices are ping and multistep. Possible values include: 'WebTestKindPing', 'WebTestKindMultistep'
	WebTestKind WebTestKind `json:"Kind,omitempty"`
	// RetryEnabled - Allow for retries should this WebTest fail.
	RetryEnabled *bool `json:"RetryEnabled,omitempty"`
	// Locations - A list of where to physically run the tests from to give global coverage for accessibility of your application.
	Locations *[]WebTestGeolocation `json:"Locations,omitempty"`
	// Configuration - An XML configuration specification for a WebTest.
	Configuration *WebTestPropertiesConfiguration `json:"Configuration,omitempty"`
	// ProvisioningState - READ-ONLY; Current state of this component, whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebTestProperties.
func (wtp WebTestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtp.SyntheticMonitorID != nil {
		objectMap["SyntheticMonitorId"] = wtp.SyntheticMonitorID
	}
	if wtp.WebTestName != nil {
		objectMap["Name"] = wtp.WebTestName
	}
	if wtp.Description != nil {
		objectMap["Description"] = wtp.Description
	}
	if wtp.Enabled != nil {
		objectMap["Enabled"] = wtp.Enabled
	}
	if wtp.Frequency != nil {
		objectMap["Frequency"] = wtp.Frequency
	}
	if wtp.Timeout != nil {
		objectMap["Timeout"] = wtp.Timeout
	}
	if wtp.WebTestKind != "" {
		objectMap["Kind"] = wtp.WebTestKind
	}
	if wtp.RetryEnabled != nil {
		objectMap["RetryEnabled"] = wtp.RetryEnabled
	}
	if wtp.Locations != nil {
		objectMap["Locations"] = wtp.Locations
	}
	if wtp.Configuration != nil {
		objectMap["Configuration"] = wtp.Configuration
	}
	return json.Marshal(objectMap)
}

// WebTestPropertiesConfiguration an XML configuration specification for a WebTest.
type WebTestPropertiesConfiguration struct {
	// WebTest - The XML specification of a WebTest to run against an application.
	WebTest *string `json:"WebTest,omitempty"`
}

// WebtestsResource an azure resource object
type WebtestsResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebtestsResource.
func (wr WebtestsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wr.Location != nil {
		objectMap["location"] = wr.Location
	}
	if wr.Tags != nil {
		objectMap["tags"] = wr.Tags
	}
	return json.Marshal(objectMap)
}

// Workbook an Application Insights workbook definition.
type Workbook struct {
	autorest.Response `json:"-"`
	// WorkbookProperties - Metadata describing a workbook for an Azure resource.
	*WorkbookProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Identity - Identity used for BYOS
	Identity *WorkbookResourceIdentity `json:"identity,omitempty"`
	// Kind - The kind of workbook. Choices are user and shared. Possible values include: 'KindUser', 'KindShared'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Resource etag
	Etag map[string]*string `json:"etag"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workbook.
func (w Workbook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkbookProperties != nil {
		objectMap["properties"] = w.WorkbookProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Kind != "" {
		objectMap["kind"] = w.Kind
	}
	if w.Etag != nil {
		objectMap["etag"] = w.Etag
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workbook struct.
func (w *Workbook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workbookProperties WorkbookProperties
				err = json.Unmarshal(*v, &workbookProperties)
				if err != nil {
					return err
				}
				w.WorkbookProperties = &workbookProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		case "identity":
			if v != nil {
				var identity WorkbookResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				w.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag map[string]*string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				w.Etag = etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkbookError error response.
type WorkbookError struct {
	// Error - The error details.
	Error *WorkbookErrorDefinition `json:"error,omitempty"`
}

// WorkbookErrorDefinition error definition.
type WorkbookErrorDefinition struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty"`
	// InnerError - READ-ONLY; Internal error details.
	InnerError interface{} `json:"innerError,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookErrorDefinition.
func (wed WorkbookErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkbookInnerErrorTrace error details
type WorkbookInnerErrorTrace struct {
	// Trace - READ-ONLY; detailed error trace
	Trace *[]string `json:"trace,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookInnerErrorTrace.
func (wiet WorkbookInnerErrorTrace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkbookProperties properties that contain a workbook.
type WorkbookProperties struct {
	// DisplayName - The user-defined name (display name) of the workbook.
	DisplayName *string `json:"displayName,omitempty"`
	// SerializedData - Configuration of this particular workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`
	// Version - Workbook schema version format, like 'Notebook/1.0', which should match the workbook in serializedData
	Version *string `json:"version,omitempty"`
	// TimeModified - READ-ONLY; Date and time in UTC of the last modification that was made to this workbook definition.
	TimeModified *date.Time `json:"timeModified,omitempty"`
	// Category - Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`
	// Tags - Being deprecated, please use the other tags field
	Tags *[]string `json:"tags,omitempty"`
	// UserID - READ-ONLY; Unique user id of the specific user that owns this workbook.
	UserID *string `json:"userId,omitempty"`
	// SourceID - ResourceId for a source resource.
	SourceID *string `json:"sourceId,omitempty"`
	// StorageURI - The resourceId to the storage account when bring your own storage is used
	StorageURI *string `json:"storageUri,omitempty"`
	// Description - The description of the workbook.
	Description *string `json:"description,omitempty"`
	// Revision - READ-ONLY; The unique revision id for this workbook definition
	Revision *string `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookProperties.
func (wp WorkbookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.DisplayName != nil {
		objectMap["displayName"] = wp.DisplayName
	}
	if wp.SerializedData != nil {
		objectMap["serializedData"] = wp.SerializedData
	}
	if wp.Version != nil {
		objectMap["version"] = wp.Version
	}
	if wp.Category != nil {
		objectMap["category"] = wp.Category
	}
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	if wp.SourceID != nil {
		objectMap["sourceId"] = wp.SourceID
	}
	if wp.StorageURI != nil {
		objectMap["storageUri"] = wp.StorageURI
	}
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	return json.Marshal(objectMap)
}

// WorkbookPropertiesUpdateParameters properties that contain a workbook for PATCH operation.
type WorkbookPropertiesUpdateParameters struct {
	// DisplayName - The user-defined name (display name) of the workbook.
	DisplayName *string `json:"displayName,omitempty"`
	// SerializedData - Configuration of this particular workbook. Configuration data is a string containing valid JSON
	SerializedData *string `json:"serializedData,omitempty"`
	// Category - Workbook category, as defined by the user at creation time.
	Category *string `json:"category,omitempty"`
	// Tags - A list of 0 or more tags that are associated with this workbook definition
	Tags *[]string `json:"tags,omitempty"`
	// Description - The description of the workbook.
	Description *string `json:"description,omitempty"`
	// Revision - The unique revision id for this workbook definition
	Revision *string `json:"revision,omitempty"`
}

// WorkbookResource an azure resource object
type WorkbookResource struct {
	// Identity - Identity used for BYOS
	Identity *WorkbookResourceIdentity `json:"identity,omitempty"`
	// Kind - The kind of workbook. Choices are user and shared. Possible values include: 'KindUser', 'KindShared'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Resource etag
	Etag map[string]*string `json:"etag"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookResource.
func (wr WorkbookResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wr.Identity != nil {
		objectMap["identity"] = wr.Identity
	}
	if wr.Kind != "" {
		objectMap["kind"] = wr.Kind
	}
	if wr.Etag != nil {
		objectMap["etag"] = wr.Etag
	}
	if wr.Tags != nil {
		objectMap["tags"] = wr.Tags
	}
	if wr.Location != nil {
		objectMap["location"] = wr.Location
	}
	return json.Marshal(objectMap)
}

// WorkbookResourceIdentity identity used for BYOS
type WorkbookResourceIdentity struct {
	// PrincipalID - READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Type - Possible values include: 'ManagedServiceIdentityTypeNone', 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeUserAssigned', 'ManagedServiceIdentityTypeSystemAssignedUserAssigned'
	Type                   ManagedServiceIdentityType       `json:"type,omitempty"`
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for WorkbookResourceIdentity.
func (wr WorkbookResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wr.Type != "" {
		objectMap["type"] = wr.Type
	}
	if wr.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = wr.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// WorkbooksListResult workbook list result.
type WorkbooksListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; An array of workbooks.
	Value    *[]Workbook `json:"value,omitempty"`
	NextLink *string     `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbooksListResult.
func (wlr WorkbooksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wlr.NextLink != nil {
		objectMap["nextLink"] = wlr.NextLink
	}
	return json.Marshal(objectMap)
}

// WorkbooksListResultIterator provides access to a complete listing of Workbook values.
type WorkbooksListResultIterator struct {
	i    int
	page WorkbooksListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkbooksListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkbooksListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkbooksListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkbooksListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkbooksListResultIterator) Response() WorkbooksListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkbooksListResultIterator) Value() Workbook {
	if !iter.page.NotDone() {
		return Workbook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkbooksListResultIterator type.
func NewWorkbooksListResultIterator(page WorkbooksListResultPage) WorkbooksListResultIterator {
	return WorkbooksListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkbooksListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkbooksListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workbooksListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkbooksListResult) workbooksListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkbooksListResultPage contains a page of Workbook values.
type WorkbooksListResultPage struct {
	fn  func(context.Context, WorkbooksListResult) (WorkbooksListResult, error)
	wlr WorkbooksListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkbooksListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkbooksListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkbooksListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkbooksListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkbooksListResultPage) Response() WorkbooksListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkbooksListResultPage) Values() []Workbook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkbooksListResultPage type.
func NewWorkbooksListResultPage(cur WorkbooksListResult, getNextPage func(context.Context, WorkbooksListResult) (WorkbooksListResult, error)) WorkbooksListResultPage {
	return WorkbooksListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkbookTemplate an Application Insights workbook template definition.
type WorkbookTemplate struct {
	autorest.Response `json:"-"`
	// WorkbookTemplateProperties - Metadata describing a workbook template for an Azure resource.
	*WorkbookTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkbookTemplate.
func (wt WorkbookTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wt.WorkbookTemplateProperties != nil {
		objectMap["properties"] = wt.WorkbookTemplateProperties
	}
	if wt.Location != nil {
		objectMap["location"] = wt.Location
	}
	if wt.Tags != nil {
		objectMap["tags"] = wt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkbookTemplate struct.
func (wt *WorkbookTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workbookTemplateProperties WorkbookTemplateProperties
				err = json.Unmarshal(*v, &workbookTemplateProperties)
				if err != nil {
					return err
				}
				wt.WorkbookTemplateProperties = &workbookTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wt.Tags = tags
			}
		}
	}

	return nil
}

// WorkbookTemplateError error message that will indicate why the operation failed.
type WorkbookTemplateError struct {
	// Error - Error message object that will indicate why the operation failed.
	Error *WorkbookTemplateErrorBody `json:"error,omitempty"`
}

// WorkbookTemplateErrorBody error message body that will indicate why the operation failed.
type WorkbookTemplateErrorBody struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]WorkbookTemplateErrorFieldContract `json:"details,omitempty"`
}

// WorkbookTemplateErrorFieldContract error Field contract.
type WorkbookTemplateErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// WorkbookTemplateGallery gallery information for a workbook template.
type WorkbookTemplateGallery struct {
	// Name - Name of the workbook template in the gallery.
	Name *string `json:"name,omitempty"`
	// Category - Category for the gallery.
	Category *string `json:"category,omitempty"`
	// Type - Type of workbook supported by the workbook template.
	Type *string `json:"type,omitempty"`
	// Order - Order of the template within the gallery.
	Order *int32 `json:"order,omitempty"`
	// ResourceType - Azure resource type supported by the gallery.
	ResourceType *string `json:"resourceType,omitempty"`
}

// WorkbookTemplateLocalizedGallery localized template data and gallery information.
type WorkbookTemplateLocalizedGallery struct {
	// TemplateData - Valid JSON object containing workbook template payload.
	TemplateData interface{} `json:"templateData,omitempty"`
	// Galleries - Workbook galleries supported by the template.
	Galleries *[]WorkbookTemplateGallery `json:"galleries,omitempty"`
}

// WorkbookTemplateProperties properties that contain a workbook template.
type WorkbookTemplateProperties struct {
	// Priority - Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
	Priority *int32 `json:"priority,omitempty"`
	// Author - Information about the author of the workbook template.
	Author *string `json:"author,omitempty"`
	// TemplateData - Valid JSON object containing workbook template payload.
	TemplateData interface{} `json:"templateData,omitempty"`
	// Galleries - Workbook galleries supported by the template.
	Galleries *[]WorkbookTemplateGallery `json:"galleries,omitempty"`
	// Localized - Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
	Localized map[string][]WorkbookTemplateLocalizedGallery `json:"localized"`
}

// MarshalJSON is the custom marshaler for WorkbookTemplateProperties.
func (wtp WorkbookTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtp.Priority != nil {
		objectMap["priority"] = wtp.Priority
	}
	if wtp.Author != nil {
		objectMap["author"] = wtp.Author
	}
	if wtp.TemplateData != nil {
		objectMap["templateData"] = wtp.TemplateData
	}
	if wtp.Galleries != nil {
		objectMap["galleries"] = wtp.Galleries
	}
	if wtp.Localized != nil {
		objectMap["localized"] = wtp.Localized
	}
	return json.Marshal(objectMap)
}

// WorkbookTemplateResource an azure resource object
type WorkbookTemplateResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkbookTemplateResource.
func (wtr WorkbookTemplateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtr.Location != nil {
		objectMap["location"] = wtr.Location
	}
	if wtr.Tags != nil {
		objectMap["tags"] = wtr.Tags
	}
	return json.Marshal(objectMap)
}

// WorkbookTemplatesListResult workbookTemplate list result.
type WorkbookTemplatesListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of workbook templates.
	Value *[]WorkbookTemplate `json:"value,omitempty"`
}

// WorkbookTemplateUpdateParameters the parameters that can be provided when updating workbook template.
type WorkbookTemplateUpdateParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// WorkbookTemplateProperties - Metadata describing a workbook for an Azure resource.
	*WorkbookTemplateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookTemplateUpdateParameters.
func (wtup WorkbookTemplateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtup.Tags != nil {
		objectMap["tags"] = wtup.Tags
	}
	if wtup.WorkbookTemplateProperties != nil {
		objectMap["properties"] = wtup.WorkbookTemplateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkbookTemplateUpdateParameters struct.
func (wtup *WorkbookTemplateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wtup.Tags = tags
			}
		case "properties":
			if v != nil {
				var workbookTemplateProperties WorkbookTemplateProperties
				err = json.Unmarshal(*v, &workbookTemplateProperties)
				if err != nil {
					return err
				}
				wtup.WorkbookTemplateProperties = &workbookTemplateProperties
			}
		}
	}

	return nil
}

// WorkbookUpdateParameters the parameters that can be provided when updating workbook properties
// properties.
type WorkbookUpdateParameters struct {
	// Kind - The kind of workbook. Choices are user and shared. Possible values include: 'SharedTypeKindUser', 'SharedTypeKindShared'
	Kind SharedTypeKind `json:"kind,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// WorkbookPropertiesUpdateParameters - Metadata describing a workbook for an Azure resource.
	*WorkbookPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkbookUpdateParameters.
func (wup WorkbookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Kind != "" {
		objectMap["kind"] = wup.Kind
	}
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WorkbookPropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WorkbookPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkbookUpdateParameters struct.
func (wup *WorkbookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind SharedTypeKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				wup.Kind = kind
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var workbookPropertiesUpdateParameters WorkbookPropertiesUpdateParameters
				err = json.Unmarshal(*v, &workbookPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WorkbookPropertiesUpdateParameters = &workbookPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// WorkItemConfiguration work item configuration associated with an application insights resource.
type WorkItemConfiguration struct {
	autorest.Response `json:"-"`
	// ConnectorID - Connector identifier where work item is created
	ConnectorID *string `json:"ConnectorId,omitempty"`
	// ConfigDisplayName - Configuration friendly name
	ConfigDisplayName *string `json:"ConfigDisplayName,omitempty"`
	// IsDefault - Boolean value indicating whether configuration is default
	IsDefault *bool `json:"IsDefault,omitempty"`
	// ID - Unique Id for work item
	ID *string `json:"Id,omitempty"`
	// ConfigProperties - Serialized JSON object for detailed properties
	ConfigProperties *string `json:"ConfigProperties,omitempty"`
}

// WorkItemConfigurationError error associated with trying to get work item configuration or configurations
type WorkItemConfigurationError struct {
	// Code - Error detail code and explanation
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message    *string     `json:"message,omitempty"`
	Innererror *InnerError `json:"innererror,omitempty"`
}

// WorkItemConfigurationsListResult work item configuration list result.
type WorkItemConfigurationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; An array of work item configurations.
	Value *[]WorkItemConfiguration `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkItemConfigurationsListResult.
func (wiclr WorkItemConfigurationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkItemCreateConfiguration work item configuration creation payload
type WorkItemCreateConfiguration struct {
	// ConnectorID - Unique connector id
	ConnectorID *string `json:"ConnectorId,omitempty"`
	// ConnectorDataConfiguration - Serialized JSON object for detailed properties
	ConnectorDataConfiguration *string `json:"ConnectorDataConfiguration,omitempty"`
	// ValidateOnly - Boolean indicating validate only
	ValidateOnly *bool `json:"ValidateOnly,omitempty"`
	// WorkItemProperties - Custom work item properties
	WorkItemProperties map[string]*string `json:"WorkItemProperties"`
}

// MarshalJSON is the custom marshaler for WorkItemCreateConfiguration.
func (wicc WorkItemCreateConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wicc.ConnectorID != nil {
		objectMap["ConnectorId"] = wicc.ConnectorID
	}
	if wicc.ConnectorDataConfiguration != nil {
		objectMap["ConnectorDataConfiguration"] = wicc.ConnectorDataConfiguration
	}
	if wicc.ValidateOnly != nil {
		objectMap["ValidateOnly"] = wicc.ValidateOnly
	}
	if wicc.WorkItemProperties != nil {
		objectMap["WorkItemProperties"] = wicc.WorkItemProperties
	}
	return json.Marshal(objectMap)
}
