/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_THERMAL_ZONE
#  define H_THERMAL_ZONE

/************************************************************************
 * Constants
 ************************************************************************/

/*
 * Name of the subdirectory of /proc/acpi which contains the thermal zone
 * information.
 * Must contain "/" as first and last characters.
 */
extern const char * const thermal_zone_dir;

/* 
 * Name of the file in the device directory which contains its status, i.e.
 * temperature.
 * Must contain "/" as first character.
 */
extern const char * const thermal_zone_status_file;

/************************************************************************
 * Function prototypes for thermal.c
 ************************************************************************/

/*
 * Allocates memory for a Thermal_Zone structure, and initializes it
 * with the info found in the directory provided, which must be
 * one such as /proc/acpi/thermal_zone/TZ1/.
 *
 * The Thermal_Zone allocated with thermal_zone_init-) must be deallocated
 * with thermal_zone_free().
 *
 * If the dirent* is NULL, or if any malloc() fails, then it returns NULL.
 */
void *thermal_zone_init(struct dirent *);

/*
 * Sets the selected thermal zone to the next one, or the first if the thermal
 * zone selected before calling thermal_zone_next() is the last.
 *
 * If the AcpiInfos is NULL, or if no thermal zone is detected,
 * then thermal_zone_next() does nothing.
 */
void thermal_zone_next(AcpiInfos *);

/*
 * Cleanly frees the Thermal_Zone from memory.
 *
 * Accepts a NULL Thermal_Zone*, but does nothing with it.
 */
void thermal_zone_free(Thermal_Zone *);

/*
 * Updates the temp field of the Thermal_Zone. In case of error, the temperature
 * is set to 0C.
 * If the parameter is NULL, it does nothing with it and returns.
 */
void thermal_zone_update_status(Thermal_Zone *);

#endif                          /* H_THERMAL_ZONE */
