# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `psych` gem.
# Please instead update this file by running `bin/tapioca gem psych`.

# source://psych//lib/psych/core_ext.rb#2
class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin

  # call-seq: to_yaml(options = {})
  #
  # Convert an object to YAML.  See Psych.dump for more information on the
  # available +options+.
  #
  # source://psych//lib/psych/core_ext.rb#12
  def to_yaml(options = T.unsafe(nil)); end

  class << self
    # source://psych//lib/psych/core_ext.rb#3
    def yaml_tag(url); end
  end
end

# = Overview
#
# Psych is a YAML parser and emitter.
# Psych leverages libyaml [Home page: https://pyyaml.org/wiki/LibYAML]
# or [git repo: https://github.com/yaml/libyaml] for its YAML parsing
# and emitting capabilities. In addition to wrapping libyaml, Psych also
# knows how to serialize and de-serialize most Ruby objects to and from
# the YAML format.
#
# = I NEED TO PARSE OR EMIT YAML RIGHT NOW!
#
#   # Parse some YAML
#   Psych.load("--- foo") # => "foo"
#
#   # Emit some YAML
#   Psych.dump("foo")     # => "--- foo\n...\n"
#   { :a => 'b'}.to_yaml  # => "---\n:a: b\n"
#
# Got more time on your hands?  Keep on reading!
#
# == YAML Parsing
#
# Psych provides a range of interfaces for parsing a YAML document ranging from
# low level to high level, depending on your parsing needs.  At the lowest
# level, is an event based parser.  Mid level is access to the raw YAML AST,
# and at the highest level is the ability to unmarshal YAML to Ruby objects.
#
# == YAML Emitting
#
# Psych provides a range of interfaces ranging from low to high level for
# producing YAML documents.  Very similar to the YAML parsing interfaces, Psych
# provides at the lowest level, an event based system, mid-level is building
# a YAML AST, and the highest level is converting a Ruby object straight to
# a YAML document.
#
# == High-level API
#
# === Parsing
#
# The high level YAML parser provided by Psych simply takes YAML as input and
# returns a Ruby data structure.  For information on using the high level parser
# see Psych.load
#
# ==== Reading from a string
#
#   Psych.safe_load("--- a")             # => 'a'
#   Psych.safe_load("---\n - a\n - b")   # => ['a', 'b']
#   # From a trusted string:
#   Psych.load("--- !ruby/range\nbegin: 0\nend: 42\nexcl: false\n") # => 0..42
#
# ==== Reading from a file
#
#   Psych.safe_load_file("data.yml", permitted_classes: [Date])
#   Psych.load_file("trusted_database.yml")
#
# ==== Exception handling
#
#   begin
#     # The second argument changes only the exception contents
#     Psych.parse("--- `", "file.txt")
#   rescue Psych::SyntaxError => ex
#     ex.file    # => 'file.txt'
#     ex.message # => "(file.txt): found character that cannot start any token"
#   end
#
# === Emitting
#
# The high level emitter has the easiest interface.  Psych simply takes a Ruby
# data structure and converts it to a YAML document.  See Psych.dump for more
# information on dumping a Ruby data structure.
#
# ==== Writing to a string
#
#   # Dump an array, get back a YAML string
#   Psych.dump(['a', 'b'])  # => "---\n- a\n- b\n"
#
#   # Dump an array to an IO object
#   Psych.dump(['a', 'b'], StringIO.new)  # => #<StringIO:0x000001009d0890>
#
#   # Dump an array with indentation set
#   Psych.dump(['a', ['b']], :indentation => 3) # => "---\n- a\n-  - b\n"
#
#   # Dump an array to an IO with indentation set
#   Psych.dump(['a', ['b']], StringIO.new, :indentation => 3)
#
# ==== Writing to a file
#
# Currently there is no direct API for dumping Ruby structure to file:
#
#   File.open('database.yml', 'w') do |file|
#     file.write(Psych.dump(['a', 'b']))
#   end
#
# == Mid-level API
#
# === Parsing
#
# Psych provides access to an AST produced from parsing a YAML document.  This
# tree is built using the Psych::Parser and Psych::TreeBuilder.  The AST can
# be examined and manipulated freely.  Please see Psych::parse_stream,
# Psych::Nodes, and Psych::Nodes::Node for more information on dealing with
# YAML syntax trees.
#
# ==== Reading from a string
#
#   # Returns Psych::Nodes::Stream
#   Psych.parse_stream("---\n - a\n - b")
#
#   # Returns Psych::Nodes::Document
#   Psych.parse("---\n - a\n - b")
#
# ==== Reading from a file
#
#   # Returns Psych::Nodes::Stream
#   Psych.parse_stream(File.read('database.yml'))
#
#   # Returns Psych::Nodes::Document
#   Psych.parse_file('database.yml')
#
# ==== Exception handling
#
#   begin
#     # The second argument changes only the exception contents
#     Psych.parse("--- `", "file.txt")
#   rescue Psych::SyntaxError => ex
#     ex.file    # => 'file.txt'
#     ex.message # => "(file.txt): found character that cannot start any token"
#   end
#
# === Emitting
#
# At the mid level is building an AST.  This AST is exactly the same as the AST
# used when parsing a YAML document.  Users can build an AST by hand and the
# AST knows how to emit itself as a YAML document.  See Psych::Nodes,
# Psych::Nodes::Node, and Psych::TreeBuilder for more information on building
# a YAML AST.
#
# ==== Writing to a string
#
#   # We need Psych::Nodes::Stream (not Psych::Nodes::Document)
#   stream = Psych.parse_stream("---\n - a\n - b")
#
#   stream.to_yaml # => "---\n- a\n- b\n"
#
# ==== Writing to a file
#
#   # We need Psych::Nodes::Stream (not Psych::Nodes::Document)
#   stream = Psych.parse_stream(File.read('database.yml'))
#
#   File.open('database.yml', 'w') do |file|
#     file.write(stream.to_yaml)
#   end
#
# == Low-level API
#
# === Parsing
#
# The lowest level parser should be used when the YAML input is already known,
# and the developer does not want to pay the price of building an AST or
# automatic detection and conversion to Ruby objects.  See Psych::Parser for
# more information on using the event based parser.
#
# ==== Reading to Psych::Nodes::Stream structure
#
#   parser = Psych::Parser.new(TreeBuilder.new) # => #<Psych::Parser>
#   parser = Psych.parser                       # it's an alias for the above
#
#   parser.parse("---\n - a\n - b")             # => #<Psych::Parser>
#   parser.handler                              # => #<Psych::TreeBuilder>
#   parser.handler.root                         # => #<Psych::Nodes::Stream>
#
# ==== Receiving an events stream
#
#   recorder = Psych::Handlers::Recorder.new
#   parser = Psych::Parser.new(recorder)
#
#   parser.parse("---\n - a\n - b")
#   recorder.events # => [list of [event, args] lists]
#                   # event is one of: Psych::Handler::EVENTS
#                   # args are the arguments passed to the event
#
# === Emitting
#
# The lowest level emitter is an event based system.  Events are sent to a
# Psych::Emitter object.  That object knows how to convert the events to a YAML
# document.  This interface should be used when document format is known in
# advance or speed is a concern.  See Psych::Emitter for more information.
#
# ==== Writing to a Ruby structure
#
#   Psych.parser.parse("--- a")       # => #<Psych::Parser>
#
#   parser.handler.first              # => #<Psych::Nodes::Stream>
#   parser.handler.first.to_ruby      # => ["a"]
#
#   parser.handler.root.first         # => #<Psych::Nodes::Document>
#   parser.handler.root.first.to_ruby # => "a"
#
#   # You can instantiate an Emitter manually
#   Psych::Visitors::ToRuby.new.accept(parser.handler.root.first)
#   # => "a"
#
# source://psych//lib/psych/versions.rb#3
module Psych
  class << self
    # source://psych//lib/psych.rb#682
    def add_builtin_type(type_tag, &block); end

    # :stopdoc:
    #
    # source://psych//lib/psych.rb#676
    def add_domain_type(domain, type_tag, &block); end

    # source://psych//lib/psych.rb#692
    def add_tag(tag, klass); end

    # source://psych//lib/psych.rb#726
    def config; end

    # call-seq:
    #   Psych.dump(o)               -> string of yaml
    #   Psych.dump(o, options)      -> string of yaml
    #   Psych.dump(o, io)           -> io object passed in
    #   Psych.dump(o, io, options)  -> io object passed in
    #
    # Dump Ruby object +o+ to a YAML string.  Optional +options+ may be passed in
    # to control the output format.  If an IO object is passed in, the YAML will
    # be dumped to that IO object.
    #
    # Currently supported options are:
    #
    # [<tt>:indentation</tt>]   Number of space characters used to indent.
    #                           Acceptable value should be in <tt>0..9</tt> range,
    #                           otherwise option is ignored.
    #
    #                           Default: <tt>2</tt>.
    # [<tt>:line_width</tt>]    Max character to wrap line at.
    #
    #                           Default: <tt>0</tt> (meaning "wrap at 81").
    # [<tt>:canonical</tt>]     Write "canonical" YAML form (very verbose, yet
    #                           strictly formal).
    #
    #                           Default: <tt>false</tt>.
    # [<tt>:header</tt>]        Write <tt>%YAML [version]</tt> at the beginning of document.
    #
    #                           Default: <tt>false</tt>.
    #
    # Example:
    #
    #   # Dump an array, get back a YAML string
    #   Psych.dump(['a', 'b'])  # => "---\n- a\n- b\n"
    #
    #   # Dump an array to an IO object
    #   Psych.dump(['a', 'b'], StringIO.new)  # => #<StringIO:0x000001009d0890>
    #
    #   # Dump an array with indentation set
    #   Psych.dump(['a', ['b']], indentation: 3) # => "---\n- a\n-  - b\n"
    #
    #   # Dump an array to an IO with indentation set
    #   Psych.dump(['a', ['b']], StringIO.new, indentation: 3)
    #
    # source://psych//lib/psych.rb#505
    def dump(o, io = T.unsafe(nil), options = T.unsafe(nil)); end

    # Dump a list of objects as separate documents to a document stream.
    #
    # Example:
    #
    #   Psych.dump_stream("foo\n  ", {}) # => "--- ! \"foo\\n  \"\n--- {}\n"
    #
    # source://psych//lib/psych.rb#595
    def dump_stream(*objects); end

    # Load +yaml+ in to a Ruby data structure.  If multiple documents are
    # provided, the object contained in the first document will be returned.
    # +filename+ will be used in the exception message if any exception
    # is raised while parsing.  If +yaml+ is empty, it returns
    # the specified +fallback+ return value, which defaults to +false+.
    #
    # Raises a Psych::SyntaxError when a YAML syntax error is detected.
    #
    # Example:
    #
    #   Psych.load("--- a")             # => 'a'
    #   Psych.load("---\n - a\n - b")   # => ['a', 'b']
    #
    #   begin
    #     Psych.load("--- `", filename: "file.txt")
    #   rescue Psych::SyntaxError => ex
    #     ex.file    # => 'file.txt'
    #     ex.message # => "(file.txt): found character that cannot start any token"
    #   end
    #
    # When the optional +symbolize_names+ keyword argument is set to a
    # true value, returns symbols for keys in Hash objects (default: strings).
    #
    #   Psych.load("---\n foo: bar")                         # => {"foo"=>"bar"}
    #   Psych.load("---\n foo: bar", symbolize_names: true)  # => {:foo=>"bar"}
    #
    # Raises a TypeError when `yaml` parameter is NilClass.  This method is
    # similar to `safe_load` except that `Symbol` objects are allowed by default.
    #
    # source://psych//lib/psych.rb#368
    def load(yaml, permitted_classes: T.unsafe(nil), permitted_symbols: T.unsafe(nil), aliases: T.unsafe(nil), filename: T.unsafe(nil), fallback: T.unsafe(nil), symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end

    # Loads the document contained in +filename+.  Returns the yaml contained in
    # +filename+ as a Ruby object, or if the file is empty, it returns
    # the specified +fallback+ return value, which defaults to +false+.
    # See load for options.
    #
    # source://psych//lib/psych.rb#669
    def load_file(filename, **kwargs); end

    # Load multiple documents given in +yaml+.  Returns the parsed documents
    # as a list.  If a block is given, each document will be converted to Ruby
    # and passed to the block during parsing
    #
    # Example:
    #
    #   Psych.load_stream("--- foo\n...\n--- bar\n...") # => ['foo', 'bar']
    #
    #   list = []
    #   Psych.load_stream("--- foo\n...\n--- bar\n...") do |ruby|
    #     list << ruby
    #   end
    #   list # => ['foo', 'bar']
    #
    # source://psych//lib/psych.rb#626
    def load_stream(yaml, filename: T.unsafe(nil), fallback: T.unsafe(nil), **kwargs); end

    # Parse a YAML string in +yaml+.  Returns the Psych::Nodes::Document.
    # +filename+ is used in the exception message if a Psych::SyntaxError is
    # raised.
    #
    # Raises a Psych::SyntaxError when a YAML syntax error is detected.
    #
    # Example:
    #
    #   Psych.parse("---\n - a\n - b") # => #<Psych::Nodes::Document:0x00>
    #
    #   begin
    #     Psych.parse("--- `", filename: "file.txt")
    #   rescue Psych::SyntaxError => ex
    #     ex.file    # => 'file.txt'
    #     ex.message # => "(file.txt): found character that cannot start any token"
    #   end
    #
    # See Psych::Nodes for more information about YAML AST.
    #
    # source://psych//lib/psych.rb#398
    def parse(yaml, filename: T.unsafe(nil)); end

    # Parse a file at +filename+. Returns the Psych::Nodes::Document.
    #
    # Raises a Psych::SyntaxError when a YAML syntax error is detected.
    #
    # source://psych//lib/psych.rb#410
    def parse_file(filename, fallback: T.unsafe(nil)); end

    # Parse a YAML string in +yaml+.  Returns the Psych::Nodes::Stream.
    # This method can handle multiple YAML documents contained in +yaml+.
    # +filename+ is used in the exception message if a Psych::SyntaxError is
    # raised.
    #
    # If a block is given, a Psych::Nodes::Document node will be yielded to the
    # block as it's being parsed.
    #
    # Raises a Psych::SyntaxError when a YAML syntax error is detected.
    #
    # Example:
    #
    #   Psych.parse_stream("---\n - a\n - b") # => #<Psych::Nodes::Stream:0x00>
    #
    #   Psych.parse_stream("--- a\n--- b") do |node|
    #     node # => #<Psych::Nodes::Document:0x00>
    #   end
    #
    #   begin
    #     Psych.parse_stream("--- `", filename: "file.txt")
    #   rescue Psych::SyntaxError => ex
    #     ex.file    # => 'file.txt'
    #     ex.message # => "(file.txt): found character that cannot start any token"
    #   end
    #
    # Raises a TypeError when NilClass is passed.
    #
    # See Psych::Nodes for more information about YAML AST.
    #
    # source://psych//lib/psych.rb#452
    def parse_stream(yaml, filename: T.unsafe(nil), &block); end

    # Returns a default parser
    #
    # source://psych//lib/psych.rb#419
    def parser; end

    # source://psych//lib/psych.rb#688
    def remove_type(type_tag); end

    # call-seq:
    #   Psych.safe_dump(o)               -> string of yaml
    #   Psych.safe_dump(o, options)      -> string of yaml
    #   Psych.safe_dump(o, io)           -> io object passed in
    #   Psych.safe_dump(o, io, options)  -> io object passed in
    #
    # Safely dump Ruby object +o+ to a YAML string. Optional +options+ may be passed in
    # to control the output format.  If an IO object is passed in, the YAML will
    # be dumped to that IO object. By default, only the following
    # classes are allowed to be serialized:
    #
    # * TrueClass
    # * FalseClass
    # * NilClass
    # * Integer
    # * Float
    # * String
    # * Array
    # * Hash
    #
    # Arbitrary classes can be allowed by adding those classes to the +permitted_classes+
    # keyword argument.  They are additive.  For example, to allow Date serialization:
    #
    #   Psych.safe_dump(yaml, permitted_classes: [Date])
    #
    # Now the Date class can be dumped in addition to the classes listed above.
    #
    # A Psych::DisallowedClass exception will be raised if the object contains a
    # class that isn't in the +permitted_classes+ list.
    #
    # Currently supported options are:
    #
    # [<tt>:indentation</tt>]   Number of space characters used to indent.
    #                           Acceptable value should be in <tt>0..9</tt> range,
    #                           otherwise option is ignored.
    #
    #                           Default: <tt>2</tt>.
    # [<tt>:line_width</tt>]    Max character to wrap line at.
    #
    #                           Default: <tt>0</tt> (meaning "wrap at 81").
    # [<tt>:canonical</tt>]     Write "canonical" YAML form (very verbose, yet
    #                           strictly formal).
    #
    #                           Default: <tt>false</tt>.
    # [<tt>:header</tt>]        Write <tt>%YAML [version]</tt> at the beginning of document.
    #
    #                           Default: <tt>false</tt>.
    #
    # Example:
    #
    #   # Dump an array, get back a YAML string
    #   Psych.safe_dump(['a', 'b'])  # => "---\n- a\n- b\n"
    #
    #   # Dump an array to an IO object
    #   Psych.safe_dump(['a', 'b'], StringIO.new)  # => #<StringIO:0x000001009d0890>
    #
    #   # Dump an array with indentation set
    #   Psych.safe_dump(['a', ['b']], indentation: 3) # => "---\n- a\n-  - b\n"
    #
    #   # Dump an array to an IO with indentation set
    #   Psych.safe_dump(['a', ['b']], StringIO.new, indentation: 3)
    #
    # source://psych//lib/psych.rb#578
    def safe_dump(o, io = T.unsafe(nil), options = T.unsafe(nil)); end

    # Safely load the yaml string in +yaml+.  By default, only the following
    # classes are allowed to be deserialized:
    #
    # * TrueClass
    # * FalseClass
    # * NilClass
    # * Integer
    # * Float
    # * String
    # * Array
    # * Hash
    #
    # Recursive data structures are not allowed by default.  Arbitrary classes
    # can be allowed by adding those classes to the +permitted_classes+ keyword argument.  They are
    # additive.  For example, to allow Date deserialization:
    #
    #   Psych.safe_load(yaml, permitted_classes: [Date])
    #
    # Now the Date class can be loaded in addition to the classes listed above.
    #
    # Aliases can be explicitly allowed by changing the +aliases+ keyword argument.
    # For example:
    #
    #   x = []
    #   x << x
    #   yaml = Psych.dump x
    #   Psych.safe_load yaml               # => raises an exception
    #   Psych.safe_load yaml, aliases: true # => loads the aliases
    #
    # A Psych::DisallowedClass exception will be raised if the yaml contains a
    # class that isn't in the +permitted_classes+ list.
    #
    # A Psych::AliasesNotEnabled exception will be raised if the yaml contains aliases
    # but the +aliases+ keyword argument is set to false.
    #
    # +filename+ will be used in the exception message if any exception is raised
    # while parsing.
    #
    # When the optional +symbolize_names+ keyword argument is set to a
    # true value, returns symbols for keys in Hash objects (default: strings).
    #
    #   Psych.safe_load("---\n foo: bar")                         # => {"foo"=>"bar"}
    #   Psych.safe_load("---\n foo: bar", symbolize_names: true)  # => {:foo=>"bar"}
    #
    # source://psych//lib/psych.rb#322
    def safe_load(yaml, permitted_classes: T.unsafe(nil), permitted_symbols: T.unsafe(nil), aliases: T.unsafe(nil), filename: T.unsafe(nil), fallback: T.unsafe(nil), symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end

    # Safely loads the document contained in +filename+.  Returns the yaml contained in
    # +filename+ as a Ruby object, or if the file is empty, it returns
    # the specified +fallback+ return value, which defaults to +false+.
    # See safe_load for options.
    #
    # source://psych//lib/psych.rb#658
    def safe_load_file(filename, **kwargs); end

    # Dump Ruby +object+ to a JSON string.
    #
    # source://psych//lib/psych.rb#605
    def to_json(object); end

    # Load +yaml+ in to a Ruby data structure.  If multiple documents are
    # provided, the object contained in the first document will be returned.
    # +filename+ will be used in the exception message if any exception
    # is raised while parsing.  If +yaml+ is empty, it returns
    # the specified +fallback+ return value, which defaults to +false+.
    #
    # Raises a Psych::SyntaxError when a YAML syntax error is detected.
    #
    # Example:
    #
    #   Psych.unsafe_load("--- a")             # => 'a'
    #   Psych.unsafe_load("---\n - a\n - b")   # => ['a', 'b']
    #
    #   begin
    #     Psych.unsafe_load("--- `", filename: "file.txt")
    #   rescue Psych::SyntaxError => ex
    #     ex.file    # => 'file.txt'
    #     ex.message # => "(file.txt): found character that cannot start any token"
    #   end
    #
    # When the optional +symbolize_names+ keyword argument is set to a
    # true value, returns symbols for keys in Hash objects (default: strings).
    #
    #   Psych.unsafe_load("---\n foo: bar")                         # => {"foo"=>"bar"}
    #   Psych.unsafe_load("---\n foo: bar", symbolize_names: true)  # => {:foo=>"bar"}
    #
    # Raises a TypeError when `yaml` parameter is NilClass
    #
    # NOTE: This method *should not* be used to parse untrusted documents, such as
    # YAML documents that are supplied via user input.  Instead, please use the
    # load method or the safe_load method.
    #
    # source://psych//lib/psych.rb#271
    def unsafe_load(yaml, filename: T.unsafe(nil), fallback: T.unsafe(nil), symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end

    # Load the document contained in +filename+.  Returns the yaml contained in
    # +filename+ as a Ruby object, or if the file is empty, it returns
    # the specified +fallback+ return value, which defaults to +false+.
    #
    # NOTE: This method *should not* be used to parse untrusted documents, such as
    # YAML documents that are supplied via user input.  Instead, please use the
    # safe_load_file method.
    #
    # source://psych//lib/psych.rb#647
    def unsafe_load_file(filename, **kwargs); end

    private

    # source://psych//lib/psych.rb#703
    def parse_caller(at); end

    # Workaround for emulating `warn '...', uplevel: 1` in Ruby 2.4 or lower.
    #
    # source://psych//lib/psych.rb#698
    def warn_with_uplevel(message, uplevel: T.unsafe(nil)); end
  end
end

# Subclasses `BadAlias` for backwards compatibility
#
# source://psych//lib/psych/exception.rb#10
class Psych::AliasesNotEnabled < ::Psych::BadAlias
  # @return [AliasesNotEnabled] a new instance of AliasesNotEnabled
  #
  # source://psych//lib/psych/exception.rb#11
  def initialize; end
end

# Subclasses `BadAlias` for backwards compatibility
#
# source://psych//lib/psych/exception.rb#17
class Psych::AnchorNotDefined < ::Psych::BadAlias
  # @return [AnchorNotDefined] a new instance of AnchorNotDefined
  #
  # source://psych//lib/psych/exception.rb#18
  def initialize(anchor_name); end
end

# source://psych//lib/psych/class_loader.rb#6
class Psych::ClassLoader
  # @return [ClassLoader] a new instance of ClassLoader
  #
  # source://psych//lib/psych/class_loader.rb#21
  def initialize; end

  # source://psych//lib/psych/class_loader.rb#25
  def load(klassname); end

  # source://psych//lib/psych/class_loader.rb#31
  def symbolize(sym); end

  private

  # source://psych//lib/psych/class_loader.rb#47
  def find(klassname); end

  # source://psych//lib/psych/class_loader.rb#51
  def resolve(klassname); end
end

# source://psych//lib/psych/class_loader.rb#76
class Psych::ClassLoader::Restricted < ::Psych::ClassLoader
  # @return [Restricted] a new instance of Restricted
  #
  # source://psych//lib/psych/class_loader.rb#77
  def initialize(classes, symbols); end

  # source://psych//lib/psych/class_loader.rb#83
  def symbolize(sym); end

  private

  # source://psych//lib/psych/class_loader.rb#95
  def find(klassname); end
end

# If an object defines +encode_with+, then an instance of Psych::Coder will
# be passed to the method when the object is being serialized.  The Coder
# automatically assumes a Psych::Nodes::Mapping is being emitted.  Other
# objects like Sequence and Scalar may be emitted if +seq=+ or +scalar=+ are
# called, respectively.
#
# source://psych//lib/psych/coder.rb#9
class Psych::Coder
  # @return [Coder] a new instance of Coder
  #
  # source://psych//lib/psych/coder.rb#13
  def initialize(tag); end

  # source://psych//lib/psych/coder.rb#84
  def [](k); end

  # source://psych//lib/psych/coder.rb#78
  def []=(k, v); end

  # source://psych//lib/psych/coder.rb#78
  def add(k, v); end

  # Returns the value of attribute implicit.
  #
  # source://psych//lib/psych/coder.rb#10
  def implicit; end

  # Sets the attribute implicit
  #
  # @param value the value to set the attribute implicit to.
  #
  # source://psych//lib/psych/coder.rb#10
  def implicit=(_arg0); end

  # Emit a map.  The coder will be yielded to the block.
  #
  # @yield [_self]
  # @yieldparam _self [Psych::Coder] the object that the method was called on
  #
  # source://psych//lib/psych/coder.rb#34
  def map(tag = T.unsafe(nil), style = T.unsafe(nil)); end

  # Emit a map with +value+
  #
  # source://psych//lib/psych/coder.rb#73
  def map=(map); end

  # Returns the value of attribute object.
  #
  # source://psych//lib/psych/coder.rb#10
  def object; end

  # Sets the attribute object
  #
  # @param value the value to set the attribute object to.
  #
  # source://psych//lib/psych/coder.rb#10
  def object=(_arg0); end

  # Emit a sequence with +map+ and +tag+
  #
  # source://psych//lib/psych/coder.rb#54
  def represent_map(tag, map); end

  # Emit an arbitrary object +obj+ and +tag+
  #
  # source://psych//lib/psych/coder.rb#60
  def represent_object(tag, obj); end

  # Emit a scalar with +value+ and +tag+
  #
  # source://psych//lib/psych/coder.rb#42
  def represent_scalar(tag, value); end

  # Emit a sequence with +list+ and +tag+
  #
  # source://psych//lib/psych/coder.rb#48
  def represent_seq(tag, list); end

  # source://psych//lib/psych/coder.rb#24
  def scalar(*args); end

  # Emit a scalar with +value+
  #
  # source://psych//lib/psych/coder.rb#67
  def scalar=(value); end

  # Returns the value of attribute seq.
  #
  # source://psych//lib/psych/coder.rb#11
  def seq; end

  # Emit a sequence of +list+
  #
  # source://psych//lib/psych/coder.rb#90
  def seq=(list); end

  # Returns the value of attribute style.
  #
  # source://psych//lib/psych/coder.rb#10
  def style; end

  # Sets the attribute style
  #
  # @param value the value to set the attribute style to.
  #
  # source://psych//lib/psych/coder.rb#10
  def style=(_arg0); end

  # Returns the value of attribute tag.
  #
  # source://psych//lib/psych/coder.rb#10
  def tag; end

  # Sets the attribute tag
  #
  # @param value the value to set the attribute tag to.
  #
  # source://psych//lib/psych/coder.rb#10
  def tag=(_arg0); end

  # Returns the value of attribute type.
  #
  # source://psych//lib/psych/coder.rb#11
  def type; end
end

# source://psych//lib/psych/exception.rb#23
class Psych::DisallowedClass < ::Psych::Exception
  # @return [DisallowedClass] a new instance of DisallowedClass
  #
  # source://psych//lib/psych/exception.rb#24
  def initialize(action, klass_name); end
end

# Psych::Handler is an abstract base class that defines the events used
# when dealing with Psych::Parser.  Clients who want to use Psych::Parser
# should implement a class that inherits from Psych::Handler and define
# events that they can handle.
#
# Psych::Handler defines all events that Psych::Parser can possibly send to
# event handlers.
#
# See Psych::Parser for more details
#
# source://psych//lib/psych/handler.rb#13
class Psych::Handler
  # Called when an alias is found to +anchor+.  +anchor+ will be the name
  # of the anchor found.
  #
  # === Example
  #
  # Here we have an example of an array that references itself in YAML:
  #
  #   --- &ponies
  #   - first element
  #   - *ponies
  #
  # &ponies is the anchor, *ponies is the alias.  In this case, alias is
  # called with "ponies".
  #
  # source://psych//lib/psych/handler.rb#110
  def alias(anchor); end

  # Called when an empty event happens. (Which, as far as I can tell, is
  # never).
  #
  # source://psych//lib/psych/handler.rb#236
  def empty; end

  # Called with the document ends.  +implicit+ is a boolean value indicating
  # whether or not the document has an implicit ending.
  #
  # === Example
  #
  # Given the following YAML:
  #
  #   ---
  #     hello world
  #
  # +implicit+ will be true.  Given this YAML:
  #
  #   ---
  #     hello world
  #   ...
  #
  # +implicit+ will be false.
  #
  # source://psych//lib/psych/handler.rb#93
  def end_document(implicit); end

  # Called when a map ends
  #
  # source://psych//lib/psych/handler.rb#230
  def end_mapping; end

  # Called when a sequence ends.
  #
  # source://psych//lib/psych/handler.rb#191
  def end_sequence; end

  # Called when the YAML stream ends
  #
  # source://psych//lib/psych/handler.rb#241
  def end_stream; end

  # Called before each event with line/column information.
  #
  # source://psych//lib/psych/handler.rb#246
  def event_location(start_line, start_column, end_line, end_column); end

  # Called when a scalar +value+ is found.  The scalar may have an
  # +anchor+, a +tag+, be implicitly +plain+ or implicitly +quoted+
  #
  # +value+ is the string value of the scalar
  # +anchor+ is an associated anchor or nil
  # +tag+ is an associated tag or nil
  # +plain+ is a boolean value
  # +quoted+ is a boolean value
  # +style+ is an integer indicating the string style
  #
  # See the constants in Psych::Nodes::Scalar for the possible values of
  # +style+
  #
  # === Example
  #
  # Here is a YAML document that exercises most of the possible ways this
  # method can be called:
  #
  #   ---
  #   - !str "foo"
  #   - &anchor fun
  #   - many
  #     lines
  #   - |
  #     many
  #     newlines
  #
  # The above YAML document contains a list with four strings.  Here are
  # the parameters sent to this method in the same order:
  #
  #   # value               anchor    tag     plain   quoted  style
  #   ["foo",               nil,      "!str", false,  false,  3    ]
  #   ["fun",               "anchor", nil,    true,   false,  1    ]
  #   ["many lines",        nil,      nil,    true,   false,  1    ]
  #   ["many\nnewlines\n",  nil,      nil,    false,  true,   4    ]
  #
  # source://psych//lib/psych/handler.rb#150
  def scalar(value, anchor, tag, plain, quoted, style); end

  # Called when the document starts with the declared +version+,
  # +tag_directives+, if the document is +implicit+.
  #
  # +version+ will be an array of integers indicating the YAML version being
  # dealt with, +tag_directives+ is a list of tuples indicating the prefix
  # and suffix of each tag, and +implicit+ is a boolean indicating whether
  # the document is started implicitly.
  #
  # === Example
  #
  # Given the following YAML:
  #
  #   %YAML 1.1
  #   %TAG ! tag:tenderlovemaking.com,2009:
  #   --- !squee
  #
  # The parameters for start_document must be this:
  #
  #   version         # => [1, 1]
  #   tag_directives  # => [["!", "tag:tenderlovemaking.com,2009:"]]
  #   implicit        # => false
  #
  # source://psych//lib/psych/handler.rb#72
  def start_document(version, tag_directives, implicit); end

  # Called when a map starts.
  #
  # +anchor+ is the anchor associated with the map or +nil+.
  # +tag+ is the tag associated with the map or +nil+.
  # +implicit+ is a boolean indicating whether or not the map was implicitly
  # started.
  # +style+ is an integer indicating the mapping style.
  #
  # See the constants in Psych::Nodes::Mapping for the possible values of
  # +style+.
  #
  # === Example
  #
  # Here is a YAML document that exercises most of the possible ways this
  # method can be called:
  #
  #   ---
  #   k: !!map { hello: world }
  #   v: &pewpew
  #     hello: world
  #
  # The above YAML document consists of three maps, an outer map that contains
  # two inner maps.  Below is a matrix of the parameters sent in order to
  # represent these three maps:
  #
  #   # anchor    tag                       implicit  style
  #   [nil,       nil,                      true,     1     ]
  #   [nil,       "tag:yaml.org,2002:map",  false,    2     ]
  #   ["pewpew",  nil,                      true,     1     ]
  #
  # source://psych//lib/psych/handler.rb#225
  def start_mapping(anchor, tag, implicit, style); end

  # Called when a sequence is started.
  #
  # +anchor+ is the anchor associated with the sequence or nil.
  # +tag+ is the tag associated with the sequence or nil.
  # +implicit+ a boolean indicating whether or not the sequence was implicitly
  # started.
  # +style+ is an integer indicating the list style.
  #
  # See the constants in Psych::Nodes::Sequence for the possible values of
  # +style+.
  #
  # === Example
  #
  # Here is a YAML document that exercises most of the possible ways this
  # method can be called:
  #
  #   ---
  #   - !!seq [
  #     a
  #   ]
  #   - &pewpew
  #     - b
  #
  # The above YAML document consists of three lists, an outer list that
  # contains two inner lists.  Here is a matrix of the parameters sent
  # to represent these lists:
  #
  #   # anchor    tag                       implicit  style
  #   [nil,       nil,                      true,     1     ]
  #   [nil,       "tag:yaml.org,2002:seq",  false,    2     ]
  #   ["pewpew",  nil,                      true,     1     ]
  #
  # source://psych//lib/psych/handler.rb#186
  def start_sequence(anchor, tag, implicit, style); end

  # Called with +encoding+ when the YAML stream starts.  This method is
  # called once per stream.  A stream may contain multiple documents.
  #
  # See the constants in Psych::Parser for the possible values of +encoding+.
  #
  # source://psych//lib/psych/handler.rb#47
  def start_stream(encoding); end

  # Is this handler a streaming handler?
  #
  # @return [Boolean]
  #
  # source://psych//lib/psych/handler.rb#251
  def streaming?; end
end

# Configuration options for dumping YAML.
#
# source://psych//lib/psych/handler.rb#16
class Psych::Handler::DumperOptions
  # @return [DumperOptions] a new instance of DumperOptions
  #
  # source://psych//lib/psych/handler.rb#19
  def initialize; end

  # Returns the value of attribute canonical.
  #
  # source://psych//lib/psych/handler.rb#17
  def canonical; end

  # Sets the attribute canonical
  #
  # @param value the value to set the attribute canonical to.
  #
  # source://psych//lib/psych/handler.rb#17
  def canonical=(_arg0); end

  # Returns the value of attribute indentation.
  #
  # source://psych//lib/psych/handler.rb#17
  def indentation; end

  # Sets the attribute indentation
  #
  # @param value the value to set the attribute indentation to.
  #
  # source://psych//lib/psych/handler.rb#17
  def indentation=(_arg0); end

  # Returns the value of attribute line_width.
  #
  # source://psych//lib/psych/handler.rb#17
  def line_width; end

  # Sets the attribute line_width
  #
  # @param value the value to set the attribute line_width to.
  #
  # source://psych//lib/psych/handler.rb#17
  def line_width=(_arg0); end
end

# source://psych//lib/psych/json/stream.rb#7
class Psych::JSON::Stream < ::Psych::Visitors::JSONTree
  include ::Psych::Streaming
  extend ::Psych::Streaming::ClassMethods
end

# The base class for any Node in a YAML parse tree.  This class should
# never be instantiated.
#
# source://psych//lib/psych/nodes/node.rb#11
class Psych::Nodes::Node
  include ::Enumerable

  # Create a new Psych::Nodes::Node
  #
  # @return [Node] a new instance of Node
  #
  # source://psych//lib/psych/nodes/node.rb#33
  def initialize; end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#67
  def alias?; end

  # The children of this node
  #
  # source://psych//lib/psych/nodes/node.rb#15
  def children; end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#68
  def document?; end

  # Iterate over each node in the tree. Yields each node to +block+ depth
  # first.
  #
  # source://psych//lib/psych/nodes/node.rb#40
  def each(&block); end

  # The column number where this node ends
  #
  # source://psych//lib/psych/nodes/node.rb#30
  def end_column; end

  # The column number where this node ends
  #
  # source://psych//lib/psych/nodes/node.rb#30
  def end_column=(_arg0); end

  # The line number where this node ends
  #
  # source://psych//lib/psych/nodes/node.rb#27
  def end_line; end

  # The line number where this node ends
  #
  # source://psych//lib/psych/nodes/node.rb#27
  def end_line=(_arg0); end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#69
  def mapping?; end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#70
  def scalar?; end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#71
  def sequence?; end

  # The column number where this node start
  #
  # source://psych//lib/psych/nodes/node.rb#24
  def start_column; end

  # The column number where this node start
  #
  # source://psych//lib/psych/nodes/node.rb#24
  def start_column=(_arg0); end

  # The line number where this node start
  #
  # source://psych//lib/psych/nodes/node.rb#21
  def start_line; end

  # The line number where this node start
  #
  # source://psych//lib/psych/nodes/node.rb#21
  def start_line=(_arg0); end

  # @return [Boolean]
  #
  # source://psych//lib/psych/nodes/node.rb#72
  def stream?; end

  # An associated tag
  #
  # source://psych//lib/psych/nodes/node.rb#18
  def tag; end

  # Convert this node to Ruby.
  #
  # See also Psych::Visitors::ToRuby
  #
  # source://psych//lib/psych/nodes/node.rb#49
  def to_ruby(symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end

  # Convert this node to YAML.
  #
  # See also Psych::Visitors::Emitter
  #
  # source://psych//lib/psych/nodes/node.rb#58
  def to_yaml(io = T.unsafe(nil), options = T.unsafe(nil)); end

  # Convert this node to Ruby.
  #
  # See also Psych::Visitors::ToRuby
  #
  # source://psych//lib/psych/nodes/node.rb#49
  def transform(symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end

  # Convert this node to YAML.
  #
  # See also Psych::Visitors::Emitter
  #
  # source://psych//lib/psych/nodes/node.rb#58
  def yaml(io = T.unsafe(nil), options = T.unsafe(nil)); end
end

# YAML event parser class.  This class parses a YAML document and calls
# events on the handler that is passed to the constructor.  The events can
# be used for things such as constructing a YAML AST or deserializing YAML
# documents.  It can even be fed back to Psych::Emitter to emit the same
# document that was parsed.
#
# See Psych::Handler for documentation on the events that Psych::Parser emits.
#
# Here is an example that prints out ever scalar found in a YAML document:
#
#   # Handler for detecting scalar values
#   class ScalarHandler < Psych::Handler
#     def scalar value, anchor, tag, plain, quoted, style
#       puts value
#     end
#   end
#
#   parser = Psych::Parser.new(ScalarHandler.new)
#   parser.parse(yaml_document)
#
# Here is an example that feeds the parser back in to Psych::Emitter.  The
# YAML document is read from STDIN and written back out to STDERR:
#
#   parser = Psych::Parser.new(Psych::Emitter.new($stderr))
#   parser.parse($stdin)
#
# Psych uses Psych::Parser in combination with Psych::TreeBuilder to
# construct an AST of the parsed YAML document.
#
# source://psych//lib/psych/parser.rb#33
class Psych::Parser
  # Creates a new Psych::Parser instance with +handler+.  YAML events will
  # be called on +handler+.  See Psych::Parser for more details.
  #
  # @return [Parser] a new instance of Parser
  #
  # source://psych//lib/psych/parser.rb#47
  def initialize(handler = T.unsafe(nil)); end

  # Set the encoding for this parser to +encoding+
  #
  # source://psych//lib/psych/parser.rb#41
  def external_encoding=(_arg0); end

  # The handler on which events will be called
  #
  # source://psych//lib/psych/parser.rb#38
  def handler; end

  # The handler on which events will be called
  #
  # source://psych//lib/psych/parser.rb#38
  def handler=(_arg0); end

  # call-seq:
  #    parser.parse(yaml)
  #
  # Parse the YAML document contained in +yaml+.  Events will be called on
  # the handler set on the parser instance.
  #
  # See Psych::Parser and Psych::Parser#handler
  #
  # source://psych//lib/psych/parser.rb#61
  def parse(yaml, path = T.unsafe(nil)); end
end

# Scan scalars for built in types
#
# source://psych//lib/psych/scalar_scanner.rb#6
class Psych::ScalarScanner
  # Create a new scanner
  #
  # @return [ScalarScanner] a new instance of ScalarScanner
  #
  # source://psych//lib/psych/scalar_scanner.rb#30
  def initialize(class_loader, strict_integer: T.unsafe(nil)); end

  # Returns the value of attribute class_loader.
  #
  # source://psych//lib/psych/scalar_scanner.rb#27
  def class_loader; end

  # Parse and return an int from +string+
  #
  # source://psych//lib/psych/scalar_scanner.rb#109
  def parse_int(string); end

  # Parse and return a Time from +string+
  #
  # source://psych//lib/psych/scalar_scanner.rb#115
  def parse_time(string); end

  # Tokenize +string+ returning the Ruby object
  #
  # source://psych//lib/psych/scalar_scanner.rb#37
  def tokenize(string); end
end

# Same as above, but allows commas.
# Not to YML spec, but kept for backwards compatibility
#
# source://psych//lib/psych/scalar_scanner.rb#22
Psych::ScalarScanner::INTEGER_LEGACY = T.let(T.unsafe(nil), Regexp)

# Taken from http://yaml.org/type/int.html
#
# source://psych//lib/psych/scalar_scanner.rb#15
Psych::ScalarScanner::INTEGER_STRICT = T.let(T.unsafe(nil), Regexp)

# Psych::Stream is a streaming YAML emitter.  It will not buffer your YAML,
# but send it straight to an IO.
#
# Here is an example use:
#
#   stream = Psych::Stream.new($stdout)
#   stream.start
#   stream.push({:foo => 'bar'})
#   stream.finish
#
# YAML will be immediately emitted to $stdout with no buffering.
#
# Psych::Stream#start will take a block and ensure that Psych::Stream#finish
# is called, so you can do this form:
#
#   stream = Psych::Stream.new($stdout)
#   stream.start do |em|
#     em.push(:foo => 'bar')
#   end
#
# source://psych//lib/psych/stream.rb#24
class Psych::Stream < ::Psych::Visitors::YAMLTree
  include ::Psych::Streaming
  extend ::Psych::Streaming::ClassMethods
end

# source://psych//lib/psych/stream.rb#25
class Psych::Stream::Emitter < ::Psych::Emitter
  # source://psych//lib/psych/stream.rb#26
  def end_document(implicit_end = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://psych//lib/psych/stream.rb#30
  def streaming?; end
end

# source://psych//lib/psych/streaming.rb#3
module Psych::Streaming
  # Start streaming using +encoding+
  #
  # source://psych//lib/psych/streaming.rb#18
  def start(encoding = T.unsafe(nil)); end

  private

  # source://psych//lib/psych/streaming.rb#25
  def register(target, obj); end
end

# source://psych//lib/psych/streaming.rb#4
module Psych::Streaming::ClassMethods
  # Create a new streaming emitter.  Emitter will print to +io+.  See
  # Psych::Stream for an example.
  #
  # source://psych//lib/psych/streaming.rb#8
  def new(io); end
end

# source://psych//lib/psych/syntax_error.rb#5
class Psych::SyntaxError < ::Psych::Exception
  # @return [SyntaxError] a new instance of SyntaxError
  #
  # source://psych//lib/psych/syntax_error.rb#8
  def initialize(file, line, col, offset, problem, context); end

  # Returns the value of attribute column.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def column; end

  # Returns the value of attribute context.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def context; end

  # Returns the value of attribute file.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def file; end

  # Returns the value of attribute line.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def line; end

  # Returns the value of attribute offset.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def offset; end

  # Returns the value of attribute problem.
  #
  # source://psych//lib/psych/syntax_error.rb#6
  def problem; end
end

# This class works in conjunction with Psych::Parser to build an in-memory
# parse tree that represents a YAML document.
#
# == Example
#
#   parser = Psych::Parser.new Psych::TreeBuilder.new
#   parser.parse('--- foo')
#   tree = parser.handler.root
#
# See Psych::Handler for documentation on the event methods used in this
# class.
#
# source://psych//lib/psych/tree_builder.rb#18
class Psych::TreeBuilder < ::Psych::Handler
  # Create a new TreeBuilder instance
  #
  # @return [TreeBuilder] a new instance of TreeBuilder
  #
  # source://psych//lib/psych/tree_builder.rb#22
  def initialize; end

  # source://psych//lib/psych/tree_builder.rb#103
  def alias(anchor); end

  # Handles end_document events with +version+, +tag_directives+,
  # and +implicit+ styling.
  #
  # See Psych::Handler#start_document
  #
  # source://psych//lib/psych/tree_builder.rb#77
  def end_document(implicit_end = T.unsafe(nil)); end

  # source://psych//lib/psych/tree_builder.rb#90
  def end_stream; end

  # source://psych//lib/psych/tree_builder.rb#33
  def event_location(start_line, start_column, end_line, end_column); end

  # Returns the root node for the built tree
  #
  # source://psych//lib/psych/tree_builder.rb#19
  def root; end

  # source://psych//lib/psych/tree_builder.rb#96
  def scalar(value, anchor, tag, plain, quoted, style); end

  # Handles start_document events with +version+, +tag_directives+,
  # and +implicit+ styling.
  #
  # See Psych::Handler#start_document
  #
  # source://psych//lib/psych/tree_builder.rb#65
  def start_document(version, tag_directives, implicit); end

  # source://psych//lib/psych/tree_builder.rb#84
  def start_stream(encoding); end

  private

  # source://psych//lib/psych/tree_builder.rb#116
  def pop; end

  # source://psych//lib/psych/tree_builder.rb#111
  def push(value); end

  # source://psych//lib/psych/tree_builder.rb#132
  def set_end_location(node); end

  # source://psych//lib/psych/tree_builder.rb#122
  def set_location(node); end

  # source://psych//lib/psych/tree_builder.rb#127
  def set_start_location(node); end
end

# The version of Psych you are using
#
# source://psych//lib/psych/versions.rb#5
Psych::VERSION = T.let(T.unsafe(nil), String)

# source://psych//lib/psych/visitors/depth_first.rb#4
class Psych::Visitors::DepthFirst < ::Psych::Visitors::Visitor
  # @return [DepthFirst] a new instance of DepthFirst
  #
  # source://psych//lib/psych/visitors/depth_first.rb#5
  def initialize(block); end

  private

  # source://psych//lib/psych/visitors/depth_first.rb#11
  def nary(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#20
  def terminal(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#20
  def visit_Psych_Nodes_Alias(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#11
  def visit_Psych_Nodes_Document(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#11
  def visit_Psych_Nodes_Mapping(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#20
  def visit_Psych_Nodes_Scalar(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#11
  def visit_Psych_Nodes_Sequence(o); end

  # source://psych//lib/psych/visitors/depth_first.rb#11
  def visit_Psych_Nodes_Stream(o); end
end

# source://psych//lib/psych/visitors/yaml_tree.rb#541
class Psych::Visitors::RestrictedYAMLTree < ::Psych::Visitors::YAMLTree
  # @return [RestrictedYAMLTree] a new instance of RestrictedYAMLTree
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#553
  def initialize(emitter, ss, options); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#566
  def accept(target); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#578
  def visit_Symbol(sym); end
end

# source://psych//lib/psych/visitors/yaml_tree.rb#542
Psych::Visitors::RestrictedYAMLTree::DEFAULT_PERMITTED_CLASSES = T.let(T.unsafe(nil), Hash)

# This class walks a YAML AST, converting each node to Ruby
#
# source://psych//lib/psych/visitors/to_ruby.rb#14
class Psych::Visitors::ToRuby < ::Psych::Visitors::Visitor
  # @return [ToRuby] a new instance of ToRuby
  #
  # source://psych//lib/psych/visitors/to_ruby.rb#23
  def initialize(ss, class_loader, symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil)); end

  # source://psych//lib/psych/visitors/to_ruby.rb#34
  def accept(target); end

  # Returns the value of attribute class_loader.
  #
  # source://psych//lib/psych/visitors/to_ruby.rb#21
  def class_loader; end

  # source://psych//lib/psych/visitors/to_ruby.rb#327
  def visit_Psych_Nodes_Alias(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#319
  def visit_Psych_Nodes_Document(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#165
  def visit_Psych_Nodes_Mapping(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#129
  def visit_Psych_Nodes_Scalar(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#133
  def visit_Psych_Nodes_Sequence(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#323
  def visit_Psych_Nodes_Stream(o); end

  private

  # source://psych//lib/psych/visitors/to_ruby.rb#395
  def deduplicate(key); end

  # source://psych//lib/psych/visitors/to_ruby.rb#51
  def deserialize(o); end

  # source://psych//lib/psych/visitors/to_ruby.rb#412
  def init_with(o, h, node); end

  # source://psych//lib/psych/visitors/to_ruby.rb#404
  def merge_key(hash, key, val); end

  # source://psych//lib/psych/visitors/to_ruby.rb#333
  def register(node, object); end

  # source://psych//lib/psych/visitors/to_ruby.rb#338
  def register_empty(object); end

  # Convert +klassname+ to a Class
  #
  # source://psych//lib/psych/visitors/to_ruby.rb#425
  def resolve_class(klassname); end

  # source://psych//lib/psych/visitors/to_ruby.rb#407
  def revive(klass, node); end

  # source://psych//lib/psych/visitors/to_ruby.rb#344
  def revive_hash(hash, o, tagged = T.unsafe(nil)); end

  class << self
    # source://psych//lib/psych/visitors/to_ruby.rb#15
    def create(symbolize_names: T.unsafe(nil), freeze: T.unsafe(nil), strict_integer: T.unsafe(nil)); end
  end
end

# source://psych//lib/psych/visitors/visitor.rb#4
class Psych::Visitors::Visitor
  # source://psych//lib/psych/visitors/visitor.rb#5
  def accept(target); end

  private

  # source://psych//lib/psych/visitors/visitor.rb#19
  def dispatch; end

  # source://psych//lib/psych/visitors/visitor.rb#29
  def visit(target); end

  class << self
    # @api private
    #
    # source://psych//lib/psych/visitors/visitor.rb#12
    def dispatch_cache; end
  end
end

# YAMLTree builds a YAML ast given a Ruby object.  For example:
#
#   builder = Psych::Visitors::YAMLTree.new
#   builder << { :foo => 'bar' }
#   builder.tree # => #<Psych::Nodes::Stream .. }
#
# source://psych//lib/psych/visitors/yaml_tree.rb#15
class Psych::Visitors::YAMLTree < ::Psych::Visitors::Visitor
  # @return [YAMLTree] a new instance of YAMLTree
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#56
  def initialize(emitter, ss, options); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#103
  def <<(object); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#123
  def accept(target); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#92
  def finish; end

  # Returns the value of attribute finished.
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#45
  def finished; end

  # Returns the value of attribute finished.
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#45
  def finished?; end

  # source://psych//lib/psych/visitors/yaml_tree.rb#103
  def push(object); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#86
  def start(encoding = T.unsafe(nil)); end

  # Returns the value of attribute started.
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#45
  def started; end

  # Returns the value of attribute started.
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#45
  def started?; end

  # source://psych//lib/psych/visitors/yaml_tree.rb#98
  def tree; end

  # source://psych//lib/psych/visitors/yaml_tree.rb#351
  def visit_Array(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#377
  def visit_BasicObject(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#251
  def visit_BigDecimal(o); end

  # @raise [TypeError]
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#314
  def visit_Class(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#224
  def visit_Complex(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#195
  def visit_Date(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#199
  def visit_DateTime(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#153
  def visit_Delegator(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#148
  def visit_Encoding(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#359
  def visit_Enumerator(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#183
  def visit_Exception(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#234
  def visit_FalseClass(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#240
  def visit_Float(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#327
  def visit_Hash(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#234
  def visit_Integer(o); end

  # @raise [TypeError]
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#309
  def visit_Module(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#187
  def visit_NameError(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#365
  def visit_NilClass(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#153
  def visit_Object(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#140
  def visit_Psych_Omap(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#340
  def visit_Psych_Set(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#319
  def visit_Range(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#211
  def visit_Rational(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#191
  def visit_Regexp(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#255
  def visit_String(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#169
  def visit_Struct(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#369
  def visit_Symbol(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#206
  def visit_Time(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#234
  def visit_TrueClass(o); end

  private

  # @return [Boolean]
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#391
  def binary?(string); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#498
  def dump_coder(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#467
  def dump_exception(o, msg); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#533
  def dump_ivars(target); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#464
  def dump_list(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#511
  def emit_coder(c, o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#485
  def format_time(time, utc = T.unsafe(nil)); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#493
  def register(target, yaml_obj); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#395
  def visit_array_subclass(o); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#426
  def visit_hash_subclass(o); end

  class << self
    # source://psych//lib/psych/visitors/yaml_tree.rb#49
    def create(options = T.unsafe(nil), emitter = T.unsafe(nil)); end
  end
end

# source://psych//lib/psych/visitors/yaml_tree.rb#16
class Psych::Visitors::YAMLTree::Registrar
  # @return [Registrar] a new instance of Registrar
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#17
  def initialize; end

  # source://psych//lib/psych/visitors/yaml_tree.rb#36
  def id_for(target); end

  # @return [Boolean]
  #
  # source://psych//lib/psych/visitors/yaml_tree.rb#30
  def key?(target); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#40
  def node_for(target); end

  # source://psych//lib/psych/visitors/yaml_tree.rb#24
  def register(target, node); end
end
