/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// BatchCheckRequest struct for BatchCheckRequest
type BatchCheckRequest struct {
	Checks               []BatchCheckItem       `json:"checks" yaml:"checks"`
	AuthorizationModelId *string                `json:"authorization_model_id,omitempty" yaml:"authorization_model_id,omitempty"`
	Consistency          *ConsistencyPreference `json:"consistency,omitempty" yaml:"consistency,omitempty"`
}

// NewBatchCheckRequest instantiates a new BatchCheckRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBatchCheckRequest(checks []BatchCheckItem) *BatchCheckRequest {
	this := BatchCheckRequest{}
	this.Checks = checks
	var consistency = CONSISTENCYPREFERENCE_UNSPECIFIED
	this.Consistency = &consistency
	return &this
}

// NewBatchCheckRequestWithDefaults instantiates a new BatchCheckRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBatchCheckRequestWithDefaults() *BatchCheckRequest {
	this := BatchCheckRequest{}
	var consistency = CONSISTENCYPREFERENCE_UNSPECIFIED
	this.Consistency = &consistency
	return &this
}

// GetChecks returns the Checks field value
func (o *BatchCheckRequest) GetChecks() []BatchCheckItem {
	if o == nil {
		var ret []BatchCheckItem
		return ret
	}

	return o.Checks
}

// GetChecksOk returns a tuple with the Checks field value
// and a boolean to check if the value has been set.
func (o *BatchCheckRequest) GetChecksOk() (*[]BatchCheckItem, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Checks, true
}

// SetChecks sets field value
func (o *BatchCheckRequest) SetChecks(v []BatchCheckItem) {
	o.Checks = v
}

// GetAuthorizationModelId returns the AuthorizationModelId field value if set, zero value otherwise.
func (o *BatchCheckRequest) GetAuthorizationModelId() string {
	if o == nil || o.AuthorizationModelId == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationModelId
}

// GetAuthorizationModelIdOk returns a tuple with the AuthorizationModelId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BatchCheckRequest) GetAuthorizationModelIdOk() (*string, bool) {
	if o == nil || o.AuthorizationModelId == nil {
		return nil, false
	}
	return o.AuthorizationModelId, true
}

// HasAuthorizationModelId returns a boolean if a field has been set.
func (o *BatchCheckRequest) HasAuthorizationModelId() bool {
	if o != nil && o.AuthorizationModelId != nil {
		return true
	}

	return false
}

// SetAuthorizationModelId gets a reference to the given string and assigns it to the AuthorizationModelId field.
func (o *BatchCheckRequest) SetAuthorizationModelId(v string) {
	o.AuthorizationModelId = &v
}

// GetConsistency returns the Consistency field value if set, zero value otherwise.
func (o *BatchCheckRequest) GetConsistency() ConsistencyPreference {
	if o == nil || o.Consistency == nil {
		var ret ConsistencyPreference
		return ret
	}
	return *o.Consistency
}

// GetConsistencyOk returns a tuple with the Consistency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BatchCheckRequest) GetConsistencyOk() (*ConsistencyPreference, bool) {
	if o == nil || o.Consistency == nil {
		return nil, false
	}
	return o.Consistency, true
}

// HasConsistency returns a boolean if a field has been set.
func (o *BatchCheckRequest) HasConsistency() bool {
	if o != nil && o.Consistency != nil {
		return true
	}

	return false
}

// SetConsistency gets a reference to the given ConsistencyPreference and assigns it to the Consistency field.
func (o *BatchCheckRequest) SetConsistency(v ConsistencyPreference) {
	o.Consistency = &v
}

func (o BatchCheckRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["checks"] = o.Checks
	if o.AuthorizationModelId != nil {
		toSerialize["authorization_model_id"] = o.AuthorizationModelId
	}
	if o.Consistency != nil {
		toSerialize["consistency"] = o.Consistency
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableBatchCheckRequest struct {
	value *BatchCheckRequest
	isSet bool
}

func (v NullableBatchCheckRequest) Get() *BatchCheckRequest {
	return v.value
}

func (v *NullableBatchCheckRequest) Set(val *BatchCheckRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableBatchCheckRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableBatchCheckRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBatchCheckRequest(val *BatchCheckRequest) *NullableBatchCheckRequest {
	return &NullableBatchCheckRequest{value: val, isSet: true}
}

func (v NullableBatchCheckRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBatchCheckRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
