// Code generated by github.com/go-enry/go-enry/v2/internal/code-generator DO NOT EDIT.
// Extracted from github/linguist commit: 9b50e9e46bc0fb2451f5deee612a36c386aae6cf

package data

import "strings"

// LanguageByAliasMap keeps alias for different languages and use the name of the languages as an alias too.
// All the keys (alias or not) are written in lower case and the whitespaces has been replaced by underscores.
var LanguageByAliasMap = map[string]string{
	"1c_enterprise":                      "1C Enterprise",
	"2-dimensional_array":                "2-Dimensional Array",
	"4d":                                 "4D",
	"abap":                               "ABAP",
	"abap_cds":                           "ABAP CDS",
	"abl":                                "OpenEdge ABL",
	"abnf":                               "ABNF",
	"abuild":                             "Alpine Abuild",
	"acfm":                               "Adobe Font Metrics",
	"ackrc":                              "Option List",
	"aconf":                              "ApacheConf",
	"actionscript":                       "ActionScript",
	"actionscript3":                      "ActionScript",
	"actionscript_3":                     "ActionScript",
	"ad_block":                           "Adblock Filter List",
	"ad_block_filters":                   "Adblock Filter List",
	"ada":                                "Ada",
	"ada2005":                            "Ada",
	"ada95":                              "Ada",
	"adb":                                "Adblock Filter List",
	"adblock":                            "Adblock Filter List",
	"adblock_filter_list":                "Adblock Filter List",
	"adobe_composite_font_metrics":       "Adobe Font Metrics",
	"adobe_font_metrics":                 "Adobe Font Metrics",
	"adobe_multiple_font_metrics":        "Adobe Font Metrics",
	"advpl":                              "xBase",
	"afdko":                              "OpenType Feature File",
	"agda":                               "Agda",
	"ags":                                "AGS Script",
	"ags_script":                         "AGS Script",
	"ahk":                                "AutoHotkey",
	"aidl":                               "AIDL",
	"al":                                 "AL",
	"alloy":                              "Alloy",
	"alpine_abuild":                      "Alpine Abuild",
	"altium":                             "Altium Designer",
	"altium_designer":                    "Altium Designer",
	"amfm":                               "Adobe Font Metrics",
	"ampl":                               "AMPL",
	"amusewiki":                          "Muse",
	"angelscript":                        "AngelScript",
	"ant_build_system":                   "Ant Build System",
	"antlers":                            "Antlers",
	"antlr":                              "ANTLR",
	"apache":                             "ApacheConf",
	"apacheconf":                         "ApacheConf",
	"apex":                               "Apex",
	"api_blueprint":                      "API Blueprint",
	"apkbuild":                           "Alpine Abuild",
	"apl":                                "APL",
	"apollo_guidance_computer":           "Apollo Guidance Computer",
	"applescript":                        "AppleScript",
	"arc":                                "Arc",
	"arexx":                              "REXX",
	"as3":                                "ActionScript",
	"ascii_stl":                          "STL",
	"asciidoc":                           "AsciiDoc",
	"asl":                                "ASL",
	"asm":                                "Assembly",
	"asn.1":                              "ASN.1",
	"asp":                                "Classic ASP",
	"asp.net":                            "ASP.NET",
	"aspectj":                            "AspectJ",
	"aspx":                               "ASP.NET",
	"aspx-vb":                            "ASP.NET",
	"assembly":                           "Assembly",
	"astro":                              "Astro",
	"asymptote":                          "Asymptote",
	"ats":                                "ATS",
	"ats2":                               "ATS",
	"au3":                                "AutoIt",
	"augeas":                             "Augeas",
	"autoconf":                           "M4Sugar",
	"autohotkey":                         "AutoHotkey",
	"autoit":                             "AutoIt",
	"autoit3":                            "AutoIt",
	"autoitscript":                       "AutoIt",
	"avro_idl":                           "Avro IDL",
	"awk":                                "Awk",
	"b3d":                                "BlitzBasic",
	"b4x":                                "B4X",
	"ballerina":                          "Ballerina",
	"bash":                               "Shell",
	"bash_session":                       "ShellSession",
	"basic":                              "BASIC",
	"basic_for_android":                  "B4X",
	"bat":                                "Batchfile",
	"batch":                              "Batchfile",
	"batchfile":                          "Batchfile",
	"bazel":                              "Starlark",
	"be":                                 "Berry",
	"beef":                               "Beef",
	"befunge":                            "Befunge",
	"berry":                              "Berry",
	"bh":                                 "Bluespec BH",
	"bibtex":                             "BibTeX",
	"bicep":                              "Bicep",
	"bikeshed":                           "Bikeshed",
	"bison":                              "Bison",
	"bitbake":                            "BitBake",
	"blade":                              "Blade",
	"blitz3d":                            "BlitzBasic",
	"blitzbasic":                         "BlitzBasic",
	"blitzmax":                           "BlitzMax",
	"blitzplus":                          "BlitzBasic",
	"bluespec":                           "Bluespec",
	"bluespec_bh":                        "Bluespec BH",
	"bluespec_bsv":                       "Bluespec",
	"bluespec_classic":                   "Bluespec BH",
	"bmax":                               "BlitzMax",
	"boo":                                "Boo",
	"boogie":                             "Boogie",
	"bplus":                              "BlitzBasic",
	"bqn":                                "BQN",
	"brainfuck":                          "Brainfuck",
	"brighterscript":                     "BrighterScript",
	"brightscript":                       "Brightscript",
	"bro":                                "Zeek",
	"browserslist":                       "Browserslist",
	"bsdmake":                            "Makefile",
	"bsv":                                "Bluespec",
	"byond":                              "DM",
	"bzl":                                "Starlark",
	"c":                                  "C",
	"c#":                                 "C#",
	"c++":                                "C++",
	"c++-objdump":                        "Cpp-ObjDump",
	"c-objdump":                          "C-ObjDump",
	"c2hs":                               "C2hs Haskell",
	"c2hs_haskell":                       "C2hs Haskell",
	"cabal":                              "Cabal Config",
	"cabal_config":                       "Cabal Config",
	"caddy":                              "Caddyfile",
	"caddyfile":                          "Caddyfile",
	"cadence":                            "Cadence",
	"cairo":                              "Cairo",
	"cairo_zero":                         "Cairo Zero",
	"cake":                               "C#",
	"cakescript":                         "C#",
	"cameligo":                           "CameLIGO",
	"cap'n_proto":                        "Cap'n Proto",
	"cap_cds":                            "CAP CDS",
	"carbon":                             "Carbon",
	"carto":                              "CartoCSS",
	"cartocss":                           "CartoCSS",
	"cds":                                "CAP CDS",
	"ceylon":                             "Ceylon",
	"cfc":                                "ColdFusion CFC",
	"cfm":                                "ColdFusion",
	"cfml":                               "ColdFusion",
	"chapel":                             "Chapel",
	"charity":                            "Charity",
	"checksum":                           "Checksums",
	"checksums":                          "Checksums",
	"chpl":                               "Chapel",
	"chuck":                              "ChucK",
	"cil":                                "CIL",
	"circom":                             "Circom",
	"cirru":                              "Cirru",
	"clarion":                            "Clarion",
	"clarity":                            "Clarity",
	"classic_asp":                        "Classic ASP",
	"classic_visual_basic":               "Visual Basic 6.0",
	"clean":                              "Clean",
	"click":                              "Click",
	"clipper":                            "xBase",
	"clips":                              "CLIPS",
	"clojure":                            "Clojure",
	"closure_templates":                  "Closure Templates",
	"cloud_firestore_security_rules":     "Cloud Firestore Security Rules",
	"cmake":                              "CMake",
	"cobol":                              "COBOL",
	"coccinelle":                         "SmPL",
	"codeowners":                         "CODEOWNERS",
	"codeql":                             "CodeQL",
	"coffee":                             "CoffeeScript",
	"coffee-script":                      "CoffeeScript",
	"coffeescript":                       "CoffeeScript",
	"coldfusion":                         "ColdFusion",
	"coldfusion_cfc":                     "ColdFusion CFC",
	"coldfusion_html":                    "ColdFusion",
	"collada":                            "COLLADA",
	"common_lisp":                        "Common Lisp",
	"common_workflow_language":           "Common Workflow Language",
	"component_pascal":                   "Component Pascal",
	"conll":                              "CoNLL-U",
	"conll-u":                            "CoNLL-U",
	"conll-x":                            "CoNLL-U",
	"console":                            "ShellSession",
	"containerfile":                      "Dockerfile",
	"cool":                               "Cool",
	"coq":                                "Coq",
	"cperl":                              "Perl",
	"cpp":                                "C++",
	"cpp-objdump":                        "Cpp-ObjDump",
	"creole":                             "Creole",
	"cron":                               "crontab",
	"cron_table":                         "crontab",
	"crontab":                            "crontab",
	"crystal":                            "Crystal",
	"csharp":                             "C#",
	"cson":                               "CSON",
	"csound":                             "Csound",
	"csound-csd":                         "Csound Document",
	"csound-orc":                         "Csound",
	"csound-sco":                         "Csound Score",
	"csound_document":                    "Csound Document",
	"csound_score":                       "Csound Score",
	"css":                                "CSS",
	"csv":                                "CSV",
	"cucumber":                           "Gherkin",
	"cuda":                               "Cuda",
	"cue":                                "CUE",
	"cue_sheet":                          "Cue Sheet",
	"curl_config":                        "cURL Config",
	"curlrc":                             "cURL Config",
	"curry":                              "Curry",
	"cweb":                               "CWeb",
	"cwl":                                "Common Workflow Language",
	"cycript":                            "Cycript",
	"cylc":                               "Cylc",
	"cypher":                             "Cypher",
	"cython":                             "Cython",
	"d":                                  "D",
	"d-objdump":                          "D-ObjDump",
	"d2":                                 "D2",
	"d2lang":                             "D2",
	"dafny":                              "Dafny",
	"darcs_patch":                        "Darcs Patch",
	"dart":                               "Dart",
	"dataweave":                          "DataWeave",
	"dcl":                                "DIGITAL Command Language",
	"debian_package_control_file":        "Debian Package Control File",
	"delphi":                             "Pascal",
	"denizenscript":                      "DenizenScript",
	"desktop":                            "desktop",
	"dhall":                              "Dhall",
	"diff":                               "Diff",
	"digital_command_language":           "DIGITAL Command Language",
	"dircolors":                          "dircolors",
	"directx_3d_file":                    "DirectX 3D File",
	"django":                             "Jinja",
	"dlang":                              "D",
	"dm":                                 "DM",
	"dns_zone":                           "DNS Zone",
	"dockerfile":                         "Dockerfile",
	"dogescript":                         "Dogescript",
	"dosbatch":                           "Batchfile",
	"dosini":                             "INI",
	"dotenv":                             "Dotenv",
	"dpatch":                             "Darcs Patch",
	"dtrace":                             "DTrace",
	"dtrace-script":                      "DTrace",
	"dune":                               "Dune",
	"dylan":                              "Dylan",
	"e":                                  "E",
	"e-mail":                             "E-mail",
	"eagle":                              "Eagle",
	"earthfile":                          "Earthly",
	"earthly":                            "Earthly",
	"easybuild":                          "Easybuild",
	"ebnf":                               "EBNF",
	"ec":                                 "eC",
	"ecere_projects":                     "Ecere Projects",
	"ecl":                                "ECL",
	"eclipse":                            "ECLiPSe",
	"ecmarkdown":                         "Ecmarkup",
	"ecmarkup":                           "Ecmarkup",
	"ecr":                                "HTML+ECR",
	"edge":                               "Edge",
	"edgeql":                             "EdgeQL",
	"editor-config":                      "EditorConfig",
	"editorconfig":                       "EditorConfig",
	"edje_data_collection":               "Edje Data Collection",
	"edn":                                "edn",
	"eeschema_schematic":                 "KiCad Schematic",
	"eex":                                "HTML+EEX",
	"eiffel":                             "Eiffel",
	"ejs":                                "EJS",
	"electronic_business_card":           "vCard",
	"elisp":                              "Emacs Lisp",
	"elixir":                             "Elixir",
	"elm":                                "Elm",
	"elvish":                             "Elvish",
	"elvish_transcript":                  "Elvish Transcript",
	"emacs":                              "Emacs Lisp",
	"emacs_lisp":                         "Emacs Lisp",
	"emacs_muse":                         "Muse",
	"email":                              "E-mail",
	"emberscript":                        "EmberScript",
	"eml":                                "E-mail",
	"envrc":                              "Shell",
	"eq":                                 "EQ",
	"erb":                                "HTML+ERB",
	"erlang":                             "Erlang",
	"esdl":                               "EdgeQL",
	"euphoria":                           "Euphoria",
	"f#":                                 "F#",
	"f*":                                 "F*",
	"factor":                             "Factor",
	"fancy":                              "Fancy",
	"fantom":                             "Fantom",
	"faust":                              "Faust",
	"fb":                                 "FreeBasic",
	"fennel":                             "Fennel",
	"figfont":                            "FIGlet Font",
	"figlet_font":                        "FIGlet Font",
	"filebench_wml":                      "Filebench WML",
	"filterscript":                       "Filterscript",
	"firrtl":                             "FIRRTL",
	"fish":                               "fish",
	"flex":                               "Lex",
	"fluent":                             "Fluent",
	"flux":                               "FLUX",
	"formatted":                          "Formatted",
	"forth":                              "Forth",
	"fortran":                            "Fortran",
	"fortran_free_form":                  "Fortran Free Form",
	"foxpro":                             "xBase",
	"freebasic":                          "FreeBasic",
	"freemarker":                         "FreeMarker",
	"frege":                              "Frege",
	"fsharp":                             "F#",
	"fstar":                              "F*",
	"ftl":                                "FreeMarker",
	"fundamental":                        "Text",
	"futhark":                            "Futhark",
	"g-code":                             "G-code",
	"game_maker_language":                "Game Maker Language",
	"gaml":                               "GAML",
	"gams":                               "GAMS",
	"gap":                                "GAP",
	"gas":                                "Unix Assembly",
	"gcc_machine_description":            "GCC Machine Description",
	"gdb":                                "GDB",
	"gdscript":                           "GDScript",
	"gedcom":                             "GEDCOM",
	"gemfile.lock":                       "Gemfile.lock",
	"gemini":                             "Gemini",
	"gemtext":                            "Gemini",
	"genero_4gl":                         "Genero 4gl",
	"genero_per":                         "Genero per",
	"genie":                              "Genie",
	"genshi":                             "Genshi",
	"gentoo_ebuild":                      "Gentoo Ebuild",
	"gentoo_eclass":                      "Gentoo Eclass",
	"geojson":                            "JSON",
	"gerber_image":                       "Gerber Image",
	"gettext_catalog":                    "Gettext Catalog",
	"gf":                                 "Grammatical Framework",
	"gherkin":                            "Gherkin",
	"git-ignore":                         "Ignore List",
	"git_attributes":                     "Git Attributes",
	"git_blame_ignore_revs":              "Git Revision List",
	"git_config":                         "Git Config",
	"git_revision_list":                  "Git Revision List",
	"gitattributes":                      "Git Attributes",
	"gitconfig":                          "Git Config",
	"gitignore":                          "Ignore List",
	"gitmodules":                         "Git Config",
	"gleam":                              "Gleam",
	"glimmer_js":                         "Glimmer JS",
	"glimmer_ts":                         "Glimmer TS",
	"glsl":                               "GLSL",
	"glyph":                              "Glyph",
	"glyph_bitmap_distribution_format":   "Glyph Bitmap Distribution Format",
	"gn":                                 "GN",
	"gnu_asm":                            "Unix Assembly",
	"gnuplot":                            "Gnuplot",
	"go":                                 "Go",
	"go.mod":                             "Go Module",
	"go.sum":                             "Go Checksums",
	"go.work":                            "Go Workspace",
	"go.work.sum":                        "Go Checksums",
	"go_checksums":                       "Go Checksums",
	"go_mod":                             "Go Module",
	"go_module":                          "Go Module",
	"go_sum":                             "Go Checksums",
	"go_work":                            "Go Workspace",
	"go_work_sum":                        "Go Checksums",
	"go_workspace":                       "Go Workspace",
	"godot_resource":                     "Godot Resource",
	"golang":                             "Go",
	"golo":                               "Golo",
	"gosu":                               "Gosu",
	"grace":                              "Grace",
	"gradle":                             "Gradle",
	"gradle_kotlin_dsl":                  "Gradle Kotlin DSL",
	"grammatical_framework":              "Grammatical Framework",
	"graph_modeling_language":            "Graph Modeling Language",
	"graphql":                            "GraphQL",
	"graphviz_(dot)":                     "Graphviz (DOT)",
	"groff":                              "Roff",
	"groovy":                             "Groovy",
	"groovy_server_pages":                "Groovy Server Pages",
	"gsc":                                "GSC",
	"gsp":                                "Groovy Server Pages",
	"hack":                               "Hack",
	"haml":                               "Haml",
	"handlebars":                         "Handlebars",
	"haproxy":                            "HAProxy",
	"harbour":                            "Harbour",
	"hash":                               "Checksums",
	"hashes":                             "Checksums",
	"hashicorp_configuration_language":   "HCL",
	"haskell":                            "Haskell",
	"haxe":                               "Haxe",
	"hbs":                                "Handlebars",
	"hcl":                                "HCL",
	"heex":                               "HTML+EEX",
	"help":                               "Vim Help File",
	"hiveql":                             "HiveQL",
	"hlsl":                               "HLSL",
	"hocon":                              "HOCON",
	"holyc":                              "HolyC",
	"hoon":                               "hoon",
	"hosts":                              "Hosts File",
	"hosts_file":                         "Hosts File",
	"html":                               "HTML",
	"html+django":                        "Jinja",
	"html+ecr":                           "HTML+ECR",
	"html+eex":                           "HTML+EEX",
	"html+erb":                           "HTML+ERB",
	"html+jinja":                         "Jinja",
	"html+php":                           "HTML+PHP",
	"html+razor":                         "HTML+Razor",
	"html+ruby":                          "HTML+ERB",
	"htmlbars":                           "Handlebars",
	"htmldjango":                         "Jinja",
	"http":                               "HTTP",
	"hxml":                               "HXML",
	"hy":                                 "Hy",
	"hylang":                             "Hy",
	"hyphy":                              "HyPhy",
	"i7":                                 "Inform 7",
	"ical":                               "iCalendar",
	"icalendar":                          "iCalendar",
	"idl":                                "IDL",
	"idris":                              "Idris",
	"ignore":                             "Ignore List",
	"ignore_list":                        "Ignore List",
	"igor":                               "IGOR Pro",
	"igor_pro":                           "IGOR Pro",
	"igorpro":                            "IGOR Pro",
	"ijm":                                "ImageJ Macro",
	"ile_rpg":                            "RPGLE",
	"imagej_macro":                       "ImageJ Macro",
	"imba":                               "Imba",
	"inc":                                "PHP",
	"inform7":                            "Inform 7",
	"inform_7":                           "Inform 7",
	"ini":                                "INI",
	"ink":                                "Ink",
	"inno_setup":                         "Inno Setup",
	"inputrc":                            "Readline Config",
	"io":                                 "Io",
	"ioke":                               "Ioke",
	"ipython_notebook":                   "Jupyter Notebook",
	"irc":                                "IRC log",
	"irc_log":                            "IRC log",
	"irc_logs":                           "IRC log",
	"isabelle":                           "Isabelle",
	"isabelle_root":                      "Isabelle ROOT",
	"j":                                  "J",
	"janet":                              "Janet",
	"jar_manifest":                       "JAR Manifest",
	"jasmin":                             "Jasmin",
	"java":                               "Java",
	"java_properties":                    "Java Properties",
	"java_server_page":                   "Groovy Server Pages",
	"java_server_pages":                  "Java Server Pages",
	"java_template_engine":               "Java Template Engine",
	"javascript":                         "JavaScript",
	"javascript+erb":                     "JavaScript+ERB",
	"jcl":                                "JCL",
	"jest_snapshot":                      "Jest Snapshot",
	"jetbrains_mps":                      "JetBrains MPS",
	"jflex":                              "JFlex",
	"jinja":                              "Jinja",
	"jison":                              "Jison",
	"jison_lex":                          "Jison Lex",
	"jolie":                              "Jolie",
	"jq":                                 "jq",
	"jruby":                              "Ruby",
	"js":                                 "JavaScript",
	"json":                               "JSON",
	"json5":                              "JSON5",
	"json_with_comments":                 "JSON with Comments",
	"jsonc":                              "JSON with Comments",
	"jsoniq":                             "JSONiq",
	"jsonl":                              "JSON",
	"jsonld":                             "JSONLD",
	"jsonnet":                            "Jsonnet",
	"jsp":                                "Java Server Pages",
	"jte":                                "Java Template Engine",
	"julia":                              "Julia",
	"julia_repl":                         "Julia REPL",
	"jupyter_notebook":                   "Jupyter Notebook",
	"just":                               "Just",
	"justfile":                           "Just",
	"kaitai_struct":                      "Kaitai Struct",
	"kak":                                "KakouneScript",
	"kakounescript":                      "KakouneScript",
	"kakscript":                          "KakouneScript",
	"kerboscript":                        "KerboScript",
	"keyvalues":                          "Valve Data Format",
	"kicad_layout":                       "KiCad Layout",
	"kicad_legacy_layout":                "KiCad Legacy Layout",
	"kicad_schematic":                    "KiCad Schematic",
	"kickstart":                          "Kickstart",
	"kit":                                "Kit",
	"kotlin":                             "Kotlin",
	"krl":                                "KRL",
	"ksy":                                "Kaitai Struct",
	"kusto":                              "Kusto",
	"kvlang":                             "kvlang",
	"labview":                            "LabVIEW",
	"lark":                               "Lark",
	"lasso":                              "Lasso",
	"lassoscript":                        "Lasso",
	"latex":                              "TeX",
	"latte":                              "Latte",
	"lean":                               "Lean",
	"lean_4":                             "Lean 4",
	"leex":                               "HTML+EEX",
	"less":                               "Less",
	"less-css":                           "Less",
	"lex":                                "Lex",
	"lfe":                                "LFE",
	"lhaskell":                           "Literate Haskell",
	"lhs":                                "Literate Haskell",
	"ligolang":                           "LigoLANG",
	"lilypond":                           "LilyPond",
	"limbo":                              "Limbo",
	"linker_script":                      "Linker Script",
	"linux_kernel_module":                "Linux Kernel Module",
	"liquid":                             "Liquid",
	"lisp":                               "Common Lisp",
	"litcoffee":                          "Literate CoffeeScript",
	"literate_agda":                      "Literate Agda",
	"literate_coffeescript":              "Literate CoffeeScript",
	"literate_haskell":                   "Literate Haskell",
	"live-script":                        "LiveScript",
	"livecode_script":                    "LiveCode Script",
	"livescript":                         "LiveScript",
	"llvm":                               "LLVM",
	"logos":                              "Logos",
	"logtalk":                            "Logtalk",
	"lolcode":                            "LOLCODE",
	"lookml":                             "LookML",
	"loomscript":                         "LoomScript",
	"ls":                                 "LiveScript",
	"lsl":                                "LSL",
	"ltspice_symbol":                     "LTspice Symbol",
	"lua":                                "Lua",
	"luau":                               "Luau",
	"m":                                  "M",
	"m2":                                 "Macaulay2",
	"m4":                                 "M4",
	"m4sugar":                            "M4Sugar",
	"m68k":                               "Motorola 68K Assembly",
	"macaulay2":                          "Macaulay2",
	"macruby":                            "Ruby",
	"mail":                               "E-mail",
	"make":                               "Makefile",
	"makefile":                           "Makefile",
	"mako":                               "Mako",
	"man":                                "Roff",
	"man-page":                           "Roff",
	"man_page":                           "Roff",
	"manpage":                            "Roff",
	"markdown":                           "Markdown",
	"marko":                              "Marko",
	"markojs":                            "Marko",
	"mask":                               "Mask",
	"mathematica":                        "Mathematica",
	"matlab":                             "MATLAB",
	"maven_pom":                          "Maven POM",
	"max":                                "Max",
	"max/msp":                            "Max",
	"maxmsp":                             "Max",
	"maxscript":                          "MAXScript",
	"mbox":                               "E-mail",
	"mcfunction":                         "mcfunction",
	"md":                                 "Markdown",
	"mdoc":                               "Roff",
	"mdx":                                "MDX",
	"mediawiki":                          "Wikitext",
	"mercury":                            "Mercury",
	"mermaid":                            "Mermaid",
	"mermaid_example":                    "Mermaid",
	"meson":                              "Meson",
	"metal":                              "Metal",
	"mf":                                 "Makefile",
	"microsoft_developer_studio_project": "Microsoft Developer Studio Project",
	"microsoft_visual_studio_solution":   "Microsoft Visual Studio Solution",
	"minid":                              "MiniD",
	"miniyaml":                           "MiniYAML",
	"mint":                               "Mint",
	"mirah":                              "Mirah",
	"mirc_script":                        "mIRC Script",
	"mlir":                               "MLIR",
	"mma":                                "Mathematica",
	"modelica":                           "Modelica",
	"modula-2":                           "Modula-2",
	"modula-3":                           "Modula-3",
	"module_management_system":           "Module Management System",
	"mojo":                               "Mojo",
	"monkey":                             "Monkey",
	"monkey_c":                           "Monkey C",
	"moocode":                            "Moocode",
	"moonscript":                         "MoonScript",
	"motoko":                             "Motoko",
	"motorola_68k_assembly":              "Motorola 68K Assembly",
	"move":                               "Move",
	"mps":                                "JetBrains MPS",
	"mql4":                               "MQL4",
	"mql5":                               "MQL5",
	"mtml":                               "MTML",
	"muf":                                "MUF",
	"mumps":                              "M",
	"mupad":                              "mupad",
	"muse":                               "Muse",
	"mustache":                           "Mustache",
	"myghty":                             "Myghty",
	"nanorc":                             "nanorc",
	"nargo":                              "Noir",
	"nasal":                              "Nasal",
	"nasl":                               "NASL",
	"nasm":                               "Assembly",
	"ncl":                                "NCL",
	"ne-on":                              "NEON",
	"nearley":                            "Nearley",
	"nemerle":                            "Nemerle",
	"neon":                               "NEON",
	"neosnippet":                         "Vim Snippet",
	"nesc":                               "nesC",
	"netlinx":                            "NetLinx",
	"netlinx+erb":                        "NetLinx+ERB",
	"netlogo":                            "NetLogo",
	"nette_object_notation":              "NEON",
	"newlisp":                            "NewLisp",
	"nextflow":                           "Nextflow",
	"nginx":                              "Nginx",
	"nginx_configuration_file":           "Nginx",
	"nim":                                "Nim",
	"ninja":                              "Ninja",
	"nit":                                "Nit",
	"nix":                                "Nix",
	"nixos":                              "Nix",
	"njk":                                "Nunjucks",
	"nl":                                 "NL",
	"nmodl":                              "NMODL",
	"node":                               "JavaScript",
	"noir":                               "Noir",
	"npm_config":                         "NPM Config",
	"npmrc":                              "NPM Config",
	"nroff":                              "Roff",
	"nsis":                               "NSIS",
	"nu":                                 "Nu",
	"nu-script":                          "Nushell",
	"numpy":                              "NumPy",
	"nunjucks":                           "Nunjucks",
	"nush":                               "Nu",
	"nushell":                            "Nushell",
	"nushell-script":                     "Nushell",
	"nvim":                               "Vim Script",
	"nwscript":                           "NWScript",
	"oasv2":                              "OpenAPI Specification v2",
	"oasv2-json":                         "OASv2-json",
	"oasv2-yaml":                         "OASv2-yaml",
	"oasv3":                              "OpenAPI Specification v3",
	"oasv3-json":                         "OASv3-json",
	"oasv3-yaml":                         "OASv3-yaml",
	"oberon":                             "Oberon",
	"obj-c":                              "Objective-C",
	"obj-c++":                            "Objective-C++",
	"obj-j":                              "Objective-J",
	"objc":                               "Objective-C",
	"objc++":                             "Objective-C++",
	"objdump":                            "ObjDump",
	"object_data_instance_notation":      "Object Data Instance Notation",
	"objective-c":                        "Objective-C",
	"objective-c++":                      "Objective-C++",
	"objective-j":                        "Objective-J",
	"objectivec":                         "Objective-C",
	"objectivec++":                       "Objective-C++",
	"objectivej":                         "Objective-J",
	"objectpascal":                       "Pascal",
	"objectscript":                       "ObjectScript",
	"objj":                               "Objective-J",
	"ocaml":                              "OCaml",
	"octave":                             "MATLAB",
	"odin":                               "Odin",
	"odin-lang":                          "Odin",
	"odinlang":                           "Odin",
	"omgrofl":                            "Omgrofl",
	"oncrpc":                             "RPC",
	"ooc":                                "ooc",
	"opa":                                "Opa",
	"opal":                               "Opal",
	"open_policy_agent":                  "Open Policy Agent",
	"openapi_specification_v2":           "OpenAPI Specification v2",
	"openapi_specification_v3":           "OpenAPI Specification v3",
	"opencl":                             "OpenCL",
	"openedge":                           "OpenEdge ABL",
	"openedge_abl":                       "OpenEdge ABL",
	"openqasm":                           "OpenQASM",
	"openrc":                             "OpenRC runscript",
	"openrc_runscript":                   "OpenRC runscript",
	"openscad":                           "OpenSCAD",
	"openstep_property_list":             "OpenStep Property List",
	"opentype_feature_file":              "OpenType Feature File",
	"option_list":                        "Option List",
	"opts":                               "Option List",
	"org":                                "Org",
	"osascript":                          "AppleScript",
	"ox":                                 "Ox",
	"oxygene":                            "Oxygene",
	"oz":                                 "Oz",
	"p4":                                 "P4",
	"pact":                               "Pact",
	"pan":                                "Pan",
	"pandoc":                             "Markdown",
	"papyrus":                            "Papyrus",
	"parrot":                             "Parrot",
	"parrot_assembly":                    "Parrot Assembly",
	"parrot_internal_representation":     "Parrot Internal Representation",
	"pascal":                             "Pascal",
	"pasm":                               "Parrot Assembly",
	"pawn":                               "Pawn",
	"pcbnew":                             "KiCad Layout",
	"pddl":                               "PDDL",
	"peg.js":                             "PEG.js",
	"pep8":                               "Pep8",
	"perl":                               "Perl",
	"perl-6":                             "Raku",
	"perl6":                              "Raku",
	"php":                                "PHP",
	"pic":                                "Pic",
	"pickle":                             "Pickle",
	"picolisp":                           "PicoLisp",
	"piglatin":                           "PigLatin",
	"pikchr":                             "Pic",
	"pike":                               "Pike",
	"pip_requirements":                   "Pip Requirements",
	"pir":                                "Parrot Internal Representation",
	"pkl":                                "Pkl",
	"plain_text":                         "Text",
	"plantuml":                           "PlantUML",
	"plpgsql":                            "PLpgSQL",
	"plsql":                              "PLSQL",
	"pod":                                "Pod",
	"pod_6":                              "Pod 6",
	"pogoscript":                         "PogoScript",
	"polar":                              "Polar",
	"pony":                               "Pony",
	"portugol":                           "Portugol",
	"posh":                               "PowerShell",
	"postcss":                            "PostCSS",
	"postscr":                            "PostScript",
	"postscript":                         "PostScript",
	"pot":                                "Gettext Catalog",
	"pov-ray":                            "POV-Ray SDL",
	"pov-ray_sdl":                        "POV-Ray SDL",
	"povray":                             "POV-Ray SDL",
	"powerbuilder":                       "PowerBuilder",
	"powershell":                         "PowerShell",
	"praat":                              "Praat",
	"prisma":                             "Prisma",
	"processing":                         "Processing",
	"procfile":                           "Procfile",
	"progress":                           "OpenEdge ABL",
	"proguard":                           "Proguard",
	"prolog":                             "Prolog",
	"promela":                            "Promela",
	"propeller_spin":                     "Propeller Spin",
	"proto":                              "Protocol Buffer",
	"protobuf":                           "Protocol Buffer",
	"protobuf_text_format":               "Protocol Buffer Text Format",
	"protocol_buffer":                    "Protocol Buffer",
	"protocol_buffer_text_format":        "Protocol Buffer Text Format",
	"protocol_buffers":                   "Protocol Buffer",
	"public_key":                         "Public Key",
	"pug":                                "Pug",
	"puppet":                             "Puppet",
	"pure_data":                          "Pure Data",
	"purebasic":                          "PureBasic",
	"purescript":                         "PureScript",
	"pwsh":                               "PowerShell",
	"pycon":                              "Python console",
	"pyret":                              "Pyret",
	"pyrex":                              "Cython",
	"python":                             "Python",
	"python3":                            "Python",
	"python_console":                     "Python console",
	"python_traceback":                   "Python traceback",
	"q":                                  "q",
	"q#":                                 "Q#",
	"ql":                                 "CodeQL",
	"qmake":                              "QMake",
	"qml":                                "QML",
	"qsharp":                             "Q#",
	"qt_script":                          "Qt Script",
	"quake":                              "Quake",
	"r":                                  "R",
	"racket":                             "Racket",
	"ragel":                              "Ragel",
	"ragel-rb":                           "Ragel",
	"ragel-ruby":                         "Ragel",
	"rake":                               "Ruby",
	"raku":                               "Raku",
	"raml":                               "RAML",
	"rascal":                             "Rascal",
	"raw":                                "Raw token data",
	"raw_token_data":                     "Raw token data",
	"razor":                              "HTML+Razor",
	"rb":                                 "Ruby",
	"rbs":                                "RBS",
	"rbx":                                "Ruby",
	"rdoc":                               "RDoc",
	"readline":                           "Readline Config",
	"readline_config":                    "Readline Config",
	"realbasic":                          "REALbasic",
	"reason":                             "Reason",
	"reasonligo":                         "ReasonLIGO",
	"rebol":                              "Rebol",
	"record_jar":                         "Record Jar",
	"red":                                "Red",
	"red/system":                         "Red",
	"redcode":                            "Redcode",
	"redirect_rules":                     "Redirect Rules",
	"redirects":                          "Redirect Rules",
	"regex":                              "Regular Expression",
	"regexp":                             "Regular Expression",
	"regular_expression":                 "Regular Expression",
	"ren'py":                             "Ren'Py",
	"renderscript":                       "RenderScript",
	"renpy":                              "Ren'Py",
	"rescript":                           "ReScript",
	"restructuredtext":                   "reStructuredText",
	"rexx":                               "REXX",
	"rez":                                "Rez",
	"rhtml":                              "HTML+ERB",
	"rich_text_format":                   "Rich Text Format",
	"ring":                               "Ring",
	"riot":                               "Riot",
	"rmarkdown":                          "RMarkdown",
	"robotframework":                     "RobotFramework",
	"robots":                             "robots.txt",
	"robots.txt":                         "robots.txt",
	"robots_txt":                         "robots.txt",
	"roc":                                "Roc",
	"roff":                               "Roff",
	"roff_manpage":                       "Roff Manpage",
	"ron":                                "RON",
	"rouge":                              "Rouge",
	"routeros_script":                    "RouterOS Script",
	"rpc":                                "RPC",
	"rpcgen":                             "RPC",
	"rpgle":                              "RPGLE",
	"rpm_spec":                           "RPM Spec",
	"rs":                                 "Rust",
	"rs-274x":                            "Gerber Image",
	"rscript":                            "R",
	"rss":                                "XML",
	"rst":                                "reStructuredText",
	"ruby":                               "Ruby",
	"runoff":                             "RUNOFF",
	"rust":                               "Rust",
	"rusthon":                            "Python",
	"sage":                               "Sage",
	"salt":                               "SaltStack",
	"saltstack":                          "SaltStack",
	"saltstate":                          "SaltStack",
	"sarif":                              "JSON",
	"sas":                                "SAS",
	"sass":                               "Sass",
	"scala":                              "Scala",
	"scaml":                              "Scaml",
	"scenic":                             "Scenic",
	"scheme":                             "Scheme",
	"scilab":                             "Scilab",
	"scss":                               "SCSS",
	"sdc":                                "Tcl",
	"sed":                                "sed",
	"self":                               "Self",
	"selinux_kernel_policy_language":     "SELinux Policy",
	"selinux_policy":                     "SELinux Policy",
	"sepolicy":                           "SELinux Policy",
	"sfv":                                "Simple File Verification",
	"sh":                                 "Shell",
	"shaderlab":                          "ShaderLab",
	"shell":                              "Shell",
	"shell-script":                       "Shell",
	"shellcheck_config":                  "ShellCheck Config",
	"shellcheckrc":                       "ShellCheck Config",
	"shellsession":                       "ShellSession",
	"shen":                               "Shen",
	"sieve":                              "Sieve",
	"simple_file_verification":           "Simple File Verification",
	"singularity":                        "Singularity",
	"slash":                              "Slash",
	"slice":                              "Slice",
	"slim":                               "Slim",
	"slint":                              "Slint",
	"smali":                              "Smali",
	"smalltalk":                          "Smalltalk",
	"smarty":                             "Smarty",
	"smithy":                             "Smithy",
	"sml":                                "Standard ML",
	"smpl":                               "SmPL",
	"smt":                                "SMT",
	"snakefile":                          "Snakemake",
	"snakemake":                          "Snakemake",
	"snipmate":                           "Vim Snippet",
	"snippet":                            "YASnippet",
	"solidity":                           "Solidity",
	"soong":                              "Soong",
	"sourcemod":                          "SourcePawn",
	"sourcepawn":                         "SourcePawn",
	"soy":                                "Closure Templates",
	"sparql":                             "SPARQL",
	"specfile":                           "RPM Spec",
	"spline_font_database":               "Spline Font Database",
	"splus":                              "R",
	"sqf":                                "SQF",
	"sql":                                "SQL",
	"sqlpl":                              "SQLPL",
	"sqlrpgle":                           "RPGLE",
	"squeak":                             "Smalltalk",
	"squirrel":                           "Squirrel",
	"srecode_template":                   "SRecode Template",
	"ssh_config":                         "SSH Config",
	"stan":                               "Stan",
	"standard_ml":                        "Standard ML",
	"star":                               "STAR",
	"starlark":                           "Starlark",
	"stata":                              "Stata",
	"stl":                                "STL",
	"stla":                               "STL",
	"ston":                               "STON",
	"stringtemplate":                     "StringTemplate",
	"stylus":                             "Stylus",
	"subrip_text":                        "SubRip Text",
	"sugarss":                            "SugarSS",
	"sum":                                "Checksums",
	"sums":                               "Checksums",
	"supercollider":                      "SuperCollider",
	"svelte":                             "Svelte",
	"svg":                                "SVG",
	"sway":                               "Sway",
	"sweave":                             "Sweave",
	"swift":                              "Swift",
	"swig":                               "SWIG",
	"systemverilog":                      "SystemVerilog",
	"tab-seperated_values":               "TSV",
	"talon":                              "Talon",
	"tcl":                                "Tcl",
	"tcsh":                               "Tcsh",
	"tea":                                "Tea",
	"templ":                              "templ",
	"terra":                              "Terra",
	"terraform":                          "HCL",
	"terraform_template":                 "Terraform Template",
	"tex":                                "TeX",
	"texinfo":                            "Texinfo",
	"text":                               "Text",
	"text_proto":                         "Protocol Buffer Text Format",
	"textgrid":                           "TextGrid",
	"textile":                            "Textile",
	"textmate_properties":                "TextMate Properties",
	"thrift":                             "Thrift",
	"ti_program":                         "TI Program",
	"tl":                                 "Type Language",
	"tl-verilog":                         "TL-Verilog",
	"tla":                                "TLA",
	"tm-properties":                      "TextMate Properties",
	"toit":                               "Toit",
	"toml":                               "TOML",
	"topojson":                           "JSON",
	"troff":                              "Roff",
	"ts":                                 "TypeScript",
	"tsql":                               "TSQL",
	"tsv":                                "TSV",
	"tsx":                                "TSX",
	"turing":                             "Turing",
	"turtle":                             "Turtle",
	"twig":                               "Twig",
	"txl":                                "TXL",
	"typ":                                "Typst",
	"type_language":                      "Type Language",
	"typescript":                         "TypeScript",
	"typst":                              "Typst",
	"udiff":                              "Diff",
	"ultisnip":                           "Vim Snippet",
	"ultisnips":                          "Vim Snippet",
	"unified_parallel_c":                 "Unified Parallel C",
	"unity3d_asset":                      "Unity3D Asset",
	"unix_asm":                           "Unix Assembly",
	"unix_assembly":                      "Unix Assembly",
	"uno":                                "Uno",
	"unrealscript":                       "UnrealScript",
	"ur":                                 "UrWeb",
	"ur/web":                             "UrWeb",
	"urweb":                              "UrWeb",
	"v":                                  "V",
	"vala":                               "Vala",
	"valve_data_format":                  "Valve Data Format",
	"vb.net":                             "Visual Basic .NET",
	"vb6":                                "Visual Basic 6.0",
	"vb_.net":                            "Visual Basic .NET",
	"vb_6":                               "Visual Basic 6.0",
	"vba":                                "VBA",
	"vbnet":                              "Visual Basic .NET",
	"vbscript":                           "VBScript",
	"vcard":                              "vCard",
	"vcl":                                "VCL",
	"vdf":                                "Valve Data Format",
	"velocity":                           "Velocity Template Language",
	"velocity_template_language":         "Velocity Template Language",
	"verilog":                            "Verilog",
	"vhdl":                               "VHDL",
	"vim":                                "Vim Script",
	"vim_help_file":                      "Vim Help File",
	"vim_script":                         "Vim Script",
	"vim_snippet":                        "Vim Snippet",
	"vimhelp":                            "Vim Help File",
	"viml":                               "Vim Script",
	"vimscript":                          "Vim Script",
	"virtual_contact_file":               "vCard",
	"visual_basic":                       "Visual Basic .NET",
	"visual_basic_.net":                  "Visual Basic .NET",
	"visual_basic_6":                     "Visual Basic 6.0",
	"visual_basic_6.0":                   "Visual Basic 6.0",
	"visual_basic_classic":               "Visual Basic 6.0",
	"visual_basic_for_applications":      "VBA",
	"vlang":                              "V",
	"volt":                               "Volt",
	"vtl":                                "Velocity Template Language",
	"vtt":                                "WebVTT",
	"vue":                                "Vue",
	"vyper":                              "Vyper",
	"wasm":                               "WebAssembly",
	"wast":                               "WebAssembly",
	"wavefront_material":                 "Wavefront Material",
	"wavefront_object":                   "Wavefront Object",
	"wdl":                                "WDL",
	"web_ontology_language":              "Web Ontology Language",
	"webassembly":                        "WebAssembly",
	"webassembly_interface_type":         "WebAssembly Interface Type",
	"webidl":                             "WebIDL",
	"webvtt":                             "WebVTT",
	"wget_config":                        "Wget Config",
	"wgetrc":                             "Wget Config",
	"wgsl":                               "WGSL",
	"whiley":                             "Whiley",
	"wiki":                               "Wikitext",
	"wikitext":                           "Wikitext",
	"win32_message_file":                 "Win32 Message File",
	"winbatch":                           "Batchfile",
	"windows_registry_entries":           "Windows Registry Entries",
	"wisp":                               "wisp",
	"wit":                                "WebAssembly Interface Type",
	"witcher_script":                     "Witcher Script",
	"wl":                                 "Mathematica",
	"wolfram":                            "Mathematica",
	"wolfram_lang":                       "Mathematica",
	"wolfram_language":                   "Mathematica",
	"wollok":                             "Wollok",
	"workflow_description_language":      "WDL",
	"world_of_warcraft_addon_data":       "World of Warcraft Addon Data",
	"wren":                               "Wren",
	"wrenlang":                           "Wren",
	"wsdl":                               "XML",
	"x10":                                "X10",
	"x_bitmap":                           "X BitMap",
	"x_font_directory_index":             "X Font Directory Index",
	"x_pixmap":                           "X PixMap",
	"xbase":                              "xBase",
	"xbm":                                "X BitMap",
	"xc":                                 "XC",
	"xcompose":                           "XCompose",
	"xdc":                                "Tcl",
	"xdr":                                "RPC",
	"xhtml":                              "HTML",
	"xml":                                "XML",
	"xml+genshi":                         "Genshi",
	"xml+kid":                            "Genshi",
	"xml_property_list":                  "XML Property List",
	"xojo":                               "Xojo",
	"xonsh":                              "Xonsh",
	"xpages":                             "XPages",
	"xpm":                                "X PixMap",
	"xproc":                              "XProc",
	"xquery":                             "XQuery",
	"xs":                                 "XS",
	"xsd":                                "XML",
	"xsl":                                "XSLT",
	"xslt":                               "XSLT",
	"xten":                               "X10",
	"xtend":                              "Xtend",
	"yacc":                               "Yacc",
	"yaml":                               "YAML",
	"yang":                               "YANG",
	"yara":                               "YARA",
	"yas":                                "YASnippet",
	"yasnippet":                          "YASnippet",
	"yml":                                "YAML",
	"yul":                                "Yul",
	"zap":                                "ZAP",
	"zeek":                               "Zeek",
	"zenscript":                          "ZenScript",
	"zephir":                             "Zephir",
	"zig":                                "Zig",
	"zil":                                "ZIL",
	"zimpl":                              "Zimpl",
	"zsh":                                "Shell",
}

// LanguageByAlias looks up the language name by it's alias or name.
// It mirrors the logic of github linguist and is needed e.g for heuristcs.yml
// that mixes names and aliases in a language field (see XPM example).
func LanguageByAlias(langOrAlias string) (lang string, ok bool) {
	k := convertToAliasKey(langOrAlias)
	lang, ok = LanguageByAliasMap[k]
	return
}

// convertToAliasKey converts language name to a key in LanguageByAliasMap.
// Following
//   - internal.code-generator.generator.convertToAliasKey()
//   - GetLanguageByAlias()
//
// conventions.
// It is here to avoid dependency on "generate" and "enry" packages.
func convertToAliasKey(langName string) string {
	ak := strings.SplitN(langName, `,`, 2)[0]
	ak = strings.Replace(ak, ` `, `_`, -1)
	ak = strings.ToLower(ak)
	return ak
}
