// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use ::aws_smithy_runtime_api::client::endpoint::EndpointFuture;
pub use ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver;
pub use ::aws_smithy_types::endpoint::Endpoint;

#[cfg(test)]
mod test {

    /// For region af-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_1() {
        let params = crate::config::endpoint::Params::builder()
            .region("af-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.af-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.af-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_2() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_3() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-northeast-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-northeast-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_4() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-northeast-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-northeast-2.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-3 with FIPS disabled and DualStack disabled
    #[test]
    fn test_5() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-northeast-3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-northeast-3.amazonaws.com")
                .build()
        );
    }

    /// For region ap-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_6() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-southeast-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_7() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-southeast-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-southeast-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-southeast-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-southeast-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_8() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-southeast-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-southeast-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-southeast-2.amazonaws.com")
                .build()
        );
    }

    /// For region ap-southeast-3 with FIPS disabled and DualStack disabled
    #[test]
    fn test_9() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-southeast-3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ap-southeast-3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ap-southeast-3.amazonaws.com")
                .build()
        );
    }

    /// For region ca-central-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_10() {
        let params = crate::config::endpoint::Params::builder()
            .region("ca-central-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.ca-central-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.ca-central-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-central-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_11() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-central-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-central-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-central-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-north-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_12() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-north-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-north-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_13() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_14() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_15() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-west-2.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-3 with FIPS disabled and DualStack disabled
    #[test]
    fn test_16() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.eu-west-3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.eu-west-3.amazonaws.com")
                .build()
        );
    }

    /// For region me-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_17() {
        let params = crate::config::endpoint::Params::builder()
            .region("me-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.me-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.me-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region sa-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_18() {
        let params = crate::config::endpoint::Params::builder()
            .region("sa-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.sa-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.sa-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_19() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_20() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_21() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-east-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-east-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-2 with FIPS enabled and DualStack disabled
    #[test]
    fn test_22() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-east-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-east-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_23() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-west-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_24() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-west-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_25() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-west-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-west-2 with FIPS enabled and DualStack disabled
    #[test]
    fn test_26() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-west-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_27() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// For region us-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_28() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-east-1.api.aws")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_29() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.cn-north-1.amazonaws.com.cn")
                .build()
        );
    }

    /// For region cn-northwest-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_30() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.cn-northwest-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.cn-northwest-1.amazonaws.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_31() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.cn-north-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.cn-north-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_32() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.cn-north-1.amazonaws.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_33() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.cn-north-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.cn-north-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_34() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-gov-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_35() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-gov-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_36() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-gov-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-gov-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-west-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_37() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-gov-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-gov-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_38() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-gov-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-gov-east-1.api.aws")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_39() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-gov-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-gov-east-1.api.aws")
                .build()
        );
    }

    /// For region us-iso-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_40() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// For region us-iso-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_41() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-west-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-west-1.c2s.ic.gov")
                .build()
        );
    }

    /// For region us-iso-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_42() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [For region us-iso-east-1 with FIPS enabled and DualStack enabled]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// For region us-iso-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_43() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// For region us-iso-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_44() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: DualStack is enabled but this partition does not support DualStack [For region us-iso-east-1 with FIPS disabled and DualStack enabled]");
        assert_eq!(format!("{}", error), "DualStack is enabled but this partition does not support DualStack")
    }

    /// For region us-isob-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_45() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// For region us-isob-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_46() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [For region us-isob-east-1 with FIPS enabled and DualStack enabled]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// For region us-isob-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_47() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// For region us-isob-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_48() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: DualStack is enabled but this partition does not support DualStack [For region us-isob-east-1 with FIPS disabled and DualStack enabled]");
        assert_eq!(format!("{}", error), "DualStack is enabled but this partition does not support DualStack")
    }

    /// For custom endpoint with region set and fips disabled and dualstack disabled
    #[test]
    fn test_49() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// For custom endpoint with region not set and fips disabled and dualstack disabled
    #[test]
    fn test_50() {
        let params = crate::config::endpoint::Params::builder()
            .use_fips(false)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// For custom endpoint with fips enabled and dualstack disabled
    #[test]
    fn test_51() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: FIPS and custom endpoint are not supported [For custom endpoint with fips enabled and dualstack disabled]");
        assert_eq!(format!("{}", error), "Invalid Configuration: FIPS and custom endpoint are not supported")
    }

    /// For custom endpoint with fips disabled and dualstack enabled
    #[test]
    fn test_52() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: Dualstack and custom endpoint are not supported [For custom endpoint with fips disabled and dualstack enabled]");
        assert_eq!(
            format!("{}", error),
            "Invalid Configuration: Dualstack and custom endpoint are not supported"
        )
    }

    /// Missing region
    #[test]
    fn test_53() {
        let params = crate::config::endpoint::Params::builder().build().expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: Missing Region [Missing region]");
        assert_eq!(format!("{}", error), "Invalid Configuration: Missing Region")
    }

    /// Invalid ARN: Failed to parse ARN.
    #[test]
    fn test_54() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Failed to parse ARN. [Invalid ARN: Failed to parse ARN.]");
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// Invalid ARN: partition missing from ARN.
    #[test]
    fn test_55() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn::kinesis:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Failed to parse ARN. [Invalid ARN: partition missing from ARN.]");
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// Invalid ARN: partitions mismatch.
    #[test]
    fn test_56() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Partition: aws from ARN doesn't match with partition name: aws-us-gov. [Invalid ARN: partitions mismatch.]");
        assert_eq!(
            format!("{}", error),
            "Partition: aws from ARN doesn't match with partition name: aws-us-gov."
        )
    }

    /// Invalid ARN: Not Kinesis
    #[test]
    fn test_57() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:s3:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: The ARN was not for the Kinesis service, found: s3. [Invalid ARN: Not Kinesis]");
        assert_eq!(format!("{}", error), "Invalid ARN: The ARN was not for the Kinesis service, found: s3.")
    }

    /// Invalid ARN: Region is missing in ARN
    #[test]
    fn test_58() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis::123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid region. [Invalid ARN: Region is missing in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// Invalid ARN: Region is empty string in ARN
    #[test]
    fn test_59() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:  :123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid region. [Invalid ARN: Region is empty string in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// Invalid ARN: Invalid account id
    #[test]
    fn test_60() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:us-east-1::stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// Invalid ARN: Invalid account id
    #[test]
    fn test_61() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:us-east-1:   :stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// Invalid ARN: Kinesis ARNs only support stream arn types
    #[test]
    fn test_62() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:us-east-1:123:accesspoint/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types. [Invalid ARN: Kinesis ARNs only support stream arn types]");
        assert_eq!(format!("{}", error), "Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types.")
    }

    /// Dual Stack not supported region.
    #[test]
    fn test_63() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .stream_arn("arn:aws-iso:kinesis:us-iso-west-1:123456789012:stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: FIPS and DualStack are enabled, but this partition does not support one or both [Dual Stack not supported region.]",
        );
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// OperationType not set
    #[test]
    fn test_64() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .stream_arn("arn:aws:kinesis:us-east-1:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Operation Type is not set. Please contact service team for resolution. [OperationType not set]");
        assert_eq!(
            format!("{}", error),
            "Operation Type is not set. Please contact service team for resolution."
        )
    }

    /// Custom Endpoint is specified
    #[test]
    fn test_65() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// Account endpoint targeting control operation type
    #[test]
    fn test_66() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint targeting data operation type
    #[test]
    fn test_67() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with fips targeting data operation type
    #[test]
    fn test_68() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with fips targeting control operation type
    #[test]
    fn test_69() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with Dual Stack and FIPS enabled
    #[test]
    fn test_70() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("control".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// Account endpoint with Dual Stack enabled
    #[test]
    fn test_71() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .stream_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-west-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-west-1.api.aws")
                .build()
        );
    }

    /// Account endpoint with FIPS and DualStack disabled
    #[test]
    fn test_72() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// RegionMismatch: client region should be used for endpoint region
    #[test]
    fn test_73() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws:kinesis:us-west-1:123:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with FIPS enabled
    #[test]
    fn test_74() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn")
                .build()
        );
    }

    /// Account endpoint with FIPS and DualStack enabled for cn regions.
    #[test]
    fn test_75() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .stream_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_76() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_77() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws-iso:kinesis:us-iso-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-west-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-west-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint targeting data operation type in ADC regions
    #[test]
    fn test_78() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// Account endpoint with fips targeting control operation type in ADC regions
    #[test]
    fn test_79() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .stream_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint with fips targeting data operation type in ADC regions
    #[test]
    fn test_80() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// Invalid ConsumerARN: Failed to parse ARN.
    #[test]
    fn test_81() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Failed to parse ARN. [Invalid ConsumerARN: Failed to parse ARN.]");
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// Invalid ConsumerARN: partition missing from ARN.
    #[test]
    fn test_82() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn::kinesis:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Failed to parse ARN. [Invalid ConsumerARN: partition missing from ARN.]");
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// Invalid ARN: partitions mismatch.
    #[test]
    fn test_83() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Partition: aws from ARN doesn't match with partition name: aws-us-gov. [Invalid ARN: partitions mismatch.]");
        assert_eq!(
            format!("{}", error),
            "Partition: aws from ARN doesn't match with partition name: aws-us-gov."
        )
    }

    /// Invalid ARN: Not Kinesis
    #[test]
    fn test_84() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:s3:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: The ARN was not for the Kinesis service, found: s3. [Invalid ARN: Not Kinesis]");
        assert_eq!(format!("{}", error), "Invalid ARN: The ARN was not for the Kinesis service, found: s3.")
    }

    /// Invalid ARN: Region is missing in ARN
    #[test]
    fn test_85() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis::123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid region. [Invalid ARN: Region is missing in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// Invalid ARN: Region is empty string in ARN
    #[test]
    fn test_86() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:  :123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid region. [Invalid ARN: Region is empty string in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// Invalid ARN: Invalid account id
    #[test]
    fn test_87() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:us-east-1::stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// Invalid ARN: Invalid account id
    #[test]
    fn test_88() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:us-east-1:   :stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// Invalid ARN: Kinesis ARNs only support stream arn/consumer arn types
    #[test]
    fn test_89() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:us-east-1:123:accesspoint/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types. [Invalid ARN: Kinesis ARNs only support stream arn/consumer arn types]");
        assert_eq!(format!("{}", error), "Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types.")
    }

    /// Dual Stack not supported region.
    #[test]
    fn test_90() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .consumer_arn("arn:aws-iso:kinesis:us-iso-west-1:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: FIPS and DualStack are enabled, but this partition does not support one or both [Dual Stack not supported region.]",
        );
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// OperationType not set
    #[test]
    fn test_91() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .consumer_arn("arn:aws:kinesis:us-east-1:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Operation Type is not set. Please contact service team for resolution. [OperationType not set]");
        assert_eq!(
            format!("{}", error),
            "Operation Type is not set. Please contact service team for resolution."
        )
    }

    /// Custom Endpoint is specified
    #[test]
    fn test_92() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// Account endpoint targeting control operation type
    #[test]
    fn test_93() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint targeting data operation type
    #[test]
    fn test_94() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with fips targeting data operation type
    #[test]
    fn test_95() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with fips targeting control operation type
    #[test]
    fn test_96() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with Dual Stack and FIPS enabled
    #[test]
    fn test_97() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// Account endpoint with Dual Stack enabled
    #[test]
    fn test_98() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-west-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-west-1.api.aws")
                .build()
        );
    }

    /// Account endpoint with FIPS and DualStack disabled
    #[test]
    fn test_99() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// RegionMismatch: client region should be used for endpoint region
    #[test]
    fn test_100() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws:kinesis:us-west-1:123:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Account endpoint with FIPS enabled
    #[test]
    fn test_101() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn")
                .build()
        );
    }

    /// Account endpoint with FIPS and DualStack enabled for cn regions.
    #[test]
    fn test_102() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_103() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_104() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws-iso:kinesis:us-iso-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-west-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-west-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint targeting data operation type in ADC regions
    #[test]
    fn test_105() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// Account endpoint with fips targeting control operation type in ADC regions
    #[test]
    fn test_106() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .consumer_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// Account endpoint with fips targeting data operation type in ADC regions
    #[test]
    fn test_107() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// ConsumerARN targeting US-EAST-1
    #[test]
    fn test_108() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123456789123:stream/foobar/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123456789123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123456789123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// Both StreamARN and ConsumerARN specified. StreamARN should take precedence
    #[test]
    fn test_109() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .stream_arn("arn:aws:kinesis:us-east-1:123:stream/foobar".to_string())
            .consumer_arn("arn:aws:kinesis:us-east-1:123456789123:stream/foobar/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN test: Invalid ARN: Failed to parse ARN.
    #[test]
    fn test_110() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Failed to parse ARN. [ResourceARN test: Invalid ARN: Failed to parse ARN.]");
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: partition missing from ARN.
    #[test]
    fn test_111() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn::kinesis:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Invalid ARN: Failed to parse ARN. [ResourceARN as StreamARN test: Invalid ARN: partition missing from ARN.]",
        );
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: partitions mismatch.
    #[test]
    fn test_112() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition: aws from ARN doesn't match with partition name: aws-us-gov. [ResourceARN as StreamARN test: Invalid ARN: partitions mismatch.]");
        assert_eq!(
            format!("{}", error),
            "Partition: aws from ARN doesn't match with partition name: aws-us-gov."
        )
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Not Kinesis
    #[test]
    fn test_113() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:s3:us-west-2:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The ARN was not for the Kinesis service, found: s3. [ResourceARN as StreamARN test: Invalid ARN: Not Kinesis]");
        assert_eq!(format!("{}", error), "Invalid ARN: The ARN was not for the Kinesis service, found: s3.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Region is missing in ARN
    #[test]
    fn test_114() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis::123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid region. [ResourceARN as StreamARN test: Invalid ARN: Region is missing in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Region is empty string in ARN
    #[test]
    fn test_115() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:  :123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid region. [ResourceARN as StreamARN test: Invalid ARN: Region is empty string in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Invalid account id
    #[test]
    fn test_116() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1::stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [ResourceARN as StreamARN test: Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Invalid account id
    #[test]
    fn test_117() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:   :stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error =
            endpoint.expect_err("expected error: Invalid ARN: Invalid account id. [ResourceARN as StreamARN test: Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// ResourceARN as StreamARN test: Invalid ARN: Kinesis ARNs only support stream arn types
    #[test]
    fn test_118() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:123:accesspoint/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types. [ResourceARN as StreamARN test: Invalid ARN: Kinesis ARNs only support stream arn types]");
        assert_eq!(format!("{}", error), "Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types.")
    }

    /// ResourceARN as StreamARN test: Dual Stack not supported region.
    #[test]
    fn test_119() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .resource_arn("arn:aws-iso:kinesis:us-iso-west-1:123456789012:stream/testStream".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [ResourceARN as StreamARN test: Dual Stack not supported region.]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// ResourceARN as StreamARN test: OperationType not set
    #[test]
    fn test_120() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:123456789012:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Operation Type is not set. Please contact service team for resolution. [ResourceARN as StreamARN test: OperationType not set]");
        assert_eq!(
            format!("{}", error),
            "Operation Type is not set. Please contact service team for resolution."
        )
    }

    /// ResourceARN as StreamARN test: Custom Endpoint is specified
    #[test]
    fn test_121() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint targeting control operation type
    #[test]
    fn test_122() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint targeting data operation type
    #[test]
    fn test_123() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with fips targeting data operation type
    #[test]
    fn test_124() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with fips targeting control operation type
    #[test]
    fn test_125() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with Dual Stack and FIPS enabled
    #[test]
    fn test_126() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with Dual Stack enabled
    #[test]
    fn test_127() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-west-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-west-1.api.aws")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with FIPS and DualStack disabled
    #[test]
    fn test_128() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: RegionMismatch: client region should be used for endpoint region
    #[test]
    fn test_129() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/testStream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with FIPS enabled
    #[test]
    fn test_130() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with FIPS and DualStack enabled for cn regions.
    #[test]
    fn test_131() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_132() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_133() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-west-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-west-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-west-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint targeting data operation type in ADC regions
    #[test]
    fn test_134() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with fips targeting control operation type in ADC regions
    #[test]
    fn test_135() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as StreamARN test: Account endpoint with fips targeting data operation type in ADC regions
    #[test]
    fn test_136() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: partition missing from ARN.
    #[test]
    fn test_137() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn::kinesis:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err(
            "expected error: Invalid ARN: Failed to parse ARN. [ResourceARN as ConsumerARN test: Invalid ARN: partition missing from ARN.]",
        );
        assert_eq!(format!("{}", error), "Invalid ARN: Failed to parse ARN.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: partitions mismatch.
    #[test]
    fn test_138() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Partition: aws from ARN doesn't match with partition name: aws-us-gov. [ResourceARN as ConsumerARN test: Invalid ARN: partitions mismatch.]");
        assert_eq!(
            format!("{}", error),
            "Partition: aws from ARN doesn't match with partition name: aws-us-gov."
        )
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Not Kinesis
    #[test]
    fn test_139() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:s3:us-west-2:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: The ARN was not for the Kinesis service, found: s3. [ResourceARN as ConsumerARN test: Invalid ARN: Not Kinesis]");
        assert_eq!(format!("{}", error), "Invalid ARN: The ARN was not for the Kinesis service, found: s3.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Region is missing in ARN
    #[test]
    fn test_140() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis::123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid region. [ResourceARN as ConsumerARN test: Invalid ARN: Region is missing in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Region is empty string in ARN
    #[test]
    fn test_141() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:  :123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid region. [ResourceARN as ConsumerARN test: Invalid ARN: Region is empty string in ARN]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid region.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Invalid account id
    #[test]
    fn test_142() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1::stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid account id. [ResourceARN as ConsumerARN test: Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Invalid account id
    #[test]
    fn test_143() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:   :stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint
            .expect_err("expected error: Invalid ARN: Invalid account id. [ResourceARN as ConsumerARN test: Invalid ARN: Invalid account id]");
        assert_eq!(format!("{}", error), "Invalid ARN: Invalid account id.")
    }

    /// ResourceARN as ConsumerARN test: Invalid ARN: Kinesis ARNs only support stream arn/consumer arn types
    #[test]
    fn test_144() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:123:accesspoint/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types. [ResourceARN as ConsumerARN test: Invalid ARN: Kinesis ARNs only support stream arn/consumer arn types]");
        assert_eq!(format!("{}", error), "Invalid ARN: Kinesis ARNs don't support `accesspoint` arn types.")
    }

    /// ResourceARN as ConsumerARN test: Dual Stack not supported region.
    #[test]
    fn test_145() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .resource_arn("arn:aws-iso:kinesis:us-iso-west-1:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .operation_type("control".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [ResourceARN as ConsumerARN test: Dual Stack not supported region.]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// ResourceARN as ConsumerARN test: OperationType not set
    #[test]
    fn test_146() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .resource_arn("arn:aws:kinesis:us-east-1:123456789012:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Operation Type is not set. Please contact service team for resolution. [ResourceARN as ConsumerARN test: OperationType not set]");
        assert_eq!(
            format!("{}", error),
            "Operation Type is not set. Please contact service team for resolution."
        )
    }

    /// ResourceARN as ConsumerARN test: Custom Endpoint is specified
    #[test]
    fn test_147() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint targeting control operation type
    #[test]
    fn test_148() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint targeting data operation type
    #[test]
    fn test_149() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with fips targeting data operation type
    #[test]
    fn test_150() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with fips targeting control operation type
    #[test]
    fn test_151() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with Dual Stack and FIPS enabled
    #[test]
    fn test_152() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with Dual Stack enabled
    #[test]
    fn test_153() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-west-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-west-1.api.aws")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with FIPS and DualStack disabled
    #[test]
    fn test_154() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.control-kinesis.us-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.control-kinesis.us-west-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: RegionMismatch: client region should be used for endpoint region
    #[test]
    fn test_155() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws:kinesis:us-west-1:123:stream/testStream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with FIPS enabled
    #[test]
    fn test_156() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.amazonaws.com.cn")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with FIPS and DualStack enabled for cn regions.
    #[test]
    fn test_157() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-northwest-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-cn:kinesis:cn-northwest-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://123.data-kinesis-fips.cn-northwest-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_158() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint targeting control operation type in ADC regions
    #[test]
    fn test_159() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-west-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-iso-west-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-iso-west-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint targeting data operation type in ADC regions
    #[test]
    fn test_160() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with fips targeting control operation type in ADC regions
    #[test]
    fn test_161() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("control".to_string())
            .resource_arn("arn:aws-iso:kinesis:us-iso-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// ResourceARN as ConsumerARN test: Account endpoint with fips targeting data operation type in ADC regions
    #[test]
    fn test_162() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .operation_type("data".to_string())
            .resource_arn("arn:aws-iso-b:kinesis:us-isob-east-1:123:stream/test-stream/consumer/test-consumer:1525898737".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://kinesis-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }
}

/// Endpoint resolver trait specific to Amazon Kinesis
pub trait ResolveEndpoint: ::std::marker::Send + ::std::marker::Sync + ::std::fmt::Debug {
    /// Resolve an endpoint with the given parameters
    fn resolve_endpoint<'a>(&'a self, params: &'a crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a>;

    /// Convert this service-specific resolver into a `SharedEndpointResolver`
    ///
    /// The resulting resolver will downcast `EndpointResolverParams` into `crate::config::endpoint::Params`.
    fn into_shared_resolver(self) -> ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver
    where
        Self: Sized + 'static,
    {
        ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver::new(DowncastParams(self))
    }
}

#[derive(Debug)]
struct DowncastParams<T>(T);
impl<T> ::aws_smithy_runtime_api::client::endpoint::ResolveEndpoint for DowncastParams<T>
where
    T: ResolveEndpoint,
{
    fn resolve_endpoint<'a>(
        &'a self,
        params: &'a ::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams,
    ) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a> {
        let ep = match params.get::<crate::config::endpoint::Params>() {
            Some(params) => self.0.resolve_endpoint(params),
            None => ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(Err("params of expected type was not present".into())),
        };
        ep
    }
}

/// The default endpoint resolver
#[derive(Debug, Default)]
pub struct DefaultResolver {
    partition_resolver: crate::endpoint_lib::partition::PartitionResolver,
}

impl DefaultResolver {
    /// Create a new endpoint resolver with default settings
    pub fn new() -> Self {
        Self {
            partition_resolver: crate::endpoint_lib::DEFAULT_PARTITION_RESOLVER.clone(),
        }
    }

    fn resolve_endpoint(
        &self,
        params: &crate::config::endpoint::Params,
    ) -> ::std::result::Result<::aws_smithy_types::endpoint::Endpoint, ::aws_smithy_runtime_api::box_error::BoxError> {
        let mut diagnostic_collector = crate::endpoint_lib::diagnostic::DiagnosticCollector::new();
        Ok(
            crate::config::endpoint::internals::resolve_endpoint(params, &mut diagnostic_collector, &self.partition_resolver)
                .map_err(|err| err.with_source(diagnostic_collector.take_last_error()))?,
        )
    }
}

impl crate::config::endpoint::ResolveEndpoint for DefaultResolver {
    fn resolve_endpoint(&self, params: &crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture {
        ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(self.resolve_endpoint(params))
    }
}

#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
/// Configuration parameters for resolving the correct endpoint
pub struct Params {
    /// The AWS region used to dispatch the request.
    pub(crate) region: ::std::option::Option<::std::string::String>,
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub(crate) use_dual_stack: bool,
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub(crate) use_fips: bool,
    /// Override the endpoint used to send this request
    pub(crate) endpoint: ::std::option::Option<::std::string::String>,
    /// The ARN of the Kinesis stream
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    /// Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
    pub(crate) operation_type: ::std::option::Option<::std::string::String>,
    /// The ARN of the Kinesis consumer
    pub(crate) consumer_arn: ::std::option::Option<::std::string::String>,
    /// The ARN of the Kinesis resource
    pub(crate) resource_arn: ::std::option::Option<::std::string::String>,
}
impl Params {
    /// Create a builder for [`Params`]
    pub fn builder() -> crate::config::endpoint::ParamsBuilder {
        crate::config::endpoint::ParamsBuilder::default()
    }
    /// The AWS region used to dispatch the request.
    pub fn region(&self) -> ::std::option::Option<&str> {
        self.region.as_deref()
    }
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(&self) -> ::std::option::Option<bool> {
        Some(self.use_dual_stack)
    }
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(&self) -> ::std::option::Option<bool> {
        Some(self.use_fips)
    }
    /// Override the endpoint used to send this request
    pub fn endpoint(&self) -> ::std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// The ARN of the Kinesis stream
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
    pub fn operation_type(&self) -> ::std::option::Option<&str> {
        self.operation_type.as_deref()
    }
    /// The ARN of the Kinesis consumer
    pub fn consumer_arn(&self) -> ::std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
    /// The ARN of the Kinesis resource
    pub fn resource_arn(&self) -> ::std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}

/// Builder for [`Params`]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ParamsBuilder {
    region: ::std::option::Option<::std::string::String>,
    use_dual_stack: ::std::option::Option<bool>,
    use_fips: ::std::option::Option<bool>,
    endpoint: ::std::option::Option<::std::string::String>,
    stream_arn: ::std::option::Option<::std::string::String>,
    operation_type: ::std::option::Option<::std::string::String>,
    consumer_arn: ::std::option::Option<::std::string::String>,
    resource_arn: ::std::option::Option<::std::string::String>,
}
impl ParamsBuilder {
    /// Consume this builder, creating [`Params`].
    pub fn build(self) -> ::std::result::Result<crate::config::endpoint::Params, crate::config::endpoint::InvalidParams> {
        Ok(
            #[allow(clippy::unnecessary_lazy_evaluations)]
            crate::config::endpoint::Params {
                region: self.region,
                use_dual_stack: self
                    .use_dual_stack
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_dual_stack"))?,
                use_fips: self
                    .use_fips
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_fips"))?,
                endpoint: self.endpoint,
                stream_arn: self.stream_arn,
                operation_type: self.operation_type,
                consumer_arn: self.consumer_arn,
                resource_arn: self.resource_arn,
            },
        )
    }
    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn region(mut self, value: impl Into<::std::string::String>) -> Self {
        self.region = Some(value.into());
        self
    }

    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn set_region(mut self, param: Option<::std::string::String>) -> Self {
        self.region = param;
        self
    }
    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(mut self, value: impl Into<bool>) -> Self {
        self.use_dual_stack = Some(value.into());
        self
    }

    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn set_use_dual_stack(mut self, param: Option<bool>) -> Self {
        self.use_dual_stack = param;
        self
    }
    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(mut self, value: impl Into<bool>) -> Self {
        self.use_fips = Some(value.into());
        self
    }

    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn set_use_fips(mut self, param: Option<bool>) -> Self {
        self.use_fips = param;
        self
    }
    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn endpoint(mut self, value: impl Into<::std::string::String>) -> Self {
        self.endpoint = Some(value.into());
        self
    }

    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn set_endpoint(mut self, param: Option<::std::string::String>) -> Self {
        self.endpoint = param;
        self
    }
    /// Sets the value for stream_arn
    ///
    /// The ARN of the Kinesis stream
    pub fn stream_arn(mut self, value: impl Into<::std::string::String>) -> Self {
        self.stream_arn = Some(value.into());
        self
    }

    /// Sets the value for stream_arn
    ///
    /// The ARN of the Kinesis stream
    pub fn set_stream_arn(mut self, param: Option<::std::string::String>) -> Self {
        self.stream_arn = param;
        self
    }
    /// Sets the value for operation_type
    ///
    /// Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
    pub fn operation_type(mut self, value: impl Into<::std::string::String>) -> Self {
        self.operation_type = Some(value.into());
        self
    }

    /// Sets the value for operation_type
    ///
    /// Internal parameter to distinguish between Control/Data plane API and accordingly generate control/data plane endpoint
    pub fn set_operation_type(mut self, param: Option<::std::string::String>) -> Self {
        self.operation_type = param;
        self
    }
    /// Sets the value for consumer_arn
    ///
    /// The ARN of the Kinesis consumer
    pub fn consumer_arn(mut self, value: impl Into<::std::string::String>) -> Self {
        self.consumer_arn = Some(value.into());
        self
    }

    /// Sets the value for consumer_arn
    ///
    /// The ARN of the Kinesis consumer
    pub fn set_consumer_arn(mut self, param: Option<::std::string::String>) -> Self {
        self.consumer_arn = param;
        self
    }
    /// Sets the value for resource_arn
    ///
    /// The ARN of the Kinesis resource
    pub fn resource_arn(mut self, value: impl Into<::std::string::String>) -> Self {
        self.resource_arn = Some(value.into());
        self
    }

    /// Sets the value for resource_arn
    ///
    /// The ARN of the Kinesis resource
    pub fn set_resource_arn(mut self, param: Option<::std::string::String>) -> Self {
        self.resource_arn = param;
        self
    }
}

/// An error that occurred during endpoint resolution
#[derive(Debug)]
pub struct InvalidParams {
    field: std::borrow::Cow<'static, str>,
}

impl InvalidParams {
    #[allow(dead_code)]
    fn missing(field: &'static str) -> Self {
        Self { field: field.into() }
    }
}

impl std::fmt::Display for InvalidParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "a required field was missing: `{}`", self.field)
    }
}

impl std::error::Error for InvalidParams {}

mod internals;
