/*
**  ClanLib SDK
**  Copyright (c) 1997-2011 The ClanLib Team
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
**  Note: Some of the libraries ClanLib may link to may have additional
**  requirements or restrictions.
**
**  File Author(s):
**
**    Magnus Norddahl
*/

#pragma once

class CL_JPEGQuantizationTable
{
public:
	CL_JPEGQuantizationTable() : table_index(0) { for (int i = 0; i < 64; i++) values[i] = 0; }

	// Specifies one of four possible destinations at the decoder into which the quantization table shall be installed.
	cl_ubyte8 table_index;

	// Quantization element values in zig-zag scan order.
	cl_ubyte16 values[64];
};

typedef std::vector<CL_JPEGQuantizationTable> CL_JPEGDefineQuantizationTable;
