## RabbitMQ 3.7.16

RabbitMQ `3.7.16` is a maintenance release. It focuses on bug fixes and minor usability improvements.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### OpenSUSE Leap 42.3 Support Dropped

OpenSUSE Leap 42.3 has [gone out of support on July 1st](https://en.opensuse.org/Lifetime), 2019. Packages for
that distribution are therefore no longer produced because upstream OpenSUSE repositories are no longer
available.

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * When a node hosting an exclusive queue was restarted with queue leader locator being something other than
   "node local", redeclaration of the queue failed.

   Contributed by Lajos Gerecs.

   GitHub issue: [rabbitmq/rabbitmq-server#2039](https://github.com/rabbitmq/rabbitmq-server/issues/2039)

#### Enhancements

 * It is now possible to configure default worker pool size:

   ``` ini
   default_worker_pool_size = 1024
   ```

   This may be necessary in environments with a large number of queues (say, hundreds of thousands)
   to speed up queue and binding recovery on node boot. By default the size of the pool is
   computed as the number of [available runtime schedulers](https://www.rabbitmq.com/runtime.html).

   GitHub issue: [rabbitmq/rabbitmq-server#2030](https://github.com/rabbitmq/rabbitmq-server/issues/2030)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl report` and `rabbitmqctl list_queues` could fail with a `{bad_argument,type}` because of a 3.8-specific column was erroneously listed as supported.

   Contributed by Lajos Gerecs.

   GitHub issue: [rabbitmq/rabbitmq-cli#354](https://github.com/rabbitmq/rabbitmq-cli/pull/354)

#### Enhancements

 * New health check: `rabbitmq-diagnostics check_virtual_hosts`.

   [rabbitmq/rabbitmq-cli#302](https://github.com/rabbitmq/rabbitmq-cli/issues/302)

 * New observability command, `rabbitmq-diagnostics log_location [--all]`, displays log file location(s)
   on target node. The node is assumed to be running.

   GitHub issue: [rabbitmq/rabbitmq-cli#325](https://github.com/rabbitmq/rabbitmq-cli/issues/325)

 * New observability commands, `rabbitmq-diagnostics log_tail` and `rabbitmq-diagnostics log_tail_stream`,
   provide a way to remotely inspect recent log file entries on a running node. The commands are meant
   to be used for troubleshooting and not to automate log aggregation.

   GitHub issue: [rabbitmq/rabbitmq-cli#326](https://github.com/rabbitmq/rabbitmq-cli/issues/326)

 * `rabbitmq-diagnostics schema_info` displays information about internal database schema
   (tables, their properties and metadata).

   [rabbitmq/rabbitmq-cli#330](https://github.com/rabbitmq/rabbitmq-cli/issues/330)


### Management Plugin

#### Bug Fixes

 * When multiple definition files were [imported on node boot](https://www.rabbitmq.com/management.html#load-definitions), errors were not reported
   the same way they would be with a single file.

   GitHub issue: [rabbitmq/rabbitmq-management#710](https://github.com/rabbitmq/rabbitmq-management/pull/710)

#### Enhancements

 * The plugin now disables [client inactivity timeout](https://www.rabbitmq.com/management.html#advanced-options) for the definition import endpoints and reports
   progress using periodic [`102 Processing` responses](https://httpstatuses.com/102) so that the connection is kept alive even if importing
   definition takes a long time.

   GitHub issue: [rabbitmq/rabbitmq-management#711](https://github.com/rabbitmq/rabbitmq-management/pull/711)


### Shovel Plugin

#### Bug Fixes

 * `3.7.15` introduced a regression where Shovels would not try to reconnect after a network
   failure.

   GitHub issue: [rabbitmq/rabbitmq-shovel#60](https://github.com/rabbitmq/rabbitmq-shovel/issues/60)


### Web MQTT Plugin

#### Bug Fixes

 * Default maximum connection limit set by a dependency (1024) has been lifted.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#55](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/55)

 * Client ID wasn't propagated to connection metadata for MQTT connections over WebSockets.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#57](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/57)


### Web STOMP Plugin

#### Bug Fixes

 * Default maximum connection limit set by a dependency (1024) has been lifted.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#113](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/113)


### Trust Store Plugin

#### Enhancements

 * It is now possiible to configure HTTPS proxy settings for the HTTPS backend.

   GitHub issue: [rabbitmq/rabbitmq-trust-store#69](https://github.com/rabbitmq/rabbitmq-trust-store/issues/69)


### Debian Package

#### Bug Fixes

 * Exit code 69 is now considered a success again in the systemd service file.

   GitHub issues: [rabbitmq/rabbitmq-server-release#104](https://github.com/rabbitmq/rabbitmq-server-release/pull/104), [rabbitmq/rabbitmq-server-release#51](https://github.com/rabbitmq/rabbitmq-server-release/issues/51)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.16.tar.xz`.
