/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.CharSetEnumerator;

public final class CharSet {
    static final int BITS = 6;
    static final int MOD = 63;
    long[] bits;
    private int numElements;

    public CharSet() {
        this.bits = new long[1];
    }

    public CharSet(int n, int n2) {
        this.bits = new long[(n >> 6) + 1];
        this.add(n2);
    }

    public void add(int n) {
        this.resize(n);
        if ((this.bits[n >> 6] & 1L << (n & 0x3F)) == 0L) {
            ++this.numElements;
        }
        int n2 = n >> 6;
        this.bits[n2] = this.bits[n2] | 1L << (n & 0x3F);
    }

    private int nbits2size(int n) {
        return (n >> 6) + 1;
    }

    private void resize(int n) {
        int n2 = this.nbits2size(n);
        if (n2 < this.bits.length) {
            return;
        }
        long[] lArray = new long[Math.max(this.bits.length * 2, n2)];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public boolean isElement(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & 1L << (n & 0x3F)) != 0L;
    }

    public CharSetEnumerator characters() {
        return new CharSetEnumerator(this);
    }

    public boolean containsElements() {
        return this.numElements > 0;
    }

    public int size() {
        return this.numElements;
    }

    public String toString() {
        CharSetEnumerator charSetEnumerator = this.characters();
        StringBuffer stringBuffer = new StringBuffer("{");
        if (charSetEnumerator.hasMoreElements()) {
            stringBuffer.append("" + charSetEnumerator.nextElement());
        }
        while (charSetEnumerator.hasMoreElements()) {
            int n = charSetEnumerator.nextElement();
            stringBuffer.append(", " + n);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

