// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Auto generated by tools/codegen/core/gen_experiments.py
//
// This file contains the autogenerated parts of the experiments API.
//
// It generates two symbols for each experiment.
//
// For the experiment named new_car_project, it generates:
//
// - a function IsNewCarProjectEnabled() that returns true if the experiment
//   should be enabled at runtime.
//
// - a macro GRPC_EXPERIMENT_IS_INCLUDED_NEW_CAR_PROJECT that is defined if the
//   experiment *could* be enabled at runtime.
//
// The function is used to determine whether to run the experiment or
// non-experiment code path.
//
// If the experiment brings significant bloat, the macro can be used to avoid
// including the experiment code path in the binary for binaries that are size
// sensitive.
//
// By default that includes our iOS and Android builds.
//
// Finally, a small array is included that contains the metadata for each
// experiment.
//
// A macro, GRPC_EXPERIMENTS_ARE_FINAL, controls whether we fix experiment
// configuration at build time (if it's defined) or allow it to be tuned at
// runtime (if it's disabled).
//
// If you are using the Bazel build system, that macro can be configured with
// --define=grpc_experiments_are_final=true

#ifndef GRPC_TEST_CORE_EXPERIMENTS_FIXTURES_EXPERIMENTS_H
#define GRPC_TEST_CORE_EXPERIMENTS_FIXTURES_EXPERIMENTS_H

#include <grpc/support/port_platform.h>

#include <stddef.h>

#include "src/core/lib/experiments/config.h"

namespace grpc_core {

#ifdef GRPC_EXPERIMENTS_ARE_FINAL

#if defined(GRPC_CFSTREAM)
inline bool IsTestExperiment1Enabled() { return false; }
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_2
inline bool IsTestExperiment2Enabled() { return true; }
#ifndef NDEBUG
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_3
#endif
inline bool IsTestExperiment3Enabled() {
#ifdef NDEBUG
  return false;
#else
  return true;
#endif
}
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_4
inline bool IsTestExperiment4Enabled() { return true; }

#elif defined(GPR_WINDOWS)
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_1
inline bool IsTestExperiment1Enabled() { return true; }
inline bool IsTestExperiment2Enabled() { return false; }
#ifndef NDEBUG
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_3
#endif
inline bool IsTestExperiment3Enabled() {
#ifdef NDEBUG
  return false;
#else
  return true;
#endif
}
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_4
inline bool IsTestExperiment4Enabled() { return true; }

#else
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_1
inline bool IsTestExperiment1Enabled() { return true; }
#ifndef NDEBUG
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_2
#endif
inline bool IsTestExperiment2Enabled() {
#ifdef NDEBUG
  return false;
#else
  return true;
#endif
}
#ifndef NDEBUG
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_3
#endif
inline bool IsTestExperiment3Enabled() {
#ifdef NDEBUG
  return false;
#else
  return true;
#endif
}
inline bool IsTestExperiment4Enabled() { return false; }
#endif

#else
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_1
inline bool IsTestExperiment1Enabled() { return IsTestExperimentEnabled(0); }
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_2
inline bool IsTestExperiment2Enabled() { return IsTestExperimentEnabled(1); }
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_3
inline bool IsTestExperiment3Enabled() { return IsTestExperimentEnabled(2); }
#define GRPC_EXPERIMENT_IS_INCLUDED_TEST_EXPERIMENT_4
inline bool IsTestExperiment4Enabled() { return IsTestExperimentEnabled(3); }

constexpr const size_t kNumTestExperiments = 4;
extern const ExperimentMetadata g_test_experiment_metadata[kNumTestExperiments];

#endif
}  // namespace grpc_core

#endif  // GRPC_TEST_CORE_EXPERIMENTS_FIXTURES_EXPERIMENTS_H
