/* Piper - the Swiss Army Knife of SOCKS/WinGate manipulation
 * Written by gcc@i.am (Chris Wilson) 16.1.99
 *
 * RCS ChangeLog:
 * $Log: piper.h,v $
 * Revision 1.3  2001/07/20 18:24:19  chris
 * Added bouncer support (finally!)
 * More generic multiplex code (re-used by bouncer)
 *
 * Revision 1.2  1999/01/18 23:01:59  chris
 * Added <sys/wait.h> for usleep()
 * Removed <timebits.h> because it was unnecessary and unportable
 * Added definitions for more functions
 *
 * Revision 1.1  1999/01/18 14:14:38  chris
 * Initial revision
 *
 */

#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <resolv.h>
#include <netdb.h>
#include <termios.h>
#include <utime.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <arpa/inet.h>

void usage();
void version();

u_long resolve(char* host);
void sig_timeout(int signum);
void sig_die(int signum);
void split_host_port(char* hostport, char* hostbuf, int* portbuf,
                     char* defhost, int defport);
char* socks_error(int errnum);

void chomp(char* str);

char** readhostlist(char* hostfile);
void   freehostlist(char** hostlist);
int    counthostlist(char** hostlist);
char** makehostlist(char* host);
char*  nexthost(char*** ptr, char** list);

int makeintlist(char* intspec, int** intlist);
int readservices(int** portlist);

int socks_connect(char* wingate, char* remotehost, int remoteport,
		  int verbose, int timeout);
int socks_connect_socket(char* wingate, char* remotehost, int remoteport,
                         int verbose, int timeout, int sock);

void multiplex_con(int sock);
void multiplex_con_2(int insock, int outsock);

void socks_test       (int argc, char** argv);
void socks_investigate(int argc, char** argv);
void socks_portscan   (int argc, char** argv);
void socks_bouncer    (int argc, char** argv);
void conn             (int argc, char** argv);

int testhost(char* server, char* host, int port, int verbose, int timeout);
int investigate_host(char* wingate, char* host, int port, int verbose);
int portscan(char* server, char* host, int port, int verbose);

// Verbosity modes
/* No output at all */                  #define V_NONE 0
/* Errors only */                       #define V_ERR  1
/* All output (verbose) */              #define V_ALL  3
/* Special mode for test function */    #define V_TEST -1

// Additional errors
/* Can't get socket */                  #define ESOCK    1000
/* Can't resolve address */             #define ERESOLV  1001
/* Connection failed */                 #define EFAIL    1002
/* Connection refused */                #define ECLOSED  1003
/* Connection timed out */		#define ETIMEOUT 1004

/* Module succeeded */                  #define ST_OK      1
/* Module failed */                     #define ST_FAIL    0
/* Module result unknown */             #define ST_UNKNOWN -1

struct connection {
  char* wingate;
  char* host;
  int port;
  struct sockaddr_in wg_addr; /* used by socks_multicon */
  struct sockaddr_in rh_addr; /* used by socks_multicon */
  int socket; /* also contains status values, if socket < 0 */
};
