// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5

// RUN: %clang_cc1 -O1 -triple spirv-pc-vulkan-compute %s -emit-llvm -o - | FileCheck %s

typedef _Float16 half;
typedef half half2 __attribute__((ext_vector_type(2)));
typedef half half3 __attribute__((ext_vector_type(3)));
typedef half half4 __attribute__((ext_vector_type(4)));
typedef float float2 __attribute__((ext_vector_type(2)));
typedef float float3 __attribute__((ext_vector_type(3)));
typedef float float4 __attribute__((ext_vector_type(4)));

// CHECK-LABEL: define spir_func half @test_faceforward_half(
// CHECK-SAME: half noundef [[N:%.*]], half noundef [[I:%.*]], half noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call half @llvm.spv.faceforward.f16(half [[N]], half [[I]], half [[NG]])
// CHECK-NEXT:    ret half [[SPV_FACEFORWARD]]
half test_faceforward_half(half N, half I, half Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <2 x half> @test_faceforward_half2(
// CHECK-SAME: <2 x half> noundef [[N:%.*]], <2 x half> noundef [[I:%.*]], <2 x half> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <2 x half> @llvm.spv.faceforward.v2f16(<2 x half> [[N]], <2 x half> [[I]], <2 x half> [[NG]])
// CHECK-NEXT:    ret <2 x half> [[SPV_FACEFORWARD]]
half2 test_faceforward_half2(half2 N, half2 I, half2 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <3 x half> @test_faceforward_half3(
// CHECK-SAME: <3 x half> noundef [[N:%.*]], <3 x half> noundef [[I:%.*]], <3 x half> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <3 x half> @llvm.spv.faceforward.v3f16(<3 x half> [[N]], <3 x half> [[I]], <3 x half> [[NG]])
// CHECK-NEXT:    ret <3 x half> [[SPV_FACEFORWARD]]
half3 test_faceforward_half3(half3 N, half3 I, half3 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <4 x half> @test_faceforward_half4(
// CHECK-SAME: <4 x half> noundef [[N:%.*]], <4 x half> noundef [[I:%.*]], <4 x half> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <4 x half> @llvm.spv.faceforward.v4f16(<4 x half> [[N]], <4 x half> [[I]], <4 x half> [[NG]])
// CHECK-NEXT:    ret <4 x half> [[SPV_FACEFORWARD]]
half4 test_faceforward_half4(half4 N, half4 I, half4 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func float @test_faceforward_float(
// CHECK-SAME: float noundef [[N:%.*]], float noundef [[I:%.*]], float noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call float @llvm.spv.faceforward.f32(float [[N]], float [[I]], float [[NG]])
// CHECK-NEXT:    ret float [[SPV_FACEFORWARD]]
float test_faceforward_float(float N, float I, float Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <2 x float> @test_faceforward_float2(
// CHECK-SAME: <2 x float> noundef [[N:%.*]], <2 x float> noundef [[I:%.*]], <2 x float> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <2 x float> @llvm.spv.faceforward.v2f32(<2 x float> [[N]], <2 x float> [[I]], <2 x float> [[NG]])
// CHECK-NEXT:    ret <2 x float> [[SPV_FACEFORWARD]]
float2 test_faceforward_float2(float2 N, float2 I, float2 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <3 x float> @test_faceforward_float3(
// CHECK-SAME: <3 x float> noundef [[N:%.*]], <3 x float> noundef [[I:%.*]], <3 x float> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <3 x float> @llvm.spv.faceforward.v3f32(<3 x float> [[N]], <3 x float> [[I]], <3 x float> [[NG]])
// CHECK-NEXT:    ret <3 x float> [[SPV_FACEFORWARD]]
float3 test_faceforward_float3(float3 N, float3 I, float3 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }

// CHECK-LABEL: define spir_func <4 x float> @test_faceforward_float4(
// CHECK-SAME: <4 x float> noundef [[N:%.*]], <4 x float> noundef [[I:%.*]], <4 x float> noundef [[NG:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SPV_FACEFORWARD:%.*]] = tail call <4 x float> @llvm.spv.faceforward.v4f32(<4 x float> [[N]], <4 x float> [[I]], <4 x float> [[NG]])
// CHECK-NEXT:    ret <4 x float> [[SPV_FACEFORWARD]]
float4 test_faceforward_float4(float4 N, float4 I, float4 Ng) { return __builtin_spirv_faceforward(N, I, Ng); }
