/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionParameterBuilder;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.types.util.UnitUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ActionInputsHelper.class})
public class ActionInputsHelper {
    private static final Pattern QUANTITY_TYPE_PATTERN = Pattern.compile("([a-z0-9]+\\.)*QuantityType<([a-z0-9]+\\.)*(?<dimension>[A-Z][a-zA-Z0-9]*)>");
    private final Logger logger = LoggerFactory.getLogger(ActionInputsHelper.class);
    private final TimeZoneProvider timeZoneProvider;
    private final UnitProvider unitProvider;

    @Activate
    public ActionInputsHelper(@Reference TimeZoneProvider timeZoneProvider, @Reference UnitProvider unitProvider) {
        this.timeZoneProvider = timeZoneProvider;
        this.unitProvider = unitProvider;
    }

    public List<ConfigDescriptionParameter> mapActionInputsToConfigDescriptionParameters(List<Input> inputs) throws IllegalArgumentException {
        ArrayList<ConfigDescriptionParameter> configDescriptionParameters = new ArrayList<ConfigDescriptionParameter>();
        for (Input input : inputs) {
            configDescriptionParameters.add(this.mapActionInputToConfigDescriptionParameter(input));
        }
        return configDescriptionParameters;
    }

    public ConfigDescriptionParameter mapActionInputToConfigDescriptionParameter(Input input) throws IllegalArgumentException {
        ConfigDescriptionParameter.Type parameterType = ConfigDescriptionParameter.Type.TEXT;
        String defaultValue = null;
        Unit<?> unit = null;
        boolean required = false;
        String context = null;
        BigDecimal step = null;
        Matcher matcher = QUANTITY_TYPE_PATTERN.matcher(input.getType());
        if (matcher.matches()) {
            parameterType = ConfigDescriptionParameter.Type.DECIMAL;
            step = BigDecimal.ZERO;
            try {
                unit = this.getDefaultUnit(matcher.group("dimension"));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Input parameter '" + input.getName() + "' with type " + input.getType() + "cannot be converted into a config description parameter!", e);
            }
        }
        switch (input.getType()) {
            case "boolean": {
                defaultValue = "false";
                required = true;
            }
            case "java.lang.Boolean": {
                parameterType = ConfigDescriptionParameter.Type.BOOLEAN;
                break;
            }
            case "int": 
            case "byte": 
            case "long": 
            case "short": {
                defaultValue = "0";
                required = true;
            }
            case "java.lang.Integer": 
            case "java.lang.Short": 
            case "java.lang.Byte": 
            case "java.lang.Long": {
                parameterType = ConfigDescriptionParameter.Type.INTEGER;
                break;
            }
            case "double": 
            case "float": {
                defaultValue = "0";
                required = true;
            }
            case "org.openhab.core.library.types.DecimalType": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.lang.Number": {
                parameterType = ConfigDescriptionParameter.Type.DECIMAL;
                step = BigDecimal.ZERO;
                break;
            }
            case "java.time.LocalDate": {
                context = "date";
                break;
            }
            case "java.time.LocalTime": {
                context = "time";
                step = BigDecimal.ONE;
                break;
            }
            case "java.time.LocalDateTime": 
            case "java.util.Date": 
            case "java.time.Instant": 
            case "java.time.ZonedDateTime": {
                context = "datetime";
                step = BigDecimal.ONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Input parameter '" + input.getName() + "' with type " + input.getType() + "cannot be converted into a config description parameter!");
            }
            case "java.time.Duration": 
            case "java.lang.String": 
        }
        ConfigDescriptionParameterBuilder builder = ConfigDescriptionParameterBuilder.create((String)input.getName(), (ConfigDescriptionParameter.Type)parameterType).withLabel(input.getLabel()).withDescription(input.getDescription()).withReadOnly(Boolean.valueOf(false)).withRequired(Boolean.valueOf(required || input.isRequired())).withContext(context);
        if (input.getDefaultValue() != null && !input.getDefaultValue().isEmpty()) {
            builder = builder.withDefault(input.getDefaultValue());
        } else if (defaultValue != null) {
            builder = builder.withDefault(defaultValue);
        }
        if (unit != null) {
            builder = builder.withUnit(unit.getSymbol());
        }
        if (step != null) {
            builder = builder.withStepSize(step);
        }
        return builder.build();
    }

    public Map<String, Object> mapSerializedInputsToActionInputs(ActionType actionType, Map<String, Object> arguments) {
        HashMap<String, Object> newArguments = new HashMap<String, Object>();
        for (Input input : actionType.getInputs()) {
            Object value = arguments.get(input.getName());
            if (value != null) {
                try {
                    newArguments.put(input.getName(), this.mapSerializedInputToActionInput(input, value));
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("{} Input parameter is ignored.", (Object)e.getMessage());
                }
                continue;
            }
            value = this.getDefaultValueForActionInput(input);
            if (value == null) continue;
            newArguments.put(input.getName(), value);
        }
        return newArguments;
    }

    private @Nullable Object getDefaultValueForActionInput(Input input) {
        return switch (input.getType()) {
            case "boolean" -> Boolean.valueOf(false);
            case "byte" -> (byte)0;
            case "short" -> (short)0;
            case "int" -> 0;
            case "long" -> 0L;
            case "float" -> Float.valueOf(0.0f);
            case "double" -> 0.0;
            default -> null;
        };
    }

    public Object mapSerializedInputToActionInput(Input input, Object argument) throws IllegalArgumentException {
        try {
            block105: {
                Matcher matcher;
                block103: {
                    matcher = QUANTITY_TYPE_PATTERN.matcher(input.getType());
                    if (!(argument instanceof Double)) break block103;
                    Double valueDouble = (Double)argument;
                    if (matcher.matches()) {
                        return new QuantityType((Number)valueDouble, this.getDefaultUnit(matcher.group("dimension")));
                    }
                    return switch (input.getType()) {
                        case "byte", "java.lang.Byte" -> valueDouble.byteValue();
                        case "java.lang.Short", "short" -> valueDouble.shortValue();
                        case "java.lang.Integer", "int" -> valueDouble.intValue();
                        case "long", "java.lang.Long" -> valueDouble.longValue();
                        case "java.lang.Float", "float" -> Float.valueOf(valueDouble.floatValue());
                        case "org.openhab.core.library.types.DecimalType" -> new DecimalType((Number)valueDouble);
                        default -> argument;
                    };
                }
                if (!(argument instanceof String)) break block105;
                String valueString = (String)argument;
                if (matcher.matches()) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(valueString);
                        return new QuantityType((Number)bigDecimal, this.getDefaultUnit(matcher.group("dimension")));
                    }
                    catch (NumberFormatException e) {
                        return new QuantityType(valueString);
                    }
                }
                return switch (input.getType()) {
                    case "boolean", "java.lang.Boolean" -> Boolean.valueOf(valueString.toLowerCase());
                    case "byte", "java.lang.Byte" -> Byte.valueOf(valueString);
                    case "java.lang.Short", "short" -> Short.valueOf(valueString);
                    case "java.lang.Integer", "int" -> Integer.valueOf(valueString);
                    case "long", "java.lang.Long" -> Long.valueOf(valueString);
                    case "java.lang.Float", "float" -> Float.valueOf(valueString);
                    case "double", "java.lang.Double", "java.lang.Number" -> Double.valueOf(valueString);
                    case "org.openhab.core.library.types.DecimalType" -> new DecimalType(valueString);
                    case "java.time.LocalDate" -> LocalDate.parse(valueString);
                    case "java.time.LocalTime" -> LocalTime.parse(valueString);
                    case "java.time.LocalDateTime" -> LocalDateTime.parse(valueString);
                    case "java.util.Date" -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(valueString);
                    case "java.time.ZonedDateTime" -> LocalDateTime.parse(valueString).atZone(this.timeZoneProvider.getTimeZone());
                    case "java.time.Instant" -> LocalDateTime.parse(valueString).atZone(this.timeZoneProvider.getTimeZone()).toInstant();
                    case "java.time.Duration" -> Duration.parse(valueString);
                    default -> argument;
                };
            }
            return argument;
        }
        catch (IllegalArgumentException | ParseException | DateTimeParseException e) {
            throw new IllegalArgumentException("Input parameter '" + input.getName() + "': converting value '" + argument.toString() + "' into type " + input.getType() + " failed!");
        }
    }

    private Unit<?> getDefaultUnit(String dimensionName) throws IllegalArgumentException {
        Class dimension = UnitUtils.parseDimension((String)dimensionName);
        if (dimension == null) {
            throw new IllegalArgumentException("Unknown dimension " + dimensionName);
        }
        return this.unitProvider.getUnit(dimension);
    }
}

