/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.util.SpecificationViolationReporter;

public abstract class UnsignedVariableInteger {
    protected long value;

    protected UnsignedVariableInteger() {
    }

    protected UnsignedVariableInteger(long value) throws NumberFormatException {
        this.setValue(value);
    }

    protected UnsignedVariableInteger(String s) throws NumberFormatException {
        if (s.startsWith("-")) {
            SpecificationViolationReporter.report("Invalid negative integer value '" + s + "', assuming value 0!", new Object[0]);
            s = "0";
        }
        this.setValue(Long.parseLong(s.trim()));
    }

    protected UnsignedVariableInteger setValue(long value) {
        this.isInRange(value);
        this.value = value;
        return this;
    }

    public Long getValue() {
        return this.value;
    }

    public void isInRange(long value) throws NumberFormatException {
        if (value < (long)this.getMinValue() || value > this.getBits().getMaxValue()) {
            throw new NumberFormatException("Value must be between " + this.getMinValue() + " and " + this.getBits().getMaxValue() + ": " + value);
        }
    }

    public int getMinValue() {
        return 0;
    }

    public abstract Bits getBits();

    public UnsignedVariableInteger increment(boolean rolloverToOne) {
        this.value = this.value + 1L > this.getBits().getMaxValue() ? (long)(rolloverToOne ? 1 : 0) : ++this.value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedVariableInteger that = (UnsignedVariableInteger)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static enum Bits {
        EIGHT(255L),
        SIXTEEN(65535L),
        TWENTYFOUR(0xFFFFFFL),
        THIRTYTWO(0xFFFFFFFFL);

        private final long maxValue;

        private Bits(long maxValue) {
            this.maxValue = maxValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }
    }
}

