/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jupnp.http.Representation;
import org.jupnp.util.io.IO;

public class HttpFetch {
    public static Representation<byte[]> fetchBinary(URL url) throws IOException {
        return HttpFetch.fetchBinary(url, 500, 500);
    }

    public static Representation<byte[]> fetchBinary(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        return HttpFetch.fetch(url, connectTimeoutMillis, readTimeoutMillis, (urlConnection, is) -> new Representation<byte[]>(urlConnection, IO.readAllBytes(is)));
    }

    public static Representation<String> fetchString(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        return HttpFetch.fetch(url, connectTimeoutMillis, readTimeoutMillis, (urlConnection, is) -> new Representation<String>(urlConnection, IO.readLines(is)));
    }

    public static <E> Representation<E> fetch(URL url, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        return HttpFetch.fetch(url, "GET", connectTimeoutMillis, readTimeoutMillis, factory);
    }

    public static <E> Representation<E> fetch(URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        HttpURLConnection urlConnection = null;
        InputStream is = null;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(method);
            urlConnection.setConnectTimeout(connectTimeoutMillis);
            urlConnection.setReadTimeout(readTimeoutMillis);
            is = urlConnection.getInputStream();
            Representation<E> representation = factory.createRepresentation(urlConnection, is);
            return representation;
        }
        catch (IOException e) {
            if (urlConnection != null) {
                int responseCode = urlConnection.getResponseCode();
                InputStream errorStream = urlConnection.getErrorStream();
                if (errorStream != null) {
                    while (errorStream.read() != -1) {
                    }
                    errorStream.close();
                }
                throw new IOException("Fetching resource failed, returned status code: " + responseCode);
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void validate(URL url) throws IOException {
        HttpFetch.fetch(url, "HEAD", 500, 500, (urlConnection, is) -> new Representation<Object>(urlConnection, null));
    }

    public static interface RepresentationFactory<E> {
        public Representation<E> createRepresentation(URLConnection var1, InputStream var2) throws IOException;
    }
}

