/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.DFA;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.ide.editor.contentassist.antlr.BaseFollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ILookAheadTerminal;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.InfiniteRecursion;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.LinkedHashSetWithoutNull;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;

public abstract class BaseInternalContentAssistParser<FollowElement extends BaseFollowElement<LookAheadTerminal>, LookAheadTerminal extends ILookAheadTerminal>
extends Parser
implements ObservableXtextTokenStream.StreamListener,
ITokenDefProvider {
    protected final List<EObject> grammarElements;
    protected final List<EObject> localTrace;
    protected final List<Integer> paramStack;
    protected final List<Integer> grammarElementsWithParams;
    protected int stackSize;
    protected final Set<FollowElement> followElements;
    protected ObservableXtextTokenStream.StreamListener delegate;
    protected List<TerminalRule> terminalRules;
    protected boolean mismatch;
    protected RecoveryListener recoveryListener;
    protected int lookAheadAddOn;
    protected int marked = 0;
    protected boolean resyncing = false;
    protected boolean strict = false;
    protected int wasErrorCount = -1;
    protected int predictionLevel = 0;
    protected int currentMarker;
    protected int firstMarker;
    protected boolean inMismatchIsUnwantedToken = false;
    protected boolean failedPredicateAtEOF = false;
    protected Multimap<Integer, AbstractElement> indexToHandledElements;
    protected IUnorderedGroupHelper unorderedGroupHelper;
    protected IFollowElementFactory<FollowElement, LookAheadTerminal> followElementFactory = this.newFollowElementFactory();

    public BaseInternalContentAssistParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        this.grammarElements = new ArrayList<EObject>();
        this.localTrace = new ArrayList<EObject>();
        this.paramStack = new ArrayList<Integer>();
        this.grammarElementsWithParams = new ArrayList<Integer>();
        this.followElements = new LinkedHashSetWithoutNull<FollowElement>();
    }

    public BaseInternalContentAssistParser(TokenStream input) {
        super(input);
        this.grammarElements = new ArrayList<EObject>();
        this.localTrace = new ArrayList<EObject>();
        this.followElements = new LinkedHashSetWithoutNull<FollowElement>();
        this.paramStack = new ArrayList<Integer>();
        this.grammarElementsWithParams = new ArrayList<Integer>();
    }

    protected abstract IFollowElementFactory<FollowElement, LookAheadTerminal> newFollowElementFactory();

    protected int getLookaheadThreshold() {
        return Integer.MAX_VALUE;
    }

    public void before(EObject grammarElement) {
        List<EObject> secondRun;
        List<EObject> firstRun;
        List<EObject> traceAfterFirstOccurrence;
        int secondIdx;
        int idx;
        if (this.input.size() == this.input.index() && (idx = this.localTrace.indexOf(grammarElement)) >= 0 && idx != this.localTrace.size() - 1 && (secondIdx = (traceAfterFirstOccurrence = this.localTrace.subList(idx + 1, this.localTrace.size())).indexOf(grammarElement)) >= 0 && secondIdx != traceAfterFirstOccurrence.size() - 1 && (firstRun = this.localTrace.subList(idx, idx + 1 + secondIdx)).equals(secondRun = traceAfterFirstOccurrence.subList(secondIdx, traceAfterFirstOccurrence.size()))) {
            throw this.infiniteRecursion();
        }
        this.grammarElements.add(grammarElement);
        this.localTrace.add(grammarElement);
    }

    protected InfiniteRecursion infiniteRecursion() {
        return new InfiniteRecursion();
    }

    public void before(EObject grammarElement, int paramConfig) {
        this.before(grammarElement);
        this.paramStack.add(paramConfig);
        this.grammarElementsWithParams.add(this.stackSize);
    }

    public void after(EObject grammarElement, int paramConfig) {
        int old = this.removeLast(this.paramStack);
        if (old != paramConfig) {
            throw new IllegalStateException(paramConfig + "!=" + old);
        }
        this.removeLast(this.grammarElementsWithParams);
        this.after(grammarElement);
    }

    public void after(EObject grammarElement) {
        int index;
        EObject foundGrammarElement = this.removeLast(this.grammarElements);
        if (grammarElement != foundGrammarElement) {
            throw new IllegalStateException("expected element: '" + String.valueOf(grammarElement) + "', but was: '" + String.valueOf(foundGrammarElement) + "'");
        }
        if (grammarElement instanceof UnorderedGroup && this.indexToHandledElements != null) {
            this.indexToHandledElements.removeAll((Object)this.grammarElements.size());
        } else if (!this.grammarElements.isEmpty() && this.grammarElements.get(index = this.grammarElements.size() - 1) instanceof UnorderedGroup) {
            if (this.indexToHandledElements == null) {
                this.indexToHandledElements = LinkedHashMultimap.create();
            }
            this.indexToHandledElements.put((Object)index, (Object)((AbstractElement)grammarElement));
        }
    }

    public void recover(IntStream stream, RecognitionException ex) {
        if (this.recoveryListener != null) {
            this.recoveryListener.beginErrorRecovery();
        }
        this.removeUnexpectedElements();
        if (ex instanceof FailedPredicateException && ex.token.getType() == -1) {
            this.failedPredicateAtEOF = true;
        }
        super.recover(stream, ex);
        if (this.recoveryListener != null) {
            this.recoveryListener.endErrorRecovery();
        }
    }

    private void removeUnexpectedElements() {
        int dropParamAt = -1;
        if (!this.grammarElementsWithParams.isEmpty()) {
            dropParamAt = this.getLast(this.grammarElementsWithParams);
        }
        while (this.stackSize < this.grammarElements.size()) {
            this.removeLast(this.grammarElements);
            if (dropParamAt != this.grammarElements.size()) continue;
            this.removeLast(this.paramStack);
            this.removeLast(this.grammarElementsWithParams);
            if (this.grammarElementsWithParams.isEmpty()) continue;
            dropParamAt = this.getLast(this.grammarElementsWithParams);
        }
    }

    private <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    private <T> T removeLast(List<T> list) {
        return list.remove(list.size() - 1);
    }

    public void emitErrorMessage(String msg) {
    }

    public RecognizerSharedState getInternalRecognizerSharedState() {
        return this.state;
    }

    protected abstract Grammar getGrammar();

    protected int keepStackSize() {
        int result = this.stackSize;
        this.stackSize = this.grammarElements.size();
        return result;
    }

    protected void restoreStackSize(int stackSize) {
        if (!this.isBacktracking()) {
            this.removeUnexpectedElements();
            this.stackSize = stackSize;
        }
    }

    protected boolean isBacktracking() {
        return this.state.backtracking != 0;
    }

    protected void selectEofStrategy(int lookAhead) {
        if (this.mismatch || !this.state.errorRecovery) {
            this.selectEofStrategy();
        } else if (this.strict && lookAhead == 1) {
            this.delegate = this.createNoOpStrategy();
            if (this.predictionLevel > 0) {
                this.delegate = this.createPredictionStrategy();
            }
        } else {
            this.selectEofStrategy();
        }
    }

    protected void selectEofStrategy() throws UnsupportedOperationException {
        if (this.mismatch) {
            this.delegate = this.createMismatchStrategy();
        } else if (!this.state.errorRecovery) {
            if (this.marked > 0 && this.state.syntaxErrors > 0 && this.state.lastErrorIndex >= this.firstMarker) {
                this.delegate = this.createNoOpStrategy();
                return;
            }
            this.delegate = this.createNotErrorRecoveryStrategy();
        } else {
            this.delegate = this.createErrorRecoveryStrategy();
        }
        if (this.predictionLevel > 0) {
            this.delegate = this.createPredictionStrategy();
        }
    }

    protected StreamAdapter createNoOpStrategy() {
        return new StreamAdapter(this){

            @Override
            public void announceEof(int lookAhead) {
            }
        };
    }

    protected StreamAdapter createPredictionStrategy() {
        return new StreamAdapter(this){
            private AbstractElement lastAddedElement;
            private AbstractElement globalLastAddedElement;
            private int lastKnownSyntaxErrors;
            private boolean wasMismatch;
            private ObservableXtextTokenStream.StreamListener privateDelegate;
            private IFollowElementFactory<FollowElement, LookAheadTerminal> followElementFactory;
            private AbstractElement recovered;
            {
                this.lastKnownSyntaxErrors = Integer.MAX_VALUE;
                this.wasMismatch = false;
                this.privateDelegate = baseInternalContentAssistParser2.delegate;
                this.followElementFactory = baseInternalContentAssistParser2.followElementFactory;
                baseInternalContentAssistParser2.followElementFactory = new IFollowElementFactory<FollowElement, LookAheadTerminal>(){

                    @Override
                    public FollowElement createFollowElement(AbstractElement current, int lookAhead) {
                        if (lastKnownSyntaxErrors == Integer.MAX_VALUE || ((BaseInternalContentAssistParser)(this).this).state.lastErrorIndex < 0) {
                            Object result = followElementFactory.createFollowElement(current, lookAhead);
                            if (result != null) {
                                globalLastAddedElement = ((BaseFollowElement)result).getGrammarElement();
                                if (lookAhead > 1 && this.isBacktracking() && lastKnownSyntaxErrors == Integer.MAX_VALUE) {
                                    lastKnownSyntaxErrors = ((BaseInternalContentAssistParser)(this).this).state.syntaxErrors;
                                }
                            }
                            return result;
                        }
                        return null;
                    }
                };
            }

            @Override
            public void announceEof(int lookAhead) {
                try {
                    if (predictionLevel == 0) {
                        AbstractElement current;
                        if (!(this.wasMismatch || ((BaseInternalContentAssistParser)this).state.errorRecovery && resyncing || (current = this.getCurrentGrammarElement()) == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                            if (((BaseInternalContentAssistParser)this).state.errorRecovery) {
                                if (!failedPredicateAtEOF && this.globalLastAddedElement != current && (this.globalLastAddedElement == null || GrammarUtil.isOptionalCardinality((AbstractElement)this.globalLastAddedElement) || GrammarUtil.isOneOrMoreCardinality((AbstractElement)this.globalLastAddedElement))) {
                                    this.createAndAddFollowElement(current, lookAhead);
                                }
                            } else if (this.globalLastAddedElement != current && ((BaseInternalContentAssistParser)this).state.syntaxErrors <= this.lastKnownSyntaxErrors) {
                                this.createAndAddFollowElement(current, lookAhead);
                            }
                        }
                        if (mismatch && !this.wasMismatch && !failedPredicateAtEOF) {
                            current = this.getCurrentGrammarElement();
                            if (!(this.recovered != null && this.recovered != current || current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                                this.createAndAddFollowElement(current, lookAhead);
                            }
                        }
                    } else if (this.globalLastAddedElement != this.getCurrentGrammarElement()) {
                        this.privateDelegate.announceEof(lookAhead);
                    }
                }
                finally {
                    this.wasMismatch |= mismatch;
                    if (this.getCurrentGrammarElement() != null && this.getCurrentGrammarElement() != this.globalLastAddedElement && ((BaseInternalContentAssistParser)this).state.errorRecovery && this.recovered == null) {
                        this.recovered = this.getCurrentGrammarElement();
                    }
                }
            }

            protected void createAndAddFollowElement(AbstractElement current, int lookAhead) {
                Object followElement;
                if (marked > 0) {
                    lookAhead += lookAheadAddOn;
                }
                if ((followElement = this.followElementFactory.createFollowElement(current, lookAhead)) != null) {
                    followElements.add(followElement);
                    this.lastAddedElement = current;
                    this.globalLastAddedElement = current;
                }
            }
        };
    }

    protected StreamAdapter createErrorRecoveryStrategy() {
        return new StreamAdapter(this){
            private AbstractElement lastAddedElement;

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current = this.getCurrentGrammarElement();
                if (!(current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    followElements.add(this.createFollowElement(current, lookAhead));
                    this.lastAddedElement = current;
                }
            }
        };
    }

    protected StreamAdapter createNotErrorRecoveryStrategy() {
        return new StreamAdapter(this){

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current;
                if (!(((BaseInternalContentAssistParser)this).state.errorRecovery || mismatch || this.isBacktracking() && marked <= 0 && wasErrorCount > 0 || (current = this.getCurrentGrammarElement()) == null)) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    if (lookAhead <= this.getLookaheadThreshold()) {
                        followElements.add(this.createFollowElement(current, lookAhead));
                    }
                }
            }
        };
    }

    protected StreamAdapter createMismatchStrategy() {
        return new StreamAdapter(this){
            private boolean wasErrorRecovery;
            {
                this.wasErrorRecovery = false;
            }

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current;
                boolean bl = this.wasErrorRecovery = this.wasErrorRecovery || ((BaseInternalContentAssistParser)this).state.errorRecovery;
                if (!this.wasErrorRecovery && !mismatch && (current = this.getCurrentGrammarElement()) != null) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    followElements.add(this.createFollowElement(current, lookAhead));
                }
            }
        };
    }

    public void beginResync() {
        this.resyncing = true;
    }

    public void endResync() {
        this.resyncing = false;
    }

    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        try {
            this.mismatch = true;
            Object object = super.recoverFromMismatchedToken(input, ttype, follow);
            return object;
        }
        finally {
            this.mismatch = false;
        }
    }

    public boolean mismatchIsMissingToken(IntStream input, BitSet follow) {
        return false;
    }

    protected AbstractElement getCurrentGrammarElement() {
        int i = this.grammarElements.size() - 1;
        while (i >= 0) {
            EObject result = this.grammarElements.get(i);
            if (result instanceof AbstractElement) {
                return (AbstractElement)result;
            }
            --i;
        }
        return null;
    }

    protected FollowElement createFollowElement(AbstractElement current, int lookAhead) {
        return this.followElementFactory.createFollowElement(current, lookAhead);
    }

    public abstract LookAheadTerminal createLookAheadTerminal(Token var1);

    @Override
    public void announceEof(int lookAhead) {
        if (this.delegate == null) {
            this.selectEofStrategy(lookAhead);
            if (this.strict) {
                this.wasErrorCount = this.state.syntaxErrors;
            }
        }
        if (this.inMismatchIsUnwantedToken) {
            return;
        }
        if (this.grammarElements.isEmpty() || this.delegate == null) {
            return;
        }
        if (this.strict && this.wasErrorCount != this.state.syntaxErrors) {
            return;
        }
        this.delegate.announceEof(lookAhead);
    }

    public void reportError(RecognitionException e) {
        if (this.strict) {
            if (this.state.errorRecovery) {
                return;
            }
            if (e.index != this.input.size()) {
                ++this.state.syntaxErrors;
            }
            this.state.errorRecovery = true;
        } else {
            super.reportError(e);
        }
    }

    @Override
    public void announceConsume() {
        if (this.marked <= 0) {
            this.localTrace.clear();
        } else {
            ++this.lookAheadAddOn;
        }
    }

    public boolean mismatchIsUnwantedToken(IntStream input, int ttype) {
        try {
            boolean result;
            this.inMismatchIsUnwantedToken = true;
            boolean bl = result = super.mismatchIsUnwantedToken(input, ttype);
            return bl;
        }
        finally {
            this.inMismatchIsUnwantedToken = false;
        }
    }

    @Override
    public void announceRewind(int marker) {
        int useLookAhead = -1;
        if (marker != 0 && this.delegate == null && this.strict && this.predictionLevel != 0 && this.lookAheadAddOn > 0 && this.state.syntaxErrors == 0 && this.input.index() == this.input.size() && marker + this.lookAheadAddOn <= this.input.size() && this.isBacktracking()) {
            useLookAhead = this.lookAheadAddOn;
            this.delegate = this.createNotErrorRecoveryStrategy();
            this.wasErrorCount = this.state.syntaxErrors;
        }
        this.currentMarker = marker;
        this.lookAheadAddOn = this.currentMarker - this.firstMarker;
        if (useLookAhead != -1 && useLookAhead + this.firstMarker >= this.input.index()) {
            this.announceEof(useLookAhead);
        }
        --this.marked;
    }

    @Override
    public void announceMark(int marker) {
        if (this.marked <= 0) {
            ++this.marked;
            this.lookAheadAddOn = 0;
            this.currentMarker = marker;
            this.firstMarker = marker;
        } else {
            ++this.marked;
            this.currentMarker = marker;
        }
    }

    public void beginDFAPrediction() {
        ++this.predictionLevel;
    }

    public boolean isDFAPrediction() {
        return this.predictionLevel != 0;
    }

    public void endDFAPrediction() {
        --this.predictionLevel;
    }

    public Set<FollowElement> getFollowElements() {
        return this.followElements;
    }

    public Map<Integer, String> getTokenDefMap() {
        String[] names = this.getTokenNames();
        HashMap result = Maps.newHashMapWithExpectedSize((int)(names.length - 4));
        int i = 4;
        while (i < names.length) {
            result.put(i, this.getValueForTokenName(names[i]));
            ++i;
        }
        return result;
    }

    protected String getValueForTokenName(String tokenName) {
        return tokenName;
    }

    public List<EObject> getGrammarElements() {
        return this.grammarElements;
    }

    public List<EObject> getLocalTrace() {
        return this.localTrace;
    }

    public List<Integer> getParamStack() {
        return this.paramStack;
    }

    public RecoveryListener getRecoveryListener() {
        return this.recoveryListener;
    }

    public void setRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListener = recoveryListener;
    }

    public void setUnorderedGroupHelper(IUnorderedGroupHelper unorderedGroupHelper) {
        this.unorderedGroupHelper = unorderedGroupHelper;
    }

    public IUnorderedGroupHelper getUnorderedGroupHelper() {
        return this.unorderedGroupHelper;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected static short[][] unpackEncodedStringArray(String[] arr) {
        int numStates = arr.length;
        short[][] result = new short[numStates][];
        int i = 0;
        while (i < numStates) {
            result[i] = DFA.unpackEncodedString((String)arr[i]);
            ++i;
        }
        return result;
    }

    public static interface IFollowElementFactory<FollowElement extends BaseFollowElement<LookAheadTerminal>, LookAheadTerminal extends ILookAheadTerminal> {
        public FollowElement createFollowElement(AbstractElement var1, int var2);
    }

    public static interface RecoveryListener {
        public void beginErrorRecovery();

        public void endErrorRecovery();
    }

    protected abstract class StreamAdapter
    implements ObservableXtextTokenStream.StreamListener {
        protected StreamAdapter() {
        }

        @Override
        public void announceConsume() {
            BaseInternalContentAssistParser.this.announceConsume();
        }

        @Override
        public void announceMark(int marker) {
            BaseInternalContentAssistParser.this.announceMark(marker);
        }

        @Override
        public void announceRewind(int marker) {
            BaseInternalContentAssistParser.this.announceRewind(marker);
        }
    }
}

