--
-- (C) 2020-23 - ntop.org
--

local vs_module = {}

package.path = dirs.installdir .. "/scripts/lua/modules/vulnerability_scan/?.lua;" .. package.path
local vs_utils = require("vs_utils")

-- ##############################################

function vs_module:new()
   local obj = { name = "udp_portscan" }

   setmetatable(obj, self)
   self.__index = self

   return obj
end

-- ##############################################

function vs_module:is_enabled()
   -- UDP scan is enabled only on Linux
   return(vs_utils.is_nmap_installed() and ntop.isLinux())
end


-- ##############################################

-- NOTE: ports are comma separated (e.g. 80,443)

function vs_module:scan_host(host_ip, ports, use_coroutines)
   -- Enabled (previleged) UDP scan on Linux
   local command = "nmap --privileged -sU" -- Use -F for fast scan
   local now,result,duration,scan_result,num_open_ports,num_vulnerabilities_found, cve, udp_ports, tcp_ports = vs_utils.nmap_scan_host(command, host_ip, ports, use_coroutines, self.name)
   return now,result,duration,scan_result,num_open_ports,num_vulnerabilities_found, cve, udp_ports, tcp_ports
end

-- ##############################################

return vs_module
