/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * ImportAliasAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ImportAliasAction extends AbstractAction {

  private static final long serialVersionUID = 8319264275758368224L;
  private File lastDirectory = null;

  public ImportAliasAction() {
    super(Messages.getString("ImportAliasAction.0"), new ImageIcon(ImportAliasAction.class //$NON-NLS-1$
        .getResource("/org/javalobby/icons/20x20/DocumentIn.gif"))); //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    File channelFile = null;
    // open file Chooser
    final JFileChooser fc = new JFileChooser();
    if (lastDirectory != null) {
      fc.setCurrentDirectory(lastDirectory);
    }
    int ret = fc.showOpenDialog(ChannelEditor.application);
    if (ret == JFileChooser.APPROVE_OPTION) {
      channelFile = fc.getSelectedFile();
    }
    // open the file
    if (channelFile != null) {
      // save last dir
      lastDirectory = channelFile.getParentFile();
      try {
        // open file and generate key value map
        Map aliasMap = Utils.buildAliasMap(new FileReader(channelFile));
        int aliasCount = aliasMap.size();
        int aliasAssigned = 0;
        if (!aliasMap.isEmpty()) {
          // traverse through tree and set alias from map
          DefaultMutableTreeNode rootNode = ChannelEditor.application.getChannelListingPanel().getRootNode();
          Enumeration enumer = rootNode.preorderEnumeration();
          while (enumer.hasMoreElements()) {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode) enumer.nextElement();
            if (mutableNode.getUserObject() instanceof Channel) {
              Channel channel = (Channel) mutableNode.getUserObject();
              // if id matches an alias assign the alias to the channel
              String alias = (String) aliasMap.get(channel.getId());
              if (alias != null) {
                channel.setAlias(alias);
                aliasAssigned++;
              }
            }
          }
        }
        // show info message
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("ImportAliasAction.2") + aliasCount //$NON-NLS-1$
            + Messages.getString("ImportAliasAction.3") + channelFile.getAbsolutePath() + Messages.getString("ImportAliasAction.4") + aliasAssigned //$NON-NLS-1$ //$NON-NLS-2$
            + Messages.getString("ImportAliasAction.5")); //$NON-NLS-1$
      } catch (FileNotFoundException fnfe) {
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("ImportAliasAction.6") //$NON-NLS-1$
            + channelFile.getAbsolutePath() + Messages.getString("ImportAliasAction.7") + fnfe.getMessage()); //$NON-NLS-1$
        channelFile = null;
      }
    }
  }

}
