/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.CreateChannelDialog;
import de.renier.vdr.channel.editor.Messages;

/**
 * CreateChannelAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class CreateChannelAction extends AbstractAction {

  private static final long serialVersionUID = 5450151829301164987L;

  public CreateChannelAction() {
    super(Messages.getString("CreateChannelAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/New.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    TreePath treePath = ChannelEditor.application.getChannelListingPanel().getLeadSelectionPath();
    DefaultMutableTreeNode node = null;
    int insertPosition = 0;
    if (treePath == null) {
      node = ChannelEditor.application.getChannelListingPanel().getRootNode();
    } else {
      node = (DefaultMutableTreeNode) treePath.getLastPathComponent();
    }
    // check if node is root or category
    if (!node.isRoot() && !((ChannelElement) node.getUserObject()).isCategory()) {
      // if we have a channel set node to parent
      DefaultMutableTreeNode parent = (DefaultMutableTreeNode) node.getParent();
      insertPosition = parent.getIndex(node);
      node = parent;
    }
    // open create dialog
    CreateChannelDialog createChannelDlg = new CreateChannelDialog(ChannelEditor.application);
    int result = createChannelDlg.showDialog();
    if (result == CreateChannelDialog.RESULT_CREATE) {
      // get the channel
      Channel channel = createChannelDlg.getChannel();
      // create the channel
      DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(channel);
      ChannelEditor.application.getChannelListingPanel().insertNodeInto(newNode, node, insertPosition);
      ChannelEditor.application.getChannelListingPanel().treeNodeStructureChanged(node);
      // set modify flag
      ChannelEditor.application.setModified(true);
    }
  }

}
