/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.testng.ITestNGMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;

public class AnnotationHelper {
    private static Class[] ALL_ANNOTATIONS = new Class[]{IConfiguration.class, IDataProvider.class, IExpectedExceptions.class, IFactory.class, IParameters.class, ITest.class};

    public static ITest findTest(IAnnotationFinder finder, Class cls) {
        return (ITest)finder.findAnnotation(cls, ITest.class);
    }

    public static ITest findTest(IAnnotationFinder finder, Method m) {
        return (ITest)finder.findAnnotation(m, ITest.class);
    }

    public static ITest findTest(IAnnotationFinder finder, Constructor ctor) {
        return (ITest)finder.findAnnotation(ctor, ITest.class);
    }

    public static IConfiguration findConfiguration(IAnnotationFinder finder, Class cls) {
        return (IConfiguration)finder.findAnnotation(cls, IConfiguration.class);
    }

    public static IConfiguration findConfiguration(IAnnotationFinder finder, Method m) {
        return (IConfiguration)finder.findAnnotation(m, IConfiguration.class);
    }

    public static IConfiguration findConfiguration(IAnnotationFinder finder, Constructor ctor) {
        return (IConfiguration)finder.findAnnotation(ctor, IConfiguration.class);
    }

    public static Class[] getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class rootClass, Class annotationClass, IAnnotationFinder annotationFinder) {
        HashMap<String, TestNGMethod> vResult = new HashMap<String, TestNGMethod>();
        try {
            vResult = new HashMap();
            for (Class cls = rootClass; null != cls; cls = cls.getSuperclass()) {
                boolean hasClassAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, cls, annotationClass);
                Method[] methods = cls.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    boolean hasMethodAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, annotationClass);
                    boolean hasTestNGAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, ITest.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, IConfiguration.class);
                    boolean isPublic = Modifier.isPublic(m.getModifiers());
                    if ((!isPublic || !hasClassAnnotation || hasTestNGAnnotation) && !hasMethodAnnotation) continue;
                    if (AnnotationHelper.isAnnotationPresent(annotationFinder, m, IConfiguration.class) && AnnotationHelper.isAnnotationPresent(annotationFinder, cls, ITest.class)) {
                        Utils.log("", 3, "Method " + m + " has a local @Configuration and a class-level @Test." + "This method will only be kept as a @Configuration.");
                        continue;
                    }
                    String key = AnnotationHelper.createMethodKey(m);
                    if (null != vResult.get(key)) continue;
                    TestNGMethod tm = new TestNGMethod(m, annotationFinder);
                    vResult.put(key, tm);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        ITestNGMethod[] result = vResult.values().toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class annotationClass) {
        return annotationFinder.findAnnotation(m, annotationClass) != null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Class cls, Class annotationClass) {
        return annotationFinder.findAnnotation(cls, annotationClass) != null;
    }

    private static String createMethodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        for (Class<?> paramClass : m.getParameterTypes()) {
            result.append(" ").append(paramClass.toString());
        }
        return result.toString();
    }
}

