# Announce: Rakudo compiler, Release #162 (2023.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2023 release of Rakudo #162. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2023.06:

+ Improvements:
    + Make unknown method calls on strings mention the string [563addbb]
    + Make sure format is reported with `Formatter` errors [10cc908d]
    + Provide better error message for `my %h = Callable` [65febb98]
    + Make extensions for CURFS configurable [924386f5]
    + Make `.fmt` a multi everywhere [69d570d2][a2d616a0]

+ Additions:
    + Implement `Uni.encode` [e3a74746]
    + Add `X::Temporal::OutOfRange` [83cc6e71]
    + Add `connect-path` and `listen-path` to IO::Socket::Async thereby
      implementing asynchronous Unix socket support (MoarVM only for
      now) [6f9bc5b1][c452fdbf]
    + Introduce the `Format` class in 6.e [ebe0e0b2][f3bb7a2c][5a7a2e5f]
    + Add `.fmt(Format:D)` candidates where appropriate [eceaeeae]

+ Fixes:
    + Fix role typechecking over its parent class [a4201c28]
    + Add one more level of dirs to check for .t fudging [1dc496ad]
    + Precomp Pipeline: Fix building on CentOS 7 [c0a95290]
    + Consider META6.json contents when calculating CURFS id [5ec81cad]
    + Fix copy-pasto in `Capture.Bool` [a2f71d80]

+ Removals:
    + Remove largely unknown / undocumented flags from installed raku
      script shims [73888f45]

+ Internal:
    + Re-commenced work on Formatter class [a54b99b6][67d8dc76][c3df563b]
    + Streamline X::Str::Sprintf::Directives::BadType [40aa1605]
    + Optimize CURFS startup time [77aa79ce][d30ac3e4][655ac635]
    + Optimize internal directory recursion [0ae02284][78d79112][2642bf2d]
      [3fa0fdf7][71240f00]
    + Streamline List.fmt a bit, a few % faster [1617881d]
    + Combine 6.e augments and additions into single files [7d3b9d6b][3d0b3222]
    + Don't need to use _I version of nqp::radix... [efa78db6]
    + Add "rakuast" as key to filter roast on [fa9cd8ef]
    + Make CURFS extensions more idiomatic [6e8339a6][4d077623]

+ RakuAST Development:
    + A lot of work was done on RakuAST development (over 100 commits), raising
      the number of passing spectest files from 825 to 884 (out of 1356).

      [c88291e2][d320deed][4a46ee17][6eafacd0][5da5c605][566f878e][b76e2bc0]
      [1028ceb6][1ab2e3e7][dd475ed0][9b207ab7][4df49e66][790b6b05][d3372c8d]
      [b593dc9a][0df71cfc][d2203ccb][cc9d1ec0][0bb11fe2][feffac51][22acb30c]
      [02548b5b][b7c73685][174c941a][881ce570][237b28b9][628bcdca][4b3bfbb3]
      [dd95fd1c][93f560a7][cebe2ad6][9b071c2c][2e77a038][013a2fa4][000648ed]
      [653e0c22][c9a5d62d][678aced8][6baa4d56][253a5d8d][7f0ba792][5a8402f5]
      [c7ecdd82][5d8ca405][ee80ae0d][dce0875a][9095d86b][4813dfb8][11c012a8]
      [bd10858e][eaa6293f][c6b21ec6][63219673][639e7e90][305a839b][da5fb80f]
      [885a86a8][54fee5e6][2d2920f0][1c6097b8][17b97c19][003777c4][554c9fc6]
      [c8a4a214][f05cd033][7661383e][9b9b7216][823f5516][58d638d3][e0cefedb]
      [e015bfe7][baf1aa0f][84d14dc9][cb887de7][45cc0d4e][f2bff1f7][2cff038d]
      [e8b477b5][75bdcd64][432c1d62][158c0c75][37e0a0b6][e0ec2749][55a26222]
      [97d13c59][1657c0f4][a6bec923][4932c2c1][e5568f93][34854eb4][0ff1118a]
      [489cb328][4dd49339][f581d020][c5b917db][0557d834][0fecf561][e10e3aa0]
      [5b456299][c884b166][c6ceff3e][e95c45a5][60a10f8a][8a4f4d8e][8ab9d11f]
      [33cb11be][5790e589][e66bcd67][655ac635]

The following people contributed to this release:

Elizabeth Mattijsen, Nick Logan, Stefan Seifert, Daniel Green, Will Coleda,
Patrick Böker, Leon Timmermans, Vadim Belman, Jonathan Worthington,
Luc St-Louis, Luis F. Uceta

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2023 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#163), is tentatively scheduled for 2023-08-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
