/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithoutRef, type ReactNode, type Ref } from 'react';
import { type UIAnalyticsEvent } from '@atlaskit/analytics-next';
import { type RouterLinkComponentProps } from '@atlaskit/app-provider';
import type { BasePrimitiveProps, StyleProp } from './types';
type BaseAnchorProps = {
    /**
     * Elements to be rendered inside the Anchor.
     */
    children?: ReactNode;
    /**
     * Handler called on click. The second argument provides an Atlaskit UI analytics event that can be fired to a listening channel. See the ['analytics-next' package](https://atlaskit.atlassian.com/packages/analytics/analytics-next) documentation for more information.
     */
    onClick?: (e: React.MouseEvent<HTMLAnchorElement>, analyticsEvent: UIAnalyticsEvent) => void;
    /**
     * An optional name used to identify events for [React UFO (Unified Frontend Observability) press interactions](https://developer.atlassian.com/platform/ufo/react-ufo/react-ufo/getting-started/#quick-start--press-interactions). For more information, see [React UFO integration into Design System components](https://go.atlassian.com/react-ufo-dst-integration).
     */
    interactionName?: string;
    /**
     * An optional component name used to identify this component in Atlaskit analytics events. This can be used if a parent component's name is preferred over the default 'Anchor'.
     */
    componentName?: string;
    /**
     * Additional information to be included in the `context` of Atlaskit analytics events that come from anchor.
     */
    analyticsContext?: Record<string, any>;
    /**
     * Override the default text to signify that a link opens in a new window.
     * This is appended to the `aria-label` attribute when the `target` prop is set to `_blank`.
     */
    newWindowLabel?: string;
    /**
     * Forwarded ref.
     */
    ref?: Ref<HTMLAnchorElement>;
};
export type AnchorProps<RouterLinkConfig extends Record<string, any> = never> = RouterLinkComponentProps<RouterLinkConfig> & Omit<ComponentPropsWithoutRef<'a'>, 'href' | 'onClick' | 'style' | 'className'> & BasePrimitiveProps & StyleProp & BaseAnchorProps;
/**
 * __Anchor__
 *
 * A primitive for building custom anchor links.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
declare const AnchorNoRef: <RouterLinkConfig extends Record<string, any> = never>({ href, children, onClick: providedOnClick, interactionName, componentName, analyticsContext, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, style, target, testId, xcss, newWindowLabel, ...htmlAttributes }: AnchorProps<RouterLinkConfig>, ref?: Ref<HTMLAnchorElement>) => JSX.Element;
/**
 * __Anchor__
 *
 * Anchor is a primitive for building custom anchor links. It's a wrapper around the HTML `<a>` element that provides a consistent API for handling client-side routing and Atlassian Design System styling.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
declare const Anchor: <RouterLinkConfig extends Record<string, any> = never>(props: AnchorProps<RouterLinkConfig> & {
    ref?: Ref<HTMLAnchorElement>;
}) => ReturnType<typeof AnchorNoRef>;
export default Anchor;
