import _extends from "@babel/runtime/helpers/extends";
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { forwardRef, useCallback, useContext } from 'react';

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css, jsx } from '@emotion/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next';
import noop from '@atlaskit/ds-lib/noop';
import InteractionContext from '@atlaskit/interaction-context';
import { backgroundColorStylesMap, borderColorMap, borderWidthMap, paddingStylesMap, positiveSpaceMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';
// This duplicates FocusRing styles from `@atlaskit/focus-ring`.
const focusRingStyles = css({
  '&:focus, &:focus-visible': {
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineColor: borderColorMap['color.border.focused'],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineOffset: positiveSpaceMap['space.025'],
    outlineStyle: 'solid',
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineWidth: borderWidthMap['border.width.outline']
  },
  // eslint-disable-next-line @atlaskit/ui-styling-standard/no-unsafe-selectors
  '&:focus:not(:focus-visible)': {
    outline: 'none'
  },
  '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)': {
    '&:focus-visible': {
      outline: '1px solid'
    }
  }
});
const baseStyles = css({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});
const enabledStyles = css({
  cursor: 'pointer'
});
const disabledStyles = css({
  cursor: 'not-allowed'
});

/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
const Pressable = /*#__PURE__*/forwardRef(({
  children,
  backgroundColor,
  padding,
  paddingBlock,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  isDisabled,
  type = 'button',
  onClick: providedOnClick = noop,
  interactionName,
  componentName,
  analyticsContext,
  style,
  testId,
  xcss,
  ...htmlAttributes
}, ref) => {
  const interactionContext = useContext(InteractionContext);
  const handleClick = useCallback((e, analyticsEvent) => {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  const onClick = usePlatformLeafEventHandler({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Pressable',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'button'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  const {
    className: _spreadClass,
    ...safeHtmlAttributes
  } = htmlAttributes;
  const resolvedStyles = parseXcss(xcss);
  return jsx("button", _extends({
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
    style: style,
    ref: ref
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static
  }, safeHtmlAttributes, {
    // eslint-disable-next-line react/button-has-type
    type: type,
    onClick: onClick,
    disabled: isDisabled,
    css: [baseStyles, focusRingStyles, isDisabled ? disabledStyles : enabledStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    backgroundColor && backgroundColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    padding && paddingStylesMap.padding[padding],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlock && paddingStylesMap.paddingBlock[paddingBlock],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockStart && paddingStylesMap.paddingBlockStart[paddingBlockStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockEnd && paddingStylesMap.paddingBlockEnd[paddingBlockEnd],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInline && paddingStylesMap.paddingInline[paddingInline],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineStart && paddingStylesMap.paddingInlineStart[paddingInlineStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineEnd && paddingStylesMap.paddingInlineEnd[paddingInlineEnd], resolvedStyles.emotion],
    "data-testid": testId
  }), children);
});
export default Pressable;