/* flex.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./flex.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var rowGapMap = {
  'space.0': "_1p57ze3t",
  'space.025': "_1p57v77o",
  'space.050': "_1p571b66",
  'space.075': "_1p5712x7",
  'space.100': "_1p57u2gc",
  'space.150': "_1p57utpp",
  'space.200': "_1p57pxbi",
  'space.250': "_1p57v47k",
  'space.300': "_1p571ejb",
  'space.400': "_1p57xy5q",
  'space.500': "_1p571jfw",
  'space.600': "_1p57oahv",
  'space.800': "_1p57xncg",
  'space.1000': "_1p571epz"
};
var columnGapMap = {
  'space.0': "_gy1pze3t",
  'space.025': "_gy1pv77o",
  'space.050': "_gy1p1b66",
  'space.075': "_gy1p12x7",
  'space.100': "_gy1pu2gc",
  'space.150': "_gy1putpp",
  'space.200': "_gy1ppxbi",
  'space.250': "_gy1pv47k",
  'space.300': "_gy1p1ejb",
  'space.400': "_gy1pxy5q",
  'space.500': "_gy1p1jfw",
  'space.600': "_gy1poahv",
  'space.800': "_gy1pxncg",
  'space.1000': "_gy1p1epz"
};
var justifyContentMap = {
  start: "_1bahv2br",
  center: "_1bah1h6o",
  end: "_1bahh9n0",
  'space-between': "_1bah1yb4",
  'space-around': "_1bah1b1v",
  'space-evenly': "_1bahitcz",
  stretch: "_1bah1fhb"
};
var flexDirectionMap = {
  column: "_2lx21bp4",
  row: "_2lx2vrvc"
};
var flexWrapMap = {
  wrap: "_1n261g80",
  nowrap: "_1n261q9c"
};
var alignItemsMap = {
  start: "_4cvrv2br",
  center: "_4cvr1h6o",
  baseline: "_4cvr1q9y",
  end: "_4cvrh9n0",
  stretch: "_4cvr1fhb"
};
var styles = {
  root: "_1e0c1txw _vchhusvi"
};

/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
var Flex = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'div' : _ref$as,
    role = _ref.role,
    alignItems = _ref.alignItems,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    testId = _ref.testId,
    direction = _ref.direction,
    wrap = _ref.wrap,
    xcss = _ref.xcss;
  return /*#__PURE__*/React.createElement(Component, {
    role: role,
    className: (0, _runtime.ax)([styles.root, gap && columnGapMap[gap], columnGap && columnGapMap[columnGap], gap && rowGapMap[gap], rowGap && rowGapMap[rowGap], alignItems && alignItemsMap[alignItems], direction && flexDirectionMap[direction], justifyContent && justifyContentMap[justifyContent], wrap && flexWrapMap[wrap], xcss]),
    "data-testid": testId,
    ref: ref
  }, children);
}));
Flex.displayName = 'Flex';
var _default = exports.default = Flex;