/**
 * Provides a boolean value for whether an element is focused.
 * The `bindFocus` function returned provides two event handlers:
 * - `onFocus` and `onBlur` which when triggered set `isFocused` accordingly.
 */
export default function useFocus(): {
    isFocused: boolean;
    bindFocus: {
        onFocus: () => void;
        onBlur: () => void;
    };
};
