/**
 * Returns the closest element with `position: absolute` or `null` if none found.
 */
function getClosestAbsolutePositionedElement(element) {
  var _getComputedStyle = getComputedStyle(element),
    position = _getComputedStyle.position;
  if (position === 'absolute') {
    return element;
  }
  var parentElement = element.parentElement;
  if (parentElement instanceof HTMLElement) {
    return getClosestAbsolutePositionedElement(parentElement);
  }
  return null;
}

/**
 * Returns the closest element that is offset relative to the scroll container.
 */
export function getClosestPositionedElement(_ref) {
  var _getClosestAbsolutePo;
  var element = _ref.element,
    mode = _ref.mode;
  /**
   * We use the element directly for standard lists,
   * because we assume it is positioned in the flow.
   */
  if (mode === 'standard') {
    return element;
  }

  /**
   * For virtual lists we use the closest element with `position: absolute`,
   * as this is how virtualization libraries offset elements.
   */
  return (_getClosestAbsolutePo = getClosestAbsolutePositionedElement(element)) !== null && _getClosestAbsolutePo !== void 0 ? _getClosestAbsolutePo : element;
}