import { useDragDropContext } from '../drag-drop-context/internal-context';
export function getDraggableDimensions(element) {
  const {
    margin
  } = window.getComputedStyle(element);
  const rect = element.getBoundingClientRect();
  return {
    margin,
    rect
  };
}

/**
 * Returns the captured dimensions of the item being dragged.
 */
export function useDraggableDimensions() {
  const {
    getDragState
  } = useDragDropContext();
  const dragState = getDragState();
  if (!dragState.isDragging) {
    return null;
  }
  return dragState.draggableDimensions;
}