"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCallbackWithAnalytics = void 0;
var _react = require("react");
var _useAnalyticsEvents2 = require("./useAnalyticsEvents");
var _useTrackedRef = require("./useTrackedRef");
var useCallbackWithAnalytics = exports.useCallbackWithAnalytics = function useCallbackWithAnalytics(method, payload, channel) {
  var _useAnalyticsEvents = (0, _useAnalyticsEvents2.useAnalyticsEvents)(),
    createAnalyticsEvent = _useAnalyticsEvents.createAnalyticsEvent;
  var methodRef = (0, _useTrackedRef.useTrackedRef)(method);
  var payloadRef = (0, _useTrackedRef.useTrackedRef)(payload);
  return (0, _react.useCallback)(function () {
    var pload = typeof payloadRef.current === 'function' ? payloadRef.current.apply(payloadRef, arguments) : payloadRef.current;
    createAnalyticsEvent(pload).fire(channel);
    methodRef.current.apply(methodRef, arguments);
  }, [createAnalyticsEvent, methodRef, payloadRef, channel]);
};