/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */

import { helper } from '@ember/component/helper';

export default helper(function ([lib], hash) {
  return [
    'activity-16.svg',
    'activity-24.svg',
    'alert-circle-16.svg',
    'alert-circle-24.svg',
    'alert-circle-fill-16.svg',
    'alert-circle-fill-24.svg',
    'alert-circle-fill.svg',
    'alert-circle-outline.svg',
    'alert-octagon-16.svg',
    'alert-octagon-24.svg',
    'alert-octagon-fill-16.svg',
    'alert-octagon-fill-24.svg',
    'alert-triangle-16.svg',
    'alert-triangle-24.svg',
    'alert-triangle-fill-16.svg',
    'alert-triangle-fill-24.svg',
    'alert-triangle.svg',
    'alibaba-16.svg',
    'alibaba-24.svg',
    'alibaba-color-16.svg',
    'alibaba-color-24.svg',
    'align-center-16.svg',
    'align-center-24.svg',
    'align-justify-16.svg',
    'align-justify-24.svg',
    'align-left-16.svg',
    'align-left-24.svg',
    'align-right-16.svg',
    'align-right-24.svg',
    'apple-16.svg',
    'apple-24.svg',
    'apple-color-16.svg',
    'apple-color-24.svg',
    'archive-16.svg',
    'archive-24.svg',
    'arrow-down-16.svg',
    'arrow-down-24.svg',
    'arrow-down-circle-16.svg',
    'arrow-down-circle-24.svg',
    'arrow-down-left-16.svg',
    'arrow-down-left-24.svg',
    'arrow-down-right-16.svg',
    'arrow-down-right-24.svg',
    'arrow-down.svg',
    'arrow-left-16.svg',
    'arrow-left-24.svg',
    'arrow-left-circle-16.svg',
    'arrow-left-circle-24.svg',
    'arrow-left.svg',
    'arrow-right-16.svg',
    'arrow-right-24.svg',
    'arrow-right-circle-16.svg',
    'arrow-right-circle-24.svg',
    'arrow-right.svg',
    'arrow-up-16.svg',
    'arrow-up-24.svg',
    'arrow-up-circle-16.svg',
    'arrow-up-circle-24.svg',
    'arrow-up-left-16.svg',
    'arrow-up-left-24.svg',
    'arrow-up-right-16.svg',
    'arrow-up-right-24.svg',
    'arrow-up.svg',
    'at-sign-16.svg',
    'at-sign-24.svg',
    'auth0-16.svg',
    'auth0-24.svg',
    'auth0-color-16.svg',
    'auth0-color-24.svg',
    'auto-apply-16.svg',
    'auto-apply-24.svg',
    'award-16.svg',
    'award-24.svg',
    'azure-16.svg',
    'azure-24.svg',
    'azure-color-16.svg',
    'azure-color-24.svg',
    'azure-devops-16.svg',
    'azure-devops-24.svg',
    'azure-devops-color-16.svg',
    'azure-devops-color-24.svg',
    'bar-chart-16.svg',
    'bar-chart-24.svg',
    'bar-chart-alt-16.svg',
    'bar-chart-alt-24.svg',
    'battery-16.svg',
    'battery-24.svg',
    'battery-charging-16.svg',
    'battery-charging-24.svg',
    'beaker-16.svg',
    'beaker-24.svg',
    'bell-16.svg',
    'bell-24.svg',
    'bell-active-16.svg',
    'bell-active-24.svg',
    'bell-active-fill-16.svg',
    'bell-active-fill-24.svg',
    'bell-off-16.svg',
    'bell-off-24.svg',
    'bitbucket-16.svg',
    'bitbucket-24.svg',
    'bitbucket-color-16.svg',
    'bitbucket-color-24.svg',
    'bolt.svg',
    'bookmark-16.svg',
    'bookmark-24.svg',
    'bookmark-add-16.svg',
    'bookmark-add-24.svg',
    'bookmark-add-fill-16.svg',
    'bookmark-add-fill-24.svg',
    'bookmark-fill-16.svg',
    'bookmark-fill-24.svg',
    'bookmark-remove-16.svg',
    'bookmark-remove-24.svg',
    'bookmark-remove-fill-16.svg',
    'bookmark-remove-fill-24.svg',
    'bottom-16.svg',
    'bottom-24.svg',
    'box-16.svg',
    'box-24.svg',
    'box-check-fill.svg',
    'box-outline.svg',
    'briefcase-16.svg',
    'briefcase-24.svg',
    'broadcast.svg',
    'bug-16.svg',
    'bug-24.svg',
    'bug.svg',
    'build-16.svg',
    'build-24.svg',
    'calendar-16.svg',
    'calendar-24.svg',
    'calendar.svg',
    'camera-16.svg',
    'camera-24.svg',
    'camera-off-16.svg',
    'camera-off-24.svg',
    'cancel-circle-fill.svg',
    'cancel-circle-outline.svg',
    'cancel-plain.svg',
    'cancel-square-fill.svg',
    'cancel-square-outline.svg',
    'caret-16.svg',
    'caret-24.svg',
    'caret-down.svg',
    'caret-up.svg',
    'cast-16.svg',
    'cast-24.svg',
    'certificate-16.svg',
    'certificate-24.svg',
    'change-16.svg',
    'change-24.svg',
    'change-circle-16.svg',
    'change-circle-24.svg',
    'change-square-16.svg',
    'change-square-24.svg',
    'check-16.svg',
    'check-24.svg',
    'check-circle-16.svg',
    'check-circle-24.svg',
    'check-circle-fill-16.svg',
    'check-circle-fill-24.svg',
    'check-circle-fill.svg',
    'check-circle-outline.svg',
    'check-diamond-16.svg',
    'check-diamond-24.svg',
    'check-diamond-fill-16.svg',
    'check-diamond-fill-24.svg',
    'check-hexagon-16.svg',
    'check-hexagon-24.svg',
    'check-hexagon-fill-16.svg',
    'check-hexagon-fill-24.svg',
    'check-plain.svg',
    'check-square-16.svg',
    'check-square-24.svg',
    'check-square-fill-16.svg',
    'check-square-fill-24.svg',
    'chevron-down-16.svg',
    'chevron-down-24.svg',
    'chevron-down.svg',
    'chevron-left-16.svg',
    'chevron-left-24.svg',
    'chevron-left.svg',
    'chevron-right-16.svg',
    'chevron-right-24.svg',
    'chevron-right.svg',
    'chevron-up-16.svg',
    'chevron-up-24.svg',
    'chevron-up.svg',
    'chevrons-down-16.svg',
    'chevrons-down-24.svg',
    'chevrons-left-16.svg',
    'chevrons-left-24.svg',
    'chevrons-right-16.svg',
    'chevrons-right-24.svg',
    'chevrons-up-16.svg',
    'chevrons-up-24.svg',
    'circle-16.svg',
    'circle-24.svg',
    'circle-dot-16.svg',
    'circle-dot-24.svg',
    'circle-fill-16.svg',
    'circle-fill-24.svg',
    'circle-half-16.svg',
    'circle-half-24.svg',
    'clipboard-16.svg',
    'clipboard-24.svg',
    'clipboard-checked-16.svg',
    'clipboard-checked-24.svg',
    'clipboard-copy-16.svg',
    'clipboard-copy-24.svg',
    'clock-16.svg',
    'clock-24.svg',
    'clock-fill.svg',
    'clock-outline.svg',
    'cloud-16.svg',
    'cloud-24.svg',
    'cloud-check-16.svg',
    'cloud-check-24.svg',
    'cloud-cross.svg',
    'cloud-download-16.svg',
    'cloud-download-24.svg',
    'cloud-lightning-16.svg',
    'cloud-lightning-24.svg',
    'cloud-lock-16.svg',
    'cloud-lock-24.svg',
    'cloud-off-16.svg',
    'cloud-off-24.svg',
    'cloud-upload-16.svg',
    'cloud-upload-24.svg',
    'cloud-x-16.svg',
    'cloud-x-24.svg',
    'code-16.svg',
    'code-24.svg',
    'code.svg',
    'collections-16.svg',
    'collections-24.svg',
    'command-16.svg',
    'command-24.svg',
    'compass-16.svg',
    'compass-24.svg',
    'connection-16.svg',
    'connection-24.svg',
    'connection-gateway-16.svg',
    'connection-gateway-24.svg',
    'console.svg',
    'copy-action.svg',
    'copy-success.svg',
    'corner-down-left-16.svg',
    'corner-down-left-24.svg',
    'corner-down-right-16.svg',
    'corner-down-right-24.svg',
    'corner-left-down-16.svg',
    'corner-left-down-24.svg',
    'corner-left-up-16.svg',
    'corner-left-up-24.svg',
    'corner-right-down-16.svg',
    'corner-right-down-24.svg',
    'corner-right-up-16.svg',
    'corner-right-up-24.svg',
    'corner-up-left-16.svg',
    'corner-up-left-24.svg',
    'corner-up-right-16.svg',
    'corner-up-right-24.svg',
    'cpu-16.svg',
    'cpu-24.svg',
    'credit-card-16.svg',
    'credit-card-24.svg',
    'crop-16.svg',
    'crop-24.svg',
    'crosshair-16.svg',
    'crosshair-24.svg',
    'dashboard-16.svg',
    'dashboard-24.svg',
    'database-16.svg',
    'database-24.svg',
    'database.svg',
    'delay-16.svg',
    'delay-24.svg',
    'delay.svg',
    'delete-16.svg',
    'delete-24.svg',
    'deny-alt.svg',
    'deny-color.svg',
    'deny-default.svg',
    'diamond-16.svg',
    'diamond-24.svg',
    'diamond-fill-16.svg',
    'diamond-fill-24.svg',
    'disabled.svg',
    'disc-16.svg',
    'disc-24.svg',
    'discussion-circle-16.svg',
    'discussion-circle-24.svg',
    'discussion-square-16.svg',
    'discussion-square-24.svg',
    'docker-16.svg',
    'docker-24.svg',
    'docker-color-16.svg',
    'docker-color-24.svg',
    'docs-16.svg',
    'docs-24.svg',
    'docs-download-16.svg',
    'docs-download-24.svg',
    'docs-link-16.svg',
    'docs-link-24.svg',
    'docs.svg',
    'dollar-sign-16.svg',
    'dollar-sign-24.svg',
    'dot-16.svg',
    'dot-24.svg',
    'dot-half-16.svg',
    'dot-half-24.svg',
    'download-16.svg',
    'download-24.svg',
    'download.svg',
    'droplet-16.svg',
    'droplet-24.svg',
    'duplicate-16.svg',
    'duplicate-24.svg',
    'edit-16.svg',
    'edit-24.svg',
    'edit.svg',
    'entry-point-16.svg',
    'entry-point-24.svg',
    'envelope-sealed-fill.svg',
    'envelope-sealed-outline.svg',
    'envelope-unsealed--outline.svg',
    'envelope-unsealed-fill.svg',
    'event-16.svg',
    'event-24.svg',
    'exit-point-16.svg',
    'exit-point-24.svg',
    'exit.svg',
    'expand-less.svg',
    'expand-more.svg',
    'external-link-16.svg',
    'external-link-24.svg',
    'eye-16.svg',
    'eye-24.svg',
    'eye-off-16.svg',
    'eye-off-24.svg',
    'f5-16.svg',
    'f5-24.svg',
    'f5-color-16.svg',
    'f5-color-24.svg',
    'fast-forward-16.svg',
    'fast-forward-24.svg',
    'file-16.svg',
    'file-24.svg',
    'file-change-16.svg',
    'file-change-24.svg',
    'file-check-16.svg',
    'file-check-24.svg',
    'file-diff-16.svg',
    'file-diff-24.svg',
    'file-fill.svg',
    'file-minus-16.svg',
    'file-minus-24.svg',
    'file-outline.svg',
    'file-plus-16.svg',
    'file-plus-24.svg',
    'file-source-16.svg',
    'file-source-24.svg',
    'file-text-16.svg',
    'file-text-24.svg',
    'file-x-16.svg',
    'file-x-24.svg',
    'files-16.svg',
    'files-24.svg',
    'film-16.svg',
    'film-24.svg',
    'filter-16.svg',
    'filter-24.svg',
    'filter-circle-16.svg',
    'filter-circle-24.svg',
    'filter-fill-16.svg',
    'filter-fill-24.svg',
    'filter.svg',
    'fingerprint-16.svg',
    'fingerprint-24.svg',
    'flag-16.svg',
    'flag-24.svg',
    'flag.svg',
    'folder-16.svg',
    'folder-24.svg',
    'folder-fill-16.svg',
    'folder-fill-24.svg',
    'folder-fill.svg',
    'folder-minus-16.svg',
    'folder-minus-24.svg',
    'folder-minus-fill-16.svg',
    'folder-minus-fill-24.svg',
    'folder-outline.svg',
    'folder-plus-16.svg',
    'folder-plus-24.svg',
    'folder-plus-fill-16.svg',
    'folder-plus-fill-24.svg',
    'folder-star-16.svg',
    'folder-star-24.svg',
    'folder-users-16.svg',
    'folder-users-24.svg',
    'frown-16.svg',
    'frown-24.svg',
    'gateway-16.svg',
    'gateway-24.svg',
    'gateway.svg',
    'gcp-16.svg',
    'gcp-24.svg',
    'gcp-color-16.svg',
    'gcp-color-24.svg',
    'gift-16.svg',
    'gift-24.svg',
    'gift-fill.svg',
    'gift-outline.svg',
    'git-branch-16.svg',
    'git-branch-24.svg',
    'git-branch.svg',
    'git-commit-16.svg',
    'git-commit-24.svg',
    'git-commit.svg',
    'git-merge-16.svg',
    'git-merge-24.svg',
    'git-pull-request-16.svg',
    'git-pull-request-24.svg',
    'git-pull-request.svg',
    'git-repo-16.svg',
    'git-repo-24.svg',
    'git-repository.svg',
    'github-16.svg',
    'github-24.svg',
    'github-color-16.svg',
    'github-color-24.svg',
    'gitlab-16.svg',
    'gitlab-24.svg',
    'gitlab-color-16.svg',
    'gitlab-color-24.svg',
    'globe-16.svg',
    'globe-24.svg',
    'globe-private-16.svg',
    'globe-private-24.svg',
    'google-16.svg',
    'google-24.svg',
    'google-color-16.svg',
    'google-color-24.svg',
    'grid-16.svg',
    'grid-24.svg',
    'grid-alt-16.svg',
    'grid-alt-24.svg',
    'guide-16.svg',
    'guide-24.svg',
    'guide-link-16.svg',
    'guide-link-24.svg',
    'guide.svg',
    'hammer-16.svg',
    'hammer-24.svg',
    'hard-drive-16.svg',
    'hard-drive-24.svg',
    'hash-16.svg',
    'hash-24.svg',
    'headphones-16.svg',
    'headphones-24.svg',
    'health.svg',
    'heart-16.svg',
    'heart-24.svg',
    'heart-fill-16.svg',
    'heart-fill-24.svg',
    'heart-off-16.svg',
    'heart-off-24.svg',
    'help-16.svg',
    'help-24.svg',
    'help-circle-fill.svg',
    'help-circle-outline.svg',
    'hexagon-16.svg',
    'hexagon-24.svg',
    'hexagon-fill-16.svg',
    'hexagon-fill-24.svg',
    'history-16.svg',
    'history-24.svg',
    'history.svg',
    'home-16.svg',
    'home-24.svg',
    'hourglass-16.svg',
    'hourglass-24.svg',
    'identity-service-16.svg',
    'identity-service-24.svg',
    'identity-user-16.svg',
    'identity-user-24.svg',
    'image-16.svg',
    'image-24.svg',
    'inbox-16.svg',
    'inbox-24.svg',
    'info-16.svg',
    'info-24.svg',
    'info-circle-fill.svg',
    'info-circle-outline.svg',
    'jump-link-16.svg',
    'jump-link-24.svg',
    'key-16.svg',
    'key-24.svg',
    'key-values-16.svg',
    'key-values-24.svg',
    'key.svg',
    'kubernetes-16.svg',
    'kubernetes-24.svg',
    'kubernetes-color-16.svg',
    'kubernetes-color-24.svg',
    'labyrinth-16.svg',
    'labyrinth-24.svg',
    'layers-16.svg',
    'layers-24.svg',
    'layers.svg',
    'layout-16.svg',
    'layout-24.svg',
    'learn-16.svg',
    'learn-24.svg',
    'learn-link-16.svg',
    'learn-link-24.svg',
    'learn.svg',
    'line-chart-16.svg',
    'line-chart-24.svg',
    'line-chart-up-16.svg',
    'line-chart-up-24.svg',
    'link-16.svg',
    'link-24.svg',
    'link.svg',
    'list-16.svg',
    'list-24.svg',
    'loading.svg',
    'lock-16.svg',
    'lock-24.svg',
    'lock-closed-fill.svg',
    'lock-closed-outline.svg',
    'lock-closed.svg',
    'lock-disabled.svg',
    'lock-fill-16.svg',
    'lock-fill-24.svg',
    'lock-off-16.svg',
    'lock-off-24.svg',
    'lock-open.svg',
    'logo-alicloud-color.svg',
    'logo-alicloud-monochrome.svg',
    'logo-auth0-color.svg',
    'logo-azure-color.svg',
    'logo-azure-dev-ops-color.svg',
    'logo-azure-dev-ops-monochrome.svg',
    'logo-azure-monochrome.svg',
    'logo-bitbucket-color.svg',
    'logo-bitbucket-monochrome.svg',
    'logo-ember-circle-color.svg',
    'logo-gcp-color.svg',
    'logo-gcp-monochrome.svg',
    'logo-github-color.svg',
    'logo-github-monochrome.svg',
    'logo-gitlab-color.svg',
    'logo-gitlab-monochrome.svg',
    'logo-glimmer-color.svg',
    'logo-google-color.svg',
    'logo-google-monochrome.svg',
    'logo-hashicorp-color.svg',
    'logo-jwt-color.svg',
    'logo-kubernetes-color.svg',
    'logo-kubernetes-monochrome.svg',
    'logo-microsoft-color.svg',
    'logo-oidc-color.svg',
    'logo-okta-color.svg',
    'logo-oracle-color.svg',
    'logo-oracle-monochrome.svg',
    'logo-slack-color.svg',
    'logo-slack-monochrome.svg',
    'logo-vmware-color.svg',
    'logo-vmware-monochrome.svg',
    'mail-16.svg',
    'mail-24.svg',
    'mail-open-16.svg',
    'mail-open-24.svg',
    'map-16.svg',
    'map-24.svg',
    'map-pin-16.svg',
    'map-pin-24.svg',
    'maximize-16.svg',
    'maximize-24.svg',
    'maximize-alt-16.svg',
    'maximize-alt-24.svg',
    'meh-16.svg',
    'meh-24.svg',
    'menu-16.svg',
    'menu-24.svg',
    'menu.svg',
    'mesh-16.svg',
    'mesh-24.svg',
    'mesh.svg',
    'message-circle-16.svg',
    'message-circle-24.svg',
    'message-circle-fill-16.svg',
    'message-circle-fill-24.svg',
    'message-square-16.svg',
    'message-square-24.svg',
    'message-square-fill-16.svg',
    'message-square-fill-24.svg',
    'message.svg',
    'mic-16.svg',
    'mic-24.svg',
    'mic-off-16.svg',
    'mic-off-24.svg',
    'microsoft-16.svg',
    'microsoft-24.svg',
    'microsoft-color-16.svg',
    'microsoft-color-24.svg',
    'migrate-16.svg',
    'migrate-24.svg',
    'minimize-16.svg',
    'minimize-24.svg',
    'minimize-alt-16.svg',
    'minimize-alt-24.svg',
    'minus-16.svg',
    'minus-24.svg',
    'minus-circle-16.svg',
    'minus-circle-24.svg',
    'minus-circle-fill.svg',
    'minus-circle-outline.svg',
    'minus-plain.svg',
    'minus-plus-16.svg',
    'minus-plus-24.svg',
    'minus-plus-circle-16.svg',
    'minus-plus-circle-24.svg',
    'minus-plus-square-16.svg',
    'minus-plus-square-24.svg',
    'minus-square-16.svg',
    'minus-square-24.svg',
    'minus-square-fill.svg',
    'module-16.svg',
    'module-24.svg',
    'module.svg',
    'monitor-16.svg',
    'monitor-24.svg',
    'moon-16.svg',
    'moon-24.svg',
    'more-horizontal-16.svg',
    'more-horizontal-24.svg',
    'more-horizontal.svg',
    'more-vertical-16.svg',
    'more-vertical-24.svg',
    'more-vertical.svg',
    'mouse-pointer-16.svg',
    'mouse-pointer-24.svg',
    'move-16.svg',
    'move-24.svg',
    'music-16.svg',
    'music-24.svg',
    'navigation-16.svg',
    'navigation-24.svg',
    'navigation-alt-16.svg',
    'navigation-alt-24.svg',
    'network-16.svg',
    'network-24.svg',
    'network-alt-16.svg',
    'network-alt-24.svg',
    'newspaper-16.svg',
    'newspaper-24.svg',
    'node-16.svg',
    'node-24.svg',
    'notification-disabled.svg',
    'notification-fill.svg',
    'notification-outline.svg',
    'octagon-16.svg',
    'octagon-24.svg',
    'okta-16.svg',
    'okta-24.svg',
    'okta-color-16.svg',
    'okta-color-24.svg',
    'oracle-16.svg',
    'oracle-24.svg',
    'oracle-color-16.svg',
    'oracle-color-24.svg',
    'org-16.svg',
    'org-24.svg',
    'outline-16.svg',
    'outline-24.svg',
    'outline.svg',
    'package-16.svg',
    'package-24.svg',
    'page-outline.svg',
    'paperclip-16.svg',
    'paperclip-24.svg',
    'partner.svg',
    'path-16.svg',
    'path-24.svg',
    'path.svg',
    'pause-16.svg',
    'pause-24.svg',
    'pause-circle-16.svg',
    'pause-circle-24.svg',
    'pen-tool-16.svg',
    'pen-tool-24.svg',
    'pencil-tool-16.svg',
    'pencil-tool-24.svg',
    'phone-16.svg',
    'phone-24.svg',
    'phone-call-16.svg',
    'phone-call-24.svg',
    'phone-off-16.svg',
    'phone-off-24.svg',
    'pie-chart-16.svg',
    'pie-chart-24.svg',
    'pin-16.svg',
    'pin-24.svg',
    'play-16.svg',
    'play-24.svg',
    'play-circle-16.svg',
    'play-circle-24.svg',
    'play-fill.svg',
    'play-outline.svg',
    'play-plain.svg',
    'plus-16.svg',
    'plus-24.svg',
    'plus-circle-16.svg',
    'plus-circle-24.svg',
    'plus-circle-fill.svg',
    'plus-circle-outline.svg',
    'plus-plain.svg',
    'plus-square-16.svg',
    'plus-square-24.svg',
    'plus-square-fill.svg',
    'port.svg',
    'power-16.svg',
    'power-24.svg',
    'printer-16.svg',
    'printer-24.svg',
    'protocol.svg',
    'provider-16.svg',
    'provider-24.svg',
    'provider.svg',
    'public-default.svg',
    'public-locked.svg',
    'queue-16.svg',
    'queue-24.svg',
    'queue.svg',
    'radio-16.svg',
    'radio-24.svg',
    'radio-button-checked.svg',
    'radio-button-unchecked.svg',
    'random-16.svg',
    'random-24.svg',
    'random.svg',
    'redirect-16.svg',
    'redirect-24.svg',
    'redirect.svg',
    'refresh-alert.svg',
    'refresh-default.svg',
    'reload-16.svg',
    'reload-24.svg',
    'remix.svg',
    'repeat-16.svg',
    'repeat-24.svg',
    'replication-direct-16.svg',
    'replication-direct-24.svg',
    'replication-perf-16.svg',
    'replication-perf-24.svg',
    'rewind-16.svg',
    'rewind-24.svg',
    'ribbon.svg',
    'rocket-16.svg',
    'rocket-24.svg',
    'rotate-ccw-16.svg',
    'rotate-ccw-24.svg',
    'rotate-cw-16.svg',
    'rotate-cw-24.svg',
    'rss-16.svg',
    'rss-24.svg',
    'run.svg',
    'save-16.svg',
    'save-24.svg',
    'scissors-16.svg',
    'scissors-24.svg',
    'search-16.svg',
    'search-24.svg',
    'search-color.svg',
    'search.svg',
    'send-16.svg',
    'send-24.svg',
    'server-16.svg',
    'server-24.svg',
    'server-cluster-16.svg',
    'server-cluster-24.svg',
    'serverless-16.svg',
    'serverless-24.svg',
    'settings-16.svg',
    'settings-24.svg',
    'settings.svg',
    'share-16.svg',
    'share-24.svg',
    'shield-16.svg',
    'shield-24.svg',
    'shield-alert-16.svg',
    'shield-alert-24.svg',
    'shield-check-16.svg',
    'shield-check-24.svg',
    'shield-off-16.svg',
    'shield-off-24.svg',
    'shield-x-16.svg',
    'shield-x-24.svg',
    'shopping-bag-16.svg',
    'shopping-bag-24.svg',
    'shopping-cart-16.svg',
    'shopping-cart-24.svg',
    'shuffle-16.svg',
    'shuffle-24.svg',
    'sidebar-16.svg',
    'sidebar-24.svg',
    'sidebar-hide-16.svg',
    'sidebar-hide-24.svg',
    'sidebar-show-16.svg',
    'sidebar-show-24.svg',
    'sign-in-16.svg',
    'sign-in-24.svg',
    'sign-out-16.svg',
    'sign-out-24.svg',
    'skip-16.svg',
    'skip-24.svg',
    'skip-back-16.svg',
    'skip-back-24.svg',
    'skip-forward-16.svg',
    'skip-forward-24.svg',
    'slack-16.svg',
    'slack-24.svg',
    'slack-color-16.svg',
    'slack-color-24.svg',
    'slash-16.svg',
    'slash-24.svg',
    'slash-square-16.svg',
    'slash-square-24.svg',
    'sliders-16.svg',
    'sliders-24.svg',
    'smartphone-16.svg',
    'smartphone-24.svg',
    'smile-16.svg',
    'smile-24.svg',
    'socket-16.svg',
    'socket-24.svg',
    'socket.svg',
    'sort-asc-16.svg',
    'sort-asc-24.svg',
    'sort-desc-16.svg',
    'sort-desc-24.svg',
    'sort.svg',
    'source-file.svg',
    'speaker-16.svg',
    'speaker-24.svg',
    'square-16.svg',
    'square-24.svg',
    'square-fill-16.svg',
    'square-fill-24.svg',
    'star-16.svg',
    'star-24.svg',
    'star-circle-16.svg',
    'star-circle-24.svg',
    'star-fill-16.svg',
    'star-fill-24.svg',
    'star-fill.svg',
    'star-off-16.svg',
    'star-off-24.svg',
    'star-outline.svg',
    'stop-circle-16.svg',
    'stop-circle-24.svg',
    'sub-left.svg',
    'sub-right.svg',
    'sun-16.svg',
    'sun-24.svg',
    'support-16.svg',
    'support-24.svg',
    'support.svg',
    'swap-horizontal-16.svg',
    'swap-horizontal-24.svg',
    'swap-horizontal.svg',
    'swap-vertical-16.svg',
    'swap-vertical-24.svg',
    'swap-vertical.svg',
    'switcher-16.svg',
    'switcher-24.svg',
    'sync-16.svg',
    'sync-24.svg',
    'sync-alert-16.svg',
    'sync-alert-24.svg',
    'sync-reverse-16.svg',
    'sync-reverse-24.svg',
    'tablet-16.svg',
    'tablet-24.svg',
    'tag-16.svg',
    'tag-24.svg',
    'tag.svg',
    'target-16.svg',
    'target-24.svg',
    'terminal-16.svg',
    'terminal-24.svg',
    'terminal-screen-16.svg',
    'terminal-screen-24.svg',
    'thumbs-down-16.svg',
    'thumbs-down-24.svg',
    'thumbs-up-16.svg',
    'thumbs-up-24.svg',
    'toggle-left-16.svg',
    'toggle-left-24.svg',
    'toggle-right-16.svg',
    'toggle-right-24.svg',
    'token-16.svg',
    'token-24.svg',
    'tools-16.svg',
    'tools-24.svg',
    'top-16.svg',
    'top-24.svg',
    'trash-16.svg',
    'trash-24.svg',
    'trash.svg',
    'trend-down-16.svg',
    'trend-down-24.svg',
    'trend-up-16.svg',
    'trend-up-24.svg',
    'triangle-16.svg',
    'triangle-24.svg',
    'triangle-fill-16.svg',
    'triangle-fill-24.svg',
    'truck-16.svg',
    'truck-24.svg',
    'tune.svg',
    'tv-16.svg',
    'tv-24.svg',
    'type-16.svg',
    'type-24.svg',
    'unfold-close-16.svg',
    'unfold-close-24.svg',
    'unfold-less.svg',
    'unfold-more.svg',
    'unfold-open-16.svg',
    'unfold-open-24.svg',
    'unlock-16.svg',
    'unlock-24.svg',
    'upload-16.svg',
    'upload-24.svg',
    'upload.svg',
    'user-16.svg',
    'user-24.svg',
    'user-add.svg',
    'user-check-16.svg',
    'user-check-24.svg',
    'user-circle-16.svg',
    'user-circle-24.svg',
    'user-circle-fill-16.svg',
    'user-circle-fill-24.svg',
    'user-minus-16.svg',
    'user-minus-24.svg',
    'user-organization.svg',
    'user-plain.svg',
    'user-plus-16.svg',
    'user-plus-24.svg',
    'user-square-fill.svg',
    'user-square-outline.svg',
    'user-team.svg',
    'user-x-16.svg',
    'user-x-24.svg',
    'users-16.svg',
    'users-24.svg',
    'vault-16.svg',
    'vault-24.svg',
    'verified-16.svg',
    'verified-24.svg',
    'video-16.svg',
    'video-24.svg',
    'video-off-16.svg',
    'video-off-24.svg',
    'visibility-hide.svg',
    'visibility-show.svg',
    'vmware-16.svg',
    'vmware-24.svg',
    'vmware-color-16.svg',
    'vmware-color-24.svg',
    'volume-16.svg',
    'volume-2-16.svg',
    'volume-2-24.svg',
    'volume-24.svg',
    'volume-down-16.svg',
    'volume-down-24.svg',
    'volume-x-16.svg',
    'volume-x-24.svg',
    'wall-16.svg',
    'wall-24.svg',
    'watch-16.svg',
    'watch-24.svg',
    'webhook-16.svg',
    'webhook-24.svg',
    'webhook.svg',
    'wifi-16.svg',
    'wifi-24.svg',
    'wifi-off-16.svg',
    'wifi-off-24.svg',
    'wrench-16.svg',
    'wrench-24.svg',
    'x-16.svg',
    'x-24.svg',
    'x-circle-16.svg',
    'x-circle-24.svg',
    'x-circle-fill-16.svg',
    'x-circle-fill-24.svg',
    'x-diamond-16.svg',
    'x-diamond-24.svg',
    'x-diamond-fill-16.svg',
    'x-diamond-fill-24.svg',
    'x-hexagon-16.svg',
    'x-hexagon-24.svg',
    'x-hexagon-fill-16.svg',
    'x-hexagon-fill-24.svg',
    'x-square-16.svg',
    'x-square-24.svg',
    'x-square-fill-16.svg',
    'x-square-fill-24.svg',
    'zap-16.svg',
    'zap-24.svg',
    'zap-off-16.svg',
    'zap-off-24.svg',
    'zoom-in-16.svg',
    'zoom-in-24.svg',
    'zoom-out-16.svg',
    'zoom-out-24.svg',
  ]
    .filter((item) => {
      const sized = item.endsWith('-16.svg') || item.endsWith('-24.svg');
      return lib === 'structure' ? !sized : sized;
    })
    .map((item) => {
      const temp = item.split('.');
      temp.pop();
      const name = temp.join('.');
      let placeholder = `with-${name}`;
      if (name.indexOf('-color') !== -1) {
        placeholder = `${placeholder}-icon`;
      } else {
        placeholder = `${placeholder}-mask`;
      }
      return {
        placeholder: placeholder,
        name: name,
      };
    });
});
