/*  job_sumterms.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_SUMTERMS_H_
#define JOB_SUMTERMS_H_

#include "job.h"

namespace Reduze {

/// Job to sum terms
class SumTerms: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("sum_terms");
		s.set_short_description("Sums terms.");
		s.set_long_description(""
			"Job to sum up linear combinations or equations."
			" No normalization of coefficients or simplification of"
			" integrals is performed, use job 'normalize' for that.");
		s.add_option("input_file", true, "string", "Input file name.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	SumTerms() {
		add_auto_options();
	}
	virtual ~SumTerms() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_file_);
		add_auto_io("output_file", output_file_);
	}
	virtual void init();
private:
	std::string input_file_; // input
	std::string output_file_; // ouput
};

}

#endif /* JOB_SUMTERMS_H_ */
