/*  job_generateseeds.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_generateseeds.h"
#include "rspoint.h"
#include "int.h"
#include "sector.h"
#include "functions.h"
#include "files.h"
#include "filedata.h"
#include "yamlutils.h"

using namespace std;
using namespace GiNaC;

namespace Reduze {

// register job type at JobFactory
namespace {
JobProxy<GenerateSeeds> dummy;
}

void GenerateSeeds::run_serial() {
	if (sector_.empty())
		throw runtime_error("missing sector definition");
	LOG("Generating seed integrals");
	const Sector& sector = sector_.front();
	Timer timer;
	const IntegralFamily* ic = sector.integralfamily();
	SeedGenerator seed_generator(ic, options_);
	set<INT> seeds;
	seed_generator.generate(sector.id(), ranges_, seeds);
	make_directory(get_directory_of_filename(output_file_));
	OutFileINTs out(output_file_);
	for (set<INT>::const_iterator s = seeds.begin(); s != seeds.end(); ++s)
		out << *s;
	out.finalize();
	LOG("Seed integrals generated: " << seeds.size() << " " << timer.get_wall_time_nice_string());
}

bool GenerateSeeds::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	//find_dependencies_all_sectormappings(outothers, in, auxjobs);
	out.push_back(output_file_);
	return true;
}

string GenerateSeeds::get_description() const {
	ostringstream ss;
	ss << "generate seeds: " << get_filename_without_directory(output_file_);
	return ss.str();
}

void GenerateSeeds::print_manual_options(YAML::Emitter& os) const {
	using namespace YAML;
	os << Key << "sector" << Value;
	if (!sector_.empty())
		os << sector_.front();
	else
		// print empty list (for doc)
		os << sector_;
}

void GenerateSeeds::read_manual_options(const YAML::Node& node) {
	sector_.push_back(Sector(node["sector"]));
}

} // namespace Reduze
