/*  job_extractdatabasecontents.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifdef HAVE_DATABASE

#ifndef JOB_EXTRACTDATABASECONTENTS_H_
#define JOB_EXTRACTDATABASECONTENTS_H_

#include "job.h"

namespace Reduze {

/// Job to extract contents from a database of an aborted reduction
class ExtractDatabaseContents: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("extract_database_contents");
		s.set_short_description(
				"Extracts intermediate results from aborted reduction.");
		s.set_long_description(""//
					"Job to extract the contents of the database files"
					" of an aborted reduction run. This might be useful"
					" to use results from a reduction which takes too"
					" long to finish.");
		s.add_option("database_file", true, "string",
				"Name of database file (ends with .db)");
		s.add_option("output_file_identities", false, "string",
				"Name of file the equations to be reduced should be written to."
					" Empty string skips extraction of equations to be reduced.");
		s.add_option("output_file_external", false, "string",
				"Name of file the subsector equations to be reduced should be"
				" written to."
				" Empty string skips extraction of equations to be reduced.");
		s.add_option("output_file_substitutions", false, "string",
				"Name of file the substitutions should be written to."
					" Empty string skips extraction of substitutions.");
		s.add_option("use_transactions", true, "boolean", ""//
				"It should be safe to use true here and in the reduction run.");
		s.add_option("cache_size", false, "integer", ""//
				" Size of the database RAM cache in bytes,"
				" must be smaller than 4294967296.");
		s.add_option("compress_coefficients", true, "boolean", ""//
				"Must be the same as in the reduction run.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	ExtractDatabaseContents() :
			use_transactions_(true),//
			cache_size_(512 * 1024 * 1024), //
			compress_coefficients_(false)
    {
		add_auto_options();
	}
	virtual ~ExtractDatabaseContents() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("database_file", database_file_);
		add_auto_io("output_file_identities", output_file_identities_);
		add_auto_io("output_file_external", output_file_external_);
		add_auto_io("output_file_substitutions", output_file_substitutions_);
	}
	virtual void init();
private:
	std::string database_file_; // input
	std::string output_file_identities_, output_file_external_,
			output_file_substitutions_; // output
	bool use_transactions_;
	long cache_size_; // e.g. 512 * 1024 * 1024, converted to u_int32_t later on
	bool compress_coefficients_;
};

}

#endif /* JOB_APPLYSHIFTS_H_ */

#endif // HAVE_DATABASE
