/*  job_catfiles.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_catfiles.h"
#include "functions.h"
#include "files.h"
#include "yamlutils.h"

using namespace std;

namespace Reduze {

namespace {
JobProxy<CatFiles> dummy;
}

bool CatFiles::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	list<string>::const_iterator f;
	for (f = input_files_.begin(); f != input_files_.end(); ++f)
		in.push_back(*f);
	out.push_back(output_file_);
	return true;
}

void CatFiles::init() {
	if (input_files_.empty() || input_files_.front().empty()
			|| output_file_.empty())
		throw runtime_error("input files or output files undefined");
}

std::string CatFiles::get_description() const {
	return "cat files to " + short_filename(output_file_);
}

void CatFiles::run_serial() {
	string output_file_tmp = output_file_ + ".tmp";
	ofstream out(output_file_tmp.c_str());
	if (!out.good())
		ABORT("can't write to file " << output_file_tmp);
	list<string>::const_iterator it;
	for (it = input_files_.begin(); it != input_files_.end(); ++it) {
		LOG("Reading file " << *it);
		ifstream in(it->c_str());
		string l;
		while (getline(in, l))
			out << l << '\n';
	}
	out.close();
	rename(output_file_tmp, output_file_);
	LOG("Output written to " << output_file_);
	if (delete_input_files_) {
		LOG("Deleting input files");
		for (it = input_files_.begin(); it != input_files_.end(); ++it)
			remove(*it);
	}
}

}
