// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/authz.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UserCanCreateOrganizationRepositoryRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanCreateOrganizationRepositoryRequest) Reset() {
	*x = UserCanCreateOrganizationRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryRequest) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanCreateOrganizationRepositoryRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanCreateOrganizationRepositoryRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanCreateOrganizationRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanCreateOrganizationRepositoryRequest_builder) Build() *UserCanCreateOrganizationRepositoryRequest {
	m0 := &UserCanCreateOrganizationRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanCreateOrganizationRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanCreateOrganizationRepositoryResponse) Reset() {
	*x = UserCanCreateOrganizationRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryResponse) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanCreateOrganizationRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanCreateOrganizationRepositoryResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanCreateOrganizationRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanCreateOrganizationRepositoryResponse_builder) Build() *UserCanCreateOrganizationRepositoryResponse {
	m0 := &UserCanCreateOrganizationRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeRepositorySettingsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanSeeRepositorySettingsRequest) Reset() {
	*x = UserCanSeeRepositorySettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsRequest) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeRepositorySettingsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanSeeRepositorySettingsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanSeeRepositorySettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanSeeRepositorySettingsRequest_builder) Build() *UserCanSeeRepositorySettingsRequest {
	m0 := &UserCanSeeRepositorySettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanSeeRepositorySettingsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeRepositorySettingsResponse) Reset() {
	*x = UserCanSeeRepositorySettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsResponse) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeRepositorySettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeRepositorySettingsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeRepositorySettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeRepositorySettingsResponse_builder) Build() *UserCanSeeRepositorySettingsResponse {
	m0 := &UserCanSeeRepositorySettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeOrganizationSettingsRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanSeeOrganizationSettingsRequest) Reset() {
	*x = UserCanSeeOrganizationSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsRequest) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeOrganizationSettingsRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanSeeOrganizationSettingsRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanSeeOrganizationSettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanSeeOrganizationSettingsRequest_builder) Build() *UserCanSeeOrganizationSettingsRequest {
	m0 := &UserCanSeeOrganizationSettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanSeeOrganizationSettingsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeOrganizationSettingsResponse) Reset() {
	*x = UserCanSeeOrganizationSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsResponse) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeOrganizationSettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeOrganizationSettingsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeOrganizationSettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeOrganizationSettingsResponse_builder) Build() *UserCanSeeOrganizationSettingsResponse {
	m0 := &UserCanSeeOrganizationSettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanAddOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanAddOrganizationMemberRequest) Reset() {
	*x = UserCanAddOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanAddOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanAddOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanAddOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanAddOrganizationMemberRequest_builder) Build() *UserCanAddOrganizationMemberRequest {
	m0 := &UserCanAddOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanAddOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanAddOrganizationMemberResponse) Reset() {
	*x = UserCanAddOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanAddOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanAddOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanAddOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to add, empty list means the user is
	// not authorized to add any members.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanAddOrganizationMemberResponse_builder) Build() *UserCanAddOrganizationMemberResponse {
	m0 := &UserCanAddOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanUpdateOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanUpdateOrganizationMemberRequest) Reset() {
	*x = UserCanUpdateOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanUpdateOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanUpdateOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanUpdateOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanUpdateOrganizationMemberRequest_builder) Build() *UserCanUpdateOrganizationMemberRequest {
	m0 := &UserCanUpdateOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanUpdateOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanUpdateOrganizationMemberResponse) Reset() {
	*x = UserCanUpdateOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanUpdateOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanUpdateOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanUpdateOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to update (from and to), empty list means the user is
	// not authorized to update any members' role.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanUpdateOrganizationMemberResponse_builder) Build() *UserCanUpdateOrganizationMemberResponse {
	m0 := &UserCanUpdateOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanRemoveOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanRemoveOrganizationMemberRequest) Reset() {
	*x = UserCanRemoveOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanRemoveOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanRemoveOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanRemoveOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanRemoveOrganizationMemberRequest_builder) Build() *UserCanRemoveOrganizationMemberRequest {
	m0 := &UserCanRemoveOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanRemoveOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanRemoveOrganizationMemberResponse) Reset() {
	*x = UserCanRemoveOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanRemoveOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanRemoveOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanRemoveOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to remove, empty list means the user is
	// not authorized to remove any members.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanRemoveOrganizationMemberResponse_builder) Build() *UserCanRemoveOrganizationMemberResponse {
	m0 := &UserCanRemoveOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanDeleteOrganizationRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanDeleteOrganizationRequest) Reset() {
	*x = UserCanDeleteOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationRequest) ProtoMessage() {}

func (x *UserCanDeleteOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteOrganizationRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanDeleteOrganizationRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanDeleteOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanDeleteOrganizationRequest_builder) Build() *UserCanDeleteOrganizationRequest {
	m0 := &UserCanDeleteOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanDeleteOrganizationResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteOrganizationResponse) Reset() {
	*x = UserCanDeleteOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationResponse) ProtoMessage() {}

func (x *UserCanDeleteOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteOrganizationResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteOrganizationResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteOrganizationResponse_builder) Build() *UserCanDeleteOrganizationResponse {
	m0 := &UserCanDeleteOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanDeleteRepositoryRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanDeleteRepositoryRequest) Reset() {
	*x = UserCanDeleteRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryRequest) ProtoMessage() {}

func (x *UserCanDeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanDeleteRepositoryRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanDeleteRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanDeleteRepositoryRequest_builder) Build() *UserCanDeleteRepositoryRequest {
	m0 := &UserCanDeleteRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanDeleteRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteRepositoryResponse) Reset() {
	*x = UserCanDeleteRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryResponse) ProtoMessage() {}

func (x *UserCanDeleteRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteRepositoryResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteRepositoryResponse_builder) Build() *UserCanDeleteRepositoryResponse {
	m0 := &UserCanDeleteRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanDeleteUserRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCanDeleteUserRequest) Reset() {
	*x = UserCanDeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserRequest) ProtoMessage() {}

func (x *UserCanDeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UserCanDeleteUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UserCanDeleteUserRequest_builder) Build() *UserCanDeleteUserRequest {
	m0 := &UserCanDeleteUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UserCanDeleteUserResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteUserResponse) Reset() {
	*x = UserCanDeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserResponse) ProtoMessage() {}

func (x *UserCanDeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteUserResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteUserResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteUserResponse_builder) Build() *UserCanDeleteUserResponse {
	m0 := &UserCanDeleteUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeServerAdminPanelRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCanSeeServerAdminPanelRequest) Reset() {
	*x = UserCanSeeServerAdminPanelRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelRequest) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UserCanSeeServerAdminPanelRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UserCanSeeServerAdminPanelRequest_builder) Build() *UserCanSeeServerAdminPanelRequest {
	m0 := &UserCanSeeServerAdminPanelRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UserCanSeeServerAdminPanelResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeServerAdminPanelResponse) Reset() {
	*x = UserCanSeeServerAdminPanelResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelResponse) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeServerAdminPanelResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeServerAdminPanelResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeServerAdminPanelResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeServerAdminPanelResponse_builder) Build() *UserCanSeeServerAdminPanelResponse {
	m0 := &UserCanSeeServerAdminPanelResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanManageRepositoryContributorsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanManageRepositoryContributorsRequest) Reset() {
	*x = UserCanManageRepositoryContributorsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsRequest) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanManageRepositoryContributorsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanManageRepositoryContributorsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanManageRepositoryContributorsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanManageRepositoryContributorsRequest_builder) Build() *UserCanManageRepositoryContributorsRequest {
	m0 := &UserCanManageRepositoryContributorsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanManageRepositoryContributorsResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []RepositoryRole       `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanManageRepositoryContributorsResponse) Reset() {
	*x = UserCanManageRepositoryContributorsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsResponse) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanManageRepositoryContributorsResponse) GetAuthorizedRoles() []RepositoryRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanManageRepositoryContributorsResponse) SetAuthorizedRoles(v []RepositoryRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanManageRepositoryContributorsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to manage, empty list means the user is
	// not authorized to manage any contributors.
	AuthorizedRoles []RepositoryRole
}

func (b0 UserCanManageRepositoryContributorsResponse_builder) Build() *UserCanManageRepositoryContributorsResponse {
	m0 := &UserCanManageRepositoryContributorsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanReviewCommitsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanReviewCommitsRequest) Reset() {
	*x = UserCanReviewCommitsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsRequest) ProtoMessage() {}

func (x *UserCanReviewCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanReviewCommitsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanReviewCommitsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanReviewCommitsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanReviewCommitsRequest_builder) Build() *UserCanReviewCommitsRequest {
	m0 := &UserCanReviewCommitsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanReviewCommitsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanReviewCommitsResponse) Reset() {
	*x = UserCanReviewCommitsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsResponse) ProtoMessage() {}

func (x *UserCanReviewCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanReviewCommitsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanReviewCommitsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanReviewCommitsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanReviewCommitsResponse_builder) Build() *UserCanReviewCommitsResponse {
	m0 := &UserCanReviewCommitsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

var File_buf_alpha_registry_v1alpha1_authz_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc = string([]byte{
	0x0a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x7a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x55,
	0x0a, 0x2a, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x2b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x22, 0x4a, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53,
	0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64,
	0x22, 0x46, 0x0a, 0x24, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x50, 0x0a, 0x25, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x48, 0x0a, 0x26, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x22, 0x4e, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41,
	0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0x80, 0x01, 0x0a, 0x24, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x41, 0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a,
	0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x26, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x27, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73,
	0x22, 0x51, 0x0a, 0x26, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x27, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x58, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x4b, 0x0a, 0x20, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a,
	0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x43, 0x0a, 0x21, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x45, 0x0a, 0x1e, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x22, 0x41, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x3b, 0x0a, 0x19, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x23,
	0x0a, 0x21, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0x44, 0x0a, 0x22, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x51, 0x0a, 0x2a, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x85, 0x01, 0x0a,
	0x2b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x10,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52,
	0x6f, 0x6c, 0x65, 0x73, 0x22, 0x42, 0x0a, 0x1b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x3e, 0x0a, 0x1c, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x32, 0xfd, 0x0f, 0x0a, 0x0c, 0x41, 0x75, 0x74,
	0x68, 0x7a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x23, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x47, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0xae, 0x01, 0x0a, 0x1e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x41, 0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x64, 0x64, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x64,
	0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01,
	0x12, 0xb1, 0x01, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0xb1, 0x01, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x9f, 0x01, 0x0a, 0x19, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x99, 0x01, 0x0a, 0x17, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x87, 0x01, 0x0a, 0x11, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x35, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01,
	0x12, 0xa2, 0x01, 0x0a, 0x1a, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x12,
	0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xbd, 0x01, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x47, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x90, 0x01, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x38,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x97, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0a, 0x41, 0x75,
	0x74, 0x68, 0x7a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f,
	0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75,
	0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = []any{
	(*UserCanCreateOrganizationRepositoryRequest)(nil),  // 0: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	(*UserCanCreateOrganizationRepositoryResponse)(nil), // 1: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	(*UserCanSeeRepositorySettingsRequest)(nil),         // 2: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	(*UserCanSeeRepositorySettingsResponse)(nil),        // 3: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	(*UserCanSeeOrganizationSettingsRequest)(nil),       // 4: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	(*UserCanSeeOrganizationSettingsResponse)(nil),      // 5: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	(*UserCanAddOrganizationMemberRequest)(nil),         // 6: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	(*UserCanAddOrganizationMemberResponse)(nil),        // 7: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	(*UserCanUpdateOrganizationMemberRequest)(nil),      // 8: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	(*UserCanUpdateOrganizationMemberResponse)(nil),     // 9: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	(*UserCanRemoveOrganizationMemberRequest)(nil),      // 10: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	(*UserCanRemoveOrganizationMemberResponse)(nil),     // 11: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	(*UserCanDeleteOrganizationRequest)(nil),            // 12: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	(*UserCanDeleteOrganizationResponse)(nil),           // 13: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	(*UserCanDeleteRepositoryRequest)(nil),              // 14: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	(*UserCanDeleteRepositoryResponse)(nil),             // 15: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	(*UserCanDeleteUserRequest)(nil),                    // 16: buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	(*UserCanDeleteUserResponse)(nil),                   // 17: buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	(*UserCanSeeServerAdminPanelRequest)(nil),           // 18: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	(*UserCanSeeServerAdminPanelResponse)(nil),          // 19: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	(*UserCanManageRepositoryContributorsRequest)(nil),  // 20: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	(*UserCanManageRepositoryContributorsResponse)(nil), // 21: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	(*UserCanReviewCommitsRequest)(nil),                 // 22: buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	(*UserCanReviewCommitsResponse)(nil),                // 23: buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	(OrganizationRole)(0),                               // 24: buf.alpha.registry.v1alpha1.OrganizationRole
	(RepositoryRole)(0),                                 // 25: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = []int32{
	24, // 0: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 1: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 2: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	25, // 3: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	0,  // 4: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	2,  // 5: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	4,  // 6: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	6,  // 7: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	8,  // 8: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	10, // 9: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	12, // 10: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	14, // 11: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	16, // 12: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	18, // 13: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	20, // 14: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:input_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	22, // 15: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:input_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	1,  // 16: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	3,  // 17: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	5,  // 18: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	7,  // 19: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	9,  // 20: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	11, // 21: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	13, // 22: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	15, // 23: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	17, // 24: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	19, // 25: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	21, // 26: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:output_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	23, // 27: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:output_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	16, // [16:28] is the sub-list for method output_type
	4,  // [4:16] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_authz_proto_init() }
func file_buf_alpha_registry_v1alpha1_authz_proto_init() {
	if File_buf_alpha_registry_v1alpha1_authz_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_authz_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_authz_proto = out.File
	file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = nil
}
