/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator;

import io.spring.githubchangeloggenerator.ChangelogGenerator;
import java.io.IOException;
import java.util.List;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class CommandProcessor
implements ApplicationRunner {
    private final ChangelogGenerator generator;

    public CommandProcessor(ChangelogGenerator generator) {
        this.generator = generator;
    }

    public void run(ApplicationArguments args) throws IOException {
        this.run(args.getNonOptionArgs());
    }

    private void run(List<String> args) throws IOException {
        String milestone = args.get(0);
        String path = args.get(1);
        this.run(milestone, path);
    }

    private void run(String milestone, String path) throws IOException {
        Assert.hasLength((String)milestone, (String)"Milestone must be specified");
        Assert.hasLength((String)path, (String)"Path must be specified");
        this.generator.generate(milestone, path);
    }
}

