
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'pk' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'pk'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-') -or
                $element.Value -eq $wordToComplete) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'pk' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('--version', '--version', [CompletionResultType]::ParameterName, 'Print version')
            [CompletionResult]::new('completion', 'completion', [CompletionResultType]::ParameterValue, 'Generate shell completion')
            [CompletionResult]::new('cpv', 'cpv', [CompletionResultType]::ParameterValue, 'Cpv commands')
            [CompletionResult]::new('dep', 'dep', [CompletionResultType]::ParameterValue, 'Dependency commands')
            [CompletionResult]::new('pkg', 'pkg', [CompletionResultType]::ParameterValue, 'Package commands')
            [CompletionResult]::new('repo', 'repo', [CompletionResultType]::ParameterValue, 'Repository commands')
            [CompletionResult]::new('version', 'version', [CompletionResultType]::ParameterValue, 'Version commands')
            break
        }
        'pk;completion' {
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Target directory for completion files')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;cpv' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('compare', 'compare', [CompletionResultType]::ParameterValue, 'Compare two cpvs')
            [CompletionResult]::new('intersect', 'intersect', [CompletionResultType]::ParameterValue, 'Determine if a cpv intersects another value')
            [CompletionResult]::new('parse', 'parse', [CompletionResultType]::ParameterValue, 'Parse cpv and optionally print formatted output')
            [CompletionResult]::new('set', 'set', [CompletionResultType]::ParameterValue, 'Collapse cpvs into a set')
            [CompletionResult]::new('sort', 'sort', [CompletionResultType]::ParameterValue, 'Sort cpvs')
            break
        }
        'pk;cpv;compare' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            break
        }
        'pk;cpv;intersect' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;cpv;parse' {
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;cpv;set' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;cpv;sort' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;dep' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('compare', 'compare', [CompletionResultType]::ParameterValue, 'Compare two deps')
            [CompletionResult]::new('intersect', 'intersect', [CompletionResultType]::ParameterValue, 'Determine if a dep intersects another value')
            [CompletionResult]::new('parse', 'parse', [CompletionResultType]::ParameterValue, 'Parse a dep and optionally print formatted output')
            [CompletionResult]::new('set', 'set', [CompletionResultType]::ParameterValue, 'Collapse deps into a set')
            [CompletionResult]::new('sort', 'sort', [CompletionResultType]::ParameterValue, 'Sort deps')
            break
        }
        'pk;dep;compare' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            break
        }
        'pk;dep;intersect' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;dep;parse' {
            [CompletionResult]::new('--eapi', '--eapi', [CompletionResultType]::ParameterName, 'Use a specific EAPI')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;dep;set' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;dep;sort' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('env', 'env', [CompletionResultType]::ParameterValue, 'Output ebuild environment')
            [CompletionResult]::new('fetch', 'fetch', [CompletionResultType]::ParameterValue, 'Fetch distfiles')
            [CompletionResult]::new('manifest', 'manifest', [CompletionResultType]::ParameterValue, 'Update manifests')
            [CompletionResult]::new('metadata', 'metadata', [CompletionResultType]::ParameterValue, 'Manipulate package metadata')
            [CompletionResult]::new('pretend', 'pretend', [CompletionResultType]::ParameterValue, 'Run the pkg_pretend phase')
            [CompletionResult]::new('revdeps', 'revdeps', [CompletionResultType]::ParameterValue, 'Output reverse dependencies')
            [CompletionResult]::new('showkw', 'showkw', [CompletionResultType]::ParameterValue, 'Output package keywords')
            [CompletionResult]::new('source', 'source', [CompletionResultType]::ParameterValue, 'Benchmark ebuild sourcing')
            break
        }
        'pk;pkg;env' {
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Variable filtering')
            [CompletionResult]::new('--filter', '--filter', [CompletionResultType]::ParameterName, 'Variable filtering')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;fetch' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'Concurrent downloads')
            [CompletionResult]::new('--concurrent', '--concurrent', [CompletionResultType]::ParameterName, 'Concurrent downloads')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Download directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Download directory')
            [CompletionResult]::new('-F', '-F ', [CompletionResultType]::ParameterName, 'Filter URLs via regex')
            [CompletionResult]::new('--filter', '--filter', [CompletionResultType]::ParameterName, 'Filter URLs via regex')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'Connection timeout in seconds')
            [CompletionResult]::new('--timeout', '--timeout', [CompletionResultType]::ParameterName, 'Connection timeout in seconds')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Overwrite existing files')
            [CompletionResult]::new('--force', '--force', [CompletionResultType]::ParameterName, 'Overwrite existing files')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-I', '-I ', [CompletionResultType]::ParameterName, 'Ignore invalid service certificates')
            [CompletionResult]::new('--insecure', '--insecure', [CompletionResultType]::ParameterName, 'Ignore invalid service certificates')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'Try fetching from default mirrors')
            [CompletionResult]::new('--mirrors', '--mirrors', [CompletionResultType]::ParameterName, 'Try fetching from default mirrors')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'Disable progress output')
            [CompletionResult]::new('--no-progress', '--no-progress', [CompletionResultType]::ParameterName, 'Disable progress output')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Output targets instead of fetching them')
            [CompletionResult]::new('--pretend', '--pretend', [CompletionResultType]::ParameterName, 'Output targets instead of fetching them')
            [CompletionResult]::new('--restrict', '--restrict', [CompletionResultType]::ParameterName, 'Process fetch-restricted URLS')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;manifest' {
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'Concurrent downloads')
            [CompletionResult]::new('--concurrent', '--concurrent', [CompletionResultType]::ParameterName, 'Concurrent downloads')
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Download directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Download directory')
            [CompletionResult]::new('-t', '-t', [CompletionResultType]::ParameterName, 'Connection timeout in seconds')
            [CompletionResult]::new('--timeout', '--timeout', [CompletionResultType]::ParameterName, 'Connection timeout in seconds')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--thick', '--thick', [CompletionResultType]::ParameterName, 'Force manifest type')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Force remanifest')
            [CompletionResult]::new('--force', '--force', [CompletionResultType]::ParameterName, 'Force remanifest')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid service certificates')
            [CompletionResult]::new('--insecure', '--insecure', [CompletionResultType]::ParameterName, 'Ignore invalid service certificates')
            [CompletionResult]::new('-m', '-m', [CompletionResultType]::ParameterName, 'Try fetching from default mirrors')
            [CompletionResult]::new('--mirrors', '--mirrors', [CompletionResultType]::ParameterName, 'Try fetching from default mirrors')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'Disable progress output')
            [CompletionResult]::new('--no-progress', '--no-progress', [CompletionResultType]::ParameterName, 'Disable progress output')
            [CompletionResult]::new('--stdout', '--stdout', [CompletionResultType]::ParameterName, 'Output to stdout')
            [CompletionResult]::new('--restrict', '--restrict', [CompletionResultType]::ParameterName, 'Process fetch-restricted URLS')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;metadata' {
            [CompletionResult]::new('-j', '-j', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('--jobs', '--jobs', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--path', '--path', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Custom cache format')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Force regeneration to occur')
            [CompletionResult]::new('--force', '--force', [CompletionResultType]::ParameterName, 'Force regeneration to occur')
            [CompletionResult]::new('-V', '-V ', [CompletionResultType]::ParameterName, 'Verify metadata without updating cache')
            [CompletionResult]::new('--verify', '--verify', [CompletionResultType]::ParameterName, 'Verify metadata without updating cache')
            [CompletionResult]::new('-R', '-R ', [CompletionResultType]::ParameterName, 'Remove cache entries')
            [CompletionResult]::new('--remove', '--remove', [CompletionResultType]::ParameterName, 'Remove cache entries')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'Disable progress bar')
            [CompletionResult]::new('--no-progress', '--no-progress', [CompletionResultType]::ParameterName, 'Disable progress bar')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'Capture stderr and stdout')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'Capture stderr and stdout')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;pretend' {
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;revdeps' {
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repository')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repository')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;showkw' {
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('-a', '-a', [CompletionResultType]::ParameterName, 'Target arches')
            [CompletionResult]::new('--arches', '--arches', [CompletionResultType]::ParameterName, 'Target arches')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Set the tabular format')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Set the tabular format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Show prefix arches')
            [CompletionResult]::new('--prefix', '--prefix', [CompletionResultType]::ParameterName, 'Show prefix arches')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;pkg;source' {
            [CompletionResult]::new('-j', '-j', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('--jobs', '--jobs', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('-b', '-b', [CompletionResultType]::ParameterName, 'Benchmark for a duration or number of runs')
            [CompletionResult]::new('--bench', '--bench', [CompletionResultType]::ParameterName, 'Benchmark for a duration or number of runs')
            [CompletionResult]::new('-B', '-B ', [CompletionResultType]::ParameterName, 'Apply bounds to elapsed time')
            [CompletionResult]::new('--bound', '--bound', [CompletionResultType]::ParameterName, 'Apply bounds to elapsed time')
            [CompletionResult]::new('-c', '-c', [CompletionResultType]::ParameterName, 'Benchmark across all targets cumulatively')
            [CompletionResult]::new('--cumulative', '--cumulative', [CompletionResultType]::ParameterName, 'Benchmark across all targets cumulatively')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'f')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'format')
            [CompletionResult]::new('-r', '-r', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--repo', '--repo', [CompletionResultType]::ParameterName, 'Target repo')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('--sort', '--sort', [CompletionResultType]::ParameterName, 'Sort output in ascending order for elapsed time')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            break
        }
        'pk;repo' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('add', 'add', [CompletionResultType]::ParameterValue, 'Add repository to config')
            [CompletionResult]::new('eapi', 'eapi', [CompletionResultType]::ParameterValue, 'Output EAPI statistics')
            [CompletionResult]::new('eclass', 'eclass', [CompletionResultType]::ParameterValue, 'Output eclass statistics')
            [CompletionResult]::new('leaf', 'leaf', [CompletionResultType]::ParameterValue, 'Output leaf packages')
            [CompletionResult]::new('license', 'license', [CompletionResultType]::ParameterValue, 'Output license statistics')
            [CompletionResult]::new('list', 'list', [CompletionResultType]::ParameterValue, 'List repositories')
            [CompletionResult]::new('metadata', 'metadata', [CompletionResultType]::ParameterValue, 'Manipulate repo metadata')
            [CompletionResult]::new('mirror', 'mirror', [CompletionResultType]::ParameterValue, 'Output mirror statistics')
            [CompletionResult]::new('remove', 'remove', [CompletionResultType]::ParameterValue, 'Remove repositories')
            [CompletionResult]::new('revdeps', 'revdeps', [CompletionResultType]::ParameterValue, 'Output revdeps cache')
            [CompletionResult]::new('sync', 'sync', [CompletionResultType]::ParameterValue, 'Sync repos')
            break
        }
        'pk;repo;add' {
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'Repository name')
            [CompletionResult]::new('--name', '--name', [CompletionResultType]::ParameterName, 'Repository name')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Repository priority')
            [CompletionResult]::new('--priority', '--priority', [CompletionResultType]::ParameterName, 'Repository priority')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Only create the config file')
            [CompletionResult]::new('--file', '--file', [CompletionResultType]::ParameterName, 'Only create the config file')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;eapi' {
            [CompletionResult]::new('--eapi', '--eapi', [CompletionResultType]::ParameterName, 'Output packages for a target EAPI')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;eclass' {
            [CompletionResult]::new('--eclass', '--eclass', [CompletionResultType]::ParameterName, 'Output packages for a target eclass')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;leaf' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;license' {
            [CompletionResult]::new('--licenses', '--licenses', [CompletionResultType]::ParameterName, 'Output packages for target licenses')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;list' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Output full repository info')
            [CompletionResult]::new('--full', '--full', [CompletionResultType]::ParameterName, 'Output full repository info')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Output repository paths')
            [CompletionResult]::new('--path', '--path', [CompletionResultType]::ParameterName, 'Output repository paths')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;metadata' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('clean', 'clean', [CompletionResultType]::ParameterValue, 'Clean metadata cache')
            [CompletionResult]::new('regen', 'regen', [CompletionResultType]::ParameterValue, 'Regenerate metadata cache')
            [CompletionResult]::new('remove', 'remove', [CompletionResultType]::ParameterValue, 'Remove metadata cache')
            break
        }
        'pk;repo;metadata;clean' {
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--path', '--path', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Custom cache format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;metadata;regen' {
            [CompletionResult]::new('-j', '-j', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('--jobs', '--jobs', [CompletionResultType]::ParameterName, 'Parallel jobs to run')
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--path', '--path', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Custom cache format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Force regeneration to occur')
            [CompletionResult]::new('--force', '--force', [CompletionResultType]::ParameterName, 'Force regeneration to occur')
            [CompletionResult]::new('-n', '-n', [CompletionResultType]::ParameterName, 'Disable progress bar')
            [CompletionResult]::new('--no-progress', '--no-progress', [CompletionResultType]::ParameterName, 'Disable progress bar')
            [CompletionResult]::new('-o', '-o', [CompletionResultType]::ParameterName, 'Capture stderr and stdout')
            [CompletionResult]::new('--output', '--output', [CompletionResultType]::ParameterName, 'Capture stderr and stdout')
            [CompletionResult]::new('--use-local', '--use-local', [CompletionResultType]::ParameterName, 'Update local USE cache')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;metadata;remove' {
            [CompletionResult]::new('-p', '-p', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--path', '--path', [CompletionResultType]::ParameterName, 'Custom cache path')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Custom cache format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;mirror' {
            [CompletionResult]::new('--mirror', '--mirror', [CompletionResultType]::ParameterName, 'Output packages for a target mirror')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;remove' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;revdeps' {
            [CompletionResult]::new('-d', '-d', [CompletionResultType]::ParameterName, 'Target directory')
            [CompletionResult]::new('--dir', '--dir', [CompletionResultType]::ParameterName, 'Target directory')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-i', '-i', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('--ignore', '--ignore', [CompletionResultType]::ParameterName, 'Ignore invalid packages')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;repo;sync' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;version' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('compare', 'compare', [CompletionResultType]::ParameterValue, 'Compare two versions')
            [CompletionResult]::new('intersect', 'intersect', [CompletionResultType]::ParameterValue, 'Determine if two versions intersect')
            [CompletionResult]::new('parse', 'parse', [CompletionResultType]::ParameterValue, 'Parse a version and optionally print formatted output')
            [CompletionResult]::new('set', 'set', [CompletionResultType]::ParameterValue, 'Collapse versions into a set')
            [CompletionResult]::new('sort', 'sort', [CompletionResultType]::ParameterValue, 'Sort versions')
            break
        }
        'pk;version;compare' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help (see more with ''--help'')')
            break
        }
        'pk;version;intersect' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;version;parse' {
            [CompletionResult]::new('-f', '-f', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--format', '--format', [CompletionResultType]::ParameterName, 'Output using a custom format')
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;version;set' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
        'pk;version;sort' {
            [CompletionResult]::new('--color', '--color', [CompletionResultType]::ParameterName, 'Enable/disable color support')
            [CompletionResult]::new('--config', '--config', [CompletionResultType]::ParameterName, 'Use a custom config')
            [CompletionResult]::new('-v', '-v', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('--verbose', '--verbose', [CompletionResultType]::ParameterName, 'Increase logging verbosity')
            [CompletionResult]::new('-q', '-q', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--quiet', '--quiet', [CompletionResultType]::ParameterName, 'Decrease logging verbosity')
            [CompletionResult]::new('--portage', '--portage', [CompletionResultType]::ParameterName, 'Load repos from portage')
            [CompletionResult]::new('-h', '-h', [CompletionResultType]::ParameterName, 'Print help')
            [CompletionResult]::new('--help', '--help', [CompletionResultType]::ParameterName, 'Print help')
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
