// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dlm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateLifecyclePolicy = "CreateLifecyclePolicy"

// CreateLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLifecyclePolicy for more information on using the CreateLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLifecyclePolicyRequest method.
//    req, resp := client.CreateLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/CreateLifecyclePolicy
func (c *DLM) CreateLifecyclePolicyRequest(input *CreateLifecyclePolicyInput) (req *request.Request, output *CreateLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opCreateLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &CreateLifecyclePolicyInput{}
	}

	output = &CreateLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Creates a policy to manage the lifecycle of the specified Amazon Web Services
// resources. You can create up to 100 lifecycle policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation CreateLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * LimitExceededException
//   The request failed because a limit was exceeded.
//
//   * InternalServerException
//   The service failed in an unexpected way.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/CreateLifecyclePolicy
func (c *DLM) CreateLifecyclePolicy(input *CreateLifecyclePolicyInput) (*CreateLifecyclePolicyOutput, error) {
	req, out := c.CreateLifecyclePolicyRequest(input)
	return out, req.Send()
}

// CreateLifecyclePolicyWithContext is the same as CreateLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) CreateLifecyclePolicyWithContext(ctx aws.Context, input *CreateLifecyclePolicyInput, opts ...request.Option) (*CreateLifecyclePolicyOutput, error) {
	req, out := c.CreateLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLifecyclePolicy = "DeleteLifecyclePolicy"

// DeleteLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLifecyclePolicy for more information on using the DeleteLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLifecyclePolicyRequest method.
//    req, resp := client.DeleteLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/DeleteLifecyclePolicy
func (c *DLM) DeleteLifecyclePolicyRequest(input *DeleteLifecyclePolicyInput) (req *request.Request, output *DeleteLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecyclePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyId}/",
	}

	if input == nil {
		input = &DeleteLifecyclePolicyInput{}
	}

	output = &DeleteLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Deletes the specified lifecycle policy and halts the automated operations
// that the policy specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation DeleteLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A requested resource was not found.
//
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * LimitExceededException
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/DeleteLifecyclePolicy
func (c *DLM) DeleteLifecyclePolicy(input *DeleteLifecyclePolicyInput) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	return out, req.Send()
}

// DeleteLifecyclePolicyWithContext is the same as DeleteLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) DeleteLifecyclePolicyWithContext(ctx aws.Context, input *DeleteLifecyclePolicyInput, opts ...request.Option) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLifecyclePolicies = "GetLifecyclePolicies"

// GetLifecyclePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetLifecyclePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLifecyclePolicies for more information on using the GetLifecyclePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLifecyclePoliciesRequest method.
//    req, resp := client.GetLifecyclePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicies
func (c *DLM) GetLifecyclePoliciesRequest(input *GetLifecyclePoliciesInput) (req *request.Request, output *GetLifecyclePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetLifecyclePolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &GetLifecyclePoliciesInput{}
	}

	output = &GetLifecyclePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLifecyclePolicies API operation for Amazon Data Lifecycle Manager.
//
// Gets summary information about all or the specified data lifecycle policies.
//
// To get complete information about a policy, use GetLifecyclePolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation GetLifecyclePolicies for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A requested resource was not found.
//
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * LimitExceededException
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicies
func (c *DLM) GetLifecyclePolicies(input *GetLifecyclePoliciesInput) (*GetLifecyclePoliciesOutput, error) {
	req, out := c.GetLifecyclePoliciesRequest(input)
	return out, req.Send()
}

// GetLifecyclePoliciesWithContext is the same as GetLifecyclePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetLifecyclePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) GetLifecyclePoliciesWithContext(ctx aws.Context, input *GetLifecyclePoliciesInput, opts ...request.Option) (*GetLifecyclePoliciesOutput, error) {
	req, out := c.GetLifecyclePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLifecyclePolicy = "GetLifecyclePolicy"

// GetLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLifecyclePolicy for more information on using the GetLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLifecyclePolicyRequest method.
//    req, resp := client.GetLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicy
func (c *DLM) GetLifecyclePolicyRequest(input *GetLifecyclePolicyInput) (req *request.Request, output *GetLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opGetLifecyclePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyId}/",
	}

	if input == nil {
		input = &GetLifecyclePolicyInput{}
	}

	output = &GetLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Gets detailed information about the specified lifecycle policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation GetLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A requested resource was not found.
//
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * LimitExceededException
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicy
func (c *DLM) GetLifecyclePolicy(input *GetLifecyclePolicyInput) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	return out, req.Send()
}

// GetLifecyclePolicyWithContext is the same as GetLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) GetLifecyclePolicyWithContext(ctx aws.Context, input *GetLifecyclePolicyInput, opts ...request.Option) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/ListTagsForResource
func (c *DLM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Data Lifecycle Manager.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ResourceNotFoundException
//   A requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/ListTagsForResource
func (c *DLM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/TagResource
func (c *DLM) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Data Lifecycle Manager.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ResourceNotFoundException
//   A requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/TagResource
func (c *DLM) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UntagResource
func (c *DLM) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Data Lifecycle Manager.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ResourceNotFoundException
//   A requested resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UntagResource
func (c *DLM) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLifecyclePolicy = "UpdateLifecyclePolicy"

// UpdateLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLifecyclePolicy for more information on using the UpdateLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLifecyclePolicyRequest method.
//    req, resp := client.UpdateLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicy
func (c *DLM) UpdateLifecyclePolicyRequest(input *UpdateLifecyclePolicyInput) (req *request.Request, output *UpdateLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateLifecyclePolicy,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyId}",
	}

	if input == nil {
		input = &UpdateLifecyclePolicyInput{}
	}

	output = &UpdateLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Updates the specified lifecycle policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation UpdateLifecyclePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A requested resource was not found.
//
//   * InvalidRequestException
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * InternalServerException
//   The service failed in an unexpected way.
//
//   * LimitExceededException
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicy
func (c *DLM) UpdateLifecyclePolicy(input *UpdateLifecyclePolicyInput) (*UpdateLifecyclePolicyOutput, error) {
	req, out := c.UpdateLifecyclePolicyRequest(input)
	return out, req.Send()
}

// UpdateLifecyclePolicyWithContext is the same as UpdateLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) UpdateLifecyclePolicyWithContext(ctx aws.Context, input *UpdateLifecyclePolicyInput, opts ...request.Option) (*UpdateLifecyclePolicyOutput, error) {
	req, out := c.UpdateLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies an action for an event-based policy.
type Action struct {
	_ struct{} `type:"structure"`

	// The rule for copying shared snapshots across Regions.
	//
	// CrossRegionCopy is a required field
	CrossRegionCopy []*CrossRegionCopyAction `type:"list" required:"true"`

	// A descriptive name for the action.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.CrossRegionCopy == nil {
		invalidParams.Add(request.NewErrParamRequired("CrossRegionCopy"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CrossRegionCopy != nil {
		for i, v := range s.CrossRegionCopy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CrossRegionCopy", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrossRegionCopy sets the CrossRegionCopy field's value.
func (s *Action) SetCrossRegionCopy(v []*CrossRegionCopyAction) *Action {
	s.CrossRegionCopy = v
	return s
}

// SetName sets the Name field's value.
func (s *Action) SetName(v string) *Action {
	s.Name = &v
	return s
}

type CreateLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are
	// supported.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `type:"string" required:"true"`

	// The configuration details of the lifecycle policy.
	//
	// PolicyDetails is a required field
	PolicyDetails *PolicyDetails `type:"structure" required:"true"`

	// The desired activation state of the lifecycle policy after creation.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SettablePolicyStateValues"`

	// The tags to apply to the lifecycle policy during creation.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLifecyclePolicyInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.PolicyDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDetails"))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.PolicyDetails != nil {
		if err := s.PolicyDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateLifecyclePolicyInput) SetDescription(v string) *CreateLifecyclePolicyInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateLifecyclePolicyInput) SetExecutionRoleArn(v string) *CreateLifecyclePolicyInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *CreateLifecyclePolicyInput) SetPolicyDetails(v *PolicyDetails) *CreateLifecyclePolicyInput {
	s.PolicyDetails = v
	return s
}

// SetState sets the State field's value.
func (s *CreateLifecyclePolicyInput) SetState(v string) *CreateLifecyclePolicyInput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLifecyclePolicyInput) SetTags(v map[string]*string) *CreateLifecyclePolicyInput {
	s.Tags = v
	return s
}

type CreateLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyId sets the PolicyId field's value.
func (s *CreateLifecyclePolicyOutput) SetPolicyId(v string) *CreateLifecyclePolicyOutput {
	s.PolicyId = &v
	return s
}

// Specifies when to create snapshots of EBS volumes.
//
// You must specify either a Cron expression or an interval, interval unit,
// and start time. You cannot specify both.
type CreateRule struct {
	_ struct{} `type:"structure"`

	// The schedule, as a Cron expression. The schedule interval must be between
	// 1 hour and 1 year. For more information, see Cron expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch User Guide.
	CronExpression *string `min:"17" type:"string"`

	// The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8,
	// 12, and 24.
	Interval *int64 `min:"1" type:"integer"`

	// The interval unit.
	IntervalUnit *string `type:"string" enum:"IntervalUnitValues"`

	// Specifies the destination for snapshots created by the policy. To create
	// snapshots in the same Region as the source resource, specify CLOUD. To create
	// snapshots on the same Outpost as the source resource, specify OUTPOST_LOCAL.
	// If you omit this parameter, CLOUD is used by default.
	//
	// If the policy targets resources in an Amazon Web Services Region, then you
	// must create snapshots in the same Region as the source resource.
	//
	// If the policy targets resources on an Outpost, then you can create snapshots
	// on the same Outpost as the source resource, or in the Region of that Outpost.
	Location *string `type:"string" enum:"LocationValues"`

	// The time, in UTC, to start the operation. The supported format is hh:mm.
	//
	// The operation occurs within a one-hour window following the specified time.
	// If you do not specify a time, Amazon DLM selects a time within the next 24
	// hours.
	Times []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRule"}
	if s.CronExpression != nil && len(*s.CronExpression) < 17 {
		invalidParams.Add(request.NewErrParamMinLen("CronExpression", 17))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCronExpression sets the CronExpression field's value.
func (s *CreateRule) SetCronExpression(v string) *CreateRule {
	s.CronExpression = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *CreateRule) SetInterval(v int64) *CreateRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *CreateRule) SetIntervalUnit(v string) *CreateRule {
	s.IntervalUnit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateRule) SetLocation(v string) *CreateRule {
	s.Location = &v
	return s
}

// SetTimes sets the Times field's value.
func (s *CreateRule) SetTimes(v []*string) *CreateRule {
	s.Times = v
	return s
}

// Specifies a rule for copying shared snapshots across Regions.
type CrossRegionCopyAction struct {
	_ struct{} `type:"structure"`

	// The encryption settings for the copied snapshot.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// Specifies the retention rule for cross-Region snapshot copies.
	RetainRule *CrossRegionCopyRetainRule `type:"structure"`

	// The target Region.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrossRegionCopyAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrossRegionCopyAction"}
	if s.EncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfiguration"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RetainRule != nil {
		if err := s.RetainRule.Validate(); err != nil {
			invalidParams.AddNested("RetainRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *CrossRegionCopyAction) SetEncryptionConfiguration(v *EncryptionConfiguration) *CrossRegionCopyAction {
	s.EncryptionConfiguration = v
	return s
}

// SetRetainRule sets the RetainRule field's value.
func (s *CrossRegionCopyAction) SetRetainRule(v *CrossRegionCopyRetainRule) *CrossRegionCopyAction {
	s.RetainRule = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CrossRegionCopyAction) SetTarget(v string) *CrossRegionCopyAction {
	s.Target = &v
	return s
}

// Specifies an AMI deprecation rule for cross-Region AMI copies created by
// a cross-Region copy rule.
type CrossRegionCopyDeprecateRule struct {
	_ struct{} `type:"structure"`

	// The period after which to deprecate the cross-Region AMI copies. The period
	// must be less than or equal to the cross-Region AMI copy retention period,
	// and it can't be greater than 10 years. This is equivalent to 120 months,
	// 520 weeks, or 3650 days.
	Interval *int64 `min:"1" type:"integer"`

	// The unit of time in which to measure the Interval.
	IntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyDeprecateRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyDeprecateRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrossRegionCopyDeprecateRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrossRegionCopyDeprecateRule"}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *CrossRegionCopyDeprecateRule) SetInterval(v int64) *CrossRegionCopyDeprecateRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *CrossRegionCopyDeprecateRule) SetIntervalUnit(v string) *CrossRegionCopyDeprecateRule {
	s.IntervalUnit = &v
	return s
}

// Specifies the retention rule for cross-Region snapshot copies.
type CrossRegionCopyRetainRule struct {
	_ struct{} `type:"structure"`

	// The amount of time to retain each snapshot. The maximum is 100 years. This
	// is equivalent to 1200 months, 5200 weeks, or 36500 days.
	Interval *int64 `min:"1" type:"integer"`

	// The unit of time for time-based retention.
	IntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyRetainRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyRetainRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrossRegionCopyRetainRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrossRegionCopyRetainRule"}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *CrossRegionCopyRetainRule) SetInterval(v int64) *CrossRegionCopyRetainRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *CrossRegionCopyRetainRule) SetIntervalUnit(v string) *CrossRegionCopyRetainRule {
	s.IntervalUnit = &v
	return s
}

// Specifies a rule for cross-Region snapshot copies.
type CrossRegionCopyRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption.
	// If this parameter is not specified, the default KMS key for the account is
	// used.
	CmkArn *string `type:"string"`

	// Indicates whether to copy all user-defined tags from the source snapshot
	// to the cross-Region snapshot copy.
	CopyTags *bool `type:"boolean"`

	// The AMI deprecation rule for cross-Region AMI copies created by the rule.
	DeprecateRule *CrossRegionCopyDeprecateRule `type:"structure"`

	// To encrypt a copy of an unencrypted snapshot if encryption by default is
	// not enabled, enable encryption using this parameter. Copies of encrypted
	// snapshots are encrypted, even if this parameter is false or if encryption
	// by default is not enabled.
	//
	// Encrypted is a required field
	Encrypted *bool `type:"boolean" required:"true"`

	// The retention rule that indicates how long snapshot copies are to be retained
	// in the destination Region.
	RetainRule *CrossRegionCopyRetainRule `type:"structure"`

	// The target Region or the Amazon Resource Name (ARN) of the target Outpost
	// for the snapshot copies.
	//
	// Use this parameter instead of TargetRegion. Do not specify both.
	Target *string `type:"string"`

	// Avoid using this parameter when creating new policies. Instead, use Target
	// to specify a target Region or a target Outpost for snapshot copies.
	//
	// For policies created before the Target parameter was introduced, this parameter
	// indicates the target Region for snapshot copies.
	TargetRegion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrossRegionCopyRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrossRegionCopyRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrossRegionCopyRule"}
	if s.Encrypted == nil {
		invalidParams.Add(request.NewErrParamRequired("Encrypted"))
	}
	if s.DeprecateRule != nil {
		if err := s.DeprecateRule.Validate(); err != nil {
			invalidParams.AddNested("DeprecateRule", err.(request.ErrInvalidParams))
		}
	}
	if s.RetainRule != nil {
		if err := s.RetainRule.Validate(); err != nil {
			invalidParams.AddNested("RetainRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCmkArn sets the CmkArn field's value.
func (s *CrossRegionCopyRule) SetCmkArn(v string) *CrossRegionCopyRule {
	s.CmkArn = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *CrossRegionCopyRule) SetCopyTags(v bool) *CrossRegionCopyRule {
	s.CopyTags = &v
	return s
}

// SetDeprecateRule sets the DeprecateRule field's value.
func (s *CrossRegionCopyRule) SetDeprecateRule(v *CrossRegionCopyDeprecateRule) *CrossRegionCopyRule {
	s.DeprecateRule = v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CrossRegionCopyRule) SetEncrypted(v bool) *CrossRegionCopyRule {
	s.Encrypted = &v
	return s
}

// SetRetainRule sets the RetainRule field's value.
func (s *CrossRegionCopyRule) SetRetainRule(v *CrossRegionCopyRetainRule) *CrossRegionCopyRule {
	s.RetainRule = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CrossRegionCopyRule) SetTarget(v string) *CrossRegionCopyRule {
	s.Target = &v
	return s
}

// SetTargetRegion sets the TargetRegion field's value.
func (s *CrossRegionCopyRule) SetTargetRegion(v string) *CrossRegionCopyRule {
	s.TargetRegion = &v
	return s
}

type DeleteLifecyclePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeleteLifecyclePolicyInput) SetPolicyId(v string) *DeleteLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

type DeleteLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// Specifies an AMI deprecation rule for a schedule.
type DeprecateRule struct {
	_ struct{} `type:"structure"`

	// If the schedule has a count-based retention rule, this parameter specifies
	// the number of oldest AMIs to deprecate. The count must be less than or equal
	// to the schedule's retention count, and it can't be greater than 1000.
	Count *int64 `min:"1" type:"integer"`

	// If the schedule has an age-based retention rule, this parameter specifies
	// the period after which to deprecate AMIs created by the schedule. The period
	// must be less than or equal to the schedule's retention period, and it can't
	// be greater than 10 years. This is equivalent to 120 months, 520 weeks, or
	// 3650 days.
	Interval *int64 `min:"1" type:"integer"`

	// The unit of time in which to measure the Interval.
	IntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprecateRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprecateRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateRule"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *DeprecateRule) SetCount(v int64) *DeprecateRule {
	s.Count = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *DeprecateRule) SetInterval(v int64) *DeprecateRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *DeprecateRule) SetIntervalUnit(v string) *DeprecateRule {
	s.IntervalUnit = &v
	return s
}

// Specifies the encryption settings for shared snapshots that are copied across
// Regions.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption.
	// If this parameter is not specified, the default KMS key for the account is
	// used.
	CmkArn *string `type:"string"`

	// To encrypt a copy of an unencrypted snapshot when encryption by default is
	// not enabled, enable encryption using this parameter. Copies of encrypted
	// snapshots are encrypted, even if this parameter is false or when encryption
	// by default is not enabled.
	//
	// Encrypted is a required field
	Encrypted *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.Encrypted == nil {
		invalidParams.Add(request.NewErrParamRequired("Encrypted"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCmkArn sets the CmkArn field's value.
func (s *EncryptionConfiguration) SetCmkArn(v string) *EncryptionConfiguration {
	s.CmkArn = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *EncryptionConfiguration) SetEncrypted(v bool) *EncryptionConfiguration {
	s.Encrypted = &v
	return s
}

// Specifies an event that triggers an event-based policy.
type EventParameters struct {
	_ struct{} `type:"structure"`

	// The snapshot description that can trigger the policy. The description pattern
	// is specified using a regular expression. The policy runs only if a snapshot
	// with a description that matches the specified pattern is shared with your
	// account.
	//
	// For example, specifying ^.*Created for policy: policy-1234567890abcdef0.*$
	// configures the policy to run only if snapshots created by policy policy-1234567890abcdef0
	// are shared with your account.
	//
	// DescriptionRegex is a required field
	DescriptionRegex *string `type:"string" required:"true"`

	// The type of event. Currently, only snapshot sharing events are supported.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true" enum:"EventTypeValues"`

	// The IDs of the Amazon Web Services accounts that can trigger policy by sharing
	// snapshots with your account. The policy only runs if one of the specified
	// Amazon Web Services accounts shares a snapshot with your account.
	//
	// SnapshotOwner is a required field
	SnapshotOwner []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventParameters"}
	if s.DescriptionRegex == nil {
		invalidParams.Add(request.NewErrParamRequired("DescriptionRegex"))
	}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.SnapshotOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescriptionRegex sets the DescriptionRegex field's value.
func (s *EventParameters) SetDescriptionRegex(v string) *EventParameters {
	s.DescriptionRegex = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *EventParameters) SetEventType(v string) *EventParameters {
	s.EventType = &v
	return s
}

// SetSnapshotOwner sets the SnapshotOwner field's value.
func (s *EventParameters) SetSnapshotOwner(v []*string) *EventParameters {
	s.SnapshotOwner = v
	return s
}

// Specifies an event that triggers an event-based policy.
type EventSource struct {
	_ struct{} `type:"structure"`

	// Information about the event.
	Parameters *EventParameters `type:"structure"`

	// The source of the event. Currently only managed CloudWatch Events rules are
	// supported.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"EventSourceValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventSource"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *EventSource) SetParameters(v *EventParameters) *EventSource {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *EventSource) SetType(v string) *EventSource {
	s.Type = &v
	return s
}

// Specifies a rule for enabling fast snapshot restore. You can enable fast
// snapshot restore based on either a count or a time interval.
type FastRestoreRule struct {
	_ struct{} `type:"structure"`

	// The Availability Zones in which to enable fast snapshot restore.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []*string `min:"1" type:"list" required:"true"`

	// The number of snapshots to be enabled with fast snapshot restore.
	Count *int64 `min:"1" type:"integer"`

	// The amount of time to enable fast snapshot restore. The maximum is 100 years.
	// This is equivalent to 1200 months, 5200 weeks, or 36500 days.
	Interval *int64 `min:"1" type:"integer"`

	// The unit of time for enabling fast snapshot restore.
	IntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastRestoreRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastRestoreRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FastRestoreRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FastRestoreRule"}
	if s.AvailabilityZones == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZones"))
	}
	if s.AvailabilityZones != nil && len(s.AvailabilityZones) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZones", 1))
	}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *FastRestoreRule) SetAvailabilityZones(v []*string) *FastRestoreRule {
	s.AvailabilityZones = v
	return s
}

// SetCount sets the Count field's value.
func (s *FastRestoreRule) SetCount(v int64) *FastRestoreRule {
	s.Count = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *FastRestoreRule) SetInterval(v int64) *FastRestoreRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *FastRestoreRule) SetIntervalUnit(v string) *FastRestoreRule {
	s.IntervalUnit = &v
	return s
}

type GetLifecyclePoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifiers of the data lifecycle policies.
	PolicyIds []*string `location:"querystring" locationName:"policyIds" type:"list"`

	// The resource type.
	ResourceTypes []*string `location:"querystring" locationName:"resourceTypes" min:"1" type:"list" enum:"ResourceTypeValues"`

	// The activation state.
	State *string `location:"querystring" locationName:"state" type:"string" enum:"GettablePolicyStateValues"`

	// The tags to add to objects created by the policy.
	//
	// Tags are strings in the format key=value.
	//
	// These user-defined tags are added in addition to the Amazon Web Services-added
	// lifecycle tags.
	TagsToAdd []*string `location:"querystring" locationName:"tagsToAdd" type:"list"`

	// The target tag for a policy.
	//
	// Tags are strings in the format key=value.
	TargetTags []*string `location:"querystring" locationName:"targetTags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLifecyclePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLifecyclePoliciesInput"}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.TargetTags != nil && len(s.TargetTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyIds sets the PolicyIds field's value.
func (s *GetLifecyclePoliciesInput) SetPolicyIds(v []*string) *GetLifecyclePoliciesInput {
	s.PolicyIds = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetLifecyclePoliciesInput) SetResourceTypes(v []*string) *GetLifecyclePoliciesInput {
	s.ResourceTypes = v
	return s
}

// SetState sets the State field's value.
func (s *GetLifecyclePoliciesInput) SetState(v string) *GetLifecyclePoliciesInput {
	s.State = &v
	return s
}

// SetTagsToAdd sets the TagsToAdd field's value.
func (s *GetLifecyclePoliciesInput) SetTagsToAdd(v []*string) *GetLifecyclePoliciesInput {
	s.TagsToAdd = v
	return s
}

// SetTargetTags sets the TargetTags field's value.
func (s *GetLifecyclePoliciesInput) SetTargetTags(v []*string) *GetLifecyclePoliciesInput {
	s.TargetTags = v
	return s
}

type GetLifecyclePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the lifecycle policies.
	Policies []*LifecyclePolicySummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *GetLifecyclePoliciesOutput) SetPolicies(v []*LifecyclePolicySummary) *GetLifecyclePoliciesOutput {
	s.Policies = v
	return s
}

type GetLifecyclePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetLifecyclePolicyInput) SetPolicyId(v string) *GetLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

type GetLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the lifecycle policy.
	Policy *LifecyclePolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetLifecyclePolicyOutput) SetPolicy(v *LifecyclePolicy) *GetLifecyclePolicyOutput {
	s.Policy = v
	return s
}

// The service failed in an unexpected way.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Bad request. The request is missing required parameters or has invalid parameters.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request included parameters that cannot be provided together.
	MutuallyExclusiveParameters []*string `type:"list"`

	// The request omitted one or more required parameters.
	RequiredParameters []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detailed information about a lifecycle policy.
type LifecyclePolicy struct {
	_ struct{} `type:"structure"`

	// The local date and time when the lifecycle policy was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The local date and time when the lifecycle policy was last modified.
	DateModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyArn *string `type:"string"`

	// The configuration of the lifecycle policy
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The activation state of the lifecycle policy.
	State *string `type:"string" enum:"GettablePolicyStateValues"`

	// The description of the status.
	StatusMessage *string `type:"string"`

	// The tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicy) GoString() string {
	return s.String()
}

// SetDateCreated sets the DateCreated field's value.
func (s *LifecyclePolicy) SetDateCreated(v time.Time) *LifecyclePolicy {
	s.DateCreated = &v
	return s
}

// SetDateModified sets the DateModified field's value.
func (s *LifecyclePolicy) SetDateModified(v time.Time) *LifecyclePolicy {
	s.DateModified = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LifecyclePolicy) SetDescription(v string) *LifecyclePolicy {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *LifecyclePolicy) SetExecutionRoleArn(v string) *LifecyclePolicy {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *LifecyclePolicy) SetPolicyArn(v string) *LifecyclePolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *LifecyclePolicy) SetPolicyDetails(v *PolicyDetails) *LifecyclePolicy {
	s.PolicyDetails = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *LifecyclePolicy) SetPolicyId(v string) *LifecyclePolicy {
	s.PolicyId = &v
	return s
}

// SetState sets the State field's value.
func (s *LifecyclePolicy) SetState(v string) *LifecyclePolicy {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *LifecyclePolicy) SetStatusMessage(v string) *LifecyclePolicy {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LifecyclePolicy) SetTags(v map[string]*string) *LifecyclePolicy {
	s.Tags = v
	return s
}

// Summary information about a lifecycle policy.
type LifecyclePolicySummary struct {
	_ struct{} `type:"structure"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The type of policy. EBS_SNAPSHOT_MANAGEMENT indicates that the policy manages
	// the lifecycle of Amazon EBS snapshots. IMAGE_MANAGEMENT indicates that the
	// policy manages the lifecycle of EBS-backed AMIs.
	PolicyType *string `type:"string" enum:"PolicyTypeValues"`

	// The activation state of the lifecycle policy.
	State *string `type:"string" enum:"GettablePolicyStateValues"`

	// The tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicySummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LifecyclePolicySummary) SetDescription(v string) *LifecyclePolicySummary {
	s.Description = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *LifecyclePolicySummary) SetPolicyId(v string) *LifecyclePolicySummary {
	s.PolicyId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *LifecyclePolicySummary) SetPolicyType(v string) *LifecyclePolicySummary {
	s.PolicyType = &v
	return s
}

// SetState sets the State field's value.
func (s *LifecyclePolicySummary) SetState(v string) *LifecyclePolicySummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LifecyclePolicySummary) SetTags(v map[string]*string) *LifecyclePolicySummary {
	s.Tags = v
	return s
}

// The request failed because a limit was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// Value is the type of resource for which a limit was exceeded.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Specifies optional parameters to add to a policy. The set of valid parameters
// depends on the combination of policy type and resource type.
type Parameters struct {
	_ struct{} `type:"structure"`

	// [EBS Snapshot Management – Instance policies only] Indicates whether to
	// exclude the root volume from snapshots created using CreateSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html).
	// The default is false.
	ExcludeBootVolume *bool `type:"boolean"`

	// Applies to AMI lifecycle policies only. Indicates whether targeted instances
	// are rebooted when the lifecycle policy runs. true indicates that targeted
	// instances are not rebooted when the policy runs. false indicates that target
	// instances are rebooted when the policy runs. The default is true (instances
	// are not rebooted).
	NoReboot *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameters) GoString() string {
	return s.String()
}

// SetExcludeBootVolume sets the ExcludeBootVolume field's value.
func (s *Parameters) SetExcludeBootVolume(v bool) *Parameters {
	s.ExcludeBootVolume = &v
	return s
}

// SetNoReboot sets the NoReboot field's value.
func (s *Parameters) SetNoReboot(v bool) *Parameters {
	s.NoReboot = &v
	return s
}

// Specifies the configuration of a lifecycle policy.
type PolicyDetails struct {
	_ struct{} `type:"structure"`

	// The actions to be performed when the event-based policy is triggered. You
	// can specify only one action per policy.
	//
	// This parameter is required for event-based policies only. If you are creating
	// a snapshot or AMI policy, omit this parameter.
	Actions []*Action `min:"1" type:"list"`

	// The event that triggers the event-based policy.
	//
	// This parameter is required for event-based policies only. If you are creating
	// a snapshot or AMI policy, omit this parameter.
	EventSource *EventSource `type:"structure"`

	// A set of optional parameters for snapshot and AMI lifecycle policies.
	//
	// This parameter is required for snapshot and AMI policies only. If you are
	// creating an event-based policy, omit this parameter.
	Parameters *Parameters `type:"structure"`

	// The valid target resource types and actions a policy can manage. Specify
	// EBS_SNAPSHOT_MANAGEMENT to create a lifecycle policy that manages the lifecycle
	// of Amazon EBS snapshots. Specify IMAGE_MANAGEMENT to create a lifecycle policy
	// that manages the lifecycle of EBS-backed AMIs. Specify EVENT_BASED_POLICY
	// to create an event-based policy that performs specific actions when a defined
	// event occurs in your Amazon Web Services account.
	//
	// The default is EBS_SNAPSHOT_MANAGEMENT.
	PolicyType *string `type:"string" enum:"PolicyTypeValues"`

	// The location of the resources to backup. If the source resources are located
	// in an Amazon Web Services Region, specify CLOUD. If the source resources
	// are located on an Outpost in your account, specify OUTPOST.
	//
	// If you specify OUTPOST, Amazon Data Lifecycle Manager backs up all resources
	// of the specified type with matching target tags across all of the Outposts
	// in your account.
	ResourceLocations []*string `min:"1" type:"list" enum:"ResourceLocationValues"`

	// The target resource type for snapshot and AMI lifecycle policies. Use VOLUME
	// to create snapshots of individual volumes or use INSTANCE to create multi-volume
	// snapshots from the volumes for an instance.
	//
	// This parameter is required for snapshot and AMI policies only. If you are
	// creating an event-based policy, omit this parameter.
	ResourceTypes []*string `min:"1" type:"list" enum:"ResourceTypeValues"`

	// The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
	// A policy can have up to four schedules—one mandatory schedule and up to
	// three optional schedules.
	//
	// This parameter is required for snapshot and AMI policies only. If you are
	// creating an event-based policy, omit this parameter.
	Schedules []*Schedule `min:"1" type:"list"`

	// The single tag that identifies targeted resources for this policy.
	//
	// This parameter is required for snapshot and AMI policies only. If you are
	// creating an event-based policy, omit this parameter.
	TargetTags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyDetails"}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.ResourceLocations != nil && len(s.ResourceLocations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLocations", 1))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.Schedules != nil && len(s.Schedules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schedules", 1))
	}
	if s.TargetTags != nil && len(s.TargetTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTags", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EventSource != nil {
		if err := s.EventSource.Validate(); err != nil {
			invalidParams.AddNested("EventSource", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedules != nil {
		for i, v := range s.Schedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schedules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetTags != nil {
		for i, v := range s.TargetTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *PolicyDetails) SetActions(v []*Action) *PolicyDetails {
	s.Actions = v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *PolicyDetails) SetEventSource(v *EventSource) *PolicyDetails {
	s.EventSource = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PolicyDetails) SetParameters(v *Parameters) *PolicyDetails {
	s.Parameters = v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PolicyDetails) SetPolicyType(v string) *PolicyDetails {
	s.PolicyType = &v
	return s
}

// SetResourceLocations sets the ResourceLocations field's value.
func (s *PolicyDetails) SetResourceLocations(v []*string) *PolicyDetails {
	s.ResourceLocations = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *PolicyDetails) SetResourceTypes(v []*string) *PolicyDetails {
	s.ResourceTypes = v
	return s
}

// SetSchedules sets the Schedules field's value.
func (s *PolicyDetails) SetSchedules(v []*Schedule) *PolicyDetails {
	s.Schedules = v
	return s
}

// SetTargetTags sets the TargetTags field's value.
func (s *PolicyDetails) SetTargetTags(v []*Tag) *PolicyDetails {
	s.TargetTags = v
	return s
}

// A requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// Value is a list of resource IDs that were not found.
	ResourceIds []*string `type:"list"`

	// Value is the type of resource that was not found.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the retention rule for a lifecycle policy. You can retain snapshots
// based on either a count or a time interval.
type RetainRule struct {
	_ struct{} `type:"structure"`

	// The number of snapshots to retain for each volume, up to a maximum of 1000.
	Count *int64 `min:"1" type:"integer"`

	// The amount of time to retain each snapshot. The maximum is 100 years. This
	// is equivalent to 1200 months, 5200 weeks, or 36500 days.
	Interval *int64 `min:"1" type:"integer"`

	// The unit of time for time-based retention.
	IntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetainRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetainRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetainRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetainRule"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *RetainRule) SetCount(v int64) *RetainRule {
	s.Count = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *RetainRule) SetInterval(v int64) *RetainRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *RetainRule) SetIntervalUnit(v string) *RetainRule {
	s.IntervalUnit = &v
	return s
}

// Specifies a backup schedule for a snapshot or AMI lifecycle policy.
type Schedule struct {
	_ struct{} `type:"structure"`

	// Copy all user-defined tags on a source volume to snapshots of the volume
	// created by this policy.
	CopyTags *bool `type:"boolean"`

	// The creation rule.
	CreateRule *CreateRule `type:"structure"`

	// The rule for cross-Region snapshot copies.
	//
	// You can only specify cross-Region copy rules for policies that create snapshots
	// in a Region. If the policy creates snapshots on an Outpost, then you cannot
	// copy the snapshots to a Region or to an Outpost. If the policy creates snapshots
	// in a Region, then snapshots can be copied to up to three Regions or Outposts.
	CrossRegionCopyRules []*CrossRegionCopyRule `type:"list"`

	// The AMI deprecation rule for the schedule.
	DeprecateRule *DeprecateRule `type:"structure"`

	// The rule for enabling fast snapshot restore.
	FastRestoreRule *FastRestoreRule `type:"structure"`

	// The name of the schedule.
	Name *string `type:"string"`

	// The retention rule.
	RetainRule *RetainRule `type:"structure"`

	// The rule for sharing snapshots with other Amazon Web Services accounts.
	ShareRules []*ShareRule `type:"list"`

	// The tags to apply to policy-created resources. These user-defined tags are
	// in addition to the Amazon Web Services-added lifecycle tags.
	TagsToAdd []*Tag `type:"list"`

	// A collection of key/value pairs with values determined dynamically when the
	// policy is executed. Keys may be any valid Amazon EC2 tag key. Values must
	// be in one of the two following formats: $(instance-id) or $(timestamp). Variable
	// tags are only valid for EBS Snapshot Management – Instance policies.
	VariableTags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schedule"}
	if s.CreateRule != nil {
		if err := s.CreateRule.Validate(); err != nil {
			invalidParams.AddNested("CreateRule", err.(request.ErrInvalidParams))
		}
	}
	if s.CrossRegionCopyRules != nil {
		for i, v := range s.CrossRegionCopyRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CrossRegionCopyRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeprecateRule != nil {
		if err := s.DeprecateRule.Validate(); err != nil {
			invalidParams.AddNested("DeprecateRule", err.(request.ErrInvalidParams))
		}
	}
	if s.FastRestoreRule != nil {
		if err := s.FastRestoreRule.Validate(); err != nil {
			invalidParams.AddNested("FastRestoreRule", err.(request.ErrInvalidParams))
		}
	}
	if s.RetainRule != nil {
		if err := s.RetainRule.Validate(); err != nil {
			invalidParams.AddNested("RetainRule", err.(request.ErrInvalidParams))
		}
	}
	if s.ShareRules != nil {
		for i, v := range s.ShareRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ShareRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TagsToAdd != nil {
		for i, v := range s.TagsToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VariableTags != nil {
		for i, v := range s.VariableTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VariableTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *Schedule) SetCopyTags(v bool) *Schedule {
	s.CopyTags = &v
	return s
}

// SetCreateRule sets the CreateRule field's value.
func (s *Schedule) SetCreateRule(v *CreateRule) *Schedule {
	s.CreateRule = v
	return s
}

// SetCrossRegionCopyRules sets the CrossRegionCopyRules field's value.
func (s *Schedule) SetCrossRegionCopyRules(v []*CrossRegionCopyRule) *Schedule {
	s.CrossRegionCopyRules = v
	return s
}

// SetDeprecateRule sets the DeprecateRule field's value.
func (s *Schedule) SetDeprecateRule(v *DeprecateRule) *Schedule {
	s.DeprecateRule = v
	return s
}

// SetFastRestoreRule sets the FastRestoreRule field's value.
func (s *Schedule) SetFastRestoreRule(v *FastRestoreRule) *Schedule {
	s.FastRestoreRule = v
	return s
}

// SetName sets the Name field's value.
func (s *Schedule) SetName(v string) *Schedule {
	s.Name = &v
	return s
}

// SetRetainRule sets the RetainRule field's value.
func (s *Schedule) SetRetainRule(v *RetainRule) *Schedule {
	s.RetainRule = v
	return s
}

// SetShareRules sets the ShareRules field's value.
func (s *Schedule) SetShareRules(v []*ShareRule) *Schedule {
	s.ShareRules = v
	return s
}

// SetTagsToAdd sets the TagsToAdd field's value.
func (s *Schedule) SetTagsToAdd(v []*Tag) *Schedule {
	s.TagsToAdd = v
	return s
}

// SetVariableTags sets the VariableTags field's value.
func (s *Schedule) SetVariableTags(v []*Tag) *Schedule {
	s.VariableTags = v
	return s
}

// Specifies a rule for sharing snapshots across Amazon Web Services accounts.
type ShareRule struct {
	_ struct{} `type:"structure"`

	// The IDs of the Amazon Web Services accounts with which to share the snapshots.
	//
	// TargetAccounts is a required field
	TargetAccounts []*string `min:"1" type:"list" required:"true"`

	// The period after which snapshots that are shared with other Amazon Web Services
	// accounts are automatically unshared.
	UnshareInterval *int64 `min:"1" type:"integer"`

	// The unit of time for the automatic unsharing interval.
	UnshareIntervalUnit *string `type:"string" enum:"RetentionIntervalUnitValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShareRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShareRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShareRule"}
	if s.TargetAccounts == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAccounts"))
	}
	if s.TargetAccounts != nil && len(s.TargetAccounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAccounts", 1))
	}
	if s.UnshareInterval != nil && *s.UnshareInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("UnshareInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetAccounts sets the TargetAccounts field's value.
func (s *ShareRule) SetTargetAccounts(v []*string) *ShareRule {
	s.TargetAccounts = v
	return s
}

// SetUnshareInterval sets the UnshareInterval field's value.
func (s *ShareRule) SetUnshareInterval(v int64) *ShareRule {
	s.UnshareInterval = &v
	return s
}

// SetUnshareIntervalUnit sets the UnshareIntervalUnit field's value.
func (s *ShareRule) SetUnshareIntervalUnit(v string) *ShareRule {
	s.UnshareIntervalUnit = &v
	return s
}

// Specifies a tag for a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tags.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The configuration of the lifecycle policy. You cannot update the policy type
	// or the resource type.
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`

	// The desired activation state of the lifecycle policy after creation.
	State *string `type:"string" enum:"SettablePolicyStateValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyId", 1))
	}
	if s.PolicyDetails != nil {
		if err := s.PolicyDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateLifecyclePolicyInput) SetDescription(v string) *UpdateLifecyclePolicyInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateLifecyclePolicyInput) SetExecutionRoleArn(v string) *UpdateLifecyclePolicyInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *UpdateLifecyclePolicyInput) SetPolicyDetails(v *PolicyDetails) *UpdateLifecyclePolicyInput {
	s.PolicyDetails = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdateLifecyclePolicyInput) SetPolicyId(v string) *UpdateLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateLifecyclePolicyInput) SetState(v string) *UpdateLifecyclePolicyInput {
	s.State = &v
	return s
}

type UpdateLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLifecyclePolicyOutput) GoString() string {
	return s.String()
}

const (
	// EventSourceValuesManagedCwe is a EventSourceValues enum value
	EventSourceValuesManagedCwe = "MANAGED_CWE"
)

// EventSourceValues_Values returns all elements of the EventSourceValues enum
func EventSourceValues_Values() []string {
	return []string{
		EventSourceValuesManagedCwe,
	}
}

const (
	// EventTypeValuesShareSnapshot is a EventTypeValues enum value
	EventTypeValuesShareSnapshot = "shareSnapshot"
)

// EventTypeValues_Values returns all elements of the EventTypeValues enum
func EventTypeValues_Values() []string {
	return []string{
		EventTypeValuesShareSnapshot,
	}
}

const (
	// GettablePolicyStateValuesEnabled is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesEnabled = "ENABLED"

	// GettablePolicyStateValuesDisabled is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesDisabled = "DISABLED"

	// GettablePolicyStateValuesError is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesError = "ERROR"
)

// GettablePolicyStateValues_Values returns all elements of the GettablePolicyStateValues enum
func GettablePolicyStateValues_Values() []string {
	return []string{
		GettablePolicyStateValuesEnabled,
		GettablePolicyStateValuesDisabled,
		GettablePolicyStateValuesError,
	}
}

const (
	// IntervalUnitValuesHours is a IntervalUnitValues enum value
	IntervalUnitValuesHours = "HOURS"
)

// IntervalUnitValues_Values returns all elements of the IntervalUnitValues enum
func IntervalUnitValues_Values() []string {
	return []string{
		IntervalUnitValuesHours,
	}
}

const (
	// LocationValuesCloud is a LocationValues enum value
	LocationValuesCloud = "CLOUD"

	// LocationValuesOutpostLocal is a LocationValues enum value
	LocationValuesOutpostLocal = "OUTPOST_LOCAL"
)

// LocationValues_Values returns all elements of the LocationValues enum
func LocationValues_Values() []string {
	return []string{
		LocationValuesCloud,
		LocationValuesOutpostLocal,
	}
}

const (
	// PolicyTypeValuesEbsSnapshotManagement is a PolicyTypeValues enum value
	PolicyTypeValuesEbsSnapshotManagement = "EBS_SNAPSHOT_MANAGEMENT"

	// PolicyTypeValuesImageManagement is a PolicyTypeValues enum value
	PolicyTypeValuesImageManagement = "IMAGE_MANAGEMENT"

	// PolicyTypeValuesEventBasedPolicy is a PolicyTypeValues enum value
	PolicyTypeValuesEventBasedPolicy = "EVENT_BASED_POLICY"
)

// PolicyTypeValues_Values returns all elements of the PolicyTypeValues enum
func PolicyTypeValues_Values() []string {
	return []string{
		PolicyTypeValuesEbsSnapshotManagement,
		PolicyTypeValuesImageManagement,
		PolicyTypeValuesEventBasedPolicy,
	}
}

const (
	// ResourceLocationValuesCloud is a ResourceLocationValues enum value
	ResourceLocationValuesCloud = "CLOUD"

	// ResourceLocationValuesOutpost is a ResourceLocationValues enum value
	ResourceLocationValuesOutpost = "OUTPOST"
)

// ResourceLocationValues_Values returns all elements of the ResourceLocationValues enum
func ResourceLocationValues_Values() []string {
	return []string{
		ResourceLocationValuesCloud,
		ResourceLocationValuesOutpost,
	}
}

const (
	// ResourceTypeValuesVolume is a ResourceTypeValues enum value
	ResourceTypeValuesVolume = "VOLUME"

	// ResourceTypeValuesInstance is a ResourceTypeValues enum value
	ResourceTypeValuesInstance = "INSTANCE"
)

// ResourceTypeValues_Values returns all elements of the ResourceTypeValues enum
func ResourceTypeValues_Values() []string {
	return []string{
		ResourceTypeValuesVolume,
		ResourceTypeValuesInstance,
	}
}

const (
	// RetentionIntervalUnitValuesDays is a RetentionIntervalUnitValues enum value
	RetentionIntervalUnitValuesDays = "DAYS"

	// RetentionIntervalUnitValuesWeeks is a RetentionIntervalUnitValues enum value
	RetentionIntervalUnitValuesWeeks = "WEEKS"

	// RetentionIntervalUnitValuesMonths is a RetentionIntervalUnitValues enum value
	RetentionIntervalUnitValuesMonths = "MONTHS"

	// RetentionIntervalUnitValuesYears is a RetentionIntervalUnitValues enum value
	RetentionIntervalUnitValuesYears = "YEARS"
)

// RetentionIntervalUnitValues_Values returns all elements of the RetentionIntervalUnitValues enum
func RetentionIntervalUnitValues_Values() []string {
	return []string{
		RetentionIntervalUnitValuesDays,
		RetentionIntervalUnitValuesWeeks,
		RetentionIntervalUnitValuesMonths,
		RetentionIntervalUnitValuesYears,
	}
}

const (
	// SettablePolicyStateValuesEnabled is a SettablePolicyStateValues enum value
	SettablePolicyStateValuesEnabled = "ENABLED"

	// SettablePolicyStateValuesDisabled is a SettablePolicyStateValues enum value
	SettablePolicyStateValuesDisabled = "DISABLED"
)

// SettablePolicyStateValues_Values returns all elements of the SettablePolicyStateValues enum
func SettablePolicyStateValues_Values() []string {
	return []string{
		SettablePolicyStateValuesEnabled,
		SettablePolicyStateValuesDisabled,
	}
}
