// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplifyuibuilder

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateComponent = "CreateComponent"

// CreateComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponent for more information on using the CreateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComponentRequest method.
//    req, resp := client.CreateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent
func (c *AmplifyUIBuilder) CreateComponentRequest(input *CreateComponentInput) (req *request.Request, output *CreateComponentOutput) {
	op := &request.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/components",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	output = &CreateComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComponent API operation for AWS Amplify UI Builder.
//
// Creates a new component for an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation CreateComponent for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   You exceeded your service quota. Service quotas, also referred to as limits,
//   are the maximum number of service resources or operations for your Amazon
//   Web Services account.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent
func (c *AmplifyUIBuilder) CreateComponent(input *CreateComponentInput) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	return out, req.Send()
}

// CreateComponentWithContext is the same as CreateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) CreateComponentWithContext(ctx aws.Context, input *CreateComponentInput, opts ...request.Option) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTheme = "CreateTheme"

// CreateThemeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTheme for more information on using the CreateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThemeRequest method.
//    req, resp := client.CreateThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme
func (c *AmplifyUIBuilder) CreateThemeRequest(input *CreateThemeInput) (req *request.Request, output *CreateThemeOutput) {
	op := &request.Operation{
		Name:       opCreateTheme,
		HTTPMethod: "POST",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/themes",
	}

	if input == nil {
		input = &CreateThemeInput{}
	}

	output = &CreateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTheme API operation for AWS Amplify UI Builder.
//
// Creates a theme to apply to the components in an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation CreateTheme for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   You exceeded your service quota. Service quotas, also referred to as limits,
//   are the maximum number of service resources or operations for your Amazon
//   Web Services account.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme
func (c *AmplifyUIBuilder) CreateTheme(input *CreateThemeInput) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	return out, req.Send()
}

// CreateThemeWithContext is the same as CreateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) CreateThemeWithContext(ctx aws.Context, input *CreateThemeInput, opts ...request.Option) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteComponentRequest method.
//    req, resp := client.DeleteComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent
func (c *AmplifyUIBuilder) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/components/{id}",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteComponent API operation for AWS Amplify UI Builder.
//
// Deletes a component from an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent
func (c *AmplifyUIBuilder) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTheme = "DeleteTheme"

// DeleteThemeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTheme for more information on using the DeleteTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThemeRequest method.
//    req, resp := client.DeleteThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme
func (c *AmplifyUIBuilder) DeleteThemeRequest(input *DeleteThemeInput) (req *request.Request, output *DeleteThemeOutput) {
	op := &request.Operation{
		Name:       opDeleteTheme,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/themes/{id}",
	}

	if input == nil {
		input = &DeleteThemeInput{}
	}

	output = &DeleteThemeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTheme API operation for AWS Amplify UI Builder.
//
// Deletes a theme from an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation DeleteTheme for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme
func (c *AmplifyUIBuilder) DeleteTheme(input *DeleteThemeInput) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	return out, req.Send()
}

// DeleteThemeWithContext is the same as DeleteTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) DeleteThemeWithContext(ctx aws.Context, input *DeleteThemeInput, opts ...request.Option) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExchangeCodeForToken = "ExchangeCodeForToken"

// ExchangeCodeForTokenRequest generates a "aws/request.Request" representing the
// client's request for the ExchangeCodeForToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExchangeCodeForToken for more information on using the ExchangeCodeForToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExchangeCodeForTokenRequest method.
//    req, resp := client.ExchangeCodeForTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken
func (c *AmplifyUIBuilder) ExchangeCodeForTokenRequest(input *ExchangeCodeForTokenInput) (req *request.Request, output *ExchangeCodeForTokenOutput) {
	op := &request.Operation{
		Name:       opExchangeCodeForToken,
		HTTPMethod: "POST",
		HTTPPath:   "/tokens/{provider}",
	}

	if input == nil {
		input = &ExchangeCodeForTokenInput{}
	}

	output = &ExchangeCodeForTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExchangeCodeForToken API operation for AWS Amplify UI Builder.
//
// Exchanges an access code for a token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation ExchangeCodeForToken for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken
func (c *AmplifyUIBuilder) ExchangeCodeForToken(input *ExchangeCodeForTokenInput) (*ExchangeCodeForTokenOutput, error) {
	req, out := c.ExchangeCodeForTokenRequest(input)
	return out, req.Send()
}

// ExchangeCodeForTokenWithContext is the same as ExchangeCodeForToken with the addition of
// the ability to pass a context and additional request options.
//
// See ExchangeCodeForToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ExchangeCodeForTokenWithContext(ctx aws.Context, input *ExchangeCodeForTokenInput, opts ...request.Option) (*ExchangeCodeForTokenOutput, error) {
	req, out := c.ExchangeCodeForTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportComponents = "ExportComponents"

// ExportComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ExportComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportComponents for more information on using the ExportComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportComponentsRequest method.
//    req, resp := client.ExportComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents
func (c *AmplifyUIBuilder) ExportComponentsRequest(input *ExportComponentsInput) (req *request.Request, output *ExportComponentsOutput) {
	op := &request.Operation{
		Name:       opExportComponents,
		HTTPMethod: "GET",
		HTTPPath:   "/export/app/{appId}/environment/{environmentName}/components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ExportComponentsInput{}
	}

	output = &ExportComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportComponents API operation for AWS Amplify UI Builder.
//
// Exports component configurations to code that is ready to integrate into
// an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation ExportComponents for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents
func (c *AmplifyUIBuilder) ExportComponents(input *ExportComponentsInput) (*ExportComponentsOutput, error) {
	req, out := c.ExportComponentsRequest(input)
	return out, req.Send()
}

// ExportComponentsWithContext is the same as ExportComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ExportComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ExportComponentsWithContext(ctx aws.Context, input *ExportComponentsInput, opts ...request.Option) (*ExportComponentsOutput, error) {
	req, out := c.ExportComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ExportComponentsPages iterates over the pages of a ExportComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ExportComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ExportComponents operation.
//    pageNum := 0
//    err := client.ExportComponentsPages(params,
//        func(page *amplifyuibuilder.ExportComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AmplifyUIBuilder) ExportComponentsPages(input *ExportComponentsInput, fn func(*ExportComponentsOutput, bool) bool) error {
	return c.ExportComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ExportComponentsPagesWithContext same as ExportComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ExportComponentsPagesWithContext(ctx aws.Context, input *ExportComponentsInput, fn func(*ExportComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ExportComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ExportComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ExportComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opExportThemes = "ExportThemes"

// ExportThemesRequest generates a "aws/request.Request" representing the
// client's request for the ExportThemes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportThemes for more information on using the ExportThemes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportThemesRequest method.
//    req, resp := client.ExportThemesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes
func (c *AmplifyUIBuilder) ExportThemesRequest(input *ExportThemesInput) (req *request.Request, output *ExportThemesOutput) {
	op := &request.Operation{
		Name:       opExportThemes,
		HTTPMethod: "GET",
		HTTPPath:   "/export/app/{appId}/environment/{environmentName}/themes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ExportThemesInput{}
	}

	output = &ExportThemesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportThemes API operation for AWS Amplify UI Builder.
//
// Exports theme configurations to code that is ready to integrate into an Amplify
// app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation ExportThemes for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes
func (c *AmplifyUIBuilder) ExportThemes(input *ExportThemesInput) (*ExportThemesOutput, error) {
	req, out := c.ExportThemesRequest(input)
	return out, req.Send()
}

// ExportThemesWithContext is the same as ExportThemes with the addition of
// the ability to pass a context and additional request options.
//
// See ExportThemes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ExportThemesWithContext(ctx aws.Context, input *ExportThemesInput, opts ...request.Option) (*ExportThemesOutput, error) {
	req, out := c.ExportThemesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ExportThemesPages iterates over the pages of a ExportThemes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ExportThemes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ExportThemes operation.
//    pageNum := 0
//    err := client.ExportThemesPages(params,
//        func(page *amplifyuibuilder.ExportThemesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AmplifyUIBuilder) ExportThemesPages(input *ExportThemesInput, fn func(*ExportThemesOutput, bool) bool) error {
	return c.ExportThemesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ExportThemesPagesWithContext same as ExportThemesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ExportThemesPagesWithContext(ctx aws.Context, input *ExportThemesInput, fn func(*ExportThemesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ExportThemesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ExportThemesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ExportThemesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetComponent = "GetComponent"

// GetComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponent for more information on using the GetComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComponentRequest method.
//    req, resp := client.GetComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent
func (c *AmplifyUIBuilder) GetComponentRequest(input *GetComponentInput) (req *request.Request, output *GetComponentOutput) {
	op := &request.Operation{
		Name:       opGetComponent,
		HTTPMethod: "GET",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/components/{id}",
	}

	if input == nil {
		input = &GetComponentInput{}
	}

	output = &GetComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponent API operation for AWS Amplify UI Builder.
//
// Returns an existing component for an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation GetComponent for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent
func (c *AmplifyUIBuilder) GetComponent(input *GetComponentInput) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	return out, req.Send()
}

// GetComponentWithContext is the same as GetComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) GetComponentWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.Option) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTheme = "GetTheme"

// GetThemeRequest generates a "aws/request.Request" representing the
// client's request for the GetTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTheme for more information on using the GetTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetThemeRequest method.
//    req, resp := client.GetThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme
func (c *AmplifyUIBuilder) GetThemeRequest(input *GetThemeInput) (req *request.Request, output *GetThemeOutput) {
	op := &request.Operation{
		Name:       opGetTheme,
		HTTPMethod: "GET",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/themes/{id}",
	}

	if input == nil {
		input = &GetThemeInput{}
	}

	output = &GetThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTheme API operation for AWS Amplify UI Builder.
//
// Returns an existing theme for an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation GetTheme for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme
func (c *AmplifyUIBuilder) GetTheme(input *GetThemeInput) (*GetThemeOutput, error) {
	req, out := c.GetThemeRequest(input)
	return out, req.Send()
}

// GetThemeWithContext is the same as GetTheme with the addition of
// the ability to pass a context and additional request options.
//
// See GetTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) GetThemeWithContext(ctx aws.Context, input *GetThemeInput, opts ...request.Option) (*GetThemeOutput, error) {
	req, out := c.GetThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComponentsRequest method.
//    req, resp := client.ListComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents
func (c *AmplifyUIBuilder) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "GET",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/components",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for AWS Amplify UI Builder.
//
// Retrieves a list of components for a specified Amplify app and backend environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents
func (c *AmplifyUIBuilder) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListComponents operation.
//    pageNum := 0
//    err := client.ListComponentsPages(params,
//        func(page *amplifyuibuilder.ListComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AmplifyUIBuilder) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemes = "ListThemes"

// ListThemesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemes for more information on using the ListThemes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThemesRequest method.
//    req, resp := client.ListThemesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes
func (c *AmplifyUIBuilder) ListThemesRequest(input *ListThemesInput) (req *request.Request, output *ListThemesOutput) {
	op := &request.Operation{
		Name:       opListThemes,
		HTTPMethod: "GET",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/themes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemesInput{}
	}

	output = &ListThemesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemes API operation for AWS Amplify UI Builder.
//
// Retrieves a list of themes for a specified Amplify app and backend environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation ListThemes for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes
func (c *AmplifyUIBuilder) ListThemes(input *ListThemesInput) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	return out, req.Send()
}

// ListThemesWithContext is the same as ListThemes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ListThemesWithContext(ctx aws.Context, input *ListThemesInput, opts ...request.Option) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemesPages iterates over the pages of a ListThemes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListThemes operation.
//    pageNum := 0
//    err := client.ListThemesPages(params,
//        func(page *amplifyuibuilder.ListThemesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AmplifyUIBuilder) ListThemesPages(input *ListThemesInput, fn func(*ListThemesOutput, bool) bool) error {
	return c.ListThemesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemesPagesWithContext same as ListThemesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) ListThemesPagesWithContext(ctx aws.Context, input *ListThemesInput, fn func(*ListThemesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRefreshToken = "RefreshToken"

// RefreshTokenRequest generates a "aws/request.Request" representing the
// client's request for the RefreshToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshToken for more information on using the RefreshToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RefreshTokenRequest method.
//    req, resp := client.RefreshTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken
func (c *AmplifyUIBuilder) RefreshTokenRequest(input *RefreshTokenInput) (req *request.Request, output *RefreshTokenOutput) {
	op := &request.Operation{
		Name:       opRefreshToken,
		HTTPMethod: "POST",
		HTTPPath:   "/tokens/{provider}/refresh",
	}

	if input == nil {
		input = &RefreshTokenInput{}
	}

	output = &RefreshTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshToken API operation for AWS Amplify UI Builder.
//
// Refreshes a previously issued access token that might have expired.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation RefreshToken for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken
func (c *AmplifyUIBuilder) RefreshToken(input *RefreshTokenInput) (*RefreshTokenOutput, error) {
	req, out := c.RefreshTokenRequest(input)
	return out, req.Send()
}

// RefreshTokenWithContext is the same as RefreshToken with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) RefreshTokenWithContext(ctx aws.Context, input *RefreshTokenInput, opts ...request.Option) (*RefreshTokenOutput, error) {
	req, out := c.RefreshTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponent = "UpdateComponent"

// UpdateComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponent for more information on using the UpdateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComponentRequest method.
//    req, resp := client.UpdateComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent
func (c *AmplifyUIBuilder) UpdateComponentRequest(input *UpdateComponentInput) (req *request.Request, output *UpdateComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateComponent,
		HTTPMethod: "PATCH",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/components/{id}",
	}

	if input == nil {
		input = &UpdateComponentInput{}
	}

	output = &UpdateComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateComponent API operation for AWS Amplify UI Builder.
//
// Updates an existing component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation UpdateComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent
func (c *AmplifyUIBuilder) UpdateComponent(input *UpdateComponentInput) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	return out, req.Send()
}

// UpdateComponentWithContext is the same as UpdateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) UpdateComponentWithContext(ctx aws.Context, input *UpdateComponentInput, opts ...request.Option) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTheme = "UpdateTheme"

// UpdateThemeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTheme for more information on using the UpdateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThemeRequest method.
//    req, resp := client.UpdateThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme
func (c *AmplifyUIBuilder) UpdateThemeRequest(input *UpdateThemeInput) (req *request.Request, output *UpdateThemeOutput) {
	op := &request.Operation{
		Name:       opUpdateTheme,
		HTTPMethod: "PATCH",
		HTTPPath:   "/app/{appId}/environment/{environmentName}/themes/{id}",
	}

	if input == nil {
		input = &UpdateThemeInput{}
	}

	output = &UpdateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTheme API operation for AWS Amplify UI Builder.
//
// Updates an existing theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify UI Builder's
// API operation UpdateTheme for usage and error information.
//
// Returned Error Types:
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * InternalServerException
//   An internal error has occurred. Please retry your request.
//
//   * InvalidParameterException
//   An invalid or out-of-range value was supplied for the input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme
func (c *AmplifyUIBuilder) UpdateTheme(input *UpdateThemeInput) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	return out, req.Send()
}

// UpdateThemeWithContext is the same as UpdateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyUIBuilder) UpdateThemeWithContext(ctx aws.Context, input *UpdateThemeInput, opts ...request.Option) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the event action configuration for an element of a Component or
// ComponentChild. Use for the workflow feature in Amplify Studio that allows
// you to bind events and actions to components. ActionParameters defines the
// action that is performed when an event occurs on the component.
type ActionParameters struct {
	_ struct{} `type:"structure"`

	// The HTML anchor link to the location to open. Specify this value for a navigation
	// action.
	Anchor *ComponentProperty `locationName:"anchor" type:"structure"`

	// A dictionary of key-value pairs mapping Amplify Studio properties to fields
	// in a data model. Use when the action performs an operation on an Amplify
	// DataStore model.
	Fields map[string]*ComponentProperty `locationName:"fields" type:"map"`

	// Specifies whether the user should be signed out globally. Specify this value
	// for an auth sign out action.
	Global *ComponentProperty `locationName:"global" type:"structure"`

	// The unique ID of the component that the ActionParameters apply to.
	Id *ComponentProperty `locationName:"id" type:"structure"`

	// The name of the data model. Use when the action performs an operation on
	// an Amplify DataStore model.
	Model *string `locationName:"model" type:"string"`

	// A key-value pair that specifies the state property name and its initial value.
	State *MutationActionSetStateParameter `locationName:"state" type:"structure"`

	// The element within the same component to modify when the action occurs.
	Target *ComponentProperty `locationName:"target" type:"structure"`

	// The type of navigation action. Valid values are url and anchor. This value
	// is required for a navigation action.
	Type *ComponentProperty `locationName:"type" type:"structure"`

	// The URL to the location to open. Specify this value for a navigation action.
	Url *ComponentProperty `locationName:"url" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionParameters"}
	if s.Anchor != nil {
		if err := s.Anchor.Validate(); err != nil {
			invalidParams.AddNested("Anchor", err.(request.ErrInvalidParams))
		}
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Global != nil {
		if err := s.Global.Validate(); err != nil {
			invalidParams.AddNested("Global", err.(request.ErrInvalidParams))
		}
	}
	if s.Id != nil {
		if err := s.Id.Validate(); err != nil {
			invalidParams.AddNested("Id", err.(request.ErrInvalidParams))
		}
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(request.ErrInvalidParams))
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}
	if s.Url != nil {
		if err := s.Url.Validate(); err != nil {
			invalidParams.AddNested("Url", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnchor sets the Anchor field's value.
func (s *ActionParameters) SetAnchor(v *ComponentProperty) *ActionParameters {
	s.Anchor = v
	return s
}

// SetFields sets the Fields field's value.
func (s *ActionParameters) SetFields(v map[string]*ComponentProperty) *ActionParameters {
	s.Fields = v
	return s
}

// SetGlobal sets the Global field's value.
func (s *ActionParameters) SetGlobal(v *ComponentProperty) *ActionParameters {
	s.Global = v
	return s
}

// SetId sets the Id field's value.
func (s *ActionParameters) SetId(v *ComponentProperty) *ActionParameters {
	s.Id = v
	return s
}

// SetModel sets the Model field's value.
func (s *ActionParameters) SetModel(v string) *ActionParameters {
	s.Model = &v
	return s
}

// SetState sets the State field's value.
func (s *ActionParameters) SetState(v *MutationActionSetStateParameter) *ActionParameters {
	s.State = v
	return s
}

// SetTarget sets the Target field's value.
func (s *ActionParameters) SetTarget(v *ComponentProperty) *ActionParameters {
	s.Target = v
	return s
}

// SetType sets the Type field's value.
func (s *ActionParameters) SetType(v *ComponentProperty) *ActionParameters {
	s.Type = v
	return s
}

// SetUrl sets the Url field's value.
func (s *ActionParameters) SetUrl(v *ComponentProperty) *ActionParameters {
	s.Url = v
	return s
}

// Contains the configuration settings for a user interface (UI) element for
// an Amplify app. A component is configured as a primary, stand-alone UI element.
// Use ComponentChild to configure an instance of a Component. A ComponentChild
// instance inherits the configuration of the main Component.
type Component struct {
	_ struct{} `type:"structure"`

	// The unique ID of the Amplify app associated with the component.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The information to connect a component's properties to data at runtime. You
	// can't specify tags as a valid property for bindingProperties.
	//
	// BindingProperties is a required field
	BindingProperties map[string]*ComponentBindingPropertiesValue `locationName:"bindingProperties" type:"map" required:"true"`

	// A list of the component's ComponentChild instances.
	Children []*ComponentChild `locationName:"children" type:"list"`

	// The data binding configuration for the component's properties. Use this for
	// a collection component. You can't specify tags as a valid property for collectionProperties.
	CollectionProperties map[string]*ComponentDataConfiguration `locationName:"collectionProperties" type:"map"`

	// The type of the component. This can be an Amplify custom UI component or
	// another custom component.
	//
	// ComponentType is a required field
	ComponentType *string `locationName:"componentType" min:"1" type:"string" required:"true"`

	// The time that the component was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" type:"string" required:"true"`

	// Describes the events that can be raised on the component. Use for the workflow
	// feature in Amplify Studio that allows you to bind events and actions to components.
	Events map[string]*ComponentEvent `locationName:"events" type:"map"`

	// The unique ID of the component.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The time that the component was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Describes the component's properties that can be overriden in a customized
	// instance of the component. You can't specify tags as a valid property for
	// overrides.
	//
	// Overrides is a required field
	Overrides map[string]map[string]*string `locationName:"overrides" type:"map" required:"true"`

	// Describes the component's properties. You can't specify tags as a valid property
	// for properties.
	//
	// Properties is a required field
	Properties map[string]*ComponentProperty `locationName:"properties" type:"map" required:"true"`

	// The schema version of the component when it was imported.
	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// The unique ID of the component in its original source system, such as Figma.
	SourceId *string `locationName:"sourceId" type:"string"`

	// One or more key-value pairs to use when tagging the component.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of the component's variants. A variant is a unique style configuration
	// of a main component.
	//
	// Variants is a required field
	Variants []*ComponentVariant `locationName:"variants" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *Component) SetAppId(v string) *Component {
	s.AppId = &v
	return s
}

// SetBindingProperties sets the BindingProperties field's value.
func (s *Component) SetBindingProperties(v map[string]*ComponentBindingPropertiesValue) *Component {
	s.BindingProperties = v
	return s
}

// SetChildren sets the Children field's value.
func (s *Component) SetChildren(v []*ComponentChild) *Component {
	s.Children = v
	return s
}

// SetCollectionProperties sets the CollectionProperties field's value.
func (s *Component) SetCollectionProperties(v map[string]*ComponentDataConfiguration) *Component {
	s.CollectionProperties = v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *Component) SetComponentType(v string) *Component {
	s.ComponentType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Component) SetCreatedAt(v time.Time) *Component {
	s.CreatedAt = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *Component) SetEnvironmentName(v string) *Component {
	s.EnvironmentName = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *Component) SetEvents(v map[string]*ComponentEvent) *Component {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *Component) SetId(v string) *Component {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Component) SetModifiedAt(v time.Time) *Component {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *Component) SetName(v string) *Component {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *Component) SetOverrides(v map[string]map[string]*string) *Component {
	s.Overrides = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Component) SetProperties(v map[string]*ComponentProperty) *Component {
	s.Properties = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *Component) SetSchemaVersion(v string) *Component {
	s.SchemaVersion = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *Component) SetSourceId(v string) *Component {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Component) SetTags(v map[string]*string) *Component {
	s.Tags = v
	return s
}

// SetVariants sets the Variants field's value.
func (s *Component) SetVariants(v []*ComponentVariant) *Component {
	s.Variants = v
	return s
}

// Represents the data binding configuration for a component at runtime. You
// can use ComponentBindingPropertiesValue to add exposed properties to a component
// to allow different values to be entered when a component is reused in different
// places in an app.
type ComponentBindingPropertiesValue struct {
	_ struct{} `type:"structure"`

	// Describes the properties to customize with data at runtime.
	BindingProperties *ComponentBindingPropertiesValueProperties `locationName:"bindingProperties" type:"structure"`

	// The default value of the property.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The property type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentBindingPropertiesValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentBindingPropertiesValue) GoString() string {
	return s.String()
}

// SetBindingProperties sets the BindingProperties field's value.
func (s *ComponentBindingPropertiesValue) SetBindingProperties(v *ComponentBindingPropertiesValueProperties) *ComponentBindingPropertiesValue {
	s.BindingProperties = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ComponentBindingPropertiesValue) SetDefaultValue(v string) *ComponentBindingPropertiesValue {
	s.DefaultValue = &v
	return s
}

// SetType sets the Type field's value.
func (s *ComponentBindingPropertiesValue) SetType(v string) *ComponentBindingPropertiesValue {
	s.Type = &v
	return s
}

// Represents the data binding configuration for a specific property using data
// stored in Amazon Web Services. For Amazon Web Services connected properties,
// you can bind a property to data stored in an Amazon S3 bucket, an Amplify
// DataStore model or an authenticated user attribute.
type ComponentBindingPropertiesValueProperties struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket.
	Bucket *string `locationName:"bucket" type:"string"`

	// The default value to assign to the property.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The field to bind the data to.
	Field *string `locationName:"field" type:"string"`

	// The storage key for an Amazon S3 bucket.
	Key *string `locationName:"key" type:"string"`

	// An Amplify DataStore model.
	Model *string `locationName:"model" type:"string"`

	// A list of predicates for binding a component's properties to data.
	Predicates []*Predicate `locationName:"predicates" type:"list"`

	// An authenticated user attribute.
	UserAttribute *string `locationName:"userAttribute" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentBindingPropertiesValueProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentBindingPropertiesValueProperties) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *ComponentBindingPropertiesValueProperties) SetBucket(v string) *ComponentBindingPropertiesValueProperties {
	s.Bucket = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ComponentBindingPropertiesValueProperties) SetDefaultValue(v string) *ComponentBindingPropertiesValueProperties {
	s.DefaultValue = &v
	return s
}

// SetField sets the Field field's value.
func (s *ComponentBindingPropertiesValueProperties) SetField(v string) *ComponentBindingPropertiesValueProperties {
	s.Field = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ComponentBindingPropertiesValueProperties) SetKey(v string) *ComponentBindingPropertiesValueProperties {
	s.Key = &v
	return s
}

// SetModel sets the Model field's value.
func (s *ComponentBindingPropertiesValueProperties) SetModel(v string) *ComponentBindingPropertiesValueProperties {
	s.Model = &v
	return s
}

// SetPredicates sets the Predicates field's value.
func (s *ComponentBindingPropertiesValueProperties) SetPredicates(v []*Predicate) *ComponentBindingPropertiesValueProperties {
	s.Predicates = v
	return s
}

// SetUserAttribute sets the UserAttribute field's value.
func (s *ComponentBindingPropertiesValueProperties) SetUserAttribute(v string) *ComponentBindingPropertiesValueProperties {
	s.UserAttribute = &v
	return s
}

// A nested UI configuration within a parent Component.
type ComponentChild struct {
	_ struct{} `type:"structure"`

	// The list of ComponentChild instances for this component.
	Children []*ComponentChild `locationName:"children" type:"list"`

	// The type of the child component.
	//
	// ComponentType is a required field
	ComponentType *string `locationName:"componentType" type:"string" required:"true"`

	// Describes the events that can be raised on the child component. Use for the
	// workflow feature in Amplify Studio that allows you to bind events and actions
	// to components.
	Events map[string]*ComponentEvent `locationName:"events" type:"map"`

	// The name of the child component.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Describes the properties of the child component. You can't specify tags as
	// a valid property for properties.
	//
	// Properties is a required field
	Properties map[string]*ComponentProperty `locationName:"properties" type:"map" required:"true"`

	// The unique ID of the child component in its original source system, such
	// as Figma.
	SourceId *string `locationName:"sourceId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentChild) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentChild) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentChild) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentChild"}
	if s.ComponentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Children != nil {
		for i, v := range s.Children {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Children", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildren sets the Children field's value.
func (s *ComponentChild) SetChildren(v []*ComponentChild) *ComponentChild {
	s.Children = v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *ComponentChild) SetComponentType(v string) *ComponentChild {
	s.ComponentType = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *ComponentChild) SetEvents(v map[string]*ComponentEvent) *ComponentChild {
	s.Events = v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentChild) SetName(v string) *ComponentChild {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ComponentChild) SetProperties(v map[string]*ComponentProperty) *ComponentChild {
	s.Properties = v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *ComponentChild) SetSourceId(v string) *ComponentChild {
	s.SourceId = &v
	return s
}

// Represents a conditional expression to set a component property. Use ComponentConditionProperty
// to set a property to different values conditionally, based on the value of
// another property.
type ComponentConditionProperty struct {
	_ struct{} `type:"structure"`

	// The value to assign to the property if the condition is not met.
	Else *ComponentProperty `locationName:"else" type:"structure"`

	// The name of a field. Specify this when the property is a data model.
	Field *string `locationName:"field" type:"string"`

	// The value of the property to evaluate.
	Operand *string `locationName:"operand" type:"string"`

	// The type of the property to evaluate.
	OperandType *string `locationName:"operandType" type:"string"`

	// The operator to use to perform the evaluation, such as eq to represent equals.
	Operator *string `locationName:"operator" type:"string"`

	// The name of the conditional property.
	Property *string `locationName:"property" type:"string"`

	// The value to assign to the property if the condition is met.
	Then *ComponentProperty `locationName:"then" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConditionProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConditionProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentConditionProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentConditionProperty"}
	if s.Else != nil {
		if err := s.Else.Validate(); err != nil {
			invalidParams.AddNested("Else", err.(request.ErrInvalidParams))
		}
	}
	if s.Then != nil {
		if err := s.Then.Validate(); err != nil {
			invalidParams.AddNested("Then", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElse sets the Else field's value.
func (s *ComponentConditionProperty) SetElse(v *ComponentProperty) *ComponentConditionProperty {
	s.Else = v
	return s
}

// SetField sets the Field field's value.
func (s *ComponentConditionProperty) SetField(v string) *ComponentConditionProperty {
	s.Field = &v
	return s
}

// SetOperand sets the Operand field's value.
func (s *ComponentConditionProperty) SetOperand(v string) *ComponentConditionProperty {
	s.Operand = &v
	return s
}

// SetOperandType sets the OperandType field's value.
func (s *ComponentConditionProperty) SetOperandType(v string) *ComponentConditionProperty {
	s.OperandType = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ComponentConditionProperty) SetOperator(v string) *ComponentConditionProperty {
	s.Operator = &v
	return s
}

// SetProperty sets the Property field's value.
func (s *ComponentConditionProperty) SetProperty(v string) *ComponentConditionProperty {
	s.Property = &v
	return s
}

// SetThen sets the Then field's value.
func (s *ComponentConditionProperty) SetThen(v *ComponentProperty) *ComponentConditionProperty {
	s.Then = v
	return s
}

// Describes the configuration for binding a component's properties to data.
type ComponentDataConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of IDs to use to bind data to a component. Use this property to bind
	// specifically chosen data, rather than data retrieved from a query.
	Identifiers []*string `locationName:"identifiers" type:"list"`

	// The name of the data model to use to bind data to a component.
	//
	// Model is a required field
	Model *string `locationName:"model" type:"string" required:"true"`

	// Represents the conditional logic to use when binding data to a component.
	// Use this property to retrieve only a subset of the data in a collection.
	Predicate *Predicate `locationName:"predicate" type:"structure"`

	// Describes how to sort the component's properties.
	Sort []*SortProperty `locationName:"sort" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDataConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentDataConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentDataConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentDataConfiguration"}
	if s.Model == nil {
		invalidParams.Add(request.NewErrParamRequired("Model"))
	}
	if s.Sort != nil {
		for i, v := range s.Sort {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sort", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifiers sets the Identifiers field's value.
func (s *ComponentDataConfiguration) SetIdentifiers(v []*string) *ComponentDataConfiguration {
	s.Identifiers = v
	return s
}

// SetModel sets the Model field's value.
func (s *ComponentDataConfiguration) SetModel(v string) *ComponentDataConfiguration {
	s.Model = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *ComponentDataConfiguration) SetPredicate(v *Predicate) *ComponentDataConfiguration {
	s.Predicate = v
	return s
}

// SetSort sets the Sort field's value.
func (s *ComponentDataConfiguration) SetSort(v []*SortProperty) *ComponentDataConfiguration {
	s.Sort = v
	return s
}

// Describes the configuration of an event. You can bind an event and a corresponding
// action to a Component or a ComponentChild. A button click is an example of
// an event.
type ComponentEvent struct {
	_ struct{} `type:"structure"`

	// The action to perform when a specific event is raised.
	Action *string `locationName:"action" type:"string"`

	// Binds an event to an action on a component. When you specify a bindingEvent,
	// the event is called when the action is performed.
	BindingEvent *string `locationName:"bindingEvent" type:"string"`

	// Describes information about the action.
	Parameters *ActionParameters `locationName:"parameters" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentEvent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentEvent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentEvent"}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ComponentEvent) SetAction(v string) *ComponentEvent {
	s.Action = &v
	return s
}

// SetBindingEvent sets the BindingEvent field's value.
func (s *ComponentEvent) SetBindingEvent(v string) *ComponentEvent {
	s.BindingEvent = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ComponentEvent) SetParameters(v *ActionParameters) *ComponentEvent {
	s.Parameters = v
	return s
}

// Describes the configuration for all of a component's properties. Use ComponentProperty
// to specify the values to render or bind by default.
type ComponentProperty struct {
	_ struct{} `type:"structure"`

	// The information to bind the component property to data at runtime.
	BindingProperties *ComponentPropertyBindingProperties `locationName:"bindingProperties" type:"structure"`

	// The information to bind the component property to form data.
	Bindings map[string]*FormBindingElement `locationName:"bindings" type:"map"`

	// The information to bind the component property to data at runtime. Use this
	// for collection components.
	CollectionBindingProperties *ComponentPropertyBindingProperties `locationName:"collectionBindingProperties" type:"structure"`

	// The name of the component that is affected by an event.
	ComponentName *string `locationName:"componentName" type:"string"`

	// A list of component properties to concatenate to create the value to assign
	// to this component property.
	Concat []*ComponentProperty `locationName:"concat" type:"list"`

	// The conditional expression to use to assign a value to the component property.
	Condition *ComponentConditionProperty `locationName:"condition" type:"structure"`

	// Specifies whether the user configured the property in Amplify Studio after
	// importing it.
	Configured *bool `locationName:"configured" type:"boolean"`

	// The default value to assign to the component property.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// An event that occurs in your app. Use this for workflow data binding.
	Event *string `locationName:"event" type:"string"`

	// The default value assigned to the property when the component is imported
	// into an app.
	ImportedValue *string `locationName:"importedValue" type:"string"`

	// The data model to use to assign a value to the component property.
	Model *string `locationName:"model" type:"string"`

	// The name of the component's property that is affected by an event.
	Property *string `locationName:"property" type:"string"`

	// The component type.
	Type *string `locationName:"type" type:"string"`

	// An authenticated user attribute to use to assign a value to the component
	// property.
	UserAttribute *string `locationName:"userAttribute" type:"string"`

	// The value to assign to the component property.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentProperty"}
	if s.BindingProperties != nil {
		if err := s.BindingProperties.Validate(); err != nil {
			invalidParams.AddNested("BindingProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.Bindings != nil {
		for i, v := range s.Bindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Bindings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CollectionBindingProperties != nil {
		if err := s.CollectionBindingProperties.Validate(); err != nil {
			invalidParams.AddNested("CollectionBindingProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.Concat != nil {
		for i, v := range s.Concat {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Concat", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBindingProperties sets the BindingProperties field's value.
func (s *ComponentProperty) SetBindingProperties(v *ComponentPropertyBindingProperties) *ComponentProperty {
	s.BindingProperties = v
	return s
}

// SetBindings sets the Bindings field's value.
func (s *ComponentProperty) SetBindings(v map[string]*FormBindingElement) *ComponentProperty {
	s.Bindings = v
	return s
}

// SetCollectionBindingProperties sets the CollectionBindingProperties field's value.
func (s *ComponentProperty) SetCollectionBindingProperties(v *ComponentPropertyBindingProperties) *ComponentProperty {
	s.CollectionBindingProperties = v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ComponentProperty) SetComponentName(v string) *ComponentProperty {
	s.ComponentName = &v
	return s
}

// SetConcat sets the Concat field's value.
func (s *ComponentProperty) SetConcat(v []*ComponentProperty) *ComponentProperty {
	s.Concat = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *ComponentProperty) SetCondition(v *ComponentConditionProperty) *ComponentProperty {
	s.Condition = v
	return s
}

// SetConfigured sets the Configured field's value.
func (s *ComponentProperty) SetConfigured(v bool) *ComponentProperty {
	s.Configured = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ComponentProperty) SetDefaultValue(v string) *ComponentProperty {
	s.DefaultValue = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *ComponentProperty) SetEvent(v string) *ComponentProperty {
	s.Event = &v
	return s
}

// SetImportedValue sets the ImportedValue field's value.
func (s *ComponentProperty) SetImportedValue(v string) *ComponentProperty {
	s.ImportedValue = &v
	return s
}

// SetModel sets the Model field's value.
func (s *ComponentProperty) SetModel(v string) *ComponentProperty {
	s.Model = &v
	return s
}

// SetProperty sets the Property field's value.
func (s *ComponentProperty) SetProperty(v string) *ComponentProperty {
	s.Property = &v
	return s
}

// SetType sets the Type field's value.
func (s *ComponentProperty) SetType(v string) *ComponentProperty {
	s.Type = &v
	return s
}

// SetUserAttribute sets the UserAttribute field's value.
func (s *ComponentProperty) SetUserAttribute(v string) *ComponentProperty {
	s.UserAttribute = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ComponentProperty) SetValue(v string) *ComponentProperty {
	s.Value = &v
	return s
}

// Associates a component property to a binding property. This enables exposed
// properties on the top level component to propagate data to the component's
// property values.
type ComponentPropertyBindingProperties struct {
	_ struct{} `type:"structure"`

	// The data field to bind the property to.
	Field *string `locationName:"field" type:"string"`

	// The component property to bind to the data field.
	//
	// Property is a required field
	Property *string `locationName:"property" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyBindingProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyBindingProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentPropertyBindingProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentPropertyBindingProperties"}
	if s.Property == nil {
		invalidParams.Add(request.NewErrParamRequired("Property"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetField sets the Field field's value.
func (s *ComponentPropertyBindingProperties) SetField(v string) *ComponentPropertyBindingProperties {
	s.Field = &v
	return s
}

// SetProperty sets the Property field's value.
func (s *ComponentPropertyBindingProperties) SetProperty(v string) *ComponentPropertyBindingProperties {
	s.Property = &v
	return s
}

// Contains a summary of a component. This is a read-only data type that is
// returned by ListComponents.
type ComponentSummary struct {
	_ struct{} `type:"structure"`

	// The unique ID of the Amplify app associated with the component.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The component type.
	//
	// ComponentType is a required field
	ComponentType *string `locationName:"componentType" min:"1" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" type:"string" required:"true"`

	// The unique ID of the component.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *ComponentSummary) SetAppId(v string) *ComponentSummary {
	s.AppId = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *ComponentSummary) SetComponentType(v string) *ComponentSummary {
	s.ComponentType = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ComponentSummary) SetEnvironmentName(v string) *ComponentSummary {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *ComponentSummary) SetId(v string) *ComponentSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentSummary) SetName(v string) *ComponentSummary {
	s.Name = &v
	return s
}

// Describes the style configuration of a unique variation of a main component.
type ComponentVariant struct {
	_ struct{} `type:"structure"`

	// The properties of the component variant that can be overriden when customizing
	// an instance of the component. You can't specify tags as a valid property
	// for overrides.
	Overrides map[string]map[string]*string `locationName:"overrides" type:"map"`

	// The combination of variants that comprise this variant. You can't specify
	// tags as a valid property for variantValues.
	VariantValues map[string]*string `locationName:"variantValues" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVariant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVariant) GoString() string {
	return s.String()
}

// SetOverrides sets the Overrides field's value.
func (s *ComponentVariant) SetOverrides(v map[string]map[string]*string) *ComponentVariant {
	s.Overrides = v
	return s
}

// SetVariantValues sets the VariantValues field's value.
func (s *ComponentVariant) SetVariantValues(v map[string]*string) *ComponentVariant {
	s.VariantValues = v
	return s
}

// Represents all of the information that is required to create a component.
type CreateComponentData struct {
	_ struct{} `type:"structure"`

	// The data binding information for the component's properties.
	//
	// BindingProperties is a required field
	BindingProperties map[string]*ComponentBindingPropertiesValue `locationName:"bindingProperties" type:"map" required:"true"`

	// A list of child components that are instances of the main component.
	Children []*ComponentChild `locationName:"children" type:"list"`

	// The data binding configuration for customizing a component's properties.
	// Use this for a collection component.
	CollectionProperties map[string]*ComponentDataConfiguration `locationName:"collectionProperties" type:"map"`

	// The component type. This can be an Amplify custom UI component or another
	// custom component.
	//
	// ComponentType is a required field
	ComponentType *string `locationName:"componentType" min:"1" type:"string" required:"true"`

	// The event configuration for the component. Use for the workflow feature in
	// Amplify Studio that allows you to bind events and actions to components.
	Events map[string]*ComponentEvent `locationName:"events" type:"map"`

	// The name of the component
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Describes the component properties that can be overriden to customize an
	// instance of the component.
	//
	// Overrides is a required field
	Overrides map[string]map[string]*string `locationName:"overrides" type:"map" required:"true"`

	// Describes the component's properties.
	//
	// Properties is a required field
	Properties map[string]*ComponentProperty `locationName:"properties" type:"map" required:"true"`

	// The schema version of the component when it was imported.
	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// The unique ID of the component in its original source system, such as Figma.
	SourceId *string `locationName:"sourceId" type:"string"`

	// One or more key-value pairs to use when tagging the component data.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of the unique variants of this component.
	//
	// Variants is a required field
	Variants []*ComponentVariant `locationName:"variants" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentData"}
	if s.BindingProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("BindingProperties"))
	}
	if s.ComponentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentType"))
	}
	if s.ComponentType != nil && len(*s.ComponentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Overrides == nil {
		invalidParams.Add(request.NewErrParamRequired("Overrides"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.Variants == nil {
		invalidParams.Add(request.NewErrParamRequired("Variants"))
	}
	if s.Children != nil {
		for i, v := range s.Children {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Children", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CollectionProperties != nil {
		for i, v := range s.CollectionProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CollectionProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBindingProperties sets the BindingProperties field's value.
func (s *CreateComponentData) SetBindingProperties(v map[string]*ComponentBindingPropertiesValue) *CreateComponentData {
	s.BindingProperties = v
	return s
}

// SetChildren sets the Children field's value.
func (s *CreateComponentData) SetChildren(v []*ComponentChild) *CreateComponentData {
	s.Children = v
	return s
}

// SetCollectionProperties sets the CollectionProperties field's value.
func (s *CreateComponentData) SetCollectionProperties(v map[string]*ComponentDataConfiguration) *CreateComponentData {
	s.CollectionProperties = v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *CreateComponentData) SetComponentType(v string) *CreateComponentData {
	s.ComponentType = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *CreateComponentData) SetEvents(v map[string]*ComponentEvent) *CreateComponentData {
	s.Events = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateComponentData) SetName(v string) *CreateComponentData {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *CreateComponentData) SetOverrides(v map[string]map[string]*string) *CreateComponentData {
	s.Overrides = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *CreateComponentData) SetProperties(v map[string]*ComponentProperty) *CreateComponentData {
	s.Properties = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *CreateComponentData) SetSchemaVersion(v string) *CreateComponentData {
	s.SchemaVersion = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *CreateComponentData) SetSourceId(v string) *CreateComponentData {
	s.SourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComponentData) SetTags(v map[string]*string) *CreateComponentData {
	s.Tags = v
	return s
}

// SetVariants sets the Variants field's value.
func (s *CreateComponentData) SetVariants(v []*ComponentVariant) *CreateComponentData {
	s.Variants = v
	return s
}

type CreateComponentInput struct {
	_ struct{} `type:"structure" payload:"ComponentToCreate"`

	// The unique ID of the Amplify app to associate with the component.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The unique client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Represents the configuration of the component to create.
	//
	// ComponentToCreate is a required field
	ComponentToCreate *CreateComponentData `locationName:"componentToCreate" type:"structure" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.ComponentToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentToCreate"))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.ComponentToCreate != nil {
		if err := s.ComponentToCreate.Validate(); err != nil {
			invalidParams.AddNested("ComponentToCreate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateComponentInput) SetAppId(v string) *CreateComponentInput {
	s.AppId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateComponentInput) SetClientToken(v string) *CreateComponentInput {
	s.ClientToken = &v
	return s
}

// SetComponentToCreate sets the ComponentToCreate field's value.
func (s *CreateComponentInput) SetComponentToCreate(v *CreateComponentData) *CreateComponentInput {
	s.ComponentToCreate = v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreateComponentInput) SetEnvironmentName(v string) *CreateComponentInput {
	s.EnvironmentName = &v
	return s
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure" payload:"Entity"`

	// Describes the configuration of the new component.
	Entity *Component `locationName:"entity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) GoString() string {
	return s.String()
}

// SetEntity sets the Entity field's value.
func (s *CreateComponentOutput) SetEntity(v *Component) *CreateComponentOutput {
	s.Entity = v
	return s
}

// Represents all of the information that is required to create a theme.
type CreateThemeData struct {
	_ struct{} `type:"structure"`

	// The name of the theme.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Describes the properties that can be overriden to customize an instance of
	// the theme.
	Overrides []*ThemeValues `locationName:"overrides" type:"list"`

	// One or more key-value pairs to use when tagging the theme data.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of key-value pairs that deﬁnes the properties of the theme.
	//
	// Values is a required field
	Values []*ThemeValues `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeData"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateThemeData) SetName(v string) *CreateThemeData {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *CreateThemeData) SetOverrides(v []*ThemeValues) *CreateThemeData {
	s.Overrides = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThemeData) SetTags(v map[string]*string) *CreateThemeData {
	s.Tags = v
	return s
}

// SetValues sets the Values field's value.
func (s *CreateThemeData) SetValues(v []*ThemeValues) *CreateThemeData {
	s.Values = v
	return s
}

type CreateThemeInput struct {
	_ struct{} `type:"structure" payload:"ThemeToCreate"`

	// The unique ID of the Amplify app associated with the theme.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The unique client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// Represents the configuration of the theme to create.
	//
	// ThemeToCreate is a required field
	ThemeToCreate *CreateThemeData `locationName:"themeToCreate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.ThemeToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeToCreate"))
	}
	if s.ThemeToCreate != nil {
		if err := s.ThemeToCreate.Validate(); err != nil {
			invalidParams.AddNested("ThemeToCreate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateThemeInput) SetAppId(v string) *CreateThemeInput {
	s.AppId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateThemeInput) SetClientToken(v string) *CreateThemeInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreateThemeInput) SetEnvironmentName(v string) *CreateThemeInput {
	s.EnvironmentName = &v
	return s
}

// SetThemeToCreate sets the ThemeToCreate field's value.
func (s *CreateThemeInput) SetThemeToCreate(v *CreateThemeData) *CreateThemeInput {
	s.ThemeToCreate = v
	return s
}

type CreateThemeOutput struct {
	_ struct{} `type:"structure" payload:"Entity"`

	// Describes the configuration of the new theme.
	Entity *Theme `locationName:"entity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) GoString() string {
	return s.String()
}

// SetEntity sets the Entity field's value.
func (s *CreateThemeOutput) SetEntity(v *Theme) *CreateThemeOutput {
	s.Entity = v
	return s
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app associated with the component to delete.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID of the component to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteComponentInput) SetAppId(v string) *DeleteComponentInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DeleteComponentInput) SetEnvironmentName(v string) *DeleteComponentInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteComponentInput) SetId(v string) *DeleteComponentInput {
	s.Id = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

type DeleteThemeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app associated with the theme to delete.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID of the theme to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThemeInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteThemeInput) SetAppId(v string) *DeleteThemeInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DeleteThemeInput) SetEnvironmentName(v string) *DeleteThemeInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteThemeInput) SetId(v string) *DeleteThemeInput {
	s.Id = &v
	return s
}

type DeleteThemeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeOutput) GoString() string {
	return s.String()
}

type ExchangeCodeForTokenInput struct {
	_ struct{} `type:"structure" payload:"Request"`

	// The third-party provider for the token. The only valid value is figma.
	//
	// Provider is a required field
	Provider *string `location:"uri" locationName:"provider" type:"string" required:"true" enum:"TokenProviders"`

	// Describes the configuration of the request.
	//
	// Request is a required field
	Request *ExchangeCodeForTokenRequestBody `locationName:"request" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExchangeCodeForTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExchangeCodeForTokenInput"}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Request == nil {
		invalidParams.Add(request.NewErrParamRequired("Request"))
	}
	if s.Request != nil {
		if err := s.Request.Validate(); err != nil {
			invalidParams.AddNested("Request", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *ExchangeCodeForTokenInput) SetProvider(v string) *ExchangeCodeForTokenInput {
	s.Provider = &v
	return s
}

// SetRequest sets the Request field's value.
func (s *ExchangeCodeForTokenInput) SetRequest(v *ExchangeCodeForTokenRequestBody) *ExchangeCodeForTokenInput {
	s.Request = v
	return s
}

type ExchangeCodeForTokenOutput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExchangeCodeForTokenOutput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `locationName:"accessToken" type:"string" required:"true" sensitive:"true"`

	// The date and time when the new access token expires.
	//
	// ExpiresIn is a required field
	ExpiresIn *int64 `locationName:"expiresIn" type:"integer" required:"true"`

	// The token to use to refresh a previously issued access token that might have
	// expired.
	//
	// RefreshToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExchangeCodeForTokenOutput's
	// String and GoString methods.
	//
	// RefreshToken is a required field
	RefreshToken *string `locationName:"refreshToken" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenOutput) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *ExchangeCodeForTokenOutput) SetAccessToken(v string) *ExchangeCodeForTokenOutput {
	s.AccessToken = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *ExchangeCodeForTokenOutput) SetExpiresIn(v int64) *ExchangeCodeForTokenOutput {
	s.ExpiresIn = &v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *ExchangeCodeForTokenOutput) SetRefreshToken(v string) *ExchangeCodeForTokenOutput {
	s.RefreshToken = &v
	return s
}

// Describes the configuration of a request to exchange an access code for a
// token.
type ExchangeCodeForTokenRequestBody struct {
	_ struct{} `type:"structure"`

	// The access code to send in the request.
	//
	// Code is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExchangeCodeForTokenRequestBody's
	// String and GoString methods.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" sensitive:"true"`

	// The location of the application that will receive the access code.
	//
	// RedirectUri is a required field
	RedirectUri *string `locationName:"redirectUri" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenRequestBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExchangeCodeForTokenRequestBody) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExchangeCodeForTokenRequestBody) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExchangeCodeForTokenRequestBody"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.RedirectUri == nil {
		invalidParams.Add(request.NewErrParamRequired("RedirectUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *ExchangeCodeForTokenRequestBody) SetCode(v string) *ExchangeCodeForTokenRequestBody {
	s.Code = &v
	return s
}

// SetRedirectUri sets the RedirectUri field's value.
func (s *ExchangeCodeForTokenRequestBody) SetRedirectUri(v string) *ExchangeCodeForTokenRequestBody {
	s.RedirectUri = &v
	return s
}

type ExportComponentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app to export components to.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportComponentsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ExportComponentsInput) SetAppId(v string) *ExportComponentsInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ExportComponentsInput) SetEnvironmentName(v string) *ExportComponentsInput {
	s.EnvironmentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportComponentsInput) SetNextToken(v string) *ExportComponentsInput {
	s.NextToken = &v
	return s
}

type ExportComponentsOutput struct {
	_ struct{} `type:"structure"`

	// Represents the configuration of the exported components.
	//
	// Entities is a required field
	Entities []*Component `locationName:"entities" type:"list" required:"true"`

	// The pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportComponentsOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *ExportComponentsOutput) SetEntities(v []*Component) *ExportComponentsOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportComponentsOutput) SetNextToken(v string) *ExportComponentsOutput {
	s.NextToken = &v
	return s
}

type ExportThemesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app to export the themes to.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportThemesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportThemesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportThemesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportThemesInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ExportThemesInput) SetAppId(v string) *ExportThemesInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ExportThemesInput) SetEnvironmentName(v string) *ExportThemesInput {
	s.EnvironmentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportThemesInput) SetNextToken(v string) *ExportThemesInput {
	s.NextToken = &v
	return s
}

type ExportThemesOutput struct {
	_ struct{} `type:"structure"`

	// Represents the configuration of the exported themes.
	//
	// Entities is a required field
	Entities []*Theme `locationName:"entities" type:"list" required:"true"`

	// The pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportThemesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportThemesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *ExportThemesOutput) SetEntities(v []*Theme) *ExportThemesOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportThemesOutput) SetNextToken(v string) *ExportThemesOutput {
	s.NextToken = &v
	return s
}

// Describes how to bind a component property to form data.
type FormBindingElement struct {
	_ struct{} `type:"structure"`

	// The name of the component to retrieve a value from.
	//
	// Element is a required field
	Element *string `locationName:"element" type:"string" required:"true"`

	// The property to retrieve a value from.
	//
	// Property is a required field
	Property *string `locationName:"property" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormBindingElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormBindingElement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FormBindingElement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FormBindingElement"}
	if s.Element == nil {
		invalidParams.Add(request.NewErrParamRequired("Element"))
	}
	if s.Property == nil {
		invalidParams.Add(request.NewErrParamRequired("Property"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElement sets the Element field's value.
func (s *FormBindingElement) SetElement(v string) *FormBindingElement {
	s.Element = &v
	return s
}

// SetProperty sets the Property field's value.
func (s *FormBindingElement) SetProperty(v string) *FormBindingElement {
	s.Property = &v
	return s
}

type GetComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID of the component.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetComponentInput) SetAppId(v string) *GetComponentInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *GetComponentInput) SetEnvironmentName(v string) *GetComponentInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetComponentInput) SetId(v string) *GetComponentInput {
	s.Id = &v
	return s
}

type GetComponentOutput struct {
	_ struct{} `type:"structure" payload:"Component"`

	// Represents the configuration settings for the component.
	Component *Component `locationName:"component" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *GetComponentOutput) SetComponent(v *Component) *GetComponentOutput {
	s.Component = v
	return s
}

type GetThemeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID for the theme.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThemeInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetThemeInput) SetAppId(v string) *GetThemeInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *GetThemeInput) SetEnvironmentName(v string) *GetThemeInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetThemeInput) SetId(v string) *GetThemeInput {
	s.Id = &v
	return s
}

type GetThemeOutput struct {
	_ struct{} `type:"structure" payload:"Theme"`

	// Represents the configuration settings for the theme.
	Theme *Theme `locationName:"theme" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThemeOutput) GoString() string {
	return s.String()
}

// SetTheme sets the Theme field's value.
func (s *GetThemeOutput) SetTheme(v *Theme) *GetThemeOutput {
	s.Theme = v
	return s
}

// An internal error has occurred. Please retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid or out-of-range value was supplied for the input parameter.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListComponentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The maximum number of components to retrieve.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListComponentsInput) SetAppId(v string) *ListComponentsInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListComponentsInput) SetEnvironmentName(v string) *ListComponentsInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of components for the Amplify app.
	//
	// Entities is a required field
	Entities []*ComponentSummary `locationName:"entities" type:"list" required:"true"`

	// The pagination token that's included if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *ListComponentsOutput) SetEntities(v []*ComponentSummary) *ListComponentsOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListThemesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID for the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The maximum number of theme results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThemesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThemesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThemesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThemesInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListThemesInput) SetAppId(v string) *ListThemesInput {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListThemesInput) SetEnvironmentName(v string) *ListThemesInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThemesInput) SetMaxResults(v int64) *ListThemesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThemesInput) SetNextToken(v string) *ListThemesInput {
	s.NextToken = &v
	return s
}

type ListThemesOutput struct {
	_ struct{} `type:"structure"`

	// The list of themes for the Amplify app.
	//
	// Entities is a required field
	Entities []*ThemeSummary `locationName:"entities" type:"list" required:"true"`

	// The pagination token that's returned if more results are available.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThemesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListThemesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *ListThemesOutput) SetEntities(v []*ThemeSummary) *ListThemesOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThemesOutput) SetNextToken(v string) *ListThemesOutput {
	s.NextToken = &v
	return s
}

// Represents the state configuration when an action modifies a property of
// another element within the same component.
type MutationActionSetStateParameter struct {
	_ struct{} `type:"structure"`

	// The name of the component that is being modified.
	//
	// ComponentName is a required field
	ComponentName *string `locationName:"componentName" type:"string" required:"true"`

	// The name of the component property to apply the state configuration to.
	//
	// Property is a required field
	Property *string `locationName:"property" type:"string" required:"true"`

	// The state configuration to assign to the property.
	//
	// Set is a required field
	Set *ComponentProperty `locationName:"set" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutationActionSetStateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutationActionSetStateParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MutationActionSetStateParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MutationActionSetStateParameter"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.Property == nil {
		invalidParams.Add(request.NewErrParamRequired("Property"))
	}
	if s.Set == nil {
		invalidParams.Add(request.NewErrParamRequired("Set"))
	}
	if s.Set != nil {
		if err := s.Set.Validate(); err != nil {
			invalidParams.AddNested("Set", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *MutationActionSetStateParameter) SetComponentName(v string) *MutationActionSetStateParameter {
	s.ComponentName = &v
	return s
}

// SetProperty sets the Property field's value.
func (s *MutationActionSetStateParameter) SetProperty(v string) *MutationActionSetStateParameter {
	s.Property = &v
	return s
}

// SetSet sets the Set field's value.
func (s *MutationActionSetStateParameter) SetSet(v *ComponentProperty) *MutationActionSetStateParameter {
	s.Set = v
	return s
}

// Stores information for generating Amplify DataStore queries. Use a Predicate
// to retrieve a subset of the data in a collection.
type Predicate struct {
	_ struct{} `type:"structure"`

	// A list of predicates to combine logically.
	And []*Predicate `locationName:"and" type:"list"`

	// The field to query.
	Field *string `locationName:"field" type:"string"`

	// The value to use when performing the evaluation.
	Operand *string `locationName:"operand" type:"string"`

	// The operator to use to perform the evaluation.
	Operator *string `locationName:"operator" type:"string"`

	// A list of predicates to combine logically.
	Or []*Predicate `locationName:"or" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Predicate) GoString() string {
	return s.String()
}

// SetAnd sets the And field's value.
func (s *Predicate) SetAnd(v []*Predicate) *Predicate {
	s.And = v
	return s
}

// SetField sets the Field field's value.
func (s *Predicate) SetField(v string) *Predicate {
	s.Field = &v
	return s
}

// SetOperand sets the Operand field's value.
func (s *Predicate) SetOperand(v string) *Predicate {
	s.Operand = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Predicate) SetOperator(v string) *Predicate {
	s.Operator = &v
	return s
}

// SetOr sets the Or field's value.
func (s *Predicate) SetOr(v []*Predicate) *Predicate {
	s.Or = v
	return s
}

type RefreshTokenInput struct {
	_ struct{} `type:"structure" payload:"RefreshTokenBody"`

	// The third-party provider for the token. The only valid value is figma.
	//
	// Provider is a required field
	Provider *string `location:"uri" locationName:"provider" type:"string" required:"true" enum:"TokenProviders"`

	// Information about the refresh token request.
	//
	// RefreshTokenBody is a required field
	RefreshTokenBody *RefreshTokenRequestBody `locationName:"refreshTokenBody" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshTokenInput"}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.RefreshTokenBody == nil {
		invalidParams.Add(request.NewErrParamRequired("RefreshTokenBody"))
	}
	if s.RefreshTokenBody != nil {
		if err := s.RefreshTokenBody.Validate(); err != nil {
			invalidParams.AddNested("RefreshTokenBody", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *RefreshTokenInput) SetProvider(v string) *RefreshTokenInput {
	s.Provider = &v
	return s
}

// SetRefreshTokenBody sets the RefreshTokenBody field's value.
func (s *RefreshTokenInput) SetRefreshTokenBody(v *RefreshTokenRequestBody) *RefreshTokenInput {
	s.RefreshTokenBody = v
	return s
}

type RefreshTokenOutput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RefreshTokenOutput's
	// String and GoString methods.
	//
	// AccessToken is a required field
	AccessToken *string `locationName:"accessToken" type:"string" required:"true" sensitive:"true"`

	// The date and time when the new access token expires.
	//
	// ExpiresIn is a required field
	ExpiresIn *int64 `locationName:"expiresIn" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenOutput) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *RefreshTokenOutput) SetAccessToken(v string) *RefreshTokenOutput {
	s.AccessToken = &v
	return s
}

// SetExpiresIn sets the ExpiresIn field's value.
func (s *RefreshTokenOutput) SetExpiresIn(v int64) *RefreshTokenOutput {
	s.ExpiresIn = &v
	return s
}

// Describes a refresh token.
type RefreshTokenRequestBody struct {
	_ struct{} `type:"structure"`

	// The token to use to refresh a previously issued access token that might have
	// expired.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RefreshTokenRequestBody's
	// String and GoString methods.
	//
	// Token is a required field
	Token *string `locationName:"token" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenRequestBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenRequestBody) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshTokenRequestBody) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshTokenRequestBody"}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetToken sets the Token field's value.
func (s *RefreshTokenRequestBody) SetToken(v string) *RefreshTokenRequestBody {
	s.Token = &v
	return s
}

// The resource specified in the request conflicts with an existing resource.
type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource does not exist, or access was denied.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You exceeded your service quota. Service quotas, also referred to as limits,
// are the maximum number of service resources or operations for your Amazon
// Web Services account.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes how to sort the data that you bind to a component.
type SortProperty struct {
	_ struct{} `type:"structure"`

	// The direction of the sort, either ascending or descending.
	//
	// Direction is a required field
	Direction *string `locationName:"direction" type:"string" required:"true" enum:"SortDirection"`

	// The field to perform the sort on.
	//
	// Field is a required field
	Field *string `locationName:"field" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SortProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SortProperty"}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.Field == nil {
		invalidParams.Add(request.NewErrParamRequired("Field"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirection sets the Direction field's value.
func (s *SortProperty) SetDirection(v string) *SortProperty {
	s.Direction = &v
	return s
}

// SetField sets the Field field's value.
func (s *SortProperty) SetField(v string) *SortProperty {
	s.Field = &v
	return s
}

// A theme is a collection of style settings that apply globally to the components
// associated with an Amplify application.
type Theme struct {
	_ struct{} `type:"structure"`

	// The unique ID for the Amplify app associated with the theme.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The time that the theme was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the backend environment that is a part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" type:"string" required:"true"`

	// The ID for the theme.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The time that the theme was modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the theme.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Describes the properties that can be overriden to customize a theme.
	Overrides []*ThemeValues `locationName:"overrides" type:"list"`

	// One or more key-value pairs to use when tagging the theme.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of key-value pairs that defines the properties of the theme.
	//
	// Values is a required field
	Values []*ThemeValues `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Theme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Theme) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *Theme) SetAppId(v string) *Theme {
	s.AppId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Theme) SetCreatedAt(v time.Time) *Theme {
	s.CreatedAt = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *Theme) SetEnvironmentName(v string) *Theme {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Theme) SetId(v string) *Theme {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Theme) SetModifiedAt(v time.Time) *Theme {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *Theme) SetName(v string) *Theme {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *Theme) SetOverrides(v []*ThemeValues) *Theme {
	s.Overrides = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Theme) SetTags(v map[string]*string) *Theme {
	s.Tags = v
	return s
}

// SetValues sets the Values field's value.
func (s *Theme) SetValues(v []*ThemeValues) *Theme {
	s.Values = v
	return s
}

// Describes the basic information about a theme.
type ThemeSummary struct {
	_ struct{} `type:"structure"`

	// The unique ID for the app associated with the theme summary.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" type:"string" required:"true"`

	// The ID of the theme.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the theme.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeSummary) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *ThemeSummary) SetAppId(v string) *ThemeSummary {
	s.AppId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ThemeSummary) SetEnvironmentName(v string) *ThemeSummary {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *ThemeSummary) SetId(v string) *ThemeSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ThemeSummary) SetName(v string) *ThemeSummary {
	s.Name = &v
	return s
}

// Describes the configuration of a theme's properties.
type ThemeValue struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs that define the theme's properties.
	Children []*ThemeValues `locationName:"children" type:"list"`

	// The value of a theme property.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeValue) GoString() string {
	return s.String()
}

// SetChildren sets the Children field's value.
func (s *ThemeValue) SetChildren(v []*ThemeValues) *ThemeValue {
	s.Children = v
	return s
}

// SetValue sets the Value field's value.
func (s *ThemeValue) SetValue(v string) *ThemeValue {
	s.Value = &v
	return s
}

// A key-value pair that defines a property of a theme.
type ThemeValues struct {
	_ struct{} `type:"structure"`

	// The name of the property.
	Key *string `locationName:"key" type:"string"`

	// The value of the property.
	Value *ThemeValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThemeValues) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ThemeValues) SetKey(v string) *ThemeValues {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ThemeValues) SetValue(v *ThemeValue) *ThemeValues {
	s.Value = v
	return s
}

// Updates and saves all of the information about a component, based on component
// ID.
type UpdateComponentData struct {
	_ struct{} `type:"structure"`

	// The data binding information for the component's properties.
	BindingProperties map[string]*ComponentBindingPropertiesValue `locationName:"bindingProperties" type:"map"`

	// The components that are instances of the main component.
	Children []*ComponentChild `locationName:"children" type:"list"`

	// The configuration for binding a component's properties to a data model. Use
	// this for a collection component.
	CollectionProperties map[string]*ComponentDataConfiguration `locationName:"collectionProperties" type:"map"`

	// The type of the component. This can be an Amplify custom UI component or
	// another custom component.
	ComponentType *string `locationName:"componentType" min:"1" type:"string"`

	// The event configuration for the component. Use for the workflow feature in
	// Amplify Studio that allows you to bind events and actions to components.
	Events map[string]*ComponentEvent `locationName:"events" type:"map"`

	// The unique ID of the component to update.
	Id *string `locationName:"id" type:"string"`

	// The name of the component to update.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Describes the properties that can be overriden to customize the component.
	Overrides map[string]map[string]*string `locationName:"overrides" type:"map"`

	// Describes the component's properties.
	Properties map[string]*ComponentProperty `locationName:"properties" type:"map"`

	// The schema version of the component when it was imported.
	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// The unique ID of the component in its original source system, such as Figma.
	SourceId *string `locationName:"sourceId" type:"string"`

	// A list of the unique variants of the main component being updated.
	Variants []*ComponentVariant `locationName:"variants" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentData"}
	if s.ComponentType != nil && len(*s.ComponentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentType", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Children != nil {
		for i, v := range s.Children {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Children", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CollectionProperties != nil {
		for i, v := range s.CollectionProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CollectionProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBindingProperties sets the BindingProperties field's value.
func (s *UpdateComponentData) SetBindingProperties(v map[string]*ComponentBindingPropertiesValue) *UpdateComponentData {
	s.BindingProperties = v
	return s
}

// SetChildren sets the Children field's value.
func (s *UpdateComponentData) SetChildren(v []*ComponentChild) *UpdateComponentData {
	s.Children = v
	return s
}

// SetCollectionProperties sets the CollectionProperties field's value.
func (s *UpdateComponentData) SetCollectionProperties(v map[string]*ComponentDataConfiguration) *UpdateComponentData {
	s.CollectionProperties = v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *UpdateComponentData) SetComponentType(v string) *UpdateComponentData {
	s.ComponentType = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *UpdateComponentData) SetEvents(v map[string]*ComponentEvent) *UpdateComponentData {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateComponentData) SetId(v string) *UpdateComponentData {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateComponentData) SetName(v string) *UpdateComponentData {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *UpdateComponentData) SetOverrides(v map[string]map[string]*string) *UpdateComponentData {
	s.Overrides = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *UpdateComponentData) SetProperties(v map[string]*ComponentProperty) *UpdateComponentData {
	s.Properties = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *UpdateComponentData) SetSchemaVersion(v string) *UpdateComponentData {
	s.SchemaVersion = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *UpdateComponentData) SetSourceId(v string) *UpdateComponentData {
	s.SourceId = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *UpdateComponentData) SetVariants(v []*ComponentVariant) *UpdateComponentData {
	s.Variants = v
	return s
}

type UpdateComponentInput struct {
	_ struct{} `type:"structure" payload:"UpdatedComponent"`

	// The unique ID for the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The unique client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID for the component.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The configuration of the updated component.
	//
	// UpdatedComponent is a required field
	UpdatedComponent *UpdateComponentData `locationName:"updatedComponent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.UpdatedComponent == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedComponent"))
	}
	if s.UpdatedComponent != nil {
		if err := s.UpdatedComponent.Validate(); err != nil {
			invalidParams.AddNested("UpdatedComponent", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateComponentInput) SetAppId(v string) *UpdateComponentInput {
	s.AppId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateComponentInput) SetClientToken(v string) *UpdateComponentInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *UpdateComponentInput) SetEnvironmentName(v string) *UpdateComponentInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateComponentInput) SetId(v string) *UpdateComponentInput {
	s.Id = &v
	return s
}

// SetUpdatedComponent sets the UpdatedComponent field's value.
func (s *UpdateComponentInput) SetUpdatedComponent(v *UpdateComponentData) *UpdateComponentInput {
	s.UpdatedComponent = v
	return s
}

type UpdateComponentOutput struct {
	_ struct{} `type:"structure" payload:"Entity"`

	// Describes the configuration of the updated component.
	Entity *Component `locationName:"entity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentOutput) GoString() string {
	return s.String()
}

// SetEntity sets the Entity field's value.
func (s *UpdateComponentOutput) SetEntity(v *Component) *UpdateComponentOutput {
	s.Entity = v
	return s
}

// Saves the data binding information for a theme.
type UpdateThemeData struct {
	_ struct{} `type:"structure"`

	// The unique ID of the theme to update.
	Id *string `locationName:"id" type:"string"`

	// The name of the theme to update.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Describes the properties that can be overriden to customize the theme.
	Overrides []*ThemeValues `locationName:"overrides" type:"list"`

	// A list of key-value pairs that define the theme's properties.
	//
	// Values is a required field
	Values []*ThemeValues `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThemeData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThemeData"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateThemeData) SetId(v string) *UpdateThemeData {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateThemeData) SetName(v string) *UpdateThemeData {
	s.Name = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *UpdateThemeData) SetOverrides(v []*ThemeValues) *UpdateThemeData {
	s.Overrides = v
	return s
}

// SetValues sets the Values field's value.
func (s *UpdateThemeData) SetValues(v []*ThemeValues) *UpdateThemeData {
	s.Values = v
	return s
}

type UpdateThemeInput struct {
	_ struct{} `type:"structure" payload:"UpdatedTheme"`

	// The unique ID for the Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The unique client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the backend environment that is part of the Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"environmentName" type:"string" required:"true"`

	// The unique ID for the theme.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// The configuration of the updated theme.
	//
	// UpdatedTheme is a required field
	UpdatedTheme *UpdateThemeData `locationName:"updatedTheme" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThemeInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.UpdatedTheme == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedTheme"))
	}
	if s.UpdatedTheme != nil {
		if err := s.UpdatedTheme.Validate(); err != nil {
			invalidParams.AddNested("UpdatedTheme", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateThemeInput) SetAppId(v string) *UpdateThemeInput {
	s.AppId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateThemeInput) SetClientToken(v string) *UpdateThemeInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *UpdateThemeInput) SetEnvironmentName(v string) *UpdateThemeInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateThemeInput) SetId(v string) *UpdateThemeInput {
	s.Id = &v
	return s
}

// SetUpdatedTheme sets the UpdatedTheme field's value.
func (s *UpdateThemeInput) SetUpdatedTheme(v *UpdateThemeData) *UpdateThemeInput {
	s.UpdatedTheme = v
	return s
}

type UpdateThemeOutput struct {
	_ struct{} `type:"structure" payload:"Entity"`

	// Describes the configuration of the updated theme.
	Entity *Theme `locationName:"entity" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThemeOutput) GoString() string {
	return s.String()
}

// SetEntity sets the Entity field's value.
func (s *UpdateThemeOutput) SetEntity(v *Theme) *UpdateThemeOutput {
	s.Entity = v
	return s
}

const (
	// SortDirectionAsc is a SortDirection enum value
	SortDirectionAsc = "ASC"

	// SortDirectionDesc is a SortDirection enum value
	SortDirectionDesc = "DESC"
)

// SortDirection_Values returns all elements of the SortDirection enum
func SortDirection_Values() []string {
	return []string{
		SortDirectionAsc,
		SortDirectionDesc,
	}
}

const (
	// TokenProvidersFigma is a TokenProviders enum value
	TokenProvidersFigma = "figma"
)

// TokenProviders_Values returns all elements of the TokenProviders enum
func TokenProviders_Values() []string {
	return []string{
		TokenProvidersFigma,
	}
}
