// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opDeleteAlarms = "DeleteAlarms"

// DeleteAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlarms for more information on using the DeleteAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAlarmsRequest method.
//	req, resp := client.DeleteAlarmsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarmsRequest(input *DeleteAlarmsInput) (req *request.Request, output *DeleteAlarmsOutput) {
	op := &request.Operation{
		Name:       opDeleteAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmsInput{}
	}

	output = &DeleteAlarmsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlarms API operation for Amazon CloudWatch.
//
// Deletes the specified alarms. You can delete up to 100 alarms in one operation.
// However, this total can include no more than one composite alarm. For example,
// you could delete 99 metric alarms and one composite alarms with one operation,
// but you can't delete two composite alarms with one operation.
//
// In the event of an error, no alarms are deleted.
//
// It is possible to create a loop or cycle of composite alarms, where composite
// alarm A depends on composite alarm B, and composite alarm B also depends
// on composite alarm A. In this scenario, you can't delete any composite alarm
// that is part of the cycle because there is always still a composite alarm
// that depends on that alarm that you want to delete.
//
// To get out of such a situation, you must break the cycle by changing the
// rule of one of the composite alarms in the cycle to remove a dependency that
// creates the cycle. The simplest change to make to break a cycle is to change
// the AlarmRule of one of the alarms to false.
//
// Additionally, the evaluation of composite alarms stops if CloudWatch detects
// a cycle in the evaluation path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteAlarms for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeResourceNotFound "ResourceNotFound"
//     The named resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *CloudWatch) DeleteAlarms(input *DeleteAlarmsInput) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	return out, req.Send()
}

// DeleteAlarmsWithContext is the same as DeleteAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteAlarmsWithContext(ctx aws.Context, input *DeleteAlarmsInput, opts ...request.Option) (*DeleteAlarmsOutput, error) {
	req, out := c.DeleteAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnomalyDetector = "DeleteAnomalyDetector"

// DeleteAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnomalyDetector for more information on using the DeleteAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAnomalyDetectorRequest method.
//	req, resp := client.DeleteAnomalyDetectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAnomalyDetector
func (c *CloudWatch) DeleteAnomalyDetectorRequest(input *DeleteAnomalyDetectorInput) (req *request.Request, output *DeleteAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnomalyDetectorInput{}
	}

	output = &DeleteAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAnomalyDetector API operation for Amazon CloudWatch.
//
// Deletes the specified anomaly detection model from your account. For more
// information about how to delete an anomaly detection model, see Deleting
// an anomaly detection model (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Anomaly_Detection_Alarm.html#Delete_Anomaly_Detection_Model)
// in the CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteAnomalyDetector for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAnomalyDetector
func (c *CloudWatch) DeleteAnomalyDetector(input *DeleteAnomalyDetectorInput) (*DeleteAnomalyDetectorOutput, error) {
	req, out := c.DeleteAnomalyDetectorRequest(input)
	return out, req.Send()
}

// DeleteAnomalyDetectorWithContext is the same as DeleteAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteAnomalyDetectorWithContext(ctx aws.Context, input *DeleteAnomalyDetectorInput, opts ...request.Option) (*DeleteAnomalyDetectorOutput, error) {
	req, out := c.DeleteAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboards = "DeleteDashboards"

// DeleteDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboards for more information on using the DeleteDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDashboardsRequest method.
//	req, resp := client.DeleteDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteDashboards
func (c *CloudWatch) DeleteDashboardsRequest(input *DeleteDashboardsInput) (req *request.Request, output *DeleteDashboardsOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDashboardsInput{}
	}

	output = &DeleteDashboardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDashboards API operation for Amazon CloudWatch.
//
// Deletes all dashboards that you specify. You can specify up to 100 dashboards
// to delete. If there is an error during this call, no dashboards are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteDashboards for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeDashboardNotFoundError "ResourceNotFound"
//     The specified dashboard does not exist.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteDashboards
func (c *CloudWatch) DeleteDashboards(input *DeleteDashboardsInput) (*DeleteDashboardsOutput, error) {
	req, out := c.DeleteDashboardsRequest(input)
	return out, req.Send()
}

// DeleteDashboardsWithContext is the same as DeleteDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteDashboardsWithContext(ctx aws.Context, input *DeleteDashboardsInput, opts ...request.Option) (*DeleteDashboardsOutput, error) {
	req, out := c.DeleteDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsightRules = "DeleteInsightRules"

// DeleteInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsightRules for more information on using the DeleteInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInsightRulesRequest method.
//	req, resp := client.DeleteInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteInsightRules
func (c *CloudWatch) DeleteInsightRulesRequest(input *DeleteInsightRulesInput) (req *request.Request, output *DeleteInsightRulesOutput) {
	op := &request.Operation{
		Name:       opDeleteInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInsightRulesInput{}
	}

	output = &DeleteInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsightRules API operation for Amazon CloudWatch.
//
// Permanently deletes the specified Contributor Insights rules.
//
// If you create a rule, delete it, and then re-create it with the same name,
// historical data from the first time the rule was created might not be available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteInsightRules for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteInsightRules
func (c *CloudWatch) DeleteInsightRules(input *DeleteInsightRulesInput) (*DeleteInsightRulesOutput, error) {
	req, out := c.DeleteInsightRulesRequest(input)
	return out, req.Send()
}

// DeleteInsightRulesWithContext is the same as DeleteInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteInsightRulesWithContext(ctx aws.Context, input *DeleteInsightRulesInput, opts ...request.Option) (*DeleteInsightRulesOutput, error) {
	req, out := c.DeleteInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMetricStream = "DeleteMetricStream"

// DeleteMetricStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMetricStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMetricStream for more information on using the DeleteMetricStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMetricStreamRequest method.
//	req, resp := client.DeleteMetricStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteMetricStream
func (c *CloudWatch) DeleteMetricStreamRequest(input *DeleteMetricStreamInput) (req *request.Request, output *DeleteMetricStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteMetricStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMetricStreamInput{}
	}

	output = &DeleteMetricStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMetricStream API operation for Amazon CloudWatch.
//
// Permanently deletes the metric stream that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DeleteMetricStream for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteMetricStream
func (c *CloudWatch) DeleteMetricStream(input *DeleteMetricStreamInput) (*DeleteMetricStreamOutput, error) {
	req, out := c.DeleteMetricStreamRequest(input)
	return out, req.Send()
}

// DeleteMetricStreamWithContext is the same as DeleteMetricStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMetricStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DeleteMetricStreamWithContext(ctx aws.Context, input *DeleteMetricStreamInput, opts ...request.Option) (*DeleteMetricStreamOutput, error) {
	req, out := c.DeleteMetricStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlarmHistory = "DescribeAlarmHistory"

// DescribeAlarmHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarmHistory for more information on using the DescribeAlarmHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAlarmHistoryRequest method.
//	req, resp := client.DescribeAlarmHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistoryRequest(input *DescribeAlarmHistoryInput) (req *request.Request, output *DescribeAlarmHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmHistoryInput{}
	}

	output = &DescribeAlarmHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmHistory API operation for Amazon CloudWatch.
//
// Retrieves the history for the specified alarm. You can filter the results
// by date range or item type. If an alarm name is not specified, the histories
// for either all metric alarms or all composite alarms are returned.
//
// CloudWatch retains the history of an alarm even if you delete the alarm.
//
// To use this operation and return information about a composite alarm, you
// must be signed on with the cloudwatch:DescribeAlarmHistory permission that
// is scoped to *. You can't return information about composite alarms if your
// cloudwatch:DescribeAlarmHistory permission has a narrower scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmHistory for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmHistory
func (c *CloudWatch) DescribeAlarmHistory(input *DescribeAlarmHistoryInput) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	return out, req.Send()
}

// DescribeAlarmHistoryWithContext is the same as DescribeAlarmHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, opts ...request.Option) (*DescribeAlarmHistoryOutput, error) {
	req, out := c.DescribeAlarmHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmHistoryPages iterates over the pages of a DescribeAlarmHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarmHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAlarmHistory operation.
//	pageNum := 0
//	err := client.DescribeAlarmHistoryPages(params,
//	    func(page *cloudwatch.DescribeAlarmHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) DescribeAlarmHistoryPages(input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool) error {
	return c.DescribeAlarmHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmHistoryPagesWithContext same as DescribeAlarmHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmHistoryPagesWithContext(ctx aws.Context, input *DescribeAlarmHistoryInput, fn func(*DescribeAlarmHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAlarmHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAlarms = "DescribeAlarms"

// DescribeAlarmsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarms for more information on using the DescribeAlarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAlarmsRequest method.
//	req, resp := client.DescribeAlarmsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarmsRequest(input *DescribeAlarmsInput) (req *request.Request, output *DescribeAlarmsOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAlarmsInput{}
	}

	output = &DescribeAlarmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarms API operation for Amazon CloudWatch.
//
// Retrieves the specified alarms. You can filter the results by specifying
// a prefix for the alarm name, the alarm state, or a prefix for any action.
//
// To use this operation and return information about composite alarms, you
// must be signed on with the cloudwatch:DescribeAlarms permission that is scoped
// to *. You can't return information about composite alarms if your cloudwatch:DescribeAlarms
// permission has a narrower scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarms for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarms
func (c *CloudWatch) DescribeAlarms(input *DescribeAlarmsInput) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	return out, req.Send()
}

// DescribeAlarmsWithContext is the same as DescribeAlarms with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsWithContext(ctx aws.Context, input *DescribeAlarmsInput, opts ...request.Option) (*DescribeAlarmsOutput, error) {
	req, out := c.DescribeAlarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAlarmsPages iterates over the pages of a DescribeAlarms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAlarms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAlarms operation.
//	pageNum := 0
//	err := client.DescribeAlarmsPages(params,
//	    func(page *cloudwatch.DescribeAlarmsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) DescribeAlarmsPages(input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool) error {
	return c.DescribeAlarmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAlarmsPagesWithContext same as DescribeAlarmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsPagesWithContext(ctx aws.Context, input *DescribeAlarmsInput, fn func(*DescribeAlarmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAlarmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAlarmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAlarmsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAlarmsForMetric = "DescribeAlarmsForMetric"

// DescribeAlarmsForMetricRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlarmsForMetric operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlarmsForMetric for more information on using the DescribeAlarmsForMetric
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAlarmsForMetricRequest method.
//	req, resp := client.DescribeAlarmsForMetricRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetricRequest(input *DescribeAlarmsForMetricInput) (req *request.Request, output *DescribeAlarmsForMetricOutput) {
	op := &request.Operation{
		Name:       opDescribeAlarmsForMetric,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlarmsForMetricInput{}
	}

	output = &DescribeAlarmsForMetricOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlarmsForMetric API operation for Amazon CloudWatch.
//
// Retrieves the alarms for the specified metric. To filter the results, specify
// a statistic, period, or unit.
//
// This operation retrieves only standard alarms that are based on the specified
// metric. It does not return alarms based on math expressions that use the
// specified metric, or composite alarms that use the specified metric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAlarmsForMetric for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAlarmsForMetric
func (c *CloudWatch) DescribeAlarmsForMetric(input *DescribeAlarmsForMetricInput) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	return out, req.Send()
}

// DescribeAlarmsForMetricWithContext is the same as DescribeAlarmsForMetric with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlarmsForMetric for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAlarmsForMetricWithContext(ctx aws.Context, input *DescribeAlarmsForMetricInput, opts ...request.Option) (*DescribeAlarmsForMetricOutput, error) {
	req, out := c.DescribeAlarmsForMetricRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnomalyDetectors = "DescribeAnomalyDetectors"

// DescribeAnomalyDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomalyDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomalyDetectors for more information on using the DescribeAnomalyDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAnomalyDetectorsRequest method.
//	req, resp := client.DescribeAnomalyDetectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAnomalyDetectors
func (c *CloudWatch) DescribeAnomalyDetectorsRequest(input *DescribeAnomalyDetectorsInput) (req *request.Request, output *DescribeAnomalyDetectorsOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomalyDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAnomalyDetectorsInput{}
	}

	output = &DescribeAnomalyDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomalyDetectors API operation for Amazon CloudWatch.
//
// Lists the anomaly detection models that you have created in your account.
// For single metric anomaly detectors, you can list all of the models in your
// account or filter the results to only the models that are related to a certain
// namespace, metric name, or metric dimension. For metric math anomaly detectors,
// you can list them by adding METRIC_MATH to the AnomalyDetectorTypes array.
// This will return all metric math anomaly detectors in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeAnomalyDetectors for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeAnomalyDetectors
func (c *CloudWatch) DescribeAnomalyDetectors(input *DescribeAnomalyDetectorsInput) (*DescribeAnomalyDetectorsOutput, error) {
	req, out := c.DescribeAnomalyDetectorsRequest(input)
	return out, req.Send()
}

// DescribeAnomalyDetectorsWithContext is the same as DescribeAnomalyDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomalyDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAnomalyDetectorsWithContext(ctx aws.Context, input *DescribeAnomalyDetectorsInput, opts ...request.Option) (*DescribeAnomalyDetectorsOutput, error) {
	req, out := c.DescribeAnomalyDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAnomalyDetectorsPages iterates over the pages of a DescribeAnomalyDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAnomalyDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAnomalyDetectors operation.
//	pageNum := 0
//	err := client.DescribeAnomalyDetectorsPages(params,
//	    func(page *cloudwatch.DescribeAnomalyDetectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) DescribeAnomalyDetectorsPages(input *DescribeAnomalyDetectorsInput, fn func(*DescribeAnomalyDetectorsOutput, bool) bool) error {
	return c.DescribeAnomalyDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAnomalyDetectorsPagesWithContext same as DescribeAnomalyDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeAnomalyDetectorsPagesWithContext(ctx aws.Context, input *DescribeAnomalyDetectorsInput, fn func(*DescribeAnomalyDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAnomalyDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAnomalyDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAnomalyDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInsightRules = "DescribeInsightRules"

// DescribeInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInsightRules for more information on using the DescribeInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInsightRulesRequest method.
//	req, resp := client.DescribeInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeInsightRules
func (c *CloudWatch) DescribeInsightRulesRequest(input *DescribeInsightRulesInput) (req *request.Request, output *DescribeInsightRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInsightRulesInput{}
	}

	output = &DescribeInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInsightRules API operation for Amazon CloudWatch.
//
// Returns a list of all the Contributor Insights rules in your account.
//
// For more information about Contributor Insights, see Using Contributor Insights
// to Analyze High-Cardinality Data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DescribeInsightRules for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DescribeInsightRules
func (c *CloudWatch) DescribeInsightRules(input *DescribeInsightRulesInput) (*DescribeInsightRulesOutput, error) {
	req, out := c.DescribeInsightRulesRequest(input)
	return out, req.Send()
}

// DescribeInsightRulesWithContext is the same as DescribeInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeInsightRulesWithContext(ctx aws.Context, input *DescribeInsightRulesInput, opts ...request.Option) (*DescribeInsightRulesOutput, error) {
	req, out := c.DescribeInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInsightRulesPages iterates over the pages of a DescribeInsightRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInsightRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInsightRules operation.
//	pageNum := 0
//	err := client.DescribeInsightRulesPages(params,
//	    func(page *cloudwatch.DescribeInsightRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) DescribeInsightRulesPages(input *DescribeInsightRulesInput, fn func(*DescribeInsightRulesOutput, bool) bool) error {
	return c.DescribeInsightRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInsightRulesPagesWithContext same as DescribeInsightRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DescribeInsightRulesPagesWithContext(ctx aws.Context, input *DescribeInsightRulesInput, fn func(*DescribeInsightRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInsightRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInsightRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInsightRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisableAlarmActions = "DisableAlarmActions"

// DisableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the DisableAlarmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableAlarmActions for more information on using the DisableAlarmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableAlarmActionsRequest method.
//	req, resp := client.DisableAlarmActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActionsRequest(input *DisableAlarmActionsInput) (req *request.Request, output *DisableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opDisableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAlarmActionsInput{}
	}

	output = &DisableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableAlarmActions API operation for Amazon CloudWatch.
//
// Disables the actions for the specified alarms. When an alarm's actions are
// disabled, the alarm actions do not execute when the alarm state changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DisableAlarmActions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableAlarmActions
func (c *CloudWatch) DisableAlarmActions(input *DisableAlarmActionsInput) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	return out, req.Send()
}

// DisableAlarmActionsWithContext is the same as DisableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See DisableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DisableAlarmActionsWithContext(ctx aws.Context, input *DisableAlarmActionsInput, opts ...request.Option) (*DisableAlarmActionsOutput, error) {
	req, out := c.DisableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableInsightRules = "DisableInsightRules"

// DisableInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the DisableInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableInsightRules for more information on using the DisableInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableInsightRulesRequest method.
//	req, resp := client.DisableInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableInsightRules
func (c *CloudWatch) DisableInsightRulesRequest(input *DisableInsightRulesInput) (req *request.Request, output *DisableInsightRulesOutput) {
	op := &request.Operation{
		Name:       opDisableInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableInsightRulesInput{}
	}

	output = &DisableInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableInsightRules API operation for Amazon CloudWatch.
//
// Disables the specified Contributor Insights rules. When rules are disabled,
// they do not analyze log groups and do not incur costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation DisableInsightRules for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DisableInsightRules
func (c *CloudWatch) DisableInsightRules(input *DisableInsightRulesInput) (*DisableInsightRulesOutput, error) {
	req, out := c.DisableInsightRulesRequest(input)
	return out, req.Send()
}

// DisableInsightRulesWithContext is the same as DisableInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See DisableInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) DisableInsightRulesWithContext(ctx aws.Context, input *DisableInsightRulesInput, opts ...request.Option) (*DisableInsightRulesOutput, error) {
	req, out := c.DisableInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAlarmActions = "EnableAlarmActions"

// EnableAlarmActionsRequest generates a "aws/request.Request" representing the
// client's request for the EnableAlarmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableAlarmActions for more information on using the EnableAlarmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableAlarmActionsRequest method.
//	req, resp := client.EnableAlarmActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActionsRequest(input *EnableAlarmActionsInput) (req *request.Request, output *EnableAlarmActionsOutput) {
	op := &request.Operation{
		Name:       opEnableAlarmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAlarmActionsInput{}
	}

	output = &EnableAlarmActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableAlarmActions API operation for Amazon CloudWatch.
//
// Enables the actions for the specified alarms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation EnableAlarmActions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableAlarmActions
func (c *CloudWatch) EnableAlarmActions(input *EnableAlarmActionsInput) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	return out, req.Send()
}

// EnableAlarmActionsWithContext is the same as EnableAlarmActions with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAlarmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) EnableAlarmActionsWithContext(ctx aws.Context, input *EnableAlarmActionsInput, opts ...request.Option) (*EnableAlarmActionsOutput, error) {
	req, out := c.EnableAlarmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableInsightRules = "EnableInsightRules"

// EnableInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the EnableInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableInsightRules for more information on using the EnableInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableInsightRulesRequest method.
//	req, resp := client.EnableInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableInsightRules
func (c *CloudWatch) EnableInsightRulesRequest(input *EnableInsightRulesInput) (req *request.Request, output *EnableInsightRulesOutput) {
	op := &request.Operation{
		Name:       opEnableInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableInsightRulesInput{}
	}

	output = &EnableInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableInsightRules API operation for Amazon CloudWatch.
//
// Enables the specified Contributor Insights rules. When rules are enabled,
// they immediately begin analyzing log data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation EnableInsightRules for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The operation exceeded one or more limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableInsightRules
func (c *CloudWatch) EnableInsightRules(input *EnableInsightRulesInput) (*EnableInsightRulesOutput, error) {
	req, out := c.EnableInsightRulesRequest(input)
	return out, req.Send()
}

// EnableInsightRulesWithContext is the same as EnableInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See EnableInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) EnableInsightRulesWithContext(ctx aws.Context, input *EnableInsightRulesInput, opts ...request.Option) (*EnableInsightRulesOutput, error) {
	req, out := c.EnableInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboard = "GetDashboard"

// GetDashboardRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboard for more information on using the GetDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDashboardRequest method.
//	req, resp := client.GetDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetDashboard
func (c *CloudWatch) GetDashboardRequest(input *GetDashboardInput) (req *request.Request, output *GetDashboardOutput) {
	op := &request.Operation{
		Name:       opGetDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDashboardInput{}
	}

	output = &GetDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboard API operation for Amazon CloudWatch.
//
// Displays the details of the dashboard that you specify.
//
// To copy an existing dashboard, use GetDashboard, and then use the data returned
// within DashboardBody as the template for the new dashboard when you call
// PutDashboard to create the copy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetDashboard for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeDashboardNotFoundError "ResourceNotFound"
//     The specified dashboard does not exist.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetDashboard
func (c *CloudWatch) GetDashboard(input *GetDashboardInput) (*GetDashboardOutput, error) {
	req, out := c.GetDashboardRequest(input)
	return out, req.Send()
}

// GetDashboardWithContext is the same as GetDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetDashboardWithContext(ctx aws.Context, input *GetDashboardInput, opts ...request.Option) (*GetDashboardOutput, error) {
	req, out := c.GetDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsightRuleReport = "GetInsightRuleReport"

// GetInsightRuleReportRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightRuleReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightRuleReport for more information on using the GetInsightRuleReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInsightRuleReportRequest method.
//	req, resp := client.GetInsightRuleReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetInsightRuleReport
func (c *CloudWatch) GetInsightRuleReportRequest(input *GetInsightRuleReportInput) (req *request.Request, output *GetInsightRuleReportOutput) {
	op := &request.Operation{
		Name:       opGetInsightRuleReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInsightRuleReportInput{}
	}

	output = &GetInsightRuleReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightRuleReport API operation for Amazon CloudWatch.
//
// This operation returns the time series data collected by a Contributor Insights
// rule. The data includes the identity and number of contributors to the log
// group.
//
// You can also optionally return one or more statistics about each data point
// in the time series. These statistics can include the following:
//
//   - UniqueContributors -- the number of unique contributors for each data
//     point.
//
//   - MaxContributorValue -- the value of the top contributor for each data
//     point. The identity of the contributor might change for each data point
//     in the graph. If this rule aggregates by COUNT, the top contributor for
//     each data point is the contributor with the most occurrences in that period.
//     If the rule aggregates by SUM, the top contributor is the contributor
//     with the highest sum in the log field specified by the rule's Value, during
//     that period.
//
//   - SampleCount -- the number of data points matched by the rule.
//
//   - Sum -- the sum of the values from all contributors during the time period
//     represented by that data point.
//
//   - Minimum -- the minimum value from a single observation during the time
//     period represented by that data point.
//
//   - Maximum -- the maximum value from a single observation during the time
//     period represented by that data point.
//
//   - Average -- the average value from all contributors during the time period
//     represented by that data point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetInsightRuleReport for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetInsightRuleReport
func (c *CloudWatch) GetInsightRuleReport(input *GetInsightRuleReportInput) (*GetInsightRuleReportOutput, error) {
	req, out := c.GetInsightRuleReportRequest(input)
	return out, req.Send()
}

// GetInsightRuleReportWithContext is the same as GetInsightRuleReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightRuleReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetInsightRuleReportWithContext(ctx aws.Context, input *GetInsightRuleReportInput, opts ...request.Option) (*GetInsightRuleReportOutput, error) {
	req, out := c.GetInsightRuleReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricData for more information on using the GetMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricDataRequest method.
//	req, resp := client.GetMetricDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricData
func (c *CloudWatch) GetMetricDataRequest(input *GetMetricDataInput) (req *request.Request, output *GetMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxDatapoints",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	output = &GetMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricData API operation for Amazon CloudWatch.
//
// You can use the GetMetricData API to retrieve CloudWatch metric values. The
// operation can also include a CloudWatch Metrics Insights query, and one or
// more metric math functions.
//
// A GetMetricData operation that does not include a query can retrieve as many
// as 500 different metrics in a single request, with a total of as many as
// 100,800 data points. You can also optionally perform metric math expressions
// on the values of the returned statistics, to create new time series that
// represent new insights into your data. For example, using Lambda metrics,
// you could divide the Errors metric by the Invocations metric to get an error
// rate time series. For more information about metric math expressions, see
// Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// If you include a Metrics Insights query, each GetMetricData operation can
// include only one query. But the same GetMetricData operation can also retrieve
// other metrics. Metrics Insights queries can query only the most recent three
// hours of metric data. For more information about Metrics Insights, see Query
// your metrics with CloudWatch Metrics Insights (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/query_with_cloudwatch-metrics-insights.html).
//
// Calls to the GetMetricData API have a different pricing structure than calls
// to GetMetricStatistics. For more information about pricing, see Amazon CloudWatch
// Pricing (https://aws.amazon.com/cloudwatch/pricing/).
//
// Amazon CloudWatch retains metric data as follows:
//
//   - Data points with a period of less than 60 seconds are available for
//     3 hours. These data points are high-resolution metrics and are available
//     only for custom metrics that have been defined with a StorageResolution
//     of 1.
//
//   - Data points with a period of 60 seconds (1-minute) are available for
//     15 days.
//
//   - Data points with a period of 300 seconds (5-minute) are available for
//     63 days.
//
//   - Data points with a period of 3600 seconds (1 hour) are available for
//     455 days (15 months).
//
// Data points that are initially published with a shorter period are aggregated
// together for long-term storage. For example, if you collect data using a
// period of 1 minute, the data remains available for 15 days with 1-minute
// resolution. After 15 days, this data is still available, but is aggregated
// and retrievable only with a resolution of 5 minutes. After 63 days, the data
// is further aggregated and is available with a resolution of 1 hour.
//
// If you omit Unit in your request, all data that was collected with any unit
// is returned, along with the corresponding units that were specified when
// the data was reported to CloudWatch. If you specify a unit, the operation
// returns only data that was collected with that unit specified. If you specify
// a unit that does not match the data collected, the results of the operation
// are null. CloudWatch does not perform unit conversions.
//
// # Using Metrics Insights queries with metric math
//
// You can't mix a Metric Insights query and metric math syntax in the same
// expression, but you can reference results from a Metrics Insights query within
// other Metric math expressions. A Metrics Insights query without a GROUP BY
// clause returns a single time-series (TS), and can be used as input for a
// metric math expression that expects a single time series. A Metrics Insights
// query with a GROUP BY clause returns an array of time-series (TS[]), and
// can be used as input for a metric math expression that expects an array of
// time series.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricData for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricData
func (c *CloudWatch) GetMetricData(input *GetMetricDataInput) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	return out, req.Send()
}

// GetMetricDataWithContext is the same as GetMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricDataWithContext(ctx aws.Context, input *GetMetricDataInput, opts ...request.Option) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMetricDataPages iterates over the pages of a GetMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetMetricData operation.
//	pageNum := 0
//	err := client.GetMetricDataPages(params,
//	    func(page *cloudwatch.GetMetricDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) GetMetricDataPages(input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool) error {
	return c.GetMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMetricDataPagesWithContext same as GetMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricDataPagesWithContext(ctx aws.Context, input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMetricDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMetricStatistics = "GetMetricStatistics"

// GetMetricStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricStatistics for more information on using the GetMetricStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricStatisticsRequest method.
//	req, resp := client.GetMetricStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatisticsRequest(input *GetMetricStatisticsInput) (req *request.Request, output *GetMetricStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetMetricStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricStatisticsInput{}
	}

	output = &GetMetricStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricStatistics API operation for Amazon CloudWatch.
//
// Gets statistics for the specified metric.
//
// The maximum number of data points returned from a single call is 1,440. If
// you request more than 1,440 data points, CloudWatch returns an error. To
// reduce the number of data points, you can narrow the specified time range
// and make multiple requests across adjacent time ranges, or you can increase
// the specified period. Data points are not returned in chronological order.
//
// CloudWatch aggregates data points based on the length of the period that
// you specify. For example, if you request statistics with a one-hour period,
// CloudWatch aggregates all data points with time stamps that fall within each
// one-hour period. Therefore, the number of values aggregated by CloudWatch
// is larger than the number of data points returned.
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you can only retrieve percentile
// statistics for this data if one of the following conditions is true:
//
//   - The SampleCount value of the statistic set is 1.
//
//   - The Min and the Max values of the statistic set are equal.
//
// Percentile statistics are not available for metrics when any of the metric
// values are negative numbers.
//
// Amazon CloudWatch retains metric data as follows:
//
//   - Data points with a period of less than 60 seconds are available for
//     3 hours. These data points are high-resolution metrics and are available
//     only for custom metrics that have been defined with a StorageResolution
//     of 1.
//
//   - Data points with a period of 60 seconds (1-minute) are available for
//     15 days.
//
//   - Data points with a period of 300 seconds (5-minute) are available for
//     63 days.
//
//   - Data points with a period of 3600 seconds (1 hour) are available for
//     455 days (15 months).
//
// Data points that are initially published with a shorter period are aggregated
// together for long-term storage. For example, if you collect data using a
// period of 1 minute, the data remains available for 15 days with 1-minute
// resolution. After 15 days, this data is still available, but is aggregated
// and retrievable only with a resolution of 5 minutes. After 63 days, the data
// is further aggregated and is available with a resolution of 1 hour.
//
// CloudWatch started retaining 5-minute and 1-hour metric data as of July 9,
// 2016.
//
// For information about metrics and dimensions supported by Amazon Web Services
// services, see the Amazon CloudWatch Metrics and Dimensions Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html)
// in the Amazon CloudWatch User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricStatistics for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStatistics
func (c *CloudWatch) GetMetricStatistics(input *GetMetricStatisticsInput) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	return out, req.Send()
}

// GetMetricStatisticsWithContext is the same as GetMetricStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricStatisticsWithContext(ctx aws.Context, input *GetMetricStatisticsInput, opts ...request.Option) (*GetMetricStatisticsOutput, error) {
	req, out := c.GetMetricStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricStream = "GetMetricStream"

// GetMetricStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricStream for more information on using the GetMetricStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricStreamRequest method.
//	req, resp := client.GetMetricStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStream
func (c *CloudWatch) GetMetricStreamRequest(input *GetMetricStreamInput) (req *request.Request, output *GetMetricStreamOutput) {
	op := &request.Operation{
		Name:       opGetMetricStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricStreamInput{}
	}

	output = &GetMetricStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricStream API operation for Amazon CloudWatch.
//
// Returns information about the metric stream that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricStream for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricStream
func (c *CloudWatch) GetMetricStream(input *GetMetricStreamInput) (*GetMetricStreamOutput, error) {
	req, out := c.GetMetricStreamRequest(input)
	return out, req.Send()
}

// GetMetricStreamWithContext is the same as GetMetricStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricStreamWithContext(ctx aws.Context, input *GetMetricStreamInput, opts ...request.Option) (*GetMetricStreamOutput, error) {
	req, out := c.GetMetricStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricWidgetImage = "GetMetricWidgetImage"

// GetMetricWidgetImageRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricWidgetImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricWidgetImage for more information on using the GetMetricWidgetImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricWidgetImageRequest method.
//	req, resp := client.GetMetricWidgetImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricWidgetImage
func (c *CloudWatch) GetMetricWidgetImageRequest(input *GetMetricWidgetImageInput) (req *request.Request, output *GetMetricWidgetImageOutput) {
	op := &request.Operation{
		Name:       opGetMetricWidgetImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMetricWidgetImageInput{}
	}

	output = &GetMetricWidgetImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricWidgetImage API operation for Amazon CloudWatch.
//
// You can use the GetMetricWidgetImage API to retrieve a snapshot graph of
// one or more Amazon CloudWatch metrics as a bitmap image. You can then embed
// this image into your services and products, such as wiki pages, reports,
// and documents. You could also retrieve images regularly, such as every minute,
// and create your own custom live dashboard.
//
// The graph you retrieve can include all CloudWatch metric graph features,
// including metric math and horizontal and vertical annotations.
//
// There is a limit of 20 transactions per second for this API. Each GetMetricWidgetImage
// action has the following limits:
//
//   - As many as 100 metrics in the graph.
//
//   - Up to 100 KB uncompressed payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation GetMetricWidgetImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/GetMetricWidgetImage
func (c *CloudWatch) GetMetricWidgetImage(input *GetMetricWidgetImageInput) (*GetMetricWidgetImageOutput, error) {
	req, out := c.GetMetricWidgetImageRequest(input)
	return out, req.Send()
}

// GetMetricWidgetImageWithContext is the same as GetMetricWidgetImage with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricWidgetImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) GetMetricWidgetImageWithContext(ctx aws.Context, input *GetMetricWidgetImageInput, opts ...request.Option) (*GetMetricWidgetImageOutput, error) {
	req, out := c.GetMetricWidgetImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDashboardsRequest method.
//	req, resp := client.ListDashboardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListDashboards
func (c *CloudWatch) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon CloudWatch.
//
// Returns a list of the dashboards for your account. If you include DashboardNamePrefix,
// only those dashboards with names starting with the prefix are listed. Otherwise,
// all dashboards in your account are listed.
//
// ListDashboards returns up to 1000 results on one page. If there are more
// than 1000 dashboards, you can call ListDashboards again and include the value
// you received for NextToken in the first call, to receive the next 1000 results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListDashboards for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListDashboards
func (c *CloudWatch) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDashboards operation.
//	pageNum := 0
//	err := client.ListDashboardsPages(params,
//	    func(page *cloudwatch.ListDashboardsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListManagedInsightRules = "ListManagedInsightRules"

// ListManagedInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedInsightRules for more information on using the ListManagedInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListManagedInsightRulesRequest method.
//	req, resp := client.ListManagedInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListManagedInsightRules
func (c *CloudWatch) ListManagedInsightRulesRequest(input *ListManagedInsightRulesInput) (req *request.Request, output *ListManagedInsightRulesOutput) {
	op := &request.Operation{
		Name:       opListManagedInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedInsightRulesInput{}
	}

	output = &ListManagedInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedInsightRules API operation for Amazon CloudWatch.
//
// Returns a list that contains the number of managed Contributor Insights rules
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListManagedInsightRules for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListManagedInsightRules
func (c *CloudWatch) ListManagedInsightRules(input *ListManagedInsightRulesInput) (*ListManagedInsightRulesOutput, error) {
	req, out := c.ListManagedInsightRulesRequest(input)
	return out, req.Send()
}

// ListManagedInsightRulesWithContext is the same as ListManagedInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListManagedInsightRulesWithContext(ctx aws.Context, input *ListManagedInsightRulesInput, opts ...request.Option) (*ListManagedInsightRulesOutput, error) {
	req, out := c.ListManagedInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedInsightRulesPages iterates over the pages of a ListManagedInsightRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedInsightRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListManagedInsightRules operation.
//	pageNum := 0
//	err := client.ListManagedInsightRulesPages(params,
//	    func(page *cloudwatch.ListManagedInsightRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) ListManagedInsightRulesPages(input *ListManagedInsightRulesInput, fn func(*ListManagedInsightRulesOutput, bool) bool) error {
	return c.ListManagedInsightRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedInsightRulesPagesWithContext same as ListManagedInsightRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListManagedInsightRulesPagesWithContext(ctx aws.Context, input *ListManagedInsightRulesInput, fn func(*ListManagedInsightRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedInsightRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedInsightRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedInsightRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetricStreams = "ListMetricStreams"

// ListMetricStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetricStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetricStreams for more information on using the ListMetricStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMetricStreamsRequest method.
//	req, resp := client.ListMetricStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetricStreams
func (c *CloudWatch) ListMetricStreamsRequest(input *ListMetricStreamsInput) (req *request.Request, output *ListMetricStreamsOutput) {
	op := &request.Operation{
		Name:       opListMetricStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricStreamsInput{}
	}

	output = &ListMetricStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetricStreams API operation for Amazon CloudWatch.
//
// Returns a list of metric streams in this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListMetricStreams for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidNextToken "InvalidNextToken"
//     The next token specified is invalid.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetricStreams
func (c *CloudWatch) ListMetricStreams(input *ListMetricStreamsInput) (*ListMetricStreamsOutput, error) {
	req, out := c.ListMetricStreamsRequest(input)
	return out, req.Send()
}

// ListMetricStreamsWithContext is the same as ListMetricStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetricStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricStreamsWithContext(ctx aws.Context, input *ListMetricStreamsInput, opts ...request.Option) (*ListMetricStreamsOutput, error) {
	req, out := c.ListMetricStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricStreamsPages iterates over the pages of a ListMetricStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetricStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMetricStreams operation.
//	pageNum := 0
//	err := client.ListMetricStreamsPages(params,
//	    func(page *cloudwatch.ListMetricStreamsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) ListMetricStreamsPages(input *ListMetricStreamsInput, fn func(*ListMetricStreamsOutput, bool) bool) error {
	return c.ListMetricStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricStreamsPagesWithContext same as ListMetricStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricStreamsPagesWithContext(ctx aws.Context, input *ListMetricStreamsInput, fn func(*ListMetricStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricStreamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricStreamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetricStreamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetrics = "ListMetrics"

// ListMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetrics for more information on using the ListMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMetricsRequest method.
//	req, resp := client.ListMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetricsRequest(input *ListMetricsInput) (req *request.Request, output *ListMetricsOutput) {
	op := &request.Operation{
		Name:       opListMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetricsInput{}
	}

	output = &ListMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetrics API operation for Amazon CloudWatch.
//
// List the specified metrics. You can use the returned metrics with GetMetricData
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html)
// or GetMetricStatistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html)
// to get statistical data.
//
// Up to 500 results are returned for any one call. To retrieve additional results,
// use the returned token with subsequent calls.
//
// After you create a metric, allow up to 15 minutes for the metric to appear.
// To see metric statistics sooner, use GetMetricData (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html)
// or GetMetricStatistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
//
// If you are using CloudWatch cross-account observability, you can use this
// operation in a monitoring account and view metrics from the linked source
// accounts. For more information, see CloudWatch cross-account observability
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html).
//
// ListMetrics doesn't return information about metrics if those metrics haven't
// reported data in the past two weeks. To retrieve those metrics, use GetMetricData
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html)
// or GetMetricStatistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListMetrics for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListMetrics
func (c *CloudWatch) ListMetrics(input *ListMetricsInput) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	return out, req.Send()
}

// ListMetricsWithContext is the same as ListMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsWithContext(ctx aws.Context, input *ListMetricsInput, opts ...request.Option) (*ListMetricsOutput, error) {
	req, out := c.ListMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetricsPages iterates over the pages of a ListMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMetrics operation.
//	pageNum := 0
//	err := client.ListMetricsPages(params,
//	    func(page *cloudwatch.ListMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CloudWatch) ListMetricsPages(input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool) error {
	return c.ListMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetricsPagesWithContext same as ListMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListMetricsPagesWithContext(ctx aws.Context, input *ListMetricsInput, fn func(*ListMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListTagsForResource
func (c *CloudWatch) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch.
//
// Displays the tags associated with a CloudWatch resource. Currently, alarms
// and Contributor Insights rules support tagging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/ListTagsForResource
func (c *CloudWatch) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAnomalyDetector = "PutAnomalyDetector"

// PutAnomalyDetectorRequest generates a "aws/request.Request" representing the
// client's request for the PutAnomalyDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAnomalyDetector for more information on using the PutAnomalyDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAnomalyDetectorRequest method.
//	req, resp := client.PutAnomalyDetectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutAnomalyDetector
func (c *CloudWatch) PutAnomalyDetectorRequest(input *PutAnomalyDetectorInput) (req *request.Request, output *PutAnomalyDetectorOutput) {
	op := &request.Operation{
		Name:       opPutAnomalyDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAnomalyDetectorInput{}
	}

	output = &PutAnomalyDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAnomalyDetector API operation for Amazon CloudWatch.
//
// Creates an anomaly detection model for a CloudWatch metric. You can use the
// model to display a band of expected normal values when the metric is graphed.
//
// For more information, see CloudWatch Anomaly Detection (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutAnomalyDetector for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The operation exceeded one or more limits.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutAnomalyDetector
func (c *CloudWatch) PutAnomalyDetector(input *PutAnomalyDetectorInput) (*PutAnomalyDetectorOutput, error) {
	req, out := c.PutAnomalyDetectorRequest(input)
	return out, req.Send()
}

// PutAnomalyDetectorWithContext is the same as PutAnomalyDetector with the addition of
// the ability to pass a context and additional request options.
//
// See PutAnomalyDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutAnomalyDetectorWithContext(ctx aws.Context, input *PutAnomalyDetectorInput, opts ...request.Option) (*PutAnomalyDetectorOutput, error) {
	req, out := c.PutAnomalyDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutCompositeAlarm = "PutCompositeAlarm"

// PutCompositeAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutCompositeAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutCompositeAlarm for more information on using the PutCompositeAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutCompositeAlarmRequest method.
//	req, resp := client.PutCompositeAlarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutCompositeAlarm
func (c *CloudWatch) PutCompositeAlarmRequest(input *PutCompositeAlarmInput) (req *request.Request, output *PutCompositeAlarmOutput) {
	op := &request.Operation{
		Name:       opPutCompositeAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutCompositeAlarmInput{}
	}

	output = &PutCompositeAlarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutCompositeAlarm API operation for Amazon CloudWatch.
//
// Creates or updates a composite alarm. When you create a composite alarm,
// you specify a rule expression for the alarm that takes into account the alarm
// states of other alarms that you have created. The composite alarm goes into
// ALARM state only if all conditions of the rule are met.
//
// The alarms specified in a composite alarm's rule expression can include metric
// alarms and other composite alarms. The rule expression of a composite alarm
// can include as many as 100 underlying alarms. Any single alarm can be included
// in the rule expressions of as many as 150 composite alarms.
//
// Using composite alarms can reduce alarm noise. You can create multiple metric
// alarms, and also create a composite alarm and set up alerts only for the
// composite alarm. For example, you could create a composite alarm that goes
// into ALARM state only when more than one of the underlying metric alarms
// are in ALARM state.
//
// Currently, the only alarm actions that can be taken by composite alarms are
// notifying SNS topics.
//
// It is possible to create a loop or cycle of composite alarms, where composite
// alarm A depends on composite alarm B, and composite alarm B also depends
// on composite alarm A. In this scenario, you can't delete any composite alarm
// that is part of the cycle because there is always still a composite alarm
// that depends on that alarm that you want to delete.
//
// To get out of such a situation, you must break the cycle by changing the
// rule of one of the composite alarms in the cycle to remove a dependency that
// creates the cycle. The simplest change to make to break a cycle is to change
// the AlarmRule of one of the alarms to false.
//
// Additionally, the evaluation of composite alarms stops if CloudWatch detects
// a cycle in the evaluation path.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed. For a composite
// alarm, this initial time after creation is the only time that the alarm can
// be in INSUFFICIENT_DATA state.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm.
//
// To use this operation, you must be signed on with the cloudwatch:PutCompositeAlarm
// permission that is scoped to *. You can't create a composite alarms if your
// cloudwatch:PutCompositeAlarm permission has a narrower scope.
//
// If you are an IAM user, you must have iam:CreateServiceLinkedRole to create
// a composite alarm that has Systems Manager OpsItem actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutCompositeAlarm for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeLimitExceededFault "LimitExceeded"
//     The quota for alarms for this customer has already been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutCompositeAlarm
func (c *CloudWatch) PutCompositeAlarm(input *PutCompositeAlarmInput) (*PutCompositeAlarmOutput, error) {
	req, out := c.PutCompositeAlarmRequest(input)
	return out, req.Send()
}

// PutCompositeAlarmWithContext is the same as PutCompositeAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See PutCompositeAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutCompositeAlarmWithContext(ctx aws.Context, input *PutCompositeAlarmInput, opts ...request.Option) (*PutCompositeAlarmOutput, error) {
	req, out := c.PutCompositeAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDashboard = "PutDashboard"

// PutDashboardRequest generates a "aws/request.Request" representing the
// client's request for the PutDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDashboard for more information on using the PutDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDashboardRequest method.
//	req, resp := client.PutDashboardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutDashboard
func (c *CloudWatch) PutDashboardRequest(input *PutDashboardInput) (req *request.Request, output *PutDashboardOutput) {
	op := &request.Operation{
		Name:       opPutDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDashboardInput{}
	}

	output = &PutDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutDashboard API operation for Amazon CloudWatch.
//
// Creates a dashboard if it does not already exist, or updates an existing
// dashboard. If you update a dashboard, the entire contents are replaced with
// what you specify here.
//
// All dashboards in your account are global, not region-specific.
//
// A simple way to create a dashboard using PutDashboard is to copy an existing
// dashboard. To copy an existing dashboard using the console, you can load
// the dashboard and then use the View/edit source command in the Actions menu
// to display the JSON block for that dashboard. Another way to copy a dashboard
// is to use GetDashboard, and then use the data returned within DashboardBody
// as the template for the new dashboard when you call PutDashboard.
//
// When you create a dashboard with PutDashboard, a good practice is to add
// a text widget at the top of the dashboard with a message that the dashboard
// was created by script and should not be changed in the console. This message
// could also point console users to the location of the DashboardBody script
// or the CloudFormation template used to create the dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutDashboard for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeDashboardInvalidInputError "InvalidParameterInput"
//     Some part of the dashboard data is invalid.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutDashboard
func (c *CloudWatch) PutDashboard(input *PutDashboardInput) (*PutDashboardOutput, error) {
	req, out := c.PutDashboardRequest(input)
	return out, req.Send()
}

// PutDashboardWithContext is the same as PutDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See PutDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutDashboardWithContext(ctx aws.Context, input *PutDashboardInput, opts ...request.Option) (*PutDashboardOutput, error) {
	req, out := c.PutDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInsightRule = "PutInsightRule"

// PutInsightRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutInsightRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInsightRule for more information on using the PutInsightRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutInsightRuleRequest method.
//	req, resp := client.PutInsightRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutInsightRule
func (c *CloudWatch) PutInsightRuleRequest(input *PutInsightRuleInput) (req *request.Request, output *PutInsightRuleOutput) {
	op := &request.Operation{
		Name:       opPutInsightRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInsightRuleInput{}
	}

	output = &PutInsightRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutInsightRule API operation for Amazon CloudWatch.
//
// Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch
// Logs log group, enabling you to find contributor data for the log events
// in that log group. For more information, see Using Contributor Insights to
// Analyze High-Cardinality Data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
//
// If you create a rule, delete it, and then re-create it with the same name,
// historical data from the first time the rule was created might not be available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutInsightRule for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeLimitExceededException "LimitExceededException"
//     The operation exceeded one or more limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutInsightRule
func (c *CloudWatch) PutInsightRule(input *PutInsightRuleInput) (*PutInsightRuleOutput, error) {
	req, out := c.PutInsightRuleRequest(input)
	return out, req.Send()
}

// PutInsightRuleWithContext is the same as PutInsightRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutInsightRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutInsightRuleWithContext(ctx aws.Context, input *PutInsightRuleInput, opts ...request.Option) (*PutInsightRuleOutput, error) {
	req, out := c.PutInsightRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutManagedInsightRules = "PutManagedInsightRules"

// PutManagedInsightRulesRequest generates a "aws/request.Request" representing the
// client's request for the PutManagedInsightRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutManagedInsightRules for more information on using the PutManagedInsightRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutManagedInsightRulesRequest method.
//	req, resp := client.PutManagedInsightRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutManagedInsightRules
func (c *CloudWatch) PutManagedInsightRulesRequest(input *PutManagedInsightRulesInput) (req *request.Request, output *PutManagedInsightRulesOutput) {
	op := &request.Operation{
		Name:       opPutManagedInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutManagedInsightRulesInput{}
	}

	output = &PutManagedInsightRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutManagedInsightRules API operation for Amazon CloudWatch.
//
// Creates a managed Contributor Insights rule for a specified Amazon Web Services
// resource. When you enable a managed rule, you create a Contributor Insights
// rule that collects data from Amazon Web Services services. You cannot edit
// these rules with PutInsightRule. The rules can be enabled, disabled, and
// deleted using EnableInsightRules, DisableInsightRules, and DeleteInsightRules.
// If a previously created managed rule is currently disabled, a subsequent
// call to this API will re-enable it. Use ListManagedInsightRules to describe
// all available rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutManagedInsightRules for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutManagedInsightRules
func (c *CloudWatch) PutManagedInsightRules(input *PutManagedInsightRulesInput) (*PutManagedInsightRulesOutput, error) {
	req, out := c.PutManagedInsightRulesRequest(input)
	return out, req.Send()
}

// PutManagedInsightRulesWithContext is the same as PutManagedInsightRules with the addition of
// the ability to pass a context and additional request options.
//
// See PutManagedInsightRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutManagedInsightRulesWithContext(ctx aws.Context, input *PutManagedInsightRulesInput, opts ...request.Option) (*PutManagedInsightRulesOutput, error) {
	req, out := c.PutManagedInsightRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricAlarm = "PutMetricAlarm"

// PutMetricAlarmRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricAlarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricAlarm for more information on using the PutMetricAlarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMetricAlarmRequest method.
//	req, resp := client.PutMetricAlarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarmRequest(input *PutMetricAlarmInput) (req *request.Request, output *PutMetricAlarmOutput) {
	op := &request.Operation{
		Name:       opPutMetricAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricAlarmInput{}
	}

	output = &PutMetricAlarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricAlarm API operation for Amazon CloudWatch.
//
// Creates or updates an alarm and associates it with the specified metric,
// metric math expression, anomaly detection model, or Metrics Insights query.
// For more information about using a Metrics Insights query for an alarm, see
// Create alarms on Metrics Insights queries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Metrics_Insights_Alarm.html).
//
// Alarms based on anomaly detection models cannot have Auto Scaling actions.
//
// When this operation creates an alarm, the alarm state is immediately set
// to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately.
// Any actions associated with the new state are then executed.
//
// When you update an existing alarm, its state is left unchanged, but the update
// completely overwrites the previous configuration of the alarm.
//
// If you are an IAM user, you must have Amazon EC2 permissions for some alarm
// operations:
//
//   - The iam:CreateServiceLinkedRole for all alarms with EC2 actions
//
//   - The iam:CreateServiceLinkedRole to create an alarm with Systems Manager
//     OpsItem actions.
//
// The first time you create an alarm in the Amazon Web Services Management
// Console, the CLI, or by using the PutMetricAlarm API, CloudWatch creates
// the necessary service-linked role for you. The service-linked roles are called
// AWSServiceRoleForCloudWatchEvents and AWSServiceRoleForCloudWatchAlarms_ActionSSM.
// For more information, see Amazon Web Services service-linked role (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role).
//
// # Cross-account alarms
//
// You can set an alarm on metrics in the current account, or in another account.
// To create a cross-account alarm that watches a metric in a different account,
// you must have completed the following pre-requisites:
//
//   - The account where the metrics are located (the sharing account) must
//     already have a sharing role named CloudWatch-CrossAccountSharingRole.
//     If it does not already have this role, you must create it using the instructions
//     in Set up a sharing account in Cross-account cross-Region CloudWatch console
//     (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region).
//     The policy for that role must grant access to the ID of the account where
//     you are creating the alarm.
//
//   - The account where you are creating the alarm (the monitoring account)
//     must already have a service-linked role named AWSServiceRoleForCloudWatchCrossAccount
//     to allow CloudWatch to assume the sharing role in the sharing account.
//     If it does not, you must create it following the directions in Set up
//     a monitoring account in Cross-account cross-Region CloudWatch console
//     (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Cross-Account-Cross-Region.html#enable-cross-account-cross-Region).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricAlarm for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeLimitExceededFault "LimitExceeded"
//     The quota for alarms for this customer has already been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricAlarm
func (c *CloudWatch) PutMetricAlarm(input *PutMetricAlarmInput) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	return out, req.Send()
}

// PutMetricAlarmWithContext is the same as PutMetricAlarm with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricAlarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricAlarmWithContext(ctx aws.Context, input *PutMetricAlarmInput, opts ...request.Option) (*PutMetricAlarmOutput, error) {
	req, out := c.PutMetricAlarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricData = "PutMetricData"

// PutMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricData for more information on using the PutMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMetricDataRequest method.
//	req, resp := client.PutMetricDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricDataRequest(input *PutMetricDataInput) (req *request.Request, output *PutMetricDataOutput) {
	op := &request.Operation{
		Name:       opPutMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricDataInput{}
	}

	output = &PutMetricDataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutMetricData API operation for Amazon CloudWatch.
//
// Publishes metric data points to Amazon CloudWatch. CloudWatch associates
// the data points with the specified metric. If the specified metric does not
// exist, CloudWatch creates the metric. When CloudWatch creates a metric, it
// can take up to fifteen minutes for the metric to appear in calls to ListMetrics
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
//
// You can publish either individual data points in the Value field, or arrays
// of values and the number of times each value occurred during the period by
// using the Values and Counts fields in the MetricDatum structure. Using the
// Values and Counts method enables you to publish up to 150 values per metric
// with one PutMetricData request, and supports retrieving percentile statistics
// on this data.
//
// Each PutMetricData request is limited to 1 MB in size for HTTP POST requests.
// You can send a payload compressed by gzip. Each request is also limited to
// no more than 1000 different metrics.
//
// Although the Value parameter accepts numbers of type Double, CloudWatch rejects
// values that are either too small or too large. Values must be in the range
// of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
// -Infinity) are not supported.
//
// You can use up to 30 dimensions per metric to further clarify what data the
// metric collects. Each dimension consists of a Name and Value pair. For more
// information about specifying dimensions, see Publishing Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
// in the Amazon CloudWatch User Guide.
//
// You specify the time stamp to be associated with each data point. You can
// specify time stamps that are as much as two weeks before the current date,
// and as much as 2 hours after the current day and time.
//
// Data points with time stamps from 24 hours ago or longer can take at least
// 48 hours to become available for GetMetricData (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html)
// or GetMetricStatistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html)
// from the time they are submitted. Data points with time stamps between 3
// and 24 hours ago can take as much as 2 hours to become available for for
// GetMetricData (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html)
// or GetMetricStatistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html).
//
// CloudWatch needs raw data points to calculate percentile statistics. If you
// publish data using a statistic set instead, you can only retrieve percentile
// statistics for this data if one of the following conditions is true:
//
//   - The SampleCount value of the statistic set is 1 and Min, Max, and Sum
//     are all equal.
//
//   - The Min and Max are equal, and Sum is equal to Min multiplied by SampleCount.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricData for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricData
func (c *CloudWatch) PutMetricData(input *PutMetricDataInput) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	return out, req.Send()
}

// PutMetricDataWithContext is the same as PutMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricDataWithContext(ctx aws.Context, input *PutMetricDataInput, opts ...request.Option) (*PutMetricDataOutput, error) {
	req, out := c.PutMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMetricStream = "PutMetricStream"

// PutMetricStreamRequest generates a "aws/request.Request" representing the
// client's request for the PutMetricStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMetricStream for more information on using the PutMetricStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMetricStreamRequest method.
//	req, resp := client.PutMetricStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricStream
func (c *CloudWatch) PutMetricStreamRequest(input *PutMetricStreamInput) (req *request.Request, output *PutMetricStreamOutput) {
	op := &request.Operation{
		Name:       opPutMetricStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricStreamInput{}
	}

	output = &PutMetricStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutMetricStream API operation for Amazon CloudWatch.
//
// Creates or updates a metric stream. Metric streams can automatically stream
// CloudWatch metrics to Amazon Web Services destinations, including Amazon
// S3, and to many third-party solutions.
//
// For more information, see Using Metric Streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html).
//
// To create a metric stream, you must be signed in to an account that has the
// iam:PassRole permission and either the CloudWatchFullAccess policy or the
// cloudwatch:PutMetricStream permission.
//
// When you create or update a metric stream, you choose one of the following:
//
//   - Stream metrics from all metric namespaces in the account.
//
//   - Stream metrics from all metric namespaces in the account, except for
//     the namespaces that you list in ExcludeFilters.
//
//   - Stream metrics from only the metric namespaces that you list in IncludeFilters.
//
// By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT
// statistics for each metric that is streamed. You can use the StatisticsConfigurations
// parameter to have the metric stream send additional statistics in the stream.
// Streaming additional statistics incurs additional costs. For more information,
// see Amazon CloudWatch Pricing (https://aws.amazon.com/cloudwatch/pricing/).
//
// When you use PutMetricStream to create a new metric stream, the stream is
// created in the running state. If you use it to update an existing stream,
// the state of the stream is not changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation PutMetricStream for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConcurrentModificationException "ConcurrentModificationException"
//     More than one process tried to modify a resource at the same time.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
//   - ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//     Parameters were used together that cannot be used together.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/PutMetricStream
func (c *CloudWatch) PutMetricStream(input *PutMetricStreamInput) (*PutMetricStreamOutput, error) {
	req, out := c.PutMetricStreamRequest(input)
	return out, req.Send()
}

// PutMetricStreamWithContext is the same as PutMetricStream with the addition of
// the ability to pass a context and additional request options.
//
// See PutMetricStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) PutMetricStreamWithContext(ctx aws.Context, input *PutMetricStreamInput, opts ...request.Option) (*PutMetricStreamOutput, error) {
	req, out := c.PutMetricStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetAlarmState = "SetAlarmState"

// SetAlarmStateRequest generates a "aws/request.Request" representing the
// client's request for the SetAlarmState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetAlarmState for more information on using the SetAlarmState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetAlarmStateRequest method.
//	req, resp := client.SetAlarmStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmStateRequest(input *SetAlarmStateInput) (req *request.Request, output *SetAlarmStateOutput) {
	op := &request.Operation{
		Name:       opSetAlarmState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetAlarmStateInput{}
	}

	output = &SetAlarmStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetAlarmState API operation for Amazon CloudWatch.
//
// Temporarily sets the state of an alarm for testing purposes. When the updated
// state differs from the previous value, the action configured for the appropriate
// state is invoked. For example, if your alarm is configured to send an Amazon
// SNS message when an alarm is triggered, temporarily changing the alarm state
// to ALARM sends an SNS message.
//
// Metric alarms returns to their actual state quickly, often within seconds.
// Because the metric alarm state change happens quickly, it is typically only
// visible in the alarm's History tab in the Amazon CloudWatch console or through
// DescribeAlarmHistory (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmHistory.html).
//
// If you use SetAlarmState on a composite alarm, the composite alarm is not
// guaranteed to return to its actual state. It returns to its actual state
// only once any of its children alarms change state. It is also reevaluated
// if you update its configuration.
//
// If an alarm triggers EC2 Auto Scaling policies or application Auto Scaling
// policies, you must include information in the StateReasonData parameter to
// enable the policy to take the correct action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation SetAlarmState for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeResourceNotFound "ResourceNotFound"
//     The named resource does not exist.
//
//   - ErrCodeInvalidFormatFault "InvalidFormat"
//     Data was not syntactically valid JSON.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/SetAlarmState
func (c *CloudWatch) SetAlarmState(input *SetAlarmStateInput) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	return out, req.Send()
}

// SetAlarmStateWithContext is the same as SetAlarmState with the addition of
// the ability to pass a context and additional request options.
//
// See SetAlarmState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) SetAlarmStateWithContext(ctx aws.Context, input *SetAlarmStateInput, opts ...request.Option) (*SetAlarmStateOutput, error) {
	req, out := c.SetAlarmStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetricStreams = "StartMetricStreams"

// StartMetricStreamsRequest generates a "aws/request.Request" representing the
// client's request for the StartMetricStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetricStreams for more information on using the StartMetricStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetricStreamsRequest method.
//	req, resp := client.StartMetricStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StartMetricStreams
func (c *CloudWatch) StartMetricStreamsRequest(input *StartMetricStreamsInput) (req *request.Request, output *StartMetricStreamsOutput) {
	op := &request.Operation{
		Name:       opStartMetricStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMetricStreamsInput{}
	}

	output = &StartMetricStreamsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMetricStreams API operation for Amazon CloudWatch.
//
// Starts the streaming of metrics for one or more of your metric streams.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation StartMetricStreams for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StartMetricStreams
func (c *CloudWatch) StartMetricStreams(input *StartMetricStreamsInput) (*StartMetricStreamsOutput, error) {
	req, out := c.StartMetricStreamsRequest(input)
	return out, req.Send()
}

// StartMetricStreamsWithContext is the same as StartMetricStreams with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetricStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) StartMetricStreamsWithContext(ctx aws.Context, input *StartMetricStreamsInput, opts ...request.Option) (*StartMetricStreamsOutput, error) {
	req, out := c.StartMetricStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMetricStreams = "StopMetricStreams"

// StopMetricStreamsRequest generates a "aws/request.Request" representing the
// client's request for the StopMetricStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMetricStreams for more information on using the StopMetricStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopMetricStreamsRequest method.
//	req, resp := client.StopMetricStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StopMetricStreams
func (c *CloudWatch) StopMetricStreamsRequest(input *StopMetricStreamsInput) (req *request.Request, output *StopMetricStreamsOutput) {
	op := &request.Operation{
		Name:       opStopMetricStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMetricStreamsInput{}
	}

	output = &StopMetricStreamsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMetricStreams API operation for Amazon CloudWatch.
//
// Stops the streaming of metrics for one or more of your metric streams.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation StopMetricStreams for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeMissingRequiredParameterException "MissingParameter"
//     An input parameter that is required is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StopMetricStreams
func (c *CloudWatch) StopMetricStreams(input *StopMetricStreamsInput) (*StopMetricStreamsOutput, error) {
	req, out := c.StopMetricStreamsRequest(input)
	return out, req.Send()
}

// StopMetricStreamsWithContext is the same as StopMetricStreams with the addition of
// the ability to pass a context and additional request options.
//
// See StopMetricStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) StopMetricStreamsWithContext(ctx aws.Context, input *StopMetricStreamsInput, opts ...request.Option) (*StopMetricStreamsOutput, error) {
	req, out := c.StopMetricStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/TagResource
func (c *CloudWatch) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch.
//
// Assigns one or more tags (key-value pairs) to the specified CloudWatch resource.
// Currently, the only CloudWatch resources that can be tagged are alarms and
// Contributor Insights rules.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with an alarm that already has tags. If
// you specify a new tag key for the alarm, this tag is appended to the list
// of tags associated with the alarm. If you specify a tag key that is already
// associated with the alarm, the new tag value that you specify replaces the
// previous value for that tag.
//
// You can associate as many as 50 tags with a CloudWatch resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
//   - ErrCodeConcurrentModificationException "ConcurrentModificationException"
//     More than one process tried to modify a resource at the same time.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/TagResource
func (c *CloudWatch) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/UntagResource
func (c *CloudWatch) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidParameterValueException "InvalidParameterValue"
//     The value of an input parameter is bad or out-of-range.
//
//   - ErrCodeResourceNotFoundException "ResourceNotFoundException"
//     The named resource does not exist.
//
//   - ErrCodeConcurrentModificationException "ConcurrentModificationException"
//     More than one process tried to modify a resource at the same time.
//
//   - ErrCodeInternalServiceFault "InternalServiceError"
//     Request processing has failed due to some unknown error, exception, or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/UntagResource
func (c *CloudWatch) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatch) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the history of a specific alarm.
type AlarmHistoryItem struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The type of alarm, either metric alarm or composite alarm.
	AlarmType *string `type:"string" enum:"AlarmType"`

	// Data about the alarm, in JSON format.
	HistoryData *string `min:"1" type:"string"`

	// The type of alarm history item.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// A summary of the alarm history, in text format.
	HistorySummary *string `min:"1" type:"string"`

	// The time stamp for the alarm history item.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmHistoryItem) GoString() string {
	return s.String()
}

// SetAlarmName sets the AlarmName field's value.
func (s *AlarmHistoryItem) SetAlarmName(v string) *AlarmHistoryItem {
	s.AlarmName = &v
	return s
}

// SetAlarmType sets the AlarmType field's value.
func (s *AlarmHistoryItem) SetAlarmType(v string) *AlarmHistoryItem {
	s.AlarmType = &v
	return s
}

// SetHistoryData sets the HistoryData field's value.
func (s *AlarmHistoryItem) SetHistoryData(v string) *AlarmHistoryItem {
	s.HistoryData = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *AlarmHistoryItem) SetHistoryItemType(v string) *AlarmHistoryItem {
	s.HistoryItemType = &v
	return s
}

// SetHistorySummary sets the HistorySummary field's value.
func (s *AlarmHistoryItem) SetHistorySummary(v string) *AlarmHistoryItem {
	s.HistorySummary = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AlarmHistoryItem) SetTimestamp(v time.Time) *AlarmHistoryItem {
	s.Timestamp = &v
	return s
}

// An anomaly detection model associated with a particular CloudWatch metric,
// statistic, or metric math expression. You can use the model to display a
// band of expected, normal values when the metric is graphed.
type AnomalyDetector struct {
	_ struct{} `type:"structure"`

	// The configuration specifies details about how the anomaly detection model
	// is to be trained, including time ranges to exclude from use for training
	// the model, and the time zone to use for the metric.
	Configuration *AnomalyDetectorConfiguration `type:"structure"`

	// The metric dimensions associated with the anomaly detection model.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.Dimensions property.
	Dimensions []*Dimension `deprecated:"true" type:"list"`

	// The CloudWatch metric math expression for this anomaly detector.
	MetricMathAnomalyDetector *MetricMathAnomalyDetector `type:"structure"`

	// The name of the metric associated with the anomaly detection model.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.MetricName property.
	MetricName *string `min:"1" deprecated:"true" type:"string"`

	// The namespace of the metric associated with the anomaly detection model.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.Namespace property.
	Namespace *string `min:"1" deprecated:"true" type:"string"`

	// The CloudWatch metric and statistic for this anomaly detector.
	SingleMetricAnomalyDetector *SingleMetricAnomalyDetector `type:"structure"`

	// The statistic associated with the anomaly detection model.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.Stat property.
	Stat *string `deprecated:"true" type:"string"`

	// The current status of the anomaly detector's training. The possible values
	// are TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA
	StateValue *string `type:"string" enum:"AnomalyDetectorStateValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetector) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *AnomalyDetector) SetConfiguration(v *AnomalyDetectorConfiguration) *AnomalyDetector {
	s.Configuration = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *AnomalyDetector) SetDimensions(v []*Dimension) *AnomalyDetector {
	s.Dimensions = v
	return s
}

// SetMetricMathAnomalyDetector sets the MetricMathAnomalyDetector field's value.
func (s *AnomalyDetector) SetMetricMathAnomalyDetector(v *MetricMathAnomalyDetector) *AnomalyDetector {
	s.MetricMathAnomalyDetector = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *AnomalyDetector) SetMetricName(v string) *AnomalyDetector {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *AnomalyDetector) SetNamespace(v string) *AnomalyDetector {
	s.Namespace = &v
	return s
}

// SetSingleMetricAnomalyDetector sets the SingleMetricAnomalyDetector field's value.
func (s *AnomalyDetector) SetSingleMetricAnomalyDetector(v *SingleMetricAnomalyDetector) *AnomalyDetector {
	s.SingleMetricAnomalyDetector = v
	return s
}

// SetStat sets the Stat field's value.
func (s *AnomalyDetector) SetStat(v string) *AnomalyDetector {
	s.Stat = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *AnomalyDetector) SetStateValue(v string) *AnomalyDetector {
	s.StateValue = &v
	return s
}

// The configuration specifies details about how the anomaly detection model
// is to be trained, including time ranges to exclude from use for training
// the model and the time zone to use for the metric.
type AnomalyDetectorConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of time ranges to exclude from use when the anomaly detection model
	// is trained. Use this to make sure that events that could cause unusual values
	// for the metric, such as deployments, aren't used when CloudWatch creates
	// the model.
	ExcludedTimeRanges []*Range `type:"list"`

	// The time zone to use for the metric. This is useful to enable the model to
	// automatically account for daylight savings time changes if the metric is
	// sensitive to such time changes.
	//
	// To specify a time zone, use the name of the time zone as specified in the
	// standard tz database. For more information, see tz database (https://en.wikipedia.org/wiki/Tz_database).
	MetricTimezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnomalyDetectorConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnomalyDetectorConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnomalyDetectorConfiguration"}
	if s.ExcludedTimeRanges != nil {
		for i, v := range s.ExcludedTimeRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedTimeRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludedTimeRanges sets the ExcludedTimeRanges field's value.
func (s *AnomalyDetectorConfiguration) SetExcludedTimeRanges(v []*Range) *AnomalyDetectorConfiguration {
	s.ExcludedTimeRanges = v
	return s
}

// SetMetricTimezone sets the MetricTimezone field's value.
func (s *AnomalyDetectorConfiguration) SetMetricTimezone(v string) *AnomalyDetectorConfiguration {
	s.MetricTimezone = &v
	return s
}

// The details about a composite alarm.
type CompositeAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// When the value is ALARM, it means that the actions are suppressed because
	// the suppressor alarm is in ALARM When the value is WaitPeriod, it means that
	// the actions are suppressed because the composite alarm is waiting for the
	// suppressor alarm to go into into the ALARM state. The maximum waiting time
	// is as specified in ActionsSuppressorWaitPeriod. After this time, the composite
	// alarm performs its actions. When the value is ExtensionPeriod, it means that
	// the actions are suppressed because the composite alarm is waiting after the
	// suppressor alarm went out of the ALARM state. The maximum waiting time is
	// as specified in ActionsSuppressorExtensionPeriod. After this time, the composite
	// alarm performs its actions.
	ActionsSuppressedBy *string `type:"string" enum:"ActionsSuppressedBy"`

	// Captures the reason for action suppression.
	ActionsSuppressedReason *string `type:"string"`

	// Actions will be suppressed if the suppressor alarm is in the ALARM state.
	// ActionsSuppressor can be an AlarmName or an Amazon Resource Name (ARN) from
	// an existing alarm.
	ActionsSuppressor *string `min:"1" type:"string"`

	// The maximum time in seconds that the composite alarm waits after suppressor
	// alarm goes out of the ALARM state. After this time, the composite alarm performs
	// its actions.
	//
	// ExtensionPeriod is required only when ActionsSuppressor is specified.
	ActionsSuppressorExtensionPeriod *int64 `type:"integer"`

	// The maximum time in seconds that the composite alarm waits for the suppressor
	// alarm to go into the ALARM state. After this time, the composite alarm performs
	// its actions.
	//
	// WaitPeriod is required only when ActionsSuppressor is specified.
	ActionsSuppressorWaitPeriod *int64 `type:"integer"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	AlarmActions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The rule that this alarm uses to evaluate its alarm state.
	AlarmRule *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	InsufficientDataActions []*string `type:"list"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	OKActions []*string `type:"list"`

	// An explanation for the alarm state, in text format.
	StateReason *string `type:"string"`

	// An explanation for the alarm state, in JSON format.
	StateReasonData *string `type:"string"`

	// The timestamp of the last change to the alarm's StateValue.
	StateTransitionedTimestamp *time.Time `type:"timestamp"`

	// Tracks the timestamp of any state update, even if StateValue doesn't change.
	StateUpdatedTimestamp *time.Time `type:"timestamp"`

	// The state value for the alarm.
	StateValue *string `type:"string" enum:"StateValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeAlarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeAlarm) GoString() string {
	return s.String()
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *CompositeAlarm) SetActionsEnabled(v bool) *CompositeAlarm {
	s.ActionsEnabled = &v
	return s
}

// SetActionsSuppressedBy sets the ActionsSuppressedBy field's value.
func (s *CompositeAlarm) SetActionsSuppressedBy(v string) *CompositeAlarm {
	s.ActionsSuppressedBy = &v
	return s
}

// SetActionsSuppressedReason sets the ActionsSuppressedReason field's value.
func (s *CompositeAlarm) SetActionsSuppressedReason(v string) *CompositeAlarm {
	s.ActionsSuppressedReason = &v
	return s
}

// SetActionsSuppressor sets the ActionsSuppressor field's value.
func (s *CompositeAlarm) SetActionsSuppressor(v string) *CompositeAlarm {
	s.ActionsSuppressor = &v
	return s
}

// SetActionsSuppressorExtensionPeriod sets the ActionsSuppressorExtensionPeriod field's value.
func (s *CompositeAlarm) SetActionsSuppressorExtensionPeriod(v int64) *CompositeAlarm {
	s.ActionsSuppressorExtensionPeriod = &v
	return s
}

// SetActionsSuppressorWaitPeriod sets the ActionsSuppressorWaitPeriod field's value.
func (s *CompositeAlarm) SetActionsSuppressorWaitPeriod(v int64) *CompositeAlarm {
	s.ActionsSuppressorWaitPeriod = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *CompositeAlarm) SetAlarmActions(v []*string) *CompositeAlarm {
	s.AlarmActions = v
	return s
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *CompositeAlarm) SetAlarmArn(v string) *CompositeAlarm {
	s.AlarmArn = &v
	return s
}

// SetAlarmConfigurationUpdatedTimestamp sets the AlarmConfigurationUpdatedTimestamp field's value.
func (s *CompositeAlarm) SetAlarmConfigurationUpdatedTimestamp(v time.Time) *CompositeAlarm {
	s.AlarmConfigurationUpdatedTimestamp = &v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *CompositeAlarm) SetAlarmDescription(v string) *CompositeAlarm {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *CompositeAlarm) SetAlarmName(v string) *CompositeAlarm {
	s.AlarmName = &v
	return s
}

// SetAlarmRule sets the AlarmRule field's value.
func (s *CompositeAlarm) SetAlarmRule(v string) *CompositeAlarm {
	s.AlarmRule = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *CompositeAlarm) SetInsufficientDataActions(v []*string) *CompositeAlarm {
	s.InsufficientDataActions = v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *CompositeAlarm) SetOKActions(v []*string) *CompositeAlarm {
	s.OKActions = v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CompositeAlarm) SetStateReason(v string) *CompositeAlarm {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *CompositeAlarm) SetStateReasonData(v string) *CompositeAlarm {
	s.StateReasonData = &v
	return s
}

// SetStateTransitionedTimestamp sets the StateTransitionedTimestamp field's value.
func (s *CompositeAlarm) SetStateTransitionedTimestamp(v time.Time) *CompositeAlarm {
	s.StateTransitionedTimestamp = &v
	return s
}

// SetStateUpdatedTimestamp sets the StateUpdatedTimestamp field's value.
func (s *CompositeAlarm) SetStateUpdatedTimestamp(v time.Time) *CompositeAlarm {
	s.StateUpdatedTimestamp = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *CompositeAlarm) SetStateValue(v string) *CompositeAlarm {
	s.StateValue = &v
	return s
}

// Represents a specific dashboard.
type DashboardEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The name of the dashboard.
	DashboardName *string `type:"string"`

	// The time stamp of when the dashboard was last modified, either by an API
	// call or through the console. This number is expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	LastModified *time.Time `type:"timestamp"`

	// The size of the dashboard, in bytes.
	Size *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardEntry) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DashboardEntry) SetDashboardArn(v string) *DashboardEntry {
	s.DashboardArn = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *DashboardEntry) SetDashboardName(v string) *DashboardEntry {
	s.DashboardName = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DashboardEntry) SetLastModified(v time.Time) *DashboardEntry {
	s.LastModified = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DashboardEntry) SetSize(v int64) *DashboardEntry {
	s.Size = &v
	return s
}

// An error or warning for the operation.
type DashboardValidationMessage struct {
	_ struct{} `type:"structure"`

	// The data path related to the message.
	DataPath *string `type:"string"`

	// A message describing the error or warning.
	Message *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardValidationMessage) GoString() string {
	return s.String()
}

// SetDataPath sets the DataPath field's value.
func (s *DashboardValidationMessage) SetDataPath(v string) *DashboardValidationMessage {
	s.DataPath = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DashboardValidationMessage) SetMessage(v string) *DashboardValidationMessage {
	s.Message = &v
	return s
}

// Encapsulates the statistical data that CloudWatch computes from metric data.
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The average of the metric values that correspond to the data point.
	Average *float64 `type:"double"`

	// The percentile statistic for the data point.
	ExtendedStatistics map[string]*float64 `type:"map"`

	// The maximum metric value for the data point.
	Maximum *float64 `type:"double"`

	// The minimum metric value for the data point.
	Minimum *float64 `type:"double"`

	// The number of metric values that contributed to the aggregate value of this
	// data point.
	SampleCount *float64 `type:"double"`

	// The sum of the metric values for the data point.
	Sum *float64 `type:"double"`

	// The time stamp used for the data point.
	Timestamp *time.Time `type:"timestamp"`

	// The standard unit for the data point.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *Datapoint) SetAverage(v float64) *Datapoint {
	s.Average = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *Datapoint) SetExtendedStatistics(v map[string]*float64) *Datapoint {
	s.ExtendedStatistics = v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *Datapoint) SetMaximum(v float64) *Datapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Datapoint) SetMinimum(v float64) *Datapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *Datapoint) SetSampleCount(v float64) *Datapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *Datapoint) SetSum(v float64) *Datapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Datapoint) SetTimestamp(v time.Time) *Datapoint {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Datapoint) SetUnit(v string) *Datapoint {
	s.Unit = &v
	return s
}

type DeleteAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The alarms to be deleted.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlarmsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DeleteAlarmsInput) SetAlarmNames(v []*string) *DeleteAlarmsInput {
	s.AlarmNames = v
	return s
}

type DeleteAlarmsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlarmsOutput) GoString() string {
	return s.String()
}

type DeleteAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The metric dimensions associated with the anomaly detection model to delete.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Dimensions []*Dimension `deprecated:"true" type:"list"`

	// The metric math anomaly detector to be deleted.
	//
	// When using MetricMathAnomalyDetector, you cannot include following parameters
	// in the same operation:
	//
	//    * Dimensions,
	//
	//    * MetricName
	//
	//    * Namespace
	//
	//    * Stat
	//
	//    * the SingleMetricAnomalyDetector parameters of DeleteAnomalyDetectorInput
	//
	// Instead, specify the metric math anomaly detector attributes as part of the
	// MetricMathAnomalyDetector property.
	MetricMathAnomalyDetector *MetricMathAnomalyDetector `type:"structure"`

	// The metric name associated with the anomaly detection model to delete.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	MetricName *string `min:"1" deprecated:"true" type:"string"`

	// The namespace associated with the anomaly detection model to delete.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Namespace *string `min:"1" deprecated:"true" type:"string"`

	// A single metric anomaly detector to be deleted.
	//
	// When using SingleMetricAnomalyDetector, you cannot include the following
	// parameters in the same operation:
	//
	//    * Dimensions,
	//
	//    * MetricName
	//
	//    * Namespace
	//
	//    * Stat
	//
	//    * the MetricMathAnomalyDetector parameters of DeleteAnomalyDetectorInput
	//
	// Instead, specify the single metric anomaly detector attributes as part of
	// the SingleMetricAnomalyDetector property.
	SingleMetricAnomalyDetector *SingleMetricAnomalyDetector `type:"structure"`

	// The statistic associated with the anomaly detection model to delete.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Stat *string `deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnomalyDetectorInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricMathAnomalyDetector != nil {
		if err := s.MetricMathAnomalyDetector.Validate(); err != nil {
			invalidParams.AddNested("MetricMathAnomalyDetector", err.(request.ErrInvalidParams))
		}
	}
	if s.SingleMetricAnomalyDetector != nil {
		if err := s.SingleMetricAnomalyDetector.Validate(); err != nil {
			invalidParams.AddNested("SingleMetricAnomalyDetector", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DeleteAnomalyDetectorInput) SetDimensions(v []*Dimension) *DeleteAnomalyDetectorInput {
	s.Dimensions = v
	return s
}

// SetMetricMathAnomalyDetector sets the MetricMathAnomalyDetector field's value.
func (s *DeleteAnomalyDetectorInput) SetMetricMathAnomalyDetector(v *MetricMathAnomalyDetector) *DeleteAnomalyDetectorInput {
	s.MetricMathAnomalyDetector = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *DeleteAnomalyDetectorInput) SetMetricName(v string) *DeleteAnomalyDetectorInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteAnomalyDetectorInput) SetNamespace(v string) *DeleteAnomalyDetectorInput {
	s.Namespace = &v
	return s
}

// SetSingleMetricAnomalyDetector sets the SingleMetricAnomalyDetector field's value.
func (s *DeleteAnomalyDetectorInput) SetSingleMetricAnomalyDetector(v *SingleMetricAnomalyDetector) *DeleteAnomalyDetectorInput {
	s.SingleMetricAnomalyDetector = v
	return s
}

// SetStat sets the Stat field's value.
func (s *DeleteAnomalyDetectorInput) SetStat(v string) *DeleteAnomalyDetectorInput {
	s.Stat = &v
	return s
}

type DeleteAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnomalyDetectorOutput) GoString() string {
	return s.String()
}

type DeleteDashboardsInput struct {
	_ struct{} `type:"structure"`

	// The dashboards to be deleted. This parameter is required.
	//
	// DashboardNames is a required field
	DashboardNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardsInput"}
	if s.DashboardNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardNames sets the DashboardNames field's value.
func (s *DeleteDashboardsInput) SetDashboardNames(v []*string) *DeleteDashboardsInput {
	s.DashboardNames = v
	return s
}

type DeleteDashboardsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardsOutput) GoString() string {
	return s.String()
}

type DeleteInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// An array of the rule names to delete. If you need to find out the names of
	// your rules, use DescribeInsightRules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html).
	//
	// RuleNames is a required field
	RuleNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInsightRulesInput"}
	if s.RuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleNames sets the RuleNames field's value.
func (s *DeleteInsightRulesInput) SetRuleNames(v []*string) *DeleteInsightRulesInput {
	s.RuleNames = v
	return s
}

type DeleteInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array listing the rules that could not be deleted. You cannot delete built-in
	// rules.
	Failures []*PartialFailure `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInsightRulesOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *DeleteInsightRulesOutput) SetFailures(v []*PartialFailure) *DeleteInsightRulesOutput {
	s.Failures = v
	return s
}

type DeleteMetricStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the metric stream to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMetricStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMetricStreamInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteMetricStreamInput) SetName(v string) *DeleteMetricStreamInput {
	s.Name = &v
	return s
}

type DeleteMetricStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMetricStreamOutput) GoString() string {
	return s.String()
}

type DescribeAlarmHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// Use this parameter to specify whether you want the operation to return metric
	// alarms or composite alarms. If you omit this parameter, only metric alarms
	// are returned.
	AlarmTypes []*string `type:"list" enum:"AlarmType"`

	// The ending date to retrieve alarm history.
	EndDate *time.Time `type:"timestamp"`

	// The type of alarm histories to retrieve.
	HistoryItemType *string `type:"string" enum:"HistoryItemType"`

	// The maximum number of alarm history records to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// Specified whether to return the newest or oldest alarm history first. Specify
	// TimestampDescending to have the newest event history returned first, and
	// specify TimestampAscending to have the oldest history returned first.
	ScanBy *string `type:"string" enum:"ScanBy"`

	// The starting date to retrieve alarm history.
	StartDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmHistoryInput"}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *DescribeAlarmHistoryInput) SetAlarmName(v string) *DescribeAlarmHistoryInput {
	s.AlarmName = &v
	return s
}

// SetAlarmTypes sets the AlarmTypes field's value.
func (s *DescribeAlarmHistoryInput) SetAlarmTypes(v []*string) *DescribeAlarmHistoryInput {
	s.AlarmTypes = v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *DescribeAlarmHistoryInput) SetEndDate(v time.Time) *DescribeAlarmHistoryInput {
	s.EndDate = &v
	return s
}

// SetHistoryItemType sets the HistoryItemType field's value.
func (s *DescribeAlarmHistoryInput) SetHistoryItemType(v string) *DescribeAlarmHistoryInput {
	s.HistoryItemType = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmHistoryInput) SetMaxRecords(v int64) *DescribeAlarmHistoryInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryInput) SetNextToken(v string) *DescribeAlarmHistoryInput {
	s.NextToken = &v
	return s
}

// SetScanBy sets the ScanBy field's value.
func (s *DescribeAlarmHistoryInput) SetScanBy(v string) *DescribeAlarmHistoryInput {
	s.ScanBy = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DescribeAlarmHistoryInput) SetStartDate(v time.Time) *DescribeAlarmHistoryInput {
	s.StartDate = &v
	return s
}

type DescribeAlarmHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The alarm histories, in JSON format.
	AlarmHistoryItems []*AlarmHistoryItem `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmHistoryOutput) GoString() string {
	return s.String()
}

// SetAlarmHistoryItems sets the AlarmHistoryItems field's value.
func (s *DescribeAlarmHistoryOutput) SetAlarmHistoryItems(v []*AlarmHistoryItem) *DescribeAlarmHistoryOutput {
	s.AlarmHistoryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmHistoryOutput) SetNextToken(v string) *DescribeAlarmHistoryOutput {
	s.NextToken = &v
	return s
}

type DescribeAlarmsForMetricInput struct {
	_ struct{} `type:"structure"`

	// The dimensions associated with the metric. If the metric has any associated
	// dimensions, you must specify them in order for the call to succeed.
	Dimensions []*Dimension `type:"list"`

	// The percentile statistic for the metric. Specify a value between p0.0 and
	// p100.
	ExtendedStatistic *string `type:"string"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"1" type:"integer"`

	// The statistic for the metric, other than percentiles. For percentile statistics,
	// use ExtendedStatistics.
	Statistic *string `type:"string" enum:"Statistic"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsForMetricInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsForMetricInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsForMetricInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsForMetricInput"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DescribeAlarmsForMetricInput) SetDimensions(v []*Dimension) *DescribeAlarmsForMetricInput {
	s.Dimensions = v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *DescribeAlarmsForMetricInput) SetExtendedStatistic(v string) *DescribeAlarmsForMetricInput {
	s.ExtendedStatistic = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *DescribeAlarmsForMetricInput) SetMetricName(v string) *DescribeAlarmsForMetricInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAlarmsForMetricInput) SetNamespace(v string) *DescribeAlarmsForMetricInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *DescribeAlarmsForMetricInput) SetPeriod(v int64) *DescribeAlarmsForMetricInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *DescribeAlarmsForMetricInput) SetStatistic(v string) *DescribeAlarmsForMetricInput {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *DescribeAlarmsForMetricInput) SetUnit(v string) *DescribeAlarmsForMetricInput {
	s.Unit = &v
	return s
}

type DescribeAlarmsForMetricOutput struct {
	_ struct{} `type:"structure"`

	// The information for each alarm with the specified metric.
	MetricAlarms []*MetricAlarm `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsForMetricOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsForMetricOutput) GoString() string {
	return s.String()
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsForMetricOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsForMetricOutput {
	s.MetricAlarms = v
	return s
}

type DescribeAlarmsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to filter the results of the operation to only those alarms
	// that use a certain alarm action. For example, you could specify the ARN of
	// an SNS topic to find all alarms that send notifications to that topic.
	ActionPrefix *string `min:"1" type:"string"`

	// An alarm name prefix. If you specify this parameter, you receive information
	// about all alarms that have names that start with this prefix.
	//
	// If this parameter is specified, you cannot specify AlarmNames.
	AlarmNamePrefix *string `min:"1" type:"string"`

	// The names of the alarms to retrieve information about.
	AlarmNames []*string `type:"list"`

	// Use this parameter to specify whether you want the operation to return metric
	// alarms or composite alarms. If you omit this parameter, only metric alarms
	// are returned.
	AlarmTypes []*string `type:"list" enum:"AlarmType"`

	// If you use this parameter and specify the name of a composite alarm, the
	// operation returns information about the "children" alarms of the alarm you
	// specify. These are the metric alarms and composite alarms referenced in the
	// AlarmRule field of the composite alarm that you specify in ChildrenOfAlarmName.
	// Information about the composite alarm that you name in ChildrenOfAlarmName
	// is not returned.
	//
	// If you specify ChildrenOfAlarmName, you cannot specify any other parameters
	// in the request except for MaxRecords and NextToken. If you do so, you receive
	// a validation error.
	//
	// Only the Alarm Name, ARN, StateValue (OK/ALARM/INSUFFICIENT_DATA), and StateUpdatedTimestamp
	// information are returned by this operation when you use this parameter. To
	// get complete information about these alarms, perform another DescribeAlarms
	// operation and specify the parent alarm names in the AlarmNames parameter.
	ChildrenOfAlarmName *string `min:"1" type:"string"`

	// The maximum number of alarm descriptions to retrieve.
	MaxRecords *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// If you use this parameter and specify the name of a metric or composite alarm,
	// the operation returns information about the "parent" alarms of the alarm
	// you specify. These are the composite alarms that have AlarmRule parameters
	// that reference the alarm named in ParentsOfAlarmName. Information about the
	// alarm that you specify in ParentsOfAlarmName is not returned.
	//
	// If you specify ParentsOfAlarmName, you cannot specify any other parameters
	// in the request except for MaxRecords and NextToken. If you do so, you receive
	// a validation error.
	//
	// Only the Alarm Name and ARN are returned by this operation when you use this
	// parameter. To get complete information about these alarms, perform another
	// DescribeAlarms operation and specify the parent alarm names in the AlarmNames
	// parameter.
	ParentsOfAlarmName *string `min:"1" type:"string"`

	// Specify this parameter to receive information only about alarms that are
	// currently in the state that you specify.
	StateValue *string `type:"string" enum:"StateValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlarmsInput"}
	if s.ActionPrefix != nil && len(*s.ActionPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionPrefix", 1))
	}
	if s.AlarmNamePrefix != nil && len(*s.AlarmNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmNamePrefix", 1))
	}
	if s.ChildrenOfAlarmName != nil && len(*s.ChildrenOfAlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChildrenOfAlarmName", 1))
	}
	if s.MaxRecords != nil && *s.MaxRecords < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRecords", 1))
	}
	if s.ParentsOfAlarmName != nil && len(*s.ParentsOfAlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentsOfAlarmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionPrefix sets the ActionPrefix field's value.
func (s *DescribeAlarmsInput) SetActionPrefix(v string) *DescribeAlarmsInput {
	s.ActionPrefix = &v
	return s
}

// SetAlarmNamePrefix sets the AlarmNamePrefix field's value.
func (s *DescribeAlarmsInput) SetAlarmNamePrefix(v string) *DescribeAlarmsInput {
	s.AlarmNamePrefix = &v
	return s
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DescribeAlarmsInput) SetAlarmNames(v []*string) *DescribeAlarmsInput {
	s.AlarmNames = v
	return s
}

// SetAlarmTypes sets the AlarmTypes field's value.
func (s *DescribeAlarmsInput) SetAlarmTypes(v []*string) *DescribeAlarmsInput {
	s.AlarmTypes = v
	return s
}

// SetChildrenOfAlarmName sets the ChildrenOfAlarmName field's value.
func (s *DescribeAlarmsInput) SetChildrenOfAlarmName(v string) *DescribeAlarmsInput {
	s.ChildrenOfAlarmName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAlarmsInput) SetMaxRecords(v int64) *DescribeAlarmsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsInput) SetNextToken(v string) *DescribeAlarmsInput {
	s.NextToken = &v
	return s
}

// SetParentsOfAlarmName sets the ParentsOfAlarmName field's value.
func (s *DescribeAlarmsInput) SetParentsOfAlarmName(v string) *DescribeAlarmsInput {
	s.ParentsOfAlarmName = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *DescribeAlarmsInput) SetStateValue(v string) *DescribeAlarmsInput {
	s.StateValue = &v
	return s
}

type DescribeAlarmsOutput struct {
	_ struct{} `type:"structure"`

	// The information about any composite alarms returned by the operation.
	CompositeAlarms []*CompositeAlarm `type:"list"`

	// The information about any metric alarms returned by the operation.
	MetricAlarms []*MetricAlarm `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlarmsOutput) GoString() string {
	return s.String()
}

// SetCompositeAlarms sets the CompositeAlarms field's value.
func (s *DescribeAlarmsOutput) SetCompositeAlarms(v []*CompositeAlarm) *DescribeAlarmsOutput {
	s.CompositeAlarms = v
	return s
}

// SetMetricAlarms sets the MetricAlarms field's value.
func (s *DescribeAlarmsOutput) SetMetricAlarms(v []*MetricAlarm) *DescribeAlarmsOutput {
	s.MetricAlarms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAlarmsOutput) SetNextToken(v string) *DescribeAlarmsOutput {
	s.NextToken = &v
	return s
}

type DescribeAnomalyDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The anomaly detector types to request when using DescribeAnomalyDetectorsInput.
	// If empty, defaults to SINGLE_METRIC.
	AnomalyDetectorTypes []*string `type:"list" enum:"AnomalyDetectorType"`

	// Limits the results to only the anomaly detection models that are associated
	// with the specified metric dimensions. If there are multiple metrics that
	// have these dimensions and have anomaly detection models associated, they're
	// all returned.
	Dimensions []*Dimension `type:"list"`

	// The maximum number of results to return in one operation. The maximum value
	// that you can specify is 100.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	MaxResults *int64 `min:"1" type:"integer"`

	// Limits the results to only the anomaly detection models that are associated
	// with the specified metric name. If there are multiple metrics with this name
	// in different namespaces that have anomaly detection models, they're all returned.
	MetricName *string `min:"1" type:"string"`

	// Limits the results to only the anomaly detection models that are associated
	// with the specified namespace.
	Namespace *string `min:"1" type:"string"`

	// Use the token returned by the previous operation to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyDetectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnomalyDetectorTypes sets the AnomalyDetectorTypes field's value.
func (s *DescribeAnomalyDetectorsInput) SetAnomalyDetectorTypes(v []*string) *DescribeAnomalyDetectorsInput {
	s.AnomalyDetectorTypes = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *DescribeAnomalyDetectorsInput) SetDimensions(v []*Dimension) *DescribeAnomalyDetectorsInput {
	s.Dimensions = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAnomalyDetectorsInput) SetMaxResults(v int64) *DescribeAnomalyDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *DescribeAnomalyDetectorsInput) SetMetricName(v string) *DescribeAnomalyDetectorsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAnomalyDetectorsInput) SetNamespace(v string) *DescribeAnomalyDetectorsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAnomalyDetectorsInput) SetNextToken(v string) *DescribeAnomalyDetectorsInput {
	s.NextToken = &v
	return s
}

type DescribeAnomalyDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of anomaly detection models returned by the operation.
	AnomalyDetectors []*AnomalyDetector `type:"list"`

	// A token that you can use in a subsequent operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnomalyDetectorsOutput) GoString() string {
	return s.String()
}

// SetAnomalyDetectors sets the AnomalyDetectors field's value.
func (s *DescribeAnomalyDetectorsOutput) SetAnomalyDetectors(v []*AnomalyDetector) *DescribeAnomalyDetectorsOutput {
	s.AnomalyDetectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAnomalyDetectorsOutput) SetNextToken(v string) *DescribeAnomalyDetectorsOutput {
	s.NextToken = &v
	return s
}

type DescribeInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 500 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Include this value, if it was returned by the previous operation, to get
	// the next set of rules.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInsightRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInsightRulesInput) SetMaxResults(v int64) *DescribeInsightRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInsightRulesInput) SetNextToken(v string) *DescribeInsightRulesInput {
	s.NextToken = &v
	return s
}

type DescribeInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// The rules returned by the operation.
	InsightRules []*InsightRule `type:"list"`

	// If this parameter is present, it is a token that marks the start of the next
	// batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightRulesOutput) GoString() string {
	return s.String()
}

// SetInsightRules sets the InsightRules field's value.
func (s *DescribeInsightRulesOutput) SetInsightRules(v []*InsightRule) *DescribeInsightRulesOutput {
	s.InsightRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInsightRulesOutput) SetNextToken(v string) *DescribeInsightRulesOutput {
	s.NextToken = &v
	return s
}

// A dimension is a name/value pair that is part of the identity of a metric.
// Because dimensions are part of the unique identifier for a metric, whenever
// you add a unique name/value pair to one of your metrics, you are creating
// a new variation of that metric. For example, many Amazon EC2 metrics publish
// InstanceId as a dimension name, and the actual instance ID as the value for
// that dimension.
//
// You can assign up to 30 dimensions to a metric.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension. Dimension names must contain only ASCII characters,
	// must include at least one non-whitespace character, and cannot start with
	// a colon (:).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension. Dimension values must contain only ASCII characters
	// and must include at least one non-whitespace character.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

// Represents filters for a dimension.
type DimensionFilter struct {
	_ struct{} `type:"structure"`

	// The dimension name to be matched.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension to be matched.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DimensionFilter) SetName(v string) *DimensionFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionFilter) SetValue(v string) *DimensionFilter {
	s.Value = &v
	return s
}

type DisableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *DisableAlarmActionsInput) SetAlarmNames(v []*string) *DisableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

type DisableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableAlarmActionsOutput) GoString() string {
	return s.String()
}

type DisableInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// An array of the rule names to disable. If you need to find out the names
	// of your rules, use DescribeInsightRules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html).
	//
	// RuleNames is a required field
	RuleNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableInsightRulesInput"}
	if s.RuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleNames sets the RuleNames field's value.
func (s *DisableInsightRulesInput) SetRuleNames(v []*string) *DisableInsightRulesInput {
	s.RuleNames = v
	return s
}

type DisableInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array listing the rules that could not be disabled. You cannot disable
	// built-in rules.
	Failures []*PartialFailure `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableInsightRulesOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *DisableInsightRulesOutput) SetFailures(v []*PartialFailure) *DisableInsightRulesOutput {
	s.Failures = v
	return s
}

type EnableAlarmActionsInput struct {
	_ struct{} `type:"structure"`

	// The names of the alarms.
	//
	// AlarmNames is a required field
	AlarmNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableAlarmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableAlarmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAlarmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableAlarmActionsInput"}
	if s.AlarmNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmNames sets the AlarmNames field's value.
func (s *EnableAlarmActionsInput) SetAlarmNames(v []*string) *EnableAlarmActionsInput {
	s.AlarmNames = v
	return s
}

type EnableAlarmActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableAlarmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableAlarmActionsOutput) GoString() string {
	return s.String()
}

type EnableInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// An array of the rule names to enable. If you need to find out the names of
	// your rules, use DescribeInsightRules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html).
	//
	// RuleNames is a required field
	RuleNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableInsightRulesInput"}
	if s.RuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleNames sets the RuleNames field's value.
func (s *EnableInsightRulesInput) SetRuleNames(v []*string) *EnableInsightRulesInput {
	s.RuleNames = v
	return s
}

type EnableInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array listing the rules that could not be enabled. You cannot disable
	// or enable built-in rules.
	Failures []*PartialFailure `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableInsightRulesOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *EnableInsightRulesOutput) SetFailures(v []*PartialFailure) *EnableInsightRulesOutput {
	s.Failures = v
	return s
}

type GetDashboardInput struct {
	_ struct{} `type:"structure"`

	// The name of the dashboard to be described.
	//
	// DashboardName is a required field
	DashboardName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardInput"}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardName sets the DashboardName field's value.
func (s *GetDashboardInput) SetDashboardName(v string) *GetDashboardInput {
	s.DashboardName = &v
	return s
}

type GetDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The detailed information about the dashboard, including what widgets are
	// included and their location on the dashboard. For more information about
	// the DashboardBody syntax, see Dashboard Body Structure and Syntax (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
	DashboardBody *string `type:"string"`

	// The name of the dashboard.
	DashboardName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *GetDashboardOutput) SetDashboardArn(v string) *GetDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardBody sets the DashboardBody field's value.
func (s *GetDashboardOutput) SetDashboardBody(v string) *GetDashboardOutput {
	s.DashboardBody = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *GetDashboardOutput) SetDashboardName(v string) *GetDashboardOutput {
	s.DashboardName = &v
	return s
}

type GetInsightRuleReportInput struct {
	_ struct{} `type:"structure"`

	// The end time of the data to use in the report. When used in a raw HTTP Query
	// API, it is formatted as yyyy-MM-dd'T'HH:mm:ss. For example, 2019-07-01T23:59:59.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The maximum number of contributors to include in the report. The range is
	// 1 to 100. If you omit this, the default of 10 is used.
	MaxContributorCount *int64 `type:"integer"`

	// Specifies which metrics to use for aggregation of contributor values for
	// the report. You can specify one or more of the following metrics:
	//
	//    * UniqueContributors -- the number of unique contributors for each data
	//    point.
	//
	//    * MaxContributorValue -- the value of the top contributor for each data
	//    point. The identity of the contributor might change for each data point
	//    in the graph. If this rule aggregates by COUNT, the top contributor for
	//    each data point is the contributor with the most occurrences in that period.
	//    If the rule aggregates by SUM, the top contributor is the contributor
	//    with the highest sum in the log field specified by the rule's Value, during
	//    that period.
	//
	//    * SampleCount -- the number of data points matched by the rule.
	//
	//    * Sum -- the sum of the values from all contributors during the time period
	//    represented by that data point.
	//
	//    * Minimum -- the minimum value from a single observation during the time
	//    period represented by that data point.
	//
	//    * Maximum -- the maximum value from a single observation during the time
	//    period represented by that data point.
	//
	//    * Average -- the average value from all contributors during the time period
	//    represented by that data point.
	Metrics []*string `type:"list"`

	// Determines what statistic to use to rank the contributors. Valid values are
	// SUM and MAXIMUM.
	OrderBy *string `min:"1" type:"string"`

	// The period, in seconds, to use for the statistics in the InsightRuleMetricDatapoint
	// results.
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The name of the rule that you want to see data from.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// The start time of the data to use in the report. When used in a raw HTTP
	// Query API, it is formatted as yyyy-MM-dd'T'HH:mm:ss. For example, 2019-07-01T23:59:59.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightRuleReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightRuleReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightRuleReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightRuleReportInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.OrderBy != nil && len(*s.OrderBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrderBy", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetInsightRuleReportInput) SetEndTime(v time.Time) *GetInsightRuleReportInput {
	s.EndTime = &v
	return s
}

// SetMaxContributorCount sets the MaxContributorCount field's value.
func (s *GetInsightRuleReportInput) SetMaxContributorCount(v int64) *GetInsightRuleReportInput {
	s.MaxContributorCount = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetInsightRuleReportInput) SetMetrics(v []*string) *GetInsightRuleReportInput {
	s.Metrics = v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *GetInsightRuleReportInput) SetOrderBy(v string) *GetInsightRuleReportInput {
	s.OrderBy = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetInsightRuleReportInput) SetPeriod(v int64) *GetInsightRuleReportInput {
	s.Period = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *GetInsightRuleReportInput) SetRuleName(v string) *GetInsightRuleReportInput {
	s.RuleName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetInsightRuleReportInput) SetStartTime(v time.Time) *GetInsightRuleReportInput {
	s.StartTime = &v
	return s
}

type GetInsightRuleReportOutput struct {
	_ struct{} `type:"structure"`

	// The sum of the values from all individual contributors that match the rule.
	AggregateValue *float64 `type:"double"`

	// Specifies whether this rule aggregates contributor data by COUNT or SUM.
	AggregationStatistic *string `type:"string"`

	// An approximate count of the unique contributors found by this rule in this
	// time period.
	ApproximateUniqueCount *int64 `type:"long"`

	// An array of the unique contributors found by this rule in this time period.
	// If the rule contains multiple keys, each combination of values for the keys
	// counts as a unique contributor.
	Contributors []*InsightRuleContributor `type:"list"`

	// An array of the strings used as the keys for this rule. The keys are the
	// dimensions used to classify contributors. If the rule contains more than
	// one key, then each unique combination of values for the keys is counted as
	// a unique contributor.
	KeyLabels []*string `type:"list"`

	// A time series of metric data points that matches the time period in the rule
	// request.
	MetricDatapoints []*InsightRuleMetricDatapoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightRuleReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightRuleReportOutput) GoString() string {
	return s.String()
}

// SetAggregateValue sets the AggregateValue field's value.
func (s *GetInsightRuleReportOutput) SetAggregateValue(v float64) *GetInsightRuleReportOutput {
	s.AggregateValue = &v
	return s
}

// SetAggregationStatistic sets the AggregationStatistic field's value.
func (s *GetInsightRuleReportOutput) SetAggregationStatistic(v string) *GetInsightRuleReportOutput {
	s.AggregationStatistic = &v
	return s
}

// SetApproximateUniqueCount sets the ApproximateUniqueCount field's value.
func (s *GetInsightRuleReportOutput) SetApproximateUniqueCount(v int64) *GetInsightRuleReportOutput {
	s.ApproximateUniqueCount = &v
	return s
}

// SetContributors sets the Contributors field's value.
func (s *GetInsightRuleReportOutput) SetContributors(v []*InsightRuleContributor) *GetInsightRuleReportOutput {
	s.Contributors = v
	return s
}

// SetKeyLabels sets the KeyLabels field's value.
func (s *GetInsightRuleReportOutput) SetKeyLabels(v []*string) *GetInsightRuleReportOutput {
	s.KeyLabels = v
	return s
}

// SetMetricDatapoints sets the MetricDatapoints field's value.
func (s *GetInsightRuleReportOutput) SetMetricDatapoints(v []*InsightRuleMetricDatapoint) *GetInsightRuleReportOutput {
	s.MetricDatapoints = v
	return s
}

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The time stamp indicating the latest data to be returned.
	//
	// The value specified is exclusive; results include data points up to the specified
	// time stamp.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as EndTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the EndTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// This structure includes the Timezone parameter, which you can use to specify
	// your time zone so that the labels of returned data display the correct time
	// for your time zone.
	LabelOptions *LabelOptions `type:"structure"`

	// The maximum number of data points the request should return before paginating.
	// If you omit this, the default of 100,800 is used.
	MaxDatapoints *int64 `type:"integer"`

	// The metric queries to be returned. A single GetMetricData call can include
	// as many as 500 MetricDataQuery structures. Each of these structures can specify
	// either a metric to retrieve, a Metrics Insights query, or a math expression
	// to perform on retrieved data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`

	// Include this value, if it was returned by the previous GetMetricData operation,
	// to get the next set of data points.
	NextToken *string `type:"string"`

	// The order in which data points should be returned. TimestampDescending returns
	// the newest data first and paginates when the MaxDatapoints limit is reached.
	// TimestampAscending returns the oldest data first and paginates when the MaxDatapoints
	// limit is reached.
	ScanBy *string `type:"string" enum:"ScanBy"`

	// The time stamp indicating the earliest data to be returned.
	//
	// The value specified is inclusive; results include data points with the specified
	// time stamp.
	//
	// CloudWatch rounds the specified time stamp as follows:
	//
	//    * Start time less than 15 days ago - Round down to the nearest whole minute.
	//    For example, 12:32:34 is rounded down to 12:32:00.
	//
	//    * Start time between 15 and 63 days ago - Round down to the nearest 5-minute
	//    clock interval. For example, 12:32:34 is rounded down to 12:30:00.
	//
	//    * Start time greater than 63 days ago - Round down to the nearest 1-hour
	//    clock interval. For example, 12:32:34 is rounded down to 12:00:00.
	//
	// If you set Period to 5, 10, or 30, the start time of your request is rounded
	// down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions
	// of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for
	// the previous 10-second period, the start time of your request is rounded
	// down and you receive data from 01:05:10 to 01:05:20. If you make a query
	// at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds,
	// you receive data timestamped between 15:02:15 and 15:07:15.
	//
	// For better performance, specify StartTime and EndTime values that align with
	// the value of the metric's Period and sync up with the beginning and end of
	// an hour. For example, if the Period of a metric is 5 minutes, specifying
	// 12:05 or 12:30 as StartTime can get a faster response from CloudWatch than
	// setting 12:07 or 12:29 as the StartTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MetricDataQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDataQueries"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricDataInput) SetEndTime(v time.Time) *GetMetricDataInput {
	s.EndTime = &v
	return s
}

// SetLabelOptions sets the LabelOptions field's value.
func (s *GetMetricDataInput) SetLabelOptions(v *LabelOptions) *GetMetricDataInput {
	s.LabelOptions = v
	return s
}

// SetMaxDatapoints sets the MaxDatapoints field's value.
func (s *GetMetricDataInput) SetMaxDatapoints(v int64) *GetMetricDataInput {
	s.MaxDatapoints = &v
	return s
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *GetMetricDataInput) SetMetricDataQueries(v []*MetricDataQuery) *GetMetricDataInput {
	s.MetricDataQueries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataInput) SetNextToken(v string) *GetMetricDataInput {
	s.NextToken = &v
	return s
}

// SetScanBy sets the ScanBy field's value.
func (s *GetMetricDataInput) SetScanBy(v string) *GetMetricDataInput {
	s.ScanBy = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricDataInput) SetStartTime(v time.Time) *GetMetricDataInput {
	s.StartTime = &v
	return s
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// Contains a message about this GetMetricData operation, if the operation results
	// in such a message. An example of a message that might be returned is Maximum
	// number of allowed metrics exceeded. If there is a message, as much of the
	// operation as possible is still executed.
	//
	// A message appears here only if it is related to the global GetMetricData
	// operation. Any message about a specific metric returned by the operation
	// appears in the MetricDataResult object returned for that metric.
	Messages []*MessageData `type:"list"`

	// The metrics that are returned, including the metric name, namespace, and
	// dimensions.
	MetricDataResults []*MetricDataResult `type:"list"`

	// A token that marks the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricDataOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *GetMetricDataOutput) SetMessages(v []*MessageData) *GetMetricDataOutput {
	s.Messages = v
	return s
}

// SetMetricDataResults sets the MetricDataResults field's value.
func (s *GetMetricDataOutput) SetMetricDataResults(v []*MetricDataResult) *GetMetricDataOutput {
	s.MetricDataResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataOutput) SetNextToken(v string) *GetMetricDataOutput {
	s.NextToken = &v
	return s
}

type GetMetricStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions. If the metric contains multiple dimensions, you must include
	// a value for each dimension. CloudWatch treats each unique combination of
	// dimensions as a separate metric. If a specific combination of dimensions
	// was not published, you can't retrieve statistics for it. You must specify
	// the same dimensions that were used when the metrics were created. For an
	// example, see Dimension Combinations (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations)
	// in the Amazon CloudWatch User Guide. For more information about specifying
	// dimensions, see Publishing Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
	// in the Amazon CloudWatch User Guide.
	Dimensions []*Dimension `type:"list"`

	// The time stamp that determines the last data point to return.
	//
	// The value specified is exclusive; results include data points up to the specified
	// time stamp. In a raw HTTP query, the time stamp must be in ISO 8601 UTC format
	// (for example, 2016-10-10T23:00:00Z).
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The percentile statistics. Specify values between p0.0 and p100. When calling
	// GetMetricStatistics, you must specify either Statistics or ExtendedStatistics,
	// but not both. Percentile statistics are not available for metrics when any
	// of the metric values are negative numbers.
	ExtendedStatistics []*string `min:"1" type:"list"`

	// The name of the metric, with or without spaces.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric, with or without spaces.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The granularity, in seconds, of the returned data points. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and
	// must be a multiple of 60. For high-resolution metrics that are collected
	// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
	// or any multiple of 60. High-resolution metrics are those metrics stored by
	// a PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3
	// hours ago, you must specify the period as follows or no data points in that
	// time range is returned:
	//
	//    * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//    (1 minute).
	//
	//    * Start time between 15 and 63 days ago - Use a multiple of 300 seconds
	//    (5 minutes).
	//
	//    * Start time greater than 63 days ago - Use a multiple of 3600 seconds
	//    (1 hour).
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The time stamp that determines the first data point to return. Start times
	// are evaluated relative to the time that CloudWatch receives the request.
	//
	// The value specified is inclusive; results include data points with the specified
	// time stamp. In a raw HTTP query, the time stamp must be in ISO 8601 UTC format
	// (for example, 2016-10-03T23:00:00Z).
	//
	// CloudWatch rounds the specified time stamp as follows:
	//
	//    * Start time less than 15 days ago - Round down to the nearest whole minute.
	//    For example, 12:32:34 is rounded down to 12:32:00.
	//
	//    * Start time between 15 and 63 days ago - Round down to the nearest 5-minute
	//    clock interval. For example, 12:32:34 is rounded down to 12:30:00.
	//
	//    * Start time greater than 63 days ago - Round down to the nearest 1-hour
	//    clock interval. For example, 12:32:34 is rounded down to 12:00:00.
	//
	// If you set Period to 5, 10, or 30, the start time of your request is rounded
	// down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions
	// of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for
	// the previous 10-second period, the start time of your request is rounded
	// down and you receive data from 01:05:10 to 01:05:20. If you make a query
	// at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds,
	// you receive data timestamped between 15:02:15 and 15:07:15.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The metric statistics, other than percentile. For percentile statistics,
	// use ExtendedStatistics. When calling GetMetricStatistics, you must specify
	// either Statistics or ExtendedStatistics, but not both.
	Statistics []*string `min:"1" type:"list" enum:"Statistic"`

	// The unit for a given metric. If you omit Unit, all data that was collected
	// with any unit is returned, along with the corresponding units that were specified
	// when the data was reported to CloudWatch. If you specify a unit, the operation
	// returns only data that was collected with that unit specified. If you specify
	// a unit that does not match the data collected, the results of the operation
	// are null. CloudWatch does not perform unit conversions.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricStatisticsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.ExtendedStatistics != nil && len(s.ExtendedStatistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtendedStatistics", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics != nil && len(s.Statistics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statistics", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *GetMetricStatisticsInput) SetDimensions(v []*Dimension) *GetMetricStatisticsInput {
	s.Dimensions = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricStatisticsInput) SetEndTime(v time.Time) *GetMetricStatisticsInput {
	s.EndTime = &v
	return s
}

// SetExtendedStatistics sets the ExtendedStatistics field's value.
func (s *GetMetricStatisticsInput) SetExtendedStatistics(v []*string) *GetMetricStatisticsInput {
	s.ExtendedStatistics = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetMetricStatisticsInput) SetMetricName(v string) *GetMetricStatisticsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetMetricStatisticsInput) SetNamespace(v string) *GetMetricStatisticsInput {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetMetricStatisticsInput) SetPeriod(v int64) *GetMetricStatisticsInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricStatisticsInput) SetStartTime(v time.Time) *GetMetricStatisticsInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetMetricStatisticsInput) SetStatistics(v []*string) *GetMetricStatisticsInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetMetricStatisticsInput) SetUnit(v string) *GetMetricStatisticsInput {
	s.Unit = &v
	return s
}

type GetMetricStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The data points for the specified metric.
	Datapoints []*Datapoint `type:"list"`

	// A label for the specified metric.
	Label *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStatisticsOutput) GoString() string {
	return s.String()
}

// SetDatapoints sets the Datapoints field's value.
func (s *GetMetricStatisticsOutput) SetDatapoints(v []*Datapoint) *GetMetricStatisticsOutput {
	s.Datapoints = v
	return s
}

// SetLabel sets the Label field's value.
func (s *GetMetricStatisticsOutput) SetLabel(v string) *GetMetricStatisticsOutput {
	s.Label = &v
	return s
}

type GetMetricStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the metric stream to retrieve information about.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricStreamInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetMetricStreamInput) SetName(v string) *GetMetricStreamInput {
	s.Name = &v
	return s
}

type GetMetricStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the metric stream.
	Arn *string `min:"1" type:"string"`

	// The date that the metric stream was created.
	CreationDate *time.Time `type:"timestamp"`

	// If this array of metric namespaces is present, then these namespaces are
	// the only metric namespaces that are not streamed by this metric stream. In
	// this case, all other metric namespaces in the account are streamed by this
	// metric stream.
	ExcludeFilters []*MetricStreamFilter `type:"list"`

	// The ARN of the Amazon Kinesis Data Firehose delivery stream that is used
	// by this metric stream.
	FirehoseArn *string `min:"1" type:"string"`

	// If this array of metric namespaces is present, then these namespaces are
	// the only metric namespaces that are streamed by this metric stream.
	IncludeFilters []*MetricStreamFilter `type:"list"`

	// The date of the most recent update to the metric stream's configuration.
	LastUpdateDate *time.Time `type:"timestamp"`

	// The name of the metric stream.
	Name *string `min:"1" type:"string"`

	// The output format for the stream. Valid values are json and opentelemetry0.7.
	// For more information about metric stream output formats, see Metric streams
	// output formats (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
	OutputFormat *string `min:"1" type:"string" enum:"MetricStreamOutputFormat"`

	// The ARN of the IAM role that is used by this metric stream.
	RoleArn *string `min:"1" type:"string"`

	// The state of the metric stream. The possible values are running and stopped.
	State *string `type:"string"`

	// Each entry in this array displays information about one or more metrics that
	// include additional statistics in the metric stream. For more information
	// about the additional statistics, see CloudWatch statistics definitions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
	StatisticsConfigurations []*MetricStreamStatisticsConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricStreamOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetMetricStreamOutput) SetArn(v string) *GetMetricStreamOutput {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetMetricStreamOutput) SetCreationDate(v time.Time) *GetMetricStreamOutput {
	s.CreationDate = &v
	return s
}

// SetExcludeFilters sets the ExcludeFilters field's value.
func (s *GetMetricStreamOutput) SetExcludeFilters(v []*MetricStreamFilter) *GetMetricStreamOutput {
	s.ExcludeFilters = v
	return s
}

// SetFirehoseArn sets the FirehoseArn field's value.
func (s *GetMetricStreamOutput) SetFirehoseArn(v string) *GetMetricStreamOutput {
	s.FirehoseArn = &v
	return s
}

// SetIncludeFilters sets the IncludeFilters field's value.
func (s *GetMetricStreamOutput) SetIncludeFilters(v []*MetricStreamFilter) *GetMetricStreamOutput {
	s.IncludeFilters = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *GetMetricStreamOutput) SetLastUpdateDate(v time.Time) *GetMetricStreamOutput {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMetricStreamOutput) SetName(v string) *GetMetricStreamOutput {
	s.Name = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *GetMetricStreamOutput) SetOutputFormat(v string) *GetMetricStreamOutput {
	s.OutputFormat = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetMetricStreamOutput) SetRoleArn(v string) *GetMetricStreamOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *GetMetricStreamOutput) SetState(v string) *GetMetricStreamOutput {
	s.State = &v
	return s
}

// SetStatisticsConfigurations sets the StatisticsConfigurations field's value.
func (s *GetMetricStreamOutput) SetStatisticsConfigurations(v []*MetricStreamStatisticsConfiguration) *GetMetricStreamOutput {
	s.StatisticsConfigurations = v
	return s
}

type GetMetricWidgetImageInput struct {
	_ struct{} `type:"structure"`

	// A JSON string that defines the bitmap graph to be retrieved. The string includes
	// the metrics to include in the graph, statistics, annotations, title, axis
	// limits, and so on. You can include only one MetricWidget parameter in each
	// GetMetricWidgetImage call.
	//
	// For more information about the syntax of MetricWidget see GetMetricWidgetImage:
	// Metric Widget Structure and Syntax (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html).
	//
	// If any metric on the graph could not load all the requested data points,
	// an orange triangle with an exclamation point appears next to the graph legend.
	//
	// MetricWidget is a required field
	MetricWidget *string `type:"string" required:"true"`

	// The format of the resulting image. Only PNG images are supported.
	//
	// The default is png. If you specify png, the API returns an HTTP response
	// with the content-type set to text/xml. The image data is in a MetricWidgetImage
	// field. For example:
	//
	// <GetMetricWidgetImageResponse xmlns=<URLstring>>
	//
	// <GetMetricWidgetImageResult>
	//
	// <MetricWidgetImage>
	//
	// iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...
	//
	// </MetricWidgetImage>
	//
	// </GetMetricWidgetImageResult>
	//
	// <ResponseMetadata>
	//
	// <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>
	//
	// </ResponseMetadata>
	//
	// </GetMetricWidgetImageResponse>
	//
	// The image/png setting is intended only for custom HTTP requests. For most
	// use cases, and all actions using an Amazon Web Services SDK, you should use
	// png. If you specify image/png, the HTTP response has a content-type set to
	// image/png, and the body of the response is a PNG image.
	OutputFormat *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricWidgetImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricWidgetImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricWidgetImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricWidgetImageInput"}
	if s.MetricWidget == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricWidget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricWidget sets the MetricWidget field's value.
func (s *GetMetricWidgetImageInput) SetMetricWidget(v string) *GetMetricWidgetImageInput {
	s.MetricWidget = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *GetMetricWidgetImageInput) SetOutputFormat(v string) *GetMetricWidgetImageInput {
	s.OutputFormat = &v
	return s
}

type GetMetricWidgetImageOutput struct {
	_ struct{} `type:"structure"`

	// The image of the graph, in the output format specified. The output is base64-encoded.
	// MetricWidgetImage is automatically base64 encoded/decoded by the SDK.
	MetricWidgetImage []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricWidgetImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricWidgetImageOutput) GoString() string {
	return s.String()
}

// SetMetricWidgetImage sets the MetricWidgetImage field's value.
func (s *GetMetricWidgetImageOutput) SetMetricWidgetImage(v []byte) *GetMetricWidgetImageOutput {
	s.MetricWidgetImage = v
	return s
}

// This structure contains the definition for a Contributor Insights rule. For
// more information about this rule, see Using Constributor Insights to analyze
// high-cardinality data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html)
// in the Amazon CloudWatch User Guide.
type InsightRule struct {
	_ struct{} `type:"structure"`

	// The definition of the rule, as a JSON object. The definition contains the
	// keywords used to define contributors, the value to aggregate on if this rule
	// returns a sum instead of a count, and the filters. For details on the valid
	// syntax, see Contributor Insights Rule Syntax (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
	//
	// Definition is a required field
	Definition *string `min:"1" type:"string" required:"true"`

	// An optional built-in rule that Amazon Web Services manages.
	ManagedRule *bool `type:"boolean"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For rules that you create, this is always {"Name": "CloudWatchLogRule", "Version":
	// 1}. For managed rules, this is {"Name": "ServiceLogRule", "Version": 1}
	//
	// Schema is a required field
	Schema *string `type:"string" required:"true"`

	// Indicates whether the rule is enabled or disabled.
	//
	// State is a required field
	State *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRule) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *InsightRule) SetDefinition(v string) *InsightRule {
	s.Definition = &v
	return s
}

// SetManagedRule sets the ManagedRule field's value.
func (s *InsightRule) SetManagedRule(v bool) *InsightRule {
	s.ManagedRule = &v
	return s
}

// SetName sets the Name field's value.
func (s *InsightRule) SetName(v string) *InsightRule {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *InsightRule) SetSchema(v string) *InsightRule {
	s.Schema = &v
	return s
}

// SetState sets the State field's value.
func (s *InsightRule) SetState(v string) *InsightRule {
	s.State = &v
	return s
}

// One of the unique contributors found by a Contributor Insights rule. If the
// rule contains multiple keys, then a unique contributor is a unique combination
// of values from all the keys in the rule.
//
// If the rule contains a single key, then each unique contributor is each unique
// value for this key.
//
// For more information, see GetInsightRuleReport (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html).
type InsightRuleContributor struct {
	_ struct{} `type:"structure"`

	// An approximation of the aggregate value that comes from this contributor.
	//
	// ApproximateAggregateValue is a required field
	ApproximateAggregateValue *float64 `type:"double" required:"true"`

	// An array of the data points where this contributor is present. Only the data
	// points when this contributor appeared are included in the array.
	//
	// Datapoints is a required field
	Datapoints []*InsightRuleContributorDatapoint `type:"list" required:"true"`

	// One of the log entry field keywords that is used to define contributors for
	// this rule.
	//
	// Keys is a required field
	Keys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleContributor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleContributor) GoString() string {
	return s.String()
}

// SetApproximateAggregateValue sets the ApproximateAggregateValue field's value.
func (s *InsightRuleContributor) SetApproximateAggregateValue(v float64) *InsightRuleContributor {
	s.ApproximateAggregateValue = &v
	return s
}

// SetDatapoints sets the Datapoints field's value.
func (s *InsightRuleContributor) SetDatapoints(v []*InsightRuleContributorDatapoint) *InsightRuleContributor {
	s.Datapoints = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *InsightRuleContributor) SetKeys(v []*string) *InsightRuleContributor {
	s.Keys = v
	return s
}

// One data point related to one contributor.
//
// For more information, see GetInsightRuleReport (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html)
// and InsightRuleContributor (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_InsightRuleContributor.html).
type InsightRuleContributorDatapoint struct {
	_ struct{} `type:"structure"`

	// The approximate value that this contributor added during this timestamp.
	//
	// ApproximateValue is a required field
	ApproximateValue *float64 `type:"double" required:"true"`

	// The timestamp of the data point.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleContributorDatapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleContributorDatapoint) GoString() string {
	return s.String()
}

// SetApproximateValue sets the ApproximateValue field's value.
func (s *InsightRuleContributorDatapoint) SetApproximateValue(v float64) *InsightRuleContributorDatapoint {
	s.ApproximateValue = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *InsightRuleContributorDatapoint) SetTimestamp(v time.Time) *InsightRuleContributorDatapoint {
	s.Timestamp = &v
	return s
}

// One data point from the metric time series returned in a Contributor Insights
// rule report.
//
// For more information, see GetInsightRuleReport (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html).
type InsightRuleMetricDatapoint struct {
	_ struct{} `type:"structure"`

	// The average value from all contributors during the time period represented
	// by that data point.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	Average *float64 `type:"double"`

	// The maximum value provided by one contributor during this timestamp. Each
	// timestamp is evaluated separately, so the identity of the max contributor
	// could be different for each timestamp.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	MaxContributorValue *float64 `type:"double"`

	// The maximum value from a single occurence from a single contributor during
	// the time period represented by that data point.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	Maximum *float64 `type:"double"`

	// The minimum value from a single contributor during the time period represented
	// by that data point.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	Minimum *float64 `type:"double"`

	// The number of occurrences that matched the rule during this data point.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	SampleCount *float64 `type:"double"`

	// The sum of the values from all contributors during the time period represented
	// by that data point.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	Sum *float64 `type:"double"`

	// The timestamp of the data point.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`

	// The number of unique contributors who published data during this timestamp.
	//
	// This statistic is returned only if you included it in the Metrics array in
	// your request.
	UniqueContributors *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleMetricDatapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightRuleMetricDatapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *InsightRuleMetricDatapoint) SetAverage(v float64) *InsightRuleMetricDatapoint {
	s.Average = &v
	return s
}

// SetMaxContributorValue sets the MaxContributorValue field's value.
func (s *InsightRuleMetricDatapoint) SetMaxContributorValue(v float64) *InsightRuleMetricDatapoint {
	s.MaxContributorValue = &v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *InsightRuleMetricDatapoint) SetMaximum(v float64) *InsightRuleMetricDatapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *InsightRuleMetricDatapoint) SetMinimum(v float64) *InsightRuleMetricDatapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *InsightRuleMetricDatapoint) SetSampleCount(v float64) *InsightRuleMetricDatapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *InsightRuleMetricDatapoint) SetSum(v float64) *InsightRuleMetricDatapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *InsightRuleMetricDatapoint) SetTimestamp(v time.Time) *InsightRuleMetricDatapoint {
	s.Timestamp = &v
	return s
}

// SetUniqueContributors sets the UniqueContributors field's value.
func (s *InsightRuleMetricDatapoint) SetUniqueContributors(v float64) *InsightRuleMetricDatapoint {
	s.UniqueContributors = &v
	return s
}

// This structure includes the Timezone parameter, which you can use to specify
// your time zone so that the labels that are associated with returned metrics
// display the correct time for your time zone.
//
// The Timezone value affects a label only if you have a time-based dynamic
// expression in the label. For more information about dynamic expressions in
// labels, see Using Dynamic Labels (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html).
type LabelOptions struct {
	_ struct{} `type:"structure"`

	// The time zone to use for metric data return in this operation. The format
	// is + or - followed by four digits. The first two digits indicate the number
	// of hours ahead or behind of UTC, and the final two digits are the number
	// of minutes. For example, +0130 indicates a time zone that is 1 hour and 30
	// minutes ahead of UTC. The default is +0000.
	Timezone *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelOptions) GoString() string {
	return s.String()
}

// SetTimezone sets the Timezone field's value.
func (s *LabelOptions) SetTimezone(v string) *LabelOptions {
	s.Timezone = &v
	return s
}

type ListDashboardsInput struct {
	_ struct{} `type:"structure"`

	// If you specify this parameter, only the dashboards with names starting with
	// the specified string are listed. The maximum length is 255, and valid characters
	// are A-Z, a-z, 0-9, ".", "-", and "_".
	DashboardNamePrefix *string `type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsInput) GoString() string {
	return s.String()
}

// SetDashboardNamePrefix sets the DashboardNamePrefix field's value.
func (s *ListDashboardsInput) SetDashboardNamePrefix(v string) *ListDashboardsInput {
	s.DashboardNamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsInput) SetNextToken(v string) *ListDashboardsInput {
	s.NextToken = &v
	return s
}

type ListDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching dashboards.
	DashboardEntries []*DashboardEntry `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDashboardsOutput) GoString() string {
	return s.String()
}

// SetDashboardEntries sets the DashboardEntries field's value.
func (s *ListDashboardsOutput) SetDashboardEntries(v []*DashboardEntry) *ListDashboardsOutput {
	s.DashboardEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsOutput) SetNextToken(v string) *ListDashboardsOutput {
	s.NextToken = &v
	return s
}

type ListManagedInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default number is used. The default number is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Include this value to get the next set of rules if the value was returned
	// by the previous operation.
	NextToken *string `type:"string"`

	// The ARN of an Amazon Web Services resource that has managed Contributor Insights
	// rules.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedInsightRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedInsightRulesInput) SetMaxResults(v int64) *ListManagedInsightRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedInsightRulesInput) SetNextToken(v string) *ListManagedInsightRulesInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListManagedInsightRulesInput) SetResourceARN(v string) *ListManagedInsightRulesInput {
	s.ResourceARN = &v
	return s
}

type ListManagedInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// The managed rules that are available for the specified Amazon Web Services
	// resource.
	ManagedRules []*ManagedRuleDescription `type:"list"`

	// Include this value to get the next set of rules if the value was returned
	// by the previous operation.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedInsightRulesOutput) GoString() string {
	return s.String()
}

// SetManagedRules sets the ManagedRules field's value.
func (s *ListManagedInsightRulesOutput) SetManagedRules(v []*ManagedRuleDescription) *ListManagedInsightRulesOutput {
	s.ManagedRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedInsightRulesOutput) SetNextToken(v string) *ListManagedInsightRulesOutput {
	s.NextToken = &v
	return s
}

type ListMetricStreamsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one operation.
	MaxResults *int64 `min:"1" type:"integer"`

	// Include this value, if it was returned by the previous call, to get the next
	// set of metric streams.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMetricStreamsInput) SetMaxResults(v int64) *ListMetricStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricStreamsInput) SetNextToken(v string) *ListMetricStreamsInput {
	s.NextToken = &v
	return s
}

type ListMetricStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The array of metric stream information.
	Entries []*MetricStreamEntry `type:"list"`

	// The token that marks the start of the next batch of returned results. You
	// can use this token in a subsequent operation to get the next batch of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricStreamsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListMetricStreamsOutput) SetEntries(v []*MetricStreamEntry) *ListMetricStreamsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricStreamsOutput) SetNextToken(v string) *ListMetricStreamsOutput {
	s.NextToken = &v
	return s
}

type ListMetricsInput struct {
	_ struct{} `type:"structure"`

	// The dimensions to filter against. Only the dimensions that match exactly
	// will be returned.
	Dimensions []*DimensionFilter `type:"list"`

	// If you are using this operation in a monitoring account, specify true to
	// include metrics from source accounts in the returned data.
	//
	// The default is false.
	IncludeLinkedAccounts *bool `type:"boolean"`

	// The name of the metric to filter against. Only the metrics with names that
	// match exactly will be returned.
	MetricName *string `min:"1" type:"string"`

	// The metric namespace to filter against. Only the namespace that matches exactly
	// will be returned.
	Namespace *string `min:"1" type:"string"`

	// The token returned by a previous call to indicate that there is more data
	// available.
	NextToken *string `type:"string"`

	// When you use this operation in a monitoring account, use this field to return
	// metrics only from one source account. To do so, specify that source account
	// ID in this field, and also specify true for IncludeLinkedAccounts.
	OwningAccount *string `min:"1" type:"string"`

	// To filter the results to show only metrics that have had data points published
	// in the past three hours, specify this parameter with a value of PT3H. This
	// is the only valid value for this parameter.
	//
	// The results that are returned are an approximation of the value you specify.
	// There is a low probability that the returned results include metrics with
	// last published data as much as 40 minutes more than the specified time interval.
	RecentlyActive *string `type:"string" enum:"RecentlyActive"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMetricsInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.OwningAccount != nil && len(*s.OwningAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwningAccount", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *ListMetricsInput) SetDimensions(v []*DimensionFilter) *ListMetricsInput {
	s.Dimensions = v
	return s
}

// SetIncludeLinkedAccounts sets the IncludeLinkedAccounts field's value.
func (s *ListMetricsInput) SetIncludeLinkedAccounts(v bool) *ListMetricsInput {
	s.IncludeLinkedAccounts = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ListMetricsInput) SetMetricName(v string) *ListMetricsInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListMetricsInput) SetNamespace(v string) *ListMetricsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsInput) SetNextToken(v string) *ListMetricsInput {
	s.NextToken = &v
	return s
}

// SetOwningAccount sets the OwningAccount field's value.
func (s *ListMetricsInput) SetOwningAccount(v string) *ListMetricsInput {
	s.OwningAccount = &v
	return s
}

// SetRecentlyActive sets the RecentlyActive field's value.
func (s *ListMetricsInput) SetRecentlyActive(v string) *ListMetricsInput {
	s.RecentlyActive = &v
	return s
}

type ListMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics that match your request.
	Metrics []*Metric `type:"list"`

	// The token that marks the start of the next batch of returned results.
	NextToken *string `type:"string"`

	// If you are using this operation in a monitoring account, this array contains
	// the account IDs of the source accounts where the metrics in the returned
	// data are from.
	//
	// This field is a 1:1 mapping between each metric that is returned and the
	// ID of the owning account.
	OwningAccounts []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMetricsOutput) GoString() string {
	return s.String()
}

// SetMetrics sets the Metrics field's value.
func (s *ListMetricsOutput) SetMetrics(v []*Metric) *ListMetricsOutput {
	s.Metrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMetricsOutput) SetNextToken(v string) *ListMetricsOutput {
	s.NextToken = &v
	return s
}

// SetOwningAccounts sets the OwningAccounts field's value.
func (s *ListMetricsOutput) SetOwningAccounts(v []*string) *ListMetricsOutput {
	s.OwningAccounts = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch resource that you want to view tags for.
	//
	// The ARN format of an alarm is arn:aws:cloudwatch:Region:account-id:alarm:alarm-name
	//
	// The ARN format of a Contributor Insights rule is arn:aws:cloudwatch:Region:account-id:insight-rule:insight-rule-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tag keys and values associated with the resource you specified.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains the information that's required to enable a managed Contributor
// Insights rule for an Amazon Web Services resource.
type ManagedRule struct {
	_ struct{} `type:"structure"`

	// The ARN of an Amazon Web Services resource that has managed Contributor Insights
	// rules.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of key-value pairs that you can associate with a managed Contributor
	// Insights rule. You can associate as many as 50 tags with a rule. Tags can
	// help you organize and categorize your resources. You also can use them to
	// scope user permissions by granting a user permission to access or change
	// only the resources that have certain tag values. To associate tags with a
	// rule, you must have the cloudwatch:TagResource permission in addition to
	// the cloudwatch:PutInsightRule permission. If you are using this operation
	// to update an existing Contributor Insights rule, any tags that you specify
	// in this parameter are ignored. To change the tags of an existing rule, use
	// TagResource.
	Tags []*Tag `type:"list"`

	// The template name for the managed Contributor Insights rule, as returned
	// by ListManagedInsightRules.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedRule"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ManagedRule) SetResourceARN(v string) *ManagedRule {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ManagedRule) SetTags(v []*Tag) *ManagedRule {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ManagedRule) SetTemplateName(v string) *ManagedRule {
	s.TemplateName = &v
	return s
}

// Contains information about managed Contributor Insights rules, as returned
// by ListManagedInsightRules.
type ManagedRuleDescription struct {
	_ struct{} `type:"structure"`

	// If a managed rule is enabled, this is the ARN for the related Amazon Web
	// Services resource.
	ResourceARN *string `min:"1" type:"string"`

	// Describes the state of a managed rule. If present, it contains information
	// about the Contributor Insights rule that contains information about the related
	// Amazon Web Services resource.
	RuleState *ManagedRuleState `type:"structure"`

	// The template name for the managed rule. Used to enable managed rules using
	// PutManagedInsightRules.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ManagedRuleDescription) SetResourceARN(v string) *ManagedRuleDescription {
	s.ResourceARN = &v
	return s
}

// SetRuleState sets the RuleState field's value.
func (s *ManagedRuleDescription) SetRuleState(v *ManagedRuleState) *ManagedRuleDescription {
	s.RuleState = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ManagedRuleDescription) SetTemplateName(v string) *ManagedRuleDescription {
	s.TemplateName = &v
	return s
}

// The status of a managed Contributor Insights rule.
type ManagedRuleState struct {
	_ struct{} `type:"structure"`

	// The name of the Contributor Insights rule that contains data for the specified
	// Amazon Web Services resource.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the rule is enabled or disabled.
	//
	// State is a required field
	State *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleState) GoString() string {
	return s.String()
}

// SetRuleName sets the RuleName field's value.
func (s *ManagedRuleState) SetRuleName(v string) *ManagedRuleState {
	s.RuleName = &v
	return s
}

// SetState sets the State field's value.
func (s *ManagedRuleState) SetState(v string) *ManagedRuleState {
	s.State = &v
	return s
}

// A message returned by the GetMetricDataAPI, including a code and a description.
//
// If a cross-Region GetMetricData operation fails with a code of Forbidden
// and a value of Authentication too complex to retrieve cross region data,
// you can correct the problem by running the GetMetricData operation in the
// same Region where the metric data is.
type MessageData struct {
	_ struct{} `type:"structure"`

	// The error code or status code associated with the message.
	Code *string `type:"string"`

	// The message text.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageData) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *MessageData) SetCode(v string) *MessageData {
	s.Code = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageData) SetValue(v string) *MessageData {
	s.Value = &v
	return s
}

// Represents a specific metric.
type Metric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric. This is a required field.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Metric) SetDimensions(v []*Dimension) *Metric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// The details about a metric alarm.
type MetricAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	AlarmActions []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The number of data points that must be breaching to trigger the alarm.
	DatapointsToAlarm *int64 `min:"1" type:"integer"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []*Dimension `type:"list"`

	// Used only for alarms based on percentiles. If ignore, the alarm state does
	// not change during periods with too few data points to be statistically significant.
	// If evaluate or this parameter is not used, the alarm is always evaluated
	// and possibly changes state no matter how many data points are available.
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// If the value of this field is PARTIAL_DATA, the alarm is being evaluated
	// based on only partial data. This happens if the query used for the alarm
	// returns more than 10,000 metrics. For more information, see Create alarms
	// on Metrics Insights queries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Metrics_Insights_Alarm.html).
	EvaluationState *string `type:"string" enum:"EvaluationState"`

	// The percentile statistic for the metric associated with the alarm. Specify
	// a value between p0.0 and p100.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	InsufficientDataActions []*string `type:"list"`

	// The name of the metric associated with the alarm, if this is an alarm based
	// on a single metric.
	MetricName *string `min:"1" type:"string"`

	// An array of MetricDataQuery structures, used in an alarm based on a metric
	// math expression. Each structure either retrieves a metric or performs a math
	// expression. One item in the Metrics array is the math expression that the
	// alarm watches. This expression by designated by having ReturnData set to
	// true.
	Metrics []*MetricDataQuery `type:"list"`

	// The namespace of the metric associated with the alarm.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	OKActions []*string `type:"list"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"1" type:"integer"`

	// An explanation for the alarm state, in text format.
	StateReason *string `type:"string"`

	// An explanation for the alarm state, in JSON format.
	StateReasonData *string `type:"string"`

	// The date and time that the alarm's StateValue most recently changed.
	StateTransitionedTimestamp *time.Time `type:"timestamp"`

	// The time stamp of the last update to the value of either the StateValue or
	// EvaluationState parameters.
	StateUpdatedTimestamp *time.Time `type:"timestamp"`

	// The state value for the alarm.
	StateValue *string `type:"string" enum:"StateValue"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value to compare with the specified statistic.
	Threshold *float64 `type:"double"`

	// In an alarm based on an anomaly detection model, this is the ID of the ANOMALY_DETECTION_BAND
	// function used as the threshold for the alarm.
	ThresholdMetricId *string `min:"1" type:"string"`

	// Sets how this alarm is to handle missing data points. The valid values are
	// breaching, notBreaching, ignore, and missing. For more information, see Configuring
	// how CloudWatch alarms treat missing data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
	//
	// If this parameter is omitted, the default behavior of missing is used.
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of the metric associated with the alarm.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAlarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricAlarm) GoString() string {
	return s.String()
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *MetricAlarm) SetActionsEnabled(v bool) *MetricAlarm {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *MetricAlarm) SetAlarmActions(v []*string) *MetricAlarm {
	s.AlarmActions = v
	return s
}

// SetAlarmArn sets the AlarmArn field's value.
func (s *MetricAlarm) SetAlarmArn(v string) *MetricAlarm {
	s.AlarmArn = &v
	return s
}

// SetAlarmConfigurationUpdatedTimestamp sets the AlarmConfigurationUpdatedTimestamp field's value.
func (s *MetricAlarm) SetAlarmConfigurationUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.AlarmConfigurationUpdatedTimestamp = &v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *MetricAlarm) SetAlarmDescription(v string) *MetricAlarm {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *MetricAlarm) SetAlarmName(v string) *MetricAlarm {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *MetricAlarm) SetComparisonOperator(v string) *MetricAlarm {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *MetricAlarm) SetDatapointsToAlarm(v int64) *MetricAlarm {
	s.DatapointsToAlarm = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricAlarm) SetDimensions(v []*Dimension) *MetricAlarm {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *MetricAlarm) SetEvaluateLowSampleCountPercentile(v string) *MetricAlarm {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *MetricAlarm) SetEvaluationPeriods(v int64) *MetricAlarm {
	s.EvaluationPeriods = &v
	return s
}

// SetEvaluationState sets the EvaluationState field's value.
func (s *MetricAlarm) SetEvaluationState(v string) *MetricAlarm {
	s.EvaluationState = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *MetricAlarm) SetExtendedStatistic(v string) *MetricAlarm {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *MetricAlarm) SetInsufficientDataActions(v []*string) *MetricAlarm {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricAlarm) SetMetricName(v string) *MetricAlarm {
	s.MetricName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *MetricAlarm) SetMetrics(v []*MetricDataQuery) *MetricAlarm {
	s.Metrics = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *MetricAlarm) SetNamespace(v string) *MetricAlarm {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *MetricAlarm) SetOKActions(v []*string) *MetricAlarm {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricAlarm) SetPeriod(v int64) *MetricAlarm {
	s.Period = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *MetricAlarm) SetStateReason(v string) *MetricAlarm {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *MetricAlarm) SetStateReasonData(v string) *MetricAlarm {
	s.StateReasonData = &v
	return s
}

// SetStateTransitionedTimestamp sets the StateTransitionedTimestamp field's value.
func (s *MetricAlarm) SetStateTransitionedTimestamp(v time.Time) *MetricAlarm {
	s.StateTransitionedTimestamp = &v
	return s
}

// SetStateUpdatedTimestamp sets the StateUpdatedTimestamp field's value.
func (s *MetricAlarm) SetStateUpdatedTimestamp(v time.Time) *MetricAlarm {
	s.StateUpdatedTimestamp = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *MetricAlarm) SetStateValue(v string) *MetricAlarm {
	s.StateValue = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *MetricAlarm) SetStatistic(v string) *MetricAlarm {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *MetricAlarm) SetThreshold(v float64) *MetricAlarm {
	s.Threshold = &v
	return s
}

// SetThresholdMetricId sets the ThresholdMetricId field's value.
func (s *MetricAlarm) SetThresholdMetricId(v string) *MetricAlarm {
	s.ThresholdMetricId = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *MetricAlarm) SetTreatMissingData(v string) *MetricAlarm {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricAlarm) SetUnit(v string) *MetricAlarm {
	s.Unit = &v
	return s
}

// This structure is used in both GetMetricData and PutMetricAlarm. The supported
// use of this structure is different for those two operations.
//
// When used in GetMetricData, it indicates the metric data to return, and whether
// this call is just retrieving a batch set of data for one metric, or is performing
// a Metrics Insights query or a math expression. A single GetMetricData call
// can include up to 500 MetricDataQuery structures.
//
// When used in PutMetricAlarm, it enables you to create an alarm based on a
// metric math expression. Each MetricDataQuery in the array specifies either
// a metric to retrieve, or a math expression to be performed on retrieved metrics.
// A single PutMetricAlarm call can include up to 20 MetricDataQuery structures
// in the array. The 20 structures can include as many as 10 structures that
// contain a MetricStat parameter to retrieve a metric, and as many as 10 structures
// that contain the Expression parameter to perform a math expression. Of those
// Expression structures, one must have true as the value for ReturnData. The
// result of this expression is the value the alarm watches.
//
// Any expression used in a PutMetricAlarm operation must return a single time
// series. For more information, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// Some of the parameters of this structure also have different uses whether
// you are using this structure in a GetMetricData operation or a PutMetricAlarm
// operation. These differences are explained in the following parameter list.
type MetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The ID of the account where the metrics are located.
	//
	// If you are performing a GetMetricData operation in a monitoring account,
	// use this to specify which account to retrieve this metric from.
	//
	// If you are performing a PutMetricAlarm operation, use this to specify which
	// account contains the metric that the alarm is watching.
	AccountId *string `min:"1" type:"string"`

	// This field can contain either a Metrics Insights query, or a metric math
	// expression to be performed on the returned data. For more information about
	// Metrics Insights queries, see Metrics Insights query components and syntax
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage)
	// in the Amazon CloudWatch User Guide.
	//
	// A math expression can use the Id of the other metrics or queries to refer
	// to those metrics, and can also use the Id of other expressions to use the
	// result of those expressions. For more information about metric math expressions,
	// see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	Expression *string `min:"1" type:"string"`

	// A short name used to tie this object to the results in the response. This
	// name must be unique within a single call to GetMetricData. If you are performing
	// math expressions on this set of data, this name represents that data and
	// can serve as a variable in the mathematical expression. The valid characters
	// are letters, numbers, and underscore. The first character must be a lowercase
	// letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is an expression, so that you know what the value represents.
	// If the metric or expression is shown in a CloudWatch dashboard widget, the
	// label is shown. If Label is omitted, CloudWatch generates a default.
	//
	// You can put dynamic expressions into a label, so that it is more descriptive.
	// For more information, see Using Dynamic Labels (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html).
	Label *string `type:"string"`

	// The metric to be returned, along with statistics, period, and units. Use
	// this parameter only if this object is retrieving a metric and not performing
	// a math expression on returned data.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat `type:"structure"`

	// The granularity, in seconds, of the returned data points. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and
	// must be a multiple of 60. For high-resolution metrics that are collected
	// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
	// or any multiple of 60. High-resolution metrics are those metrics stored by
	// a PutMetricData operation that includes a StorageResolution of 1 second.
	Period *int64 `min:"1" type:"integer"`

	// When used in GetMetricData, this option indicates whether to return the timestamps
	// and raw data values of this metric. If you are performing this call just
	// to do math expressions and do not also need the raw data returned, you can
	// specify false. If you omit this, the default of true is used.
	//
	// When used in PutMetricAlarm, specify true for the one expression result to
	// use as the alarm. For all other metrics and expressions in the same PutMetricAlarm
	// operation, specify ReturnData as False.
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDataQuery"}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MetricDataQuery) SetAccountId(v string) *MetricDataQuery {
	s.AccountId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *MetricDataQuery) SetExpression(v string) *MetricDataQuery {
	s.Expression = &v
	return s
}

// SetId sets the Id field's value.
func (s *MetricDataQuery) SetId(v string) *MetricDataQuery {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataQuery) SetLabel(v string) *MetricDataQuery {
	s.Label = &v
	return s
}

// SetMetricStat sets the MetricStat field's value.
func (s *MetricDataQuery) SetMetricStat(v *MetricStat) *MetricDataQuery {
	s.MetricStat = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricDataQuery) SetPeriod(v int64) *MetricDataQuery {
	s.Period = &v
	return s
}

// SetReturnData sets the ReturnData field's value.
func (s *MetricDataQuery) SetReturnData(v bool) *MetricDataQuery {
	s.ReturnData = &v
	return s
}

// A GetMetricData call returns an array of MetricDataResult structures. Each
// of these structures includes the data points for that metric, along with
// the timestamps of those data points and other identifying information.
type MetricDataResult struct {
	_ struct{} `type:"structure"`

	// The short name you specified to represent this metric.
	Id *string `min:"1" type:"string"`

	// The human-readable label associated with the data.
	Label *string `type:"string"`

	// A list of messages with additional information about the data returned.
	Messages []*MessageData `type:"list"`

	// The status of the returned data. Complete indicates that all data points
	// in the requested time range were returned. PartialData means that an incomplete
	// set of data points were returned. You can use the NextToken value that was
	// returned and repeat your request to get more data points. NextToken is not
	// returned if you are performing a math expression. InternalError indicates
	// that an error occurred. Retry your request using NextToken, if present.
	StatusCode *string `type:"string" enum:"StatusCode"`

	// The timestamps for the data points, formatted in Unix timestamp format. The
	// number of timestamps always matches the number of values and the value for
	// Timestamps[x] is Values[x].
	Timestamps []*time.Time `type:"list"`

	// The data points for the metric corresponding to Timestamps. The number of
	// values always matches the number of timestamps and the timestamp for Values[x]
	// is Timestamps[x].
	Values []*float64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataResult) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *MetricDataResult) SetId(v string) *MetricDataResult {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataResult) SetLabel(v string) *MetricDataResult {
	s.Label = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *MetricDataResult) SetMessages(v []*MessageData) *MetricDataResult {
	s.Messages = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MetricDataResult) SetStatusCode(v string) *MetricDataResult {
	s.StatusCode = &v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *MetricDataResult) SetTimestamps(v []*time.Time) *MetricDataResult {
	s.Timestamps = v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDataResult) SetValues(v []*float64) *MetricDataResult {
	s.Values = v
	return s
}

// Encapsulates the information sent to either create a metric or add new values
// to be aggregated into an existing metric.
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// Array of numbers that is used along with the Values array. Each number in
	// the Count array is the number of times the corresponding value in the Values
	// array occurred during the period.
	//
	// If you omit the Counts array, the default of 1 is used as the value for each
	// count. If you include a Counts array, it must include the same amount of
	// values as the Values array.
	Counts []*float64 `type:"list"`

	// The dimensions associated with the metric.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The statistical values for the metric.
	StatisticValues *StatisticSet `type:"structure"`

	// Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution
	// metric, so that CloudWatch stores the metric with sub-minute resolution down
	// to one second. Setting this to 60 specifies this metric as a regular-resolution
	// metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution
	// is available only for custom metrics. For more information about high-resolution
	// metrics, see High-Resolution Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics)
	// in the Amazon CloudWatch User Guide.
	//
	// This field is optional, if you do not specify it the default of 60 is used.
	StorageResolution *int64 `min:"1" type:"integer"`

	// The time the metric data was received, expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	Timestamp *time.Time `type:"timestamp"`

	// When you are using a Put operation, this defines what unit you want to use
	// when storing the metric.
	//
	// In a Get operation, this displays the unit that is used for the metric.
	Unit *string `type:"string" enum:"StandardUnit"`

	// The value for the metric.
	//
	// Although the parameter accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
	// -Infinity) are not supported.
	Value *float64 `type:"double"`

	// Array of numbers representing the values for the metric during the period.
	// Each unique value is listed just once in this array, and the corresponding
	// number in the Counts array specifies the number of times that value occurred
	// during the period. You can include up to 150 unique values in each PutMetricData
	// action that specifies a Values array.
	//
	// Although the Values array accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
	// -Infinity) are not supported.
	Values []*float64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDatum) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDatum"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.StorageResolution != nil && *s.StorageResolution < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StorageResolution", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatisticValues != nil {
		if err := s.StatisticValues.Validate(); err != nil {
			invalidParams.AddNested("StatisticValues", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCounts sets the Counts field's value.
func (s *MetricDatum) SetCounts(v []*float64) *MetricDatum {
	s.Counts = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricDatum) SetDimensions(v []*Dimension) *MetricDatum {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricDatum) SetMetricName(v string) *MetricDatum {
	s.MetricName = &v
	return s
}

// SetStatisticValues sets the StatisticValues field's value.
func (s *MetricDatum) SetStatisticValues(v *StatisticSet) *MetricDatum {
	s.StatisticValues = v
	return s
}

// SetStorageResolution sets the StorageResolution field's value.
func (s *MetricDatum) SetStorageResolution(v int64) *MetricDatum {
	s.StorageResolution = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatum) SetTimestamp(v time.Time) *MetricDatum {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatum) SetUnit(v string) *MetricDatum {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDatum) SetValue(v float64) *MetricDatum {
	s.Value = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetricDatum) SetValues(v []*float64) *MetricDatum {
	s.Values = v
	return s
}

// Indicates the CloudWatch math expression that provides the time series the
// anomaly detector uses as input. The designated math expression must return
// a single time series.
type MetricMathAnomalyDetector struct {
	_ struct{} `type:"structure"`

	// An array of metric data query structures that enables you to create an anomaly
	// detector based on the result of a metric math expression. Each item in MetricDataQueries
	// gets a metric or performs a math expression. One item in MetricDataQueries
	// is the expression that provides the time series that the anomaly detector
	// uses as input. Designate the expression by setting ReturnData to true for
	// this object in the array. For all other expressions and metrics, set ReturnData
	// to false. The designated expression must return a single time series.
	MetricDataQueries []*MetricDataQuery `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMathAnomalyDetector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricMathAnomalyDetector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricMathAnomalyDetector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricMathAnomalyDetector"}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *MetricMathAnomalyDetector) SetMetricDataQueries(v []*MetricDataQuery) *MetricMathAnomalyDetector {
	s.MetricDataQueries = v
	return s
}

// This structure defines the metric to be returned, along with the statistics,
// period, and units.
type MetricStat struct {
	_ struct{} `type:"structure"`

	// The metric to return, including the metric name, namespace, and dimensions.
	//
	// Metric is a required field
	Metric *Metric `type:"structure" required:"true"`

	// The granularity, in seconds, of the returned data points. For metrics with
	// regular resolution, a period can be as short as one minute (60 seconds) and
	// must be a multiple of 60. For high-resolution metrics that are collected
	// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60,
	// or any multiple of 60. High-resolution metrics are those metrics stored by
	// a PutMetricData call that includes a StorageResolution of 1 second.
	//
	// If the StartTime parameter specifies a time stamp that is greater than 3
	// hours ago, you must specify the period as follows or no data points in that
	// time range is returned:
	//
	//    * Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds
	//    (1 minute).
	//
	//    * Start time between 15 and 63 days ago - Use a multiple of 300 seconds
	//    (5 minutes).
	//
	//    * Start time greater than 63 days ago - Use a multiple of 3600 seconds
	//    (1 hour).
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic.
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`

	// When you are using a Put operation, this defines what unit you want to use
	// when storing the metric.
	//
	// In a Get operation, if you omit Unit then all data that was collected with
	// any unit is returned, along with the corresponding units that were specified
	// when the data was reported to CloudWatch. If you specify a unit, the operation
	// returns only data that was collected with that unit specified. If you specify
	// a unit that does not match the data collected, the results of the operation
	// are null. CloudWatch does not perform unit conversions.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStat"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetric sets the Metric field's value.
func (s *MetricStat) SetMetric(v *Metric) *MetricStat {
	s.Metric = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *MetricStat) SetPeriod(v int64) *MetricStat {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *MetricStat) SetStat(v string) *MetricStat {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricStat) SetUnit(v string) *MetricStat {
	s.Unit = &v
	return s
}

// This structure contains the configuration information about one metric stream.
type MetricStreamEntry struct {
	_ struct{} `type:"structure"`

	// The ARN of the metric stream.
	Arn *string `min:"1" type:"string"`

	// The date that the metric stream was originally created.
	CreationDate *time.Time `type:"timestamp"`

	// The ARN of the Kinesis Firehose devlivery stream that is used for this metric
	// stream.
	FirehoseArn *string `min:"1" type:"string"`

	// The date that the configuration of this metric stream was most recently updated.
	LastUpdateDate *time.Time `type:"timestamp"`

	// The name of the metric stream.
	Name *string `min:"1" type:"string"`

	// The output format of this metric stream. Valid values are json and opentelemetry0.7.
	OutputFormat *string `min:"1" type:"string" enum:"MetricStreamOutputFormat"`

	// The current state of this stream. Valid values are running and stopped.
	State *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MetricStreamEntry) SetArn(v string) *MetricStreamEntry {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *MetricStreamEntry) SetCreationDate(v time.Time) *MetricStreamEntry {
	s.CreationDate = &v
	return s
}

// SetFirehoseArn sets the FirehoseArn field's value.
func (s *MetricStreamEntry) SetFirehoseArn(v string) *MetricStreamEntry {
	s.FirehoseArn = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *MetricStreamEntry) SetLastUpdateDate(v time.Time) *MetricStreamEntry {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *MetricStreamEntry) SetName(v string) *MetricStreamEntry {
	s.Name = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *MetricStreamEntry) SetOutputFormat(v string) *MetricStreamEntry {
	s.OutputFormat = &v
	return s
}

// SetState sets the State field's value.
func (s *MetricStreamEntry) SetState(v string) *MetricStreamEntry {
	s.State = &v
	return s
}

// This structure contains the name of one of the metric namespaces that is
// listed in a filter of a metric stream.
type MetricStreamFilter struct {
	_ struct{} `type:"structure"`

	// The name of the metric namespace in the filter.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStreamFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStreamFilter"}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespace sets the Namespace field's value.
func (s *MetricStreamFilter) SetNamespace(v string) *MetricStreamFilter {
	s.Namespace = &v
	return s
}

// By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT
// statistics for each metric that is streamed. This structure contains information
// for one metric that includes additional statistics in the stream. For more
// information about statistics, see CloudWatch, listed in CloudWatch statistics
// definitions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
type MetricStreamStatisticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of additional statistics that are to be streamed for the metrics
	// listed in the IncludeMetrics array in this structure. This list can include
	// as many as 20 statistics.
	//
	// If the OutputFormat for the stream is opentelemetry0.7, the only valid values
	// are p?? percentile statistics such as p90, p99 and so on.
	//
	// If the OutputFormat for the stream is json, the valid values include the
	// abbreviations for all of the statistics listed in CloudWatch statistics definitions
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
	// For example, this includes tm98, wm90, PR(:300), and so on.
	//
	// AdditionalStatistics is a required field
	AdditionalStatistics []*string `type:"list" required:"true"`

	// An array of metric name and namespace pairs that stream the additional statistics
	// listed in the value of the AdditionalStatistics parameter. There can be as
	// many as 100 pairs in the array.
	//
	// All metrics that match the combination of metric name and namespace will
	// be streamed with the additional statistics, no matter their dimensions.
	//
	// IncludeMetrics is a required field
	IncludeMetrics []*MetricStreamStatisticsMetric `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamStatisticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamStatisticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStreamStatisticsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStreamStatisticsConfiguration"}
	if s.AdditionalStatistics == nil {
		invalidParams.Add(request.NewErrParamRequired("AdditionalStatistics"))
	}
	if s.IncludeMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludeMetrics"))
	}
	if s.IncludeMetrics != nil {
		for i, v := range s.IncludeMetrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IncludeMetrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalStatistics sets the AdditionalStatistics field's value.
func (s *MetricStreamStatisticsConfiguration) SetAdditionalStatistics(v []*string) *MetricStreamStatisticsConfiguration {
	s.AdditionalStatistics = v
	return s
}

// SetIncludeMetrics sets the IncludeMetrics field's value.
func (s *MetricStreamStatisticsConfiguration) SetIncludeMetrics(v []*MetricStreamStatisticsMetric) *MetricStreamStatisticsConfiguration {
	s.IncludeMetrics = v
	return s
}

// This object contains the information for one metric that is to be streamed
// with additional statistics.
type MetricStreamStatisticsMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamStatisticsMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStreamStatisticsMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStreamStatisticsMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStreamStatisticsMetric"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *MetricStreamStatisticsMetric) SetMetricName(v string) *MetricStreamStatisticsMetric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *MetricStreamStatisticsMetric) SetNamespace(v string) *MetricStreamStatisticsMetric {
	s.Namespace = &v
	return s
}

// This array is empty if the API operation was successful for all the rules
// specified in the request. If the operation could not process one of the rules,
// the following data is returned for each of those rules.
type PartialFailure struct {
	_ struct{} `type:"structure"`

	// The type of error.
	ExceptionType *string `type:"string"`

	// The code of the error.
	FailureCode *string `type:"string"`

	// A description of the error.
	FailureDescription *string `type:"string"`

	// The specified rule that could not be deleted.
	FailureResource *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartialFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartialFailure) GoString() string {
	return s.String()
}

// SetExceptionType sets the ExceptionType field's value.
func (s *PartialFailure) SetExceptionType(v string) *PartialFailure {
	s.ExceptionType = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *PartialFailure) SetFailureCode(v string) *PartialFailure {
	s.FailureCode = &v
	return s
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *PartialFailure) SetFailureDescription(v string) *PartialFailure {
	s.FailureDescription = &v
	return s
}

// SetFailureResource sets the FailureResource field's value.
func (s *PartialFailure) SetFailureResource(v string) *PartialFailure {
	s.FailureResource = &v
	return s
}

type PutAnomalyDetectorInput struct {
	_ struct{} `type:"structure"`

	// The configuration specifies details about how the anomaly detection model
	// is to be trained, including time ranges to exclude when training and updating
	// the model. You can specify as many as 10 time ranges.
	//
	// The configuration can also include the time zone to use for the metric.
	Configuration *AnomalyDetectorConfiguration `type:"structure"`

	// The metric dimensions to create the anomaly detection model for.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Dimensions []*Dimension `deprecated:"true" type:"list"`

	// The metric math anomaly detector to be created.
	//
	// When using MetricMathAnomalyDetector, you cannot include the following parameters
	// in the same operation:
	//
	//    * Dimensions
	//
	//    * MetricName
	//
	//    * Namespace
	//
	//    * Stat
	//
	//    * the SingleMetricAnomalyDetector parameters of PutAnomalyDetectorInput
	//
	// Instead, specify the metric math anomaly detector attributes as part of the
	// property MetricMathAnomalyDetector.
	MetricMathAnomalyDetector *MetricMathAnomalyDetector `type:"structure"`

	// The name of the metric to create the anomaly detection model for.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	MetricName *string `min:"1" deprecated:"true" type:"string"`

	// The namespace of the metric to create the anomaly detection model for.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Namespace *string `min:"1" deprecated:"true" type:"string"`

	// A single metric anomaly detector to be created.
	//
	// When using SingleMetricAnomalyDetector, you cannot include the following
	// parameters in the same operation:
	//
	//    * Dimensions
	//
	//    * MetricName
	//
	//    * Namespace
	//
	//    * Stat
	//
	//    * the MetricMatchAnomalyDetector parameters of PutAnomalyDetectorInput
	//
	// Instead, specify the single metric anomaly detector attributes as part of
	// the property SingleMetricAnomalyDetector.
	SingleMetricAnomalyDetector *SingleMetricAnomalyDetector `type:"structure"`

	// The statistic to use for the metric and the anomaly detection model.
	//
	// Deprecated: Use SingleMetricAnomalyDetector.
	Stat *string `deprecated:"true" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAnomalyDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAnomalyDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAnomalyDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAnomalyDetectorInput"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetricMathAnomalyDetector != nil {
		if err := s.MetricMathAnomalyDetector.Validate(); err != nil {
			invalidParams.AddNested("MetricMathAnomalyDetector", err.(request.ErrInvalidParams))
		}
	}
	if s.SingleMetricAnomalyDetector != nil {
		if err := s.SingleMetricAnomalyDetector.Validate(); err != nil {
			invalidParams.AddNested("SingleMetricAnomalyDetector", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *PutAnomalyDetectorInput) SetConfiguration(v *AnomalyDetectorConfiguration) *PutAnomalyDetectorInput {
	s.Configuration = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *PutAnomalyDetectorInput) SetDimensions(v []*Dimension) *PutAnomalyDetectorInput {
	s.Dimensions = v
	return s
}

// SetMetricMathAnomalyDetector sets the MetricMathAnomalyDetector field's value.
func (s *PutAnomalyDetectorInput) SetMetricMathAnomalyDetector(v *MetricMathAnomalyDetector) *PutAnomalyDetectorInput {
	s.MetricMathAnomalyDetector = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutAnomalyDetectorInput) SetMetricName(v string) *PutAnomalyDetectorInput {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutAnomalyDetectorInput) SetNamespace(v string) *PutAnomalyDetectorInput {
	s.Namespace = &v
	return s
}

// SetSingleMetricAnomalyDetector sets the SingleMetricAnomalyDetector field's value.
func (s *PutAnomalyDetectorInput) SetSingleMetricAnomalyDetector(v *SingleMetricAnomalyDetector) *PutAnomalyDetectorInput {
	s.SingleMetricAnomalyDetector = v
	return s
}

// SetStat sets the Stat field's value.
func (s *PutAnomalyDetectorInput) SetStat(v string) *PutAnomalyDetectorInput {
	s.Stat = &v
	return s
}

type PutAnomalyDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAnomalyDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAnomalyDetectorOutput) GoString() string {
	return s.String()
}

type PutCompositeAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state of the composite alarm. The default is TRUE.
	ActionsEnabled *bool `type:"boolean"`

	// Actions will be suppressed if the suppressor alarm is in the ALARM state.
	// ActionsSuppressor can be an AlarmName or an Amazon Resource Name (ARN) from
	// an existing alarm.
	ActionsSuppressor *string `min:"1" type:"string"`

	// The maximum time in seconds that the composite alarm waits after suppressor
	// alarm goes out of the ALARM state. After this time, the composite alarm performs
	// its actions.
	//
	// ExtensionPeriod is required only when ActionsSuppressor is specified.
	ActionsSuppressorExtensionPeriod *int64 `type:"integer"`

	// The maximum time in seconds that the composite alarm waits for the suppressor
	// alarm to go into the ALARM state. After this time, the composite alarm performs
	// its actions.
	//
	// WaitPeriod is required only when ActionsSuppressor is specified.
	ActionsSuppressorWaitPeriod *int64 `type:"integer"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name | arn:aws:ssm:region:account-id:opsitem:severity
	AlarmActions []*string `type:"list"`

	// The description for the composite alarm.
	AlarmDescription *string `type:"string"`

	// The name for the composite alarm. This name must be unique within the Region.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// An expression that specifies which other alarms are to be evaluated to determine
	// this composite alarm's state. For each alarm that you reference, you designate
	// a function that specifies whether that alarm needs to be in ALARM state,
	// OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and
	// NOT) to combine multiple functions in a single expression. You can use parenthesis
	// to logically group the functions in your expression.
	//
	// You can use either alarm names or ARNs to reference the other alarms that
	// are to be evaluated.
	//
	// Functions can include the following:
	//
	//    * ALARM("alarm-name or alarm-ARN") is TRUE if the named alarm is in ALARM
	//    state.
	//
	//    * OK("alarm-name or alarm-ARN") is TRUE if the named alarm is in OK state.
	//
	//    * INSUFFICIENT_DATA("alarm-name or alarm-ARN") is TRUE if the named alarm
	//    is in INSUFFICIENT_DATA state.
	//
	//    * TRUE always evaluates to TRUE.
	//
	//    * FALSE always evaluates to FALSE.
	//
	// TRUE and FALSE are useful for testing a complex AlarmRule structure, and
	// for testing your alarm actions.
	//
	// Alarm names specified in AlarmRule can be surrounded with double-quotes ("),
	// but do not have to be.
	//
	// The following are some examples of AlarmRule:
	//
	//    * ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh) specifies
	//    that the composite alarm goes into ALARM state only if both CPUUtilizationTooHigh
	//    and DiskReadOpsTooHigh alarms are in ALARM state.
	//
	//    * ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress) specifies
	//    that the alarm goes to ALARM state if CPUUtilizationTooHigh is in ALARM
	//    state and DeploymentInProgress is not in ALARM state. This example reduces
	//    alarm noise during a known deployment window.
	//
	//    * (ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)
	//    goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is
	//    in ALARM state, and if NetworkOutTooHigh is in OK state. This provides
	//    another example of using a composite alarm to prevent noise. This rule
	//    ensures that you are not notified with an alarm action on high CPU or
	//    disk usage if a known network problem is also occurring.
	//
	// The AlarmRule can specify as many as 100 "children" alarms. The AlarmRule
	// expression can have as many as 500 elements. Elements are child alarms, TRUE
	// or FALSE statements, and parentheses.
	//
	// AlarmRule is a required field
	AlarmRule *string `min:"1" type:"string" required:"true"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name
	InsufficientDataActions []*string `type:"list"`

	// The actions to execute when this alarm transitions to an OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:sns:region:account-id:sns-topic-name
	OKActions []*string `type:"list"`

	// A list of key-value pairs to associate with the composite alarm. You can
	// associate as many as 50 tags with an alarm.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions, by granting a user permission to access or
	// change only resources with certain tag values.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCompositeAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCompositeAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutCompositeAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutCompositeAlarmInput"}
	if s.ActionsSuppressor != nil && len(*s.ActionsSuppressor) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionsSuppressor", 1))
	}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.AlarmRule == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmRule"))
	}
	if s.AlarmRule != nil && len(*s.AlarmRule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmRule", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *PutCompositeAlarmInput) SetActionsEnabled(v bool) *PutCompositeAlarmInput {
	s.ActionsEnabled = &v
	return s
}

// SetActionsSuppressor sets the ActionsSuppressor field's value.
func (s *PutCompositeAlarmInput) SetActionsSuppressor(v string) *PutCompositeAlarmInput {
	s.ActionsSuppressor = &v
	return s
}

// SetActionsSuppressorExtensionPeriod sets the ActionsSuppressorExtensionPeriod field's value.
func (s *PutCompositeAlarmInput) SetActionsSuppressorExtensionPeriod(v int64) *PutCompositeAlarmInput {
	s.ActionsSuppressorExtensionPeriod = &v
	return s
}

// SetActionsSuppressorWaitPeriod sets the ActionsSuppressorWaitPeriod field's value.
func (s *PutCompositeAlarmInput) SetActionsSuppressorWaitPeriod(v int64) *PutCompositeAlarmInput {
	s.ActionsSuppressorWaitPeriod = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *PutCompositeAlarmInput) SetAlarmActions(v []*string) *PutCompositeAlarmInput {
	s.AlarmActions = v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *PutCompositeAlarmInput) SetAlarmDescription(v string) *PutCompositeAlarmInput {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *PutCompositeAlarmInput) SetAlarmName(v string) *PutCompositeAlarmInput {
	s.AlarmName = &v
	return s
}

// SetAlarmRule sets the AlarmRule field's value.
func (s *PutCompositeAlarmInput) SetAlarmRule(v string) *PutCompositeAlarmInput {
	s.AlarmRule = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *PutCompositeAlarmInput) SetInsufficientDataActions(v []*string) *PutCompositeAlarmInput {
	s.InsufficientDataActions = v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *PutCompositeAlarmInput) SetOKActions(v []*string) *PutCompositeAlarmInput {
	s.OKActions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutCompositeAlarmInput) SetTags(v []*Tag) *PutCompositeAlarmInput {
	s.Tags = v
	return s
}

type PutCompositeAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCompositeAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutCompositeAlarmOutput) GoString() string {
	return s.String()
}

type PutDashboardInput struct {
	_ struct{} `type:"structure"`

	// The detailed information about the dashboard in JSON format, including the
	// widgets to include and their location on the dashboard. This parameter is
	// required.
	//
	// For more information about the syntax, see Dashboard Body Structure and Syntax
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
	//
	// DashboardBody is a required field
	DashboardBody *string `type:"string" required:"true"`

	// The name of the dashboard. If a dashboard with this name already exists,
	// this call modifies that dashboard, replacing its current contents. Otherwise,
	// a new dashboard is created. The maximum length is 255, and valid characters
	// are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
	//
	// DashboardName is a required field
	DashboardName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDashboardInput"}
	if s.DashboardBody == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardBody"))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardBody sets the DashboardBody field's value.
func (s *PutDashboardInput) SetDashboardBody(v string) *PutDashboardInput {
	s.DashboardBody = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *PutDashboardInput) SetDashboardName(v string) *PutDashboardInput {
	s.DashboardName = &v
	return s
}

type PutDashboardOutput struct {
	_ struct{} `type:"structure"`

	// If the input for PutDashboard was correct and the dashboard was successfully
	// created or modified, this result is empty.
	//
	// If this result includes only warning messages, then the input was valid enough
	// for the dashboard to be created or modified, but some elements of the dashboard
	// might not render.
	//
	// If this result includes error messages, the input was not valid and the operation
	// failed.
	DashboardValidationMessages []*DashboardValidationMessage `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardValidationMessages sets the DashboardValidationMessages field's value.
func (s *PutDashboardOutput) SetDashboardValidationMessages(v []*DashboardValidationMessage) *PutDashboardOutput {
	s.DashboardValidationMessages = v
	return s
}

type PutInsightRuleInput struct {
	_ struct{} `type:"structure"`

	// The definition of the rule, as a JSON object. For details on the valid syntax,
	// see Contributor Insights Rule Syntax (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
	//
	// RuleDefinition is a required field
	RuleDefinition *string `min:"1" type:"string" required:"true"`

	// A unique name for the rule.
	//
	// RuleName is a required field
	RuleName *string `min:"1" type:"string" required:"true"`

	// The state of the rule. Valid values are ENABLED and DISABLED.
	RuleState *string `min:"1" type:"string"`

	// A list of key-value pairs to associate with the Contributor Insights rule.
	// You can associate as many as 50 tags with a rule.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions, by granting a user permission to access or
	// change only the resources that have certain tag values.
	//
	// To be able to associate tags with a rule, you must have the cloudwatch:TagResource
	// permission in addition to the cloudwatch:PutInsightRule permission.
	//
	// If you are using this operation to update an existing Contributor Insights
	// rule, any tags you specify in this parameter are ignored. To change the tags
	// of an existing rule, use TagResource (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html).
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInsightRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInsightRuleInput"}
	if s.RuleDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleDefinition"))
	}
	if s.RuleDefinition != nil && len(*s.RuleDefinition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleDefinition", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleName", 1))
	}
	if s.RuleState != nil && len(*s.RuleState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleState", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleDefinition sets the RuleDefinition field's value.
func (s *PutInsightRuleInput) SetRuleDefinition(v string) *PutInsightRuleInput {
	s.RuleDefinition = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *PutInsightRuleInput) SetRuleName(v string) *PutInsightRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleState sets the RuleState field's value.
func (s *PutInsightRuleInput) SetRuleState(v string) *PutInsightRuleInput {
	s.RuleState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutInsightRuleInput) SetTags(v []*Tag) *PutInsightRuleInput {
	s.Tags = v
	return s
}

type PutInsightRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightRuleOutput) GoString() string {
	return s.String()
}

type PutManagedInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// A list of ManagedRules to enable.
	//
	// ManagedRules is a required field
	ManagedRules []*ManagedRule `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutManagedInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutManagedInsightRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutManagedInsightRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutManagedInsightRulesInput"}
	if s.ManagedRules == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedRules"))
	}
	if s.ManagedRules != nil {
		for i, v := range s.ManagedRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ManagedRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagedRules sets the ManagedRules field's value.
func (s *PutManagedInsightRulesInput) SetManagedRules(v []*ManagedRule) *PutManagedInsightRulesInput {
	s.ManagedRules = v
	return s
}

type PutManagedInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array that lists the rules that could not be enabled.
	Failures []*PartialFailure `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutManagedInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutManagedInsightRulesOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *PutManagedInsightRulesOutput) SetFailures(v []*PartialFailure) *PutManagedInsightRulesOutput {
	s.Failures = v
	return s
}

type PutMetricAlarmInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state. The default is TRUE.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	// | arn:aws:ssm:region:account-id:opsitem:severity | arn:aws:ssm-incidents::account-id:response-plan:response-plan-name
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Recover/1.0
	AlarmActions []*string `type:"list"`

	// The description for the alarm.
	AlarmDescription *string `type:"string"`

	// The name for the alarm. This name must be unique within the Region.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	//
	// The values LessThanLowerOrGreaterThanUpperThreshold, LessThanLowerThreshold,
	// and GreaterThanUpperThreshold are used only for alarms based on anomaly detection
	// models.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// The number of data points that must be breaching to trigger the alarm. This
	// is used only if you are setting an "M out of N" alarm. In that case, this
	// value is the M. For more information, see Evaluating an Alarm (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation)
	// in the Amazon CloudWatch User Guide.
	DatapointsToAlarm *int64 `min:"1" type:"integer"`

	// The dimensions for the metric specified in MetricName.
	Dimensions []*Dimension `type:"list"`

	// Used only for alarms based on percentiles. If you specify ignore, the alarm
	// state does not change during periods with too few data points to be statistically
	// significant. If you specify evaluate or omit this parameter, the alarm is
	// always evaluated and possibly changes state no matter how many data points
	// are available. For more information, see Percentile-Based CloudWatch Alarms
	// and Low Data Samples (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
	//
	// Valid Values: evaluate | ignore
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	// If you are setting an alarm that requires that a number of consecutive data
	// points be breaching to trigger the alarm, this value specifies that number.
	// If you are setting an "M out of N" alarm, this value is the N.
	//
	// An alarm's total current evaluation period can be no longer than one day,
	// so this number multiplied by Period cannot be more than 86,400 seconds.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The percentile statistic for the metric specified in MetricName. Specify
	// a value between p0.0 and p100. When you call PutMetricAlarm and specify a
	// MetricName, you must specify either Statistic or ExtendedStatistic, but not
	// both.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	//
	// Valid Values (for use with IAM roles): >arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	InsufficientDataActions []*string `type:"list"`

	// The name for the metric associated with the alarm. For each PutMetricAlarm
	// operation, you must specify either MetricName or a Metrics array.
	//
	// If you are creating an alarm based on a math expression, you cannot specify
	// this parameter, or any of the Dimensions, Period, Namespace, Statistic, or
	// ExtendedStatistic parameters. Instead, you specify all this information in
	// the Metrics array.
	MetricName *string `min:"1" type:"string"`

	// An array of MetricDataQuery structures that enable you to create an alarm
	// based on the result of a metric math expression. For each PutMetricAlarm
	// operation, you must specify either MetricName or a Metrics array.
	//
	// Each item in the Metrics array either retrieves a metric or performs a math
	// expression.
	//
	// One item in the Metrics array is the expression that the alarm watches. You
	// designate this expression by setting ReturnData to true for this object in
	// the array. For more information, see MetricDataQuery (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html).
	//
	// If you use the Metrics parameter, you cannot include the MetricName, Dimensions,
	// Period, Namespace, Statistic, or ExtendedStatistic parameters of PutMetricAlarm
	// in the same operation. Instead, you retrieve the metrics you are using in
	// your math expression as part of the Metrics array.
	Metrics []*MetricDataQuery `type:"list"`

	// The namespace for the metric associated specified in MetricName.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to an OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	//
	// Valid Values: arn:aws:automate:region:ec2:stop | arn:aws:automate:region:ec2:terminate
	// | arn:aws:automate:region:ec2:recover | arn:aws:automate:region:ec2:reboot
	// | arn:aws:sns:region:account-id:sns-topic-name | arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name
	//
	// Valid Values (for use with IAM roles): arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0
	// | arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Recover/1.0
	OKActions []*string `type:"list"`

	// The length, in seconds, used each time the metric specified in MetricName
	// is evaluated. Valid values are 10, 30, and any multiple of 60.
	//
	// Period is required for alarms based on static thresholds. If you are creating
	// an alarm based on a metric math expression, you specify the period for each
	// metric within the objects in the Metrics array.
	//
	// Be sure to specify 10 or 30 only for metrics that are stored by a PutMetricData
	// call with a StorageResolution of 1. If you specify a period of 10 or 30 for
	// a metric that does not have sub-minute resolution, the alarm still attempts
	// to gather data at the period rate that you specify. In this case, it does
	// not receive data for the attempts that do not correspond to a one-minute
	// data resolution, and the alarm might often lapse into INSUFFICENT_DATA status.
	// Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which
	// has a higher charge than other alarms. For more information about pricing,
	// see Amazon CloudWatch Pricing (https://aws.amazon.com/cloudwatch/pricing/).
	//
	// An alarm's total current evaluation period can be no longer than one day,
	// so Period multiplied by EvaluationPeriods cannot be more than 86,400 seconds.
	Period *int64 `min:"1" type:"integer"`

	// The statistic for the metric specified in MetricName, other than percentile.
	// For percentile statistics, use ExtendedStatistic. When you call PutMetricAlarm
	// and specify a MetricName, you must specify either Statistic or ExtendedStatistic,
	// but not both.
	Statistic *string `type:"string" enum:"Statistic"`

	// A list of key-value pairs to associate with the alarm. You can associate
	// as many as 50 tags with an alarm.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// If you are using this operation to update an existing alarm, any tags you
	// specify in this parameter are ignored. To change the tags of an existing
	// alarm, use TagResource (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html)
	// or UntagResource (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
	Tags []*Tag `type:"list"`

	// The value against which the specified statistic is compared.
	//
	// This parameter is required for alarms based on static thresholds, but should
	// not be used for alarms based on anomaly detection models.
	Threshold *float64 `type:"double"`

	// If this is an alarm based on an anomaly detection model, make this value
	// match the ID of the ANOMALY_DETECTION_BAND function.
	//
	// For an example of how to use this parameter, see the Anomaly Detection Model
	// Alarm example on this page.
	//
	// If your alarm uses this parameter, it cannot have Auto Scaling actions.
	ThresholdMetricId *string `min:"1" type:"string"`

	// Sets how this alarm is to handle missing data points. If TreatMissingData
	// is omitted, the default behavior of missing is used. For more information,
	// see Configuring How CloudWatch Alarms Treats Missing Data (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
	//
	// Valid Values: breaching | notBreaching | ignore | missing
	//
	// Alarms that evaluate metrics in the AWS/DynamoDB namespace always ignore
	// missing data even if you choose a different option for TreatMissingData.
	// When an AWS/DynamoDB metric has missing data, alarms that evaluate that metric
	// remain in their current state.
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of measure for the statistic. For example, the units for the Amazon
	// EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes
	// that an instance receives on all network interfaces. You can also specify
	// a unit when you create a custom metric. Units help provide conceptual meaning
	// to your data. Metric data points that specify a unit of measure, such as
	// Percent, are aggregated separately.
	//
	// If you don't specify Unit, CloudWatch retrieves all unit types that have
	// been published for the metric and attempts to evaluate the alarm. Usually,
	// metrics are published with only one unit, so the alarm works as intended.
	//
	// However, if the metric is published with multiple types of units and you
	// don't specify a unit, the alarm's behavior is not defined and it behaves
	// unpredictably.
	//
	// We recommend omitting Unit so that you don't inadvertently specify an incorrect
	// unit that is not published for this metric. Doing so causes the alarm to
	// be stuck in the INSUFFICIENT DATA state.
	Unit *string `type:"string" enum:"StandardUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricAlarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricAlarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricAlarmInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.DatapointsToAlarm != nil && *s.DatapointsToAlarm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatapointsToAlarm", 1))
	}
	if s.EvaluateLowSampleCountPercentile != nil && len(*s.EvaluateLowSampleCountPercentile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluateLowSampleCountPercentile", 1))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.ThresholdMetricId != nil && len(*s.ThresholdMetricId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThresholdMetricId", 1))
	}
	if s.TreatMissingData != nil && len(*s.TreatMissingData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TreatMissingData", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionsEnabled sets the ActionsEnabled field's value.
func (s *PutMetricAlarmInput) SetActionsEnabled(v bool) *PutMetricAlarmInput {
	s.ActionsEnabled = &v
	return s
}

// SetAlarmActions sets the AlarmActions field's value.
func (s *PutMetricAlarmInput) SetAlarmActions(v []*string) *PutMetricAlarmInput {
	s.AlarmActions = v
	return s
}

// SetAlarmDescription sets the AlarmDescription field's value.
func (s *PutMetricAlarmInput) SetAlarmDescription(v string) *PutMetricAlarmInput {
	s.AlarmDescription = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *PutMetricAlarmInput) SetAlarmName(v string) *PutMetricAlarmInput {
	s.AlarmName = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PutMetricAlarmInput) SetComparisonOperator(v string) *PutMetricAlarmInput {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *PutMetricAlarmInput) SetDatapointsToAlarm(v int64) *PutMetricAlarmInput {
	s.DatapointsToAlarm = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *PutMetricAlarmInput) SetDimensions(v []*Dimension) *PutMetricAlarmInput {
	s.Dimensions = v
	return s
}

// SetEvaluateLowSampleCountPercentile sets the EvaluateLowSampleCountPercentile field's value.
func (s *PutMetricAlarmInput) SetEvaluateLowSampleCountPercentile(v string) *PutMetricAlarmInput {
	s.EvaluateLowSampleCountPercentile = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *PutMetricAlarmInput) SetEvaluationPeriods(v int64) *PutMetricAlarmInput {
	s.EvaluationPeriods = &v
	return s
}

// SetExtendedStatistic sets the ExtendedStatistic field's value.
func (s *PutMetricAlarmInput) SetExtendedStatistic(v string) *PutMetricAlarmInput {
	s.ExtendedStatistic = &v
	return s
}

// SetInsufficientDataActions sets the InsufficientDataActions field's value.
func (s *PutMetricAlarmInput) SetInsufficientDataActions(v []*string) *PutMetricAlarmInput {
	s.InsufficientDataActions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutMetricAlarmInput) SetMetricName(v string) *PutMetricAlarmInput {
	s.MetricName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *PutMetricAlarmInput) SetMetrics(v []*MetricDataQuery) *PutMetricAlarmInput {
	s.Metrics = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricAlarmInput) SetNamespace(v string) *PutMetricAlarmInput {
	s.Namespace = &v
	return s
}

// SetOKActions sets the OKActions field's value.
func (s *PutMetricAlarmInput) SetOKActions(v []*string) *PutMetricAlarmInput {
	s.OKActions = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PutMetricAlarmInput) SetPeriod(v int64) *PutMetricAlarmInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *PutMetricAlarmInput) SetStatistic(v string) *PutMetricAlarmInput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutMetricAlarmInput) SetTags(v []*Tag) *PutMetricAlarmInput {
	s.Tags = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *PutMetricAlarmInput) SetThreshold(v float64) *PutMetricAlarmInput {
	s.Threshold = &v
	return s
}

// SetThresholdMetricId sets the ThresholdMetricId field's value.
func (s *PutMetricAlarmInput) SetThresholdMetricId(v string) *PutMetricAlarmInput {
	s.ThresholdMetricId = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *PutMetricAlarmInput) SetTreatMissingData(v string) *PutMetricAlarmInput {
	s.TreatMissingData = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *PutMetricAlarmInput) SetUnit(v string) *PutMetricAlarmInput {
	s.Unit = &v
	return s
}

type PutMetricAlarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricAlarmOutput) GoString() string {
	return s.String()
}

type PutMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The data for the metric. The array can include no more than 1000 metrics
	// per call.
	//
	// MetricData is a required field
	MetricData []*MetricDatum `type:"list" required:"true"`

	// The namespace for the metric data.
	//
	// To avoid conflicts with Amazon Web Services service namespaces, you should
	// not specify a namespace that begins with AWS/
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricDataInput"}
	if s.MetricData == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricData"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.MetricData != nil {
		for i, v := range s.MetricData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricData sets the MetricData field's value.
func (s *PutMetricDataInput) SetMetricData(v []*MetricDatum) *PutMetricDataInput {
	s.MetricData = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PutMetricDataInput) SetNamespace(v string) *PutMetricDataInput {
	s.Namespace = &v
	return s
}

type PutMetricDataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricDataOutput) GoString() string {
	return s.String()
}

type PutMetricStreamInput struct {
	_ struct{} `type:"structure"`

	// If you specify this parameter, the stream sends metrics from all metric namespaces
	// except for the namespaces that you specify here.
	//
	// You cannot include ExcludeFilters and IncludeFilters in the same operation.
	ExcludeFilters []*MetricStreamFilter `type:"list"`

	// The ARN of the Amazon Kinesis Data Firehose delivery stream to use for this
	// metric stream. This Amazon Kinesis Data Firehose delivery stream must already
	// exist and must be in the same account as the metric stream.
	//
	// FirehoseArn is a required field
	FirehoseArn *string `min:"1" type:"string" required:"true"`

	// If you specify this parameter, the stream sends only the metrics from the
	// metric namespaces that you specify here.
	//
	// You cannot include IncludeFilters and ExcludeFilters in the same operation.
	IncludeFilters []*MetricStreamFilter `type:"list"`

	// If you are creating a new metric stream, this is the name for the new stream.
	// The name must be different than the names of other metric streams in this
	// account and Region.
	//
	// If you are updating a metric stream, specify the name of that stream here.
	//
	// Valid characters are A-Z, a-z, 0-9, "-" and "_".
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The output format for the stream. Valid values are json and opentelemetry0.7.
	// For more information about metric stream output formats, see Metric streams
	// output formats (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
	//
	// OutputFormat is a required field
	OutputFormat *string `min:"1" type:"string" required:"true" enum:"MetricStreamOutputFormat"`

	// The ARN of an IAM role that this metric stream will use to access Amazon
	// Kinesis Data Firehose resources. This IAM role must already exist and must
	// be in the same account as the metric stream. This IAM role must include the
	// following permissions:
	//
	//    * firehose:PutRecord
	//
	//    * firehose:PutRecordBatch
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// By default, a metric stream always sends the MAX, MIN, SUM, and SAMPLECOUNT
	// statistics for each metric that is streamed. You can use this parameter to
	// have the metric stream also send additional statistics in the stream. This
	// array can have up to 100 members.
	//
	// For each entry in this array, you specify one or more metrics and the list
	// of additional statistics to stream for those metrics. The additional statistics
	// that you can stream depend on the stream's OutputFormat. If the OutputFormat
	// is json, you can stream any additional statistic that is supported by CloudWatch,
	// listed in CloudWatch statistics definitions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html.html).
	// If the OutputFormat is opentelemetry0.7, you can stream percentile statistics
	// such as p95, p99.9, and so on.
	StatisticsConfigurations []*MetricStreamStatisticsConfiguration `type:"list"`

	// A list of key-value pairs to associate with the metric stream. You can associate
	// as many as 50 tags with a metric stream.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// You can use this parameter only when you are creating a new metric stream.
	// If you are using this operation to update an existing metric stream, any
	// tags you specify in this parameter are ignored. To change the tags of an
	// existing metric stream, use TagResource (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html)
	// or UntagResource (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_UntagResource.html).
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMetricStreamInput"}
	if s.FirehoseArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FirehoseArn"))
	}
	if s.FirehoseArn != nil && len(*s.FirehoseArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirehoseArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutputFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputFormat"))
	}
	if s.OutputFormat != nil && len(*s.OutputFormat) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputFormat", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.ExcludeFilters != nil {
		for i, v := range s.ExcludeFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludeFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IncludeFilters != nil {
		for i, v := range s.IncludeFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IncludeFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StatisticsConfigurations != nil {
		for i, v := range s.StatisticsConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatisticsConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludeFilters sets the ExcludeFilters field's value.
func (s *PutMetricStreamInput) SetExcludeFilters(v []*MetricStreamFilter) *PutMetricStreamInput {
	s.ExcludeFilters = v
	return s
}

// SetFirehoseArn sets the FirehoseArn field's value.
func (s *PutMetricStreamInput) SetFirehoseArn(v string) *PutMetricStreamInput {
	s.FirehoseArn = &v
	return s
}

// SetIncludeFilters sets the IncludeFilters field's value.
func (s *PutMetricStreamInput) SetIncludeFilters(v []*MetricStreamFilter) *PutMetricStreamInput {
	s.IncludeFilters = v
	return s
}

// SetName sets the Name field's value.
func (s *PutMetricStreamInput) SetName(v string) *PutMetricStreamInput {
	s.Name = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *PutMetricStreamInput) SetOutputFormat(v string) *PutMetricStreamInput {
	s.OutputFormat = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutMetricStreamInput) SetRoleArn(v string) *PutMetricStreamInput {
	s.RoleArn = &v
	return s
}

// SetStatisticsConfigurations sets the StatisticsConfigurations field's value.
func (s *PutMetricStreamInput) SetStatisticsConfigurations(v []*MetricStreamStatisticsConfiguration) *PutMetricStreamInput {
	s.StatisticsConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutMetricStreamInput) SetTags(v []*Tag) *PutMetricStreamInput {
	s.Tags = v
	return s
}

type PutMetricStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the metric stream.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMetricStreamOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutMetricStreamOutput) SetArn(v string) *PutMetricStreamOutput {
	s.Arn = &v
	return s
}

// Specifies one range of days or times to exclude from use for training an
// anomaly detection model.
type Range struct {
	_ struct{} `type:"structure"`

	// The end time of the range to exclude. The format is yyyy-MM-dd'T'HH:mm:ss.
	// For example, 2019-07-01T23:59:59.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The start time of the range to exclude. The format is yyyy-MM-dd'T'HH:mm:ss.
	// For example, 2019-07-01T23:59:59.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Range) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Range) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Range"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *Range) SetEndTime(v time.Time) *Range {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Range) SetStartTime(v time.Time) *Range {
	s.StartTime = &v
	return s
}

type SetAlarmStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm.
	//
	// AlarmName is a required field
	AlarmName *string `min:"1" type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in text format.
	//
	// StateReason is a required field
	StateReason *string `type:"string" required:"true"`

	// The reason that this alarm is set to this specific state, in JSON format.
	//
	// For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto
	// Scaling or application Auto Scaling alarm actions, the Auto Scaling policy
	// uses the information in this field to take the correct action.
	StateReasonData *string `type:"string"`

	// The value of the state.
	//
	// StateValue is a required field
	StateValue *string `type:"string" required:"true" enum:"StateValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetAlarmStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetAlarmStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetAlarmStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetAlarmStateInput"}
	if s.AlarmName == nil {
		invalidParams.Add(request.NewErrParamRequired("AlarmName"))
	}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}
	if s.StateReason == nil {
		invalidParams.Add(request.NewErrParamRequired("StateReason"))
	}
	if s.StateValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StateValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *SetAlarmStateInput) SetAlarmName(v string) *SetAlarmStateInput {
	s.AlarmName = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *SetAlarmStateInput) SetStateReason(v string) *SetAlarmStateInput {
	s.StateReason = &v
	return s
}

// SetStateReasonData sets the StateReasonData field's value.
func (s *SetAlarmStateInput) SetStateReasonData(v string) *SetAlarmStateInput {
	s.StateReasonData = &v
	return s
}

// SetStateValue sets the StateValue field's value.
func (s *SetAlarmStateInput) SetStateValue(v string) *SetAlarmStateInput {
	s.StateValue = &v
	return s
}

type SetAlarmStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetAlarmStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetAlarmStateOutput) GoString() string {
	return s.String()
}

// Designates the CloudWatch metric and statistic that provides the time series
// the anomaly detector uses as input.
type SingleMetricAnomalyDetector struct {
	_ struct{} `type:"structure"`

	// The metric dimensions to create the anomaly detection model for.
	Dimensions []*Dimension `type:"list"`

	// The name of the metric to create the anomaly detection model for.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric to create the anomaly detection model for.
	Namespace *string `min:"1" type:"string"`

	// The statistic to use for the metric and anomaly detection model.
	Stat *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SingleMetricAnomalyDetector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SingleMetricAnomalyDetector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleMetricAnomalyDetector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingleMetricAnomalyDetector"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *SingleMetricAnomalyDetector) SetDimensions(v []*Dimension) *SingleMetricAnomalyDetector {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *SingleMetricAnomalyDetector) SetMetricName(v string) *SingleMetricAnomalyDetector {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *SingleMetricAnomalyDetector) SetNamespace(v string) *SingleMetricAnomalyDetector {
	s.Namespace = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *SingleMetricAnomalyDetector) SetStat(v string) *SingleMetricAnomalyDetector {
	s.Stat = &v
	return s
}

type StartMetricStreamsInput struct {
	_ struct{} `type:"structure"`

	// The array of the names of metric streams to start streaming.
	//
	// This is an "all or nothing" operation. If you do not have permission to access
	// all of the metric streams that you list here, then none of the streams that
	// you list in the operation will start streaming.
	//
	// Names is a required field
	Names []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMetricStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMetricStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMetricStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMetricStreamsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *StartMetricStreamsInput) SetNames(v []*string) *StartMetricStreamsInput {
	s.Names = v
	return s
}

type StartMetricStreamsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMetricStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMetricStreamsOutput) GoString() string {
	return s.String()
}

// Represents a set of statistics that describes a specific metric.
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// The maximum value of the sample set.
	//
	// Maximum is a required field
	Maximum *float64 `type:"double" required:"true"`

	// The minimum value of the sample set.
	//
	// Minimum is a required field
	Minimum *float64 `type:"double" required:"true"`

	// The number of samples used for the statistic set.
	//
	// SampleCount is a required field
	SampleCount *float64 `type:"double" required:"true"`

	// The sum of values for the sample set.
	//
	// Sum is a required field
	Sum *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatisticSet"}
	if s.Maximum == nil {
		invalidParams.Add(request.NewErrParamRequired("Maximum"))
	}
	if s.Minimum == nil {
		invalidParams.Add(request.NewErrParamRequired("Minimum"))
	}
	if s.SampleCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleCount"))
	}
	if s.Sum == nil {
		invalidParams.Add(request.NewErrParamRequired("Sum"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximum sets the Maximum field's value.
func (s *StatisticSet) SetMaximum(v float64) *StatisticSet {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *StatisticSet) SetMinimum(v float64) *StatisticSet {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *StatisticSet) SetSampleCount(v float64) *StatisticSet {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *StatisticSet) SetSum(v float64) *StatisticSet {
	s.Sum = &v
	return s
}

type StopMetricStreamsInput struct {
	_ struct{} `type:"structure"`

	// The array of the names of metric streams to stop streaming.
	//
	// This is an "all or nothing" operation. If you do not have permission to access
	// all of the metric streams that you list here, then none of the streams that
	// you list in the operation will stop streaming.
	//
	// Names is a required field
	Names []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMetricStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMetricStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMetricStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMetricStreamsInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *StopMetricStreamsInput) SetNames(v []*string) *StopMetricStreamsInput {
	s.Names = v
	return s
}

type StopMetricStreamsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMetricStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMetricStreamsOutput) GoString() string {
	return s.String()
}

// A key-value pair associated with a CloudWatch resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that you can use to assign a value. The combination of tag keys
	// and values can help you organize and categorize your resources.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch resource that you're adding tags to.
	//
	// The ARN format of an alarm is arn:aws:cloudwatch:Region:account-id:alarm:alarm-name
	//
	// The ARN format of a Contributor Insights rule is arn:aws:cloudwatch:Region:account-id:insight-rule:insight-rule-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The list of key-value pairs to associate with the alarm.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch resource that you're removing tags from.
	//
	// The ARN format of an alarm is arn:aws:cloudwatch:Region:account-id:alarm:alarm-name
	//
	// The ARN format of a Contributor Insights rule is arn:aws:cloudwatch:Region:account-id:insight-rule:insight-rule-name
	//
	// For more information about ARN format, see Resource Types Defined by Amazon
	// CloudWatch (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
	// in the Amazon Web Services General Reference.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// ActionsSuppressedByWaitPeriod is a ActionsSuppressedBy enum value
	ActionsSuppressedByWaitPeriod = "WaitPeriod"

	// ActionsSuppressedByExtensionPeriod is a ActionsSuppressedBy enum value
	ActionsSuppressedByExtensionPeriod = "ExtensionPeriod"

	// ActionsSuppressedByAlarm is a ActionsSuppressedBy enum value
	ActionsSuppressedByAlarm = "Alarm"
)

// ActionsSuppressedBy_Values returns all elements of the ActionsSuppressedBy enum
func ActionsSuppressedBy_Values() []string {
	return []string{
		ActionsSuppressedByWaitPeriod,
		ActionsSuppressedByExtensionPeriod,
		ActionsSuppressedByAlarm,
	}
}

const (
	// AlarmTypeCompositeAlarm is a AlarmType enum value
	AlarmTypeCompositeAlarm = "CompositeAlarm"

	// AlarmTypeMetricAlarm is a AlarmType enum value
	AlarmTypeMetricAlarm = "MetricAlarm"
)

// AlarmType_Values returns all elements of the AlarmType enum
func AlarmType_Values() []string {
	return []string{
		AlarmTypeCompositeAlarm,
		AlarmTypeMetricAlarm,
	}
}

const (
	// AnomalyDetectorStateValuePendingTraining is a AnomalyDetectorStateValue enum value
	AnomalyDetectorStateValuePendingTraining = "PENDING_TRAINING"

	// AnomalyDetectorStateValueTrainedInsufficientData is a AnomalyDetectorStateValue enum value
	AnomalyDetectorStateValueTrainedInsufficientData = "TRAINED_INSUFFICIENT_DATA"

	// AnomalyDetectorStateValueTrained is a AnomalyDetectorStateValue enum value
	AnomalyDetectorStateValueTrained = "TRAINED"
)

// AnomalyDetectorStateValue_Values returns all elements of the AnomalyDetectorStateValue enum
func AnomalyDetectorStateValue_Values() []string {
	return []string{
		AnomalyDetectorStateValuePendingTraining,
		AnomalyDetectorStateValueTrainedInsufficientData,
		AnomalyDetectorStateValueTrained,
	}
}

const (
	// AnomalyDetectorTypeSingleMetric is a AnomalyDetectorType enum value
	AnomalyDetectorTypeSingleMetric = "SINGLE_METRIC"

	// AnomalyDetectorTypeMetricMath is a AnomalyDetectorType enum value
	AnomalyDetectorTypeMetricMath = "METRIC_MATH"
)

// AnomalyDetectorType_Values returns all elements of the AnomalyDetectorType enum
func AnomalyDetectorType_Values() []string {
	return []string{
		AnomalyDetectorTypeSingleMetric,
		AnomalyDetectorTypeMetricMath,
	}
}

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"

	// ComparisonOperatorLessThanLowerOrGreaterThanUpperThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanLowerOrGreaterThanUpperThreshold = "LessThanLowerOrGreaterThanUpperThreshold"

	// ComparisonOperatorLessThanLowerThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanLowerThreshold = "LessThanLowerThreshold"

	// ComparisonOperatorGreaterThanUpperThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanUpperThreshold = "GreaterThanUpperThreshold"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorGreaterThanOrEqualToThreshold,
		ComparisonOperatorGreaterThanThreshold,
		ComparisonOperatorLessThanThreshold,
		ComparisonOperatorLessThanOrEqualToThreshold,
		ComparisonOperatorLessThanLowerOrGreaterThanUpperThreshold,
		ComparisonOperatorLessThanLowerThreshold,
		ComparisonOperatorGreaterThanUpperThreshold,
	}
}

const (
	// EvaluationStatePartialData is a EvaluationState enum value
	EvaluationStatePartialData = "PARTIAL_DATA"
)

// EvaluationState_Values returns all elements of the EvaluationState enum
func EvaluationState_Values() []string {
	return []string{
		EvaluationStatePartialData,
	}
}

const (
	// HistoryItemTypeConfigurationUpdate is a HistoryItemType enum value
	HistoryItemTypeConfigurationUpdate = "ConfigurationUpdate"

	// HistoryItemTypeStateUpdate is a HistoryItemType enum value
	HistoryItemTypeStateUpdate = "StateUpdate"

	// HistoryItemTypeAction is a HistoryItemType enum value
	HistoryItemTypeAction = "Action"
)

// HistoryItemType_Values returns all elements of the HistoryItemType enum
func HistoryItemType_Values() []string {
	return []string{
		HistoryItemTypeConfigurationUpdate,
		HistoryItemTypeStateUpdate,
		HistoryItemTypeAction,
	}
}

const (
	// MetricStreamOutputFormatJson is a MetricStreamOutputFormat enum value
	MetricStreamOutputFormatJson = "json"

	// MetricStreamOutputFormatOpentelemetry07 is a MetricStreamOutputFormat enum value
	MetricStreamOutputFormatOpentelemetry07 = "opentelemetry0.7"
)

// MetricStreamOutputFormat_Values returns all elements of the MetricStreamOutputFormat enum
func MetricStreamOutputFormat_Values() []string {
	return []string{
		MetricStreamOutputFormatJson,
		MetricStreamOutputFormatOpentelemetry07,
	}
}

const (
	// RecentlyActivePt3h is a RecentlyActive enum value
	RecentlyActivePt3h = "PT3H"
)

// RecentlyActive_Values returns all elements of the RecentlyActive enum
func RecentlyActive_Values() []string {
	return []string{
		RecentlyActivePt3h,
	}
}

const (
	// ScanByTimestampDescending is a ScanBy enum value
	ScanByTimestampDescending = "TimestampDescending"

	// ScanByTimestampAscending is a ScanBy enum value
	ScanByTimestampAscending = "TimestampAscending"
)

// ScanBy_Values returns all elements of the ScanBy enum
func ScanBy_Values() []string {
	return []string{
		ScanByTimestampDescending,
		ScanByTimestampAscending,
	}
}

const (
	// StandardUnitSeconds is a StandardUnit enum value
	StandardUnitSeconds = "Seconds"

	// StandardUnitMicroseconds is a StandardUnit enum value
	StandardUnitMicroseconds = "Microseconds"

	// StandardUnitMilliseconds is a StandardUnit enum value
	StandardUnitMilliseconds = "Milliseconds"

	// StandardUnitBytes is a StandardUnit enum value
	StandardUnitBytes = "Bytes"

	// StandardUnitKilobytes is a StandardUnit enum value
	StandardUnitKilobytes = "Kilobytes"

	// StandardUnitMegabytes is a StandardUnit enum value
	StandardUnitMegabytes = "Megabytes"

	// StandardUnitGigabytes is a StandardUnit enum value
	StandardUnitGigabytes = "Gigabytes"

	// StandardUnitTerabytes is a StandardUnit enum value
	StandardUnitTerabytes = "Terabytes"

	// StandardUnitBits is a StandardUnit enum value
	StandardUnitBits = "Bits"

	// StandardUnitKilobits is a StandardUnit enum value
	StandardUnitKilobits = "Kilobits"

	// StandardUnitMegabits is a StandardUnit enum value
	StandardUnitMegabits = "Megabits"

	// StandardUnitGigabits is a StandardUnit enum value
	StandardUnitGigabits = "Gigabits"

	// StandardUnitTerabits is a StandardUnit enum value
	StandardUnitTerabits = "Terabits"

	// StandardUnitPercent is a StandardUnit enum value
	StandardUnitPercent = "Percent"

	// StandardUnitCount is a StandardUnit enum value
	StandardUnitCount = "Count"

	// StandardUnitBytesSecond is a StandardUnit enum value
	StandardUnitBytesSecond = "Bytes/Second"

	// StandardUnitKilobytesSecond is a StandardUnit enum value
	StandardUnitKilobytesSecond = "Kilobytes/Second"

	// StandardUnitMegabytesSecond is a StandardUnit enum value
	StandardUnitMegabytesSecond = "Megabytes/Second"

	// StandardUnitGigabytesSecond is a StandardUnit enum value
	StandardUnitGigabytesSecond = "Gigabytes/Second"

	// StandardUnitTerabytesSecond is a StandardUnit enum value
	StandardUnitTerabytesSecond = "Terabytes/Second"

	// StandardUnitBitsSecond is a StandardUnit enum value
	StandardUnitBitsSecond = "Bits/Second"

	// StandardUnitKilobitsSecond is a StandardUnit enum value
	StandardUnitKilobitsSecond = "Kilobits/Second"

	// StandardUnitMegabitsSecond is a StandardUnit enum value
	StandardUnitMegabitsSecond = "Megabits/Second"

	// StandardUnitGigabitsSecond is a StandardUnit enum value
	StandardUnitGigabitsSecond = "Gigabits/Second"

	// StandardUnitTerabitsSecond is a StandardUnit enum value
	StandardUnitTerabitsSecond = "Terabits/Second"

	// StandardUnitCountSecond is a StandardUnit enum value
	StandardUnitCountSecond = "Count/Second"

	// StandardUnitNone is a StandardUnit enum value
	StandardUnitNone = "None"
)

// StandardUnit_Values returns all elements of the StandardUnit enum
func StandardUnit_Values() []string {
	return []string{
		StandardUnitSeconds,
		StandardUnitMicroseconds,
		StandardUnitMilliseconds,
		StandardUnitBytes,
		StandardUnitKilobytes,
		StandardUnitMegabytes,
		StandardUnitGigabytes,
		StandardUnitTerabytes,
		StandardUnitBits,
		StandardUnitKilobits,
		StandardUnitMegabits,
		StandardUnitGigabits,
		StandardUnitTerabits,
		StandardUnitPercent,
		StandardUnitCount,
		StandardUnitBytesSecond,
		StandardUnitKilobytesSecond,
		StandardUnitMegabytesSecond,
		StandardUnitGigabytesSecond,
		StandardUnitTerabytesSecond,
		StandardUnitBitsSecond,
		StandardUnitKilobitsSecond,
		StandardUnitMegabitsSecond,
		StandardUnitGigabitsSecond,
		StandardUnitTerabitsSecond,
		StandardUnitCountSecond,
		StandardUnitNone,
	}
}

const (
	// StateValueOk is a StateValue enum value
	StateValueOk = "OK"

	// StateValueAlarm is a StateValue enum value
	StateValueAlarm = "ALARM"

	// StateValueInsufficientData is a StateValue enum value
	StateValueInsufficientData = "INSUFFICIENT_DATA"
)

// StateValue_Values returns all elements of the StateValue enum
func StateValue_Values() []string {
	return []string{
		StateValueOk,
		StateValueAlarm,
		StateValueInsufficientData,
	}
}

const (
	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"
)

// Statistic_Values returns all elements of the Statistic enum
func Statistic_Values() []string {
	return []string{
		StatisticSampleCount,
		StatisticAverage,
		StatisticSum,
		StatisticMinimum,
		StatisticMaximum,
	}
}

const (
	// StatusCodeComplete is a StatusCode enum value
	StatusCodeComplete = "Complete"

	// StatusCodeInternalError is a StatusCode enum value
	StatusCodeInternalError = "InternalError"

	// StatusCodePartialData is a StatusCode enum value
	StatusCodePartialData = "PartialData"

	// StatusCodeForbidden is a StatusCode enum value
	StatusCodeForbidden = "Forbidden"
)

// StatusCode_Values returns all elements of the StatusCode enum
func StatusCode_Values() []string {
	return []string{
		StatusCodeComplete,
		StatusCodeInternalError,
		StatusCodePartialData,
		StatusCodeForbidden,
	}
}
