// Code generated by sdkgen. DO NOT EDIT.

// nolint
package clickhouse

import (
	"context"

	"google.golang.org/grpc"

	clickhouse "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1"
)

//revive:disable

// VersionsServiceClient is a clickhouse.VersionsServiceClient with
// lazy GRPC connection initialization.
type VersionsServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// List implements clickhouse.VersionsServiceClient
func (c *VersionsServiceClient) List(ctx context.Context, in *clickhouse.ListVersionsRequest, opts ...grpc.CallOption) (*clickhouse.ListVersionsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return clickhouse.NewVersionsServiceClient(conn).List(ctx, in, opts...)
}

type VersionsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *VersionsServiceClient
	request *clickhouse.ListVersionsRequest

	items []*clickhouse.Version
}

func (c *VersionsServiceClient) VersionsIterator(ctx context.Context, req *clickhouse.ListVersionsRequest, opts ...grpc.CallOption) *VersionsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &VersionsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *VersionsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Version
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *VersionsIterator) Take(size int64) ([]*clickhouse.Version, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*clickhouse.Version

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *VersionsIterator) TakeAll() ([]*clickhouse.Version, error) {
	return it.Take(0)
}

func (it *VersionsIterator) Value() *clickhouse.Version {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *VersionsIterator) Error() error {
	return it.err
}
